/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.KeyBindingData;
import docking.widgets.dialogs.NumberInputDialog;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.util.HelpLocation;
import ghidra.util.exception.UsrException;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import resources.ResourceManager;

public class DuplicateMultipleAction
extends CompositeEditorTableAction {
    private static final ImageIcon duplicateMultipleIcon = ResourceManager.loadImage((String)"images/MultiDuplicateData.png");
    private static final String ACTION_NAME = "Duplicate Multiple of Component";
    private static final String GROUP_NAME = "4_COMPONENT_EDITOR_ACTION";
    private static final String DESCRIPTION = "Duplicate multiple of the selected component";
    private KeyStroke keyStroke = KeyStroke.getKeyStroke(77, 8);
    private static String[] popupPath = new String[]{"Duplicate Multiple of Component"};

    public DuplicateMultipleAction(CompositeEditorProvider provider) {
        super(provider, "Editor: Duplicate Multiple of Component", GROUP_NAME, popupPath, null, duplicateMultipleIcon);
        this.setDescription(DESCRIPTION);
        this.setKeyBindingData(new KeyBindingData(this.keyStroke));
        this.adjustEnablement();
    }

    public void actionPerformed(ActionContext context) {
        int[] indices = this.model.getSelectedComponentRows();
        if (indices.length == 1) {
            int min = 1;
            int max = this.model.getMaxDuplicates(indices[0]);
            if (max != 0) {
                int initial = this.model.getLastNumDuplicates();
                NumberInputDialog numberInputDialog = new NumberInputDialog("duplicates", initial > 0 ? initial : 1, min, max);
                String helpAnchor = this.provider.getHelpName() + "_Duplicates_NumberInputDialog";
                HelpLocation helpLoc = new HelpLocation(this.provider.getHelpTopic(), helpAnchor);
                numberInputDialog.setHelpLocation(helpLoc);
                if (numberInputDialog.show()) {
                    int numDuplicates = numberInputDialog.getValue();
                    try {
                        this.model.duplicateMultiple(indices[0], numDuplicates);
                    }
                    catch (UsrException e1) {
                        this.model.setStatus(e1.getMessage(), true);
                    }
                }
            }
        }
        this.requestTableFocus();
    }

    @Override
    public void adjustEnablement() {
        this.setEnabled(this.model.isDuplicateAllowed());
    }
}

