/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser;

import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.Highlight;
import ghidra.GhidraOptions;
import ghidra.app.plugin.processors.generic.PcodeFieldFactory;
import ghidra.app.services.ButtonPressedListener;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.viewer.field.BrowserCodeUnitFormat;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.field.OperandFieldFactory;
import ghidra.app.util.viewer.field.VariableLocFieldFactory;
import ghidra.app.util.viewer.field.VariableNameFieldFactory;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.LabelString;
import ghidra.program.model.listing.OperandRepresentationList;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableOffset;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.MemReferenceImpl;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.PcodeFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocFieldLocation;
import ghidra.program.util.VariableNameFieldLocation;
import ghidra.util.HelpLocation;
import ghidra.util.StringUtilities;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.Stack;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ListingHighlightProvider
implements ButtonPressedListener,
OptionsChangeListener,
HighlightProvider {
    private static final String DISPLAY_HIGHLIGHT_NAME = "Cursor Text Highlight.Enabled";
    private static final String SCOPED_WRITE_HIGHLIGHT_COLOR = "Cursor Text Highlight.Scoped Write Highlight Color";
    private static final String SCOPED_READ_HIGHLIGHT_COLOR = "Cursor Text Highlight.Scoped Read Highlight Color";
    private static final String SCOPE_REGISTER_OPERAND = "Cursor Text Highlight.Scope Register Operand";
    private static char[] UNDERSCORE_AND_PERIOD_OK = new char[]{'.', '_'};
    private static char[] UNDERSCORE_OK = new char[]{'_'};
    private static final Highlight[] NO_HIGHLIGHTS = new Highlight[0];
    private Pattern currentHighlightPattern;
    private String currentHighlightString;
    private boolean displayHighlight;
    private Color textMatchingHighlightColor;
    private Color scopeWriteHighlightColor;
    private Color scopeReadHighlightColor;
    private int highlightButtonOption;
    private boolean scopeRegisterHighlight;
    private AddressSet scope;
    private Long variableMatchFirstUseOffset;
    private AddressSet writeScope;
    private BrowserCodeUnitFormat format;
    private final Component repaintComponent;
    private final PluginTool tool;

    public ListingHighlightProvider(PluginTool tool, Component repaintComponent) {
        this.tool = tool;
        this.repaintComponent = repaintComponent;
        this.format = new BrowserCodeUnitFormat((ServiceProvider)tool);
        this.setupHighlightOptions();
    }

    protected void dispose() {
        this.currentHighlightString = null;
        this.currentHighlightPattern = null;
    }

    @Override
    public Highlight[] getHighlights(String text, Object obj, Class<? extends FieldFactory> fieldFactoryClass, int cursorTextOffset) {
        if (this.scopeRegisterHighlight && this.scope != null) {
            if ((fieldFactoryClass == VariableNameFieldFactory.class || fieldFactoryClass == VariableLocFieldFactory.class) && obj instanceof Variable) {
                Variable var = (Variable)obj;
                if (this.variableMatchFirstUseOffset != null && (long)var.getFirstUseOffset() == this.variableMatchFirstUseOffset) {
                    return this.getTextHighlights(null, text);
                }
            }
            if ((fieldFactoryClass == OperandFieldFactory.class || fieldFactoryClass == PcodeFieldFactory.class) && obj instanceof Instruction) {
                Instruction instr = (Instruction)obj;
                return this.getTextHighlights(instr.getMinAddress(), text);
            }
            return NO_HIGHLIGHTS;
        }
        return this.getTextHighlights(null, text);
    }

    private Highlight[] getTextHighlights(Address addr, String text) {
        String highlightString = this.currentHighlightString;
        if (text == null || highlightString == null) {
            return NO_HIGHLIGHTS;
        }
        Color color = this.textMatchingHighlightColor;
        if (addr != null && this.scope != null && this.scope.contains(addr)) {
            color = this.scopeReadHighlightColor;
        }
        if (addr != null && this.writeScope != null && this.writeScope.contains(addr)) {
            color = this.scopeWriteHighlightColor;
        }
        Pattern highlightPattern = this.currentHighlightPattern;
        Matcher matcher = highlightPattern.matcher(text);
        ArrayList<Highlight> highlightList = new ArrayList<Highlight>();
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end() - 1;
            if (this.scope != null && !this.isWholeWord(text, start, end)) continue;
            highlightList.add(new Highlight(start, end, color));
        }
        if (highlightList.size() < 1) {
            return NO_HIGHLIGHTS;
        }
        return highlightList.toArray(new Highlight[highlightList.size()]);
    }

    private boolean isWholeWord(String text, int start, int end) {
        char c;
        if (start > 0 && Character.isLetterOrDigit(c = text.charAt(start - 1))) {
            return false;
        }
        return end >= text.length() - 1 || !Character.isLetterOrDigit(c = text.charAt(end + 1));
    }

    @Override
    public void buttonPressed(ProgramLocation location, FieldLocation fieldLocation, ListingField field, MouseEvent event) {
        if (event == null) {
            return;
        }
        if (!this.displayHighlight) {
            return;
        }
        if (event.getButton() == this.highlightButtonOption) {
            this.setHighlightString(location.getProgram(), this.getStringToHighlight(field, fieldLocation.getRow(), fieldLocation.getCol(), location));
        }
    }

    private void setHighlightString(Program program, String highlightString) {
        if (highlightString == null || highlightString.equals(this.currentHighlightString)) {
            this.clearHighlight();
            return;
        }
        this.currentHighlightString = highlightString;
        this.repaintComponent.repaint();
    }

    private void clearHighlight() {
        this.currentHighlightString = null;
        this.currentHighlightPattern = null;
        this.repaintComponent.repaint();
    }

    private Pattern createRegisterPattern(Register register, String ... highlightStrings) {
        List<String> registerNames = this.gatherRegisterNames(new ArrayList<String>(), register);
        StringBuilder buffy = new StringBuilder();
        for (String s : highlightStrings) {
            if (s == null) continue;
            buffy.append("\\Q").append(s).append("\\E|");
        }
        for (String name : registerNames) {
            buffy.append("\\Q").append(name).append("\\E|");
        }
        if (buffy.length() != 0) {
            buffy.deleteCharAt(buffy.length() - 1);
        }
        return Pattern.compile(buffy.toString());
    }

    private List<String> gatherRegisterNames(List<String> names, Register register) {
        for (Register parent = register.getParentRegister(); parent != null; parent = parent.getParentRegister()) {
            names.add(parent.getName());
        }
        this.accumulateSubRegisters(names, register);
        return names;
    }

    private void accumulateSubRegisters(List<String> names, Register register) {
        names.add(register.getName());
        List childRegisters = register.getChildRegisters();
        for (Register childRegister : childRegisters) {
            this.accumulateSubRegisters(names, childRegister);
        }
    }

    private String getStringToHighlight(ListingField tf, int row, int col, ProgramLocation loc) {
        if (!(tf instanceof ListingTextField)) {
            return null;
        }
        this.scope = null;
        this.variableMatchFirstUseOffset = null;
        ListingTextField ltf = (ListingTextField)tf;
        Object proxyObj = tf.getProxy().getObject();
        FieldElement fieldElement = ltf.getFieldElement(row, col);
        String text = null;
        String altText = null;
        Register register = null;
        Variable var = null;
        Varnode refVarnode = null;
        Instruction instr = null;
        if (loc instanceof OperandFieldLocation && proxyObj instanceof Instruction) {
            instr = (Instruction)proxyObj;
            OperandFieldLocation opLoc = (OperandFieldLocation)loc;
            OperandRepresentationList opRepList = this.format.getOperandRepresentationList((CodeUnit)instr, opLoc.getOperandIndex());
            Object object = opRepList.get(opLoc.getSubOperandIndex());
            int elementCol = ltf.screenToDataLocation(row, col).col() - fieldElement.getDataLocationForCharacterIndex(0).col();
            if (object instanceof OperandRepresentationList) {
                text = fieldElement.getText();
                for (Object listObj : (OperandRepresentationList)object) {
                    String str = listObj.toString();
                    if (!text.equals(str)) continue;
                    object = listObj;
                    break;
                }
            }
            if (object instanceof Register) {
                register = (Register)object;
                text = register.getName();
            } else if (object instanceof VariableOffset) {
                String offsetStr;
                boolean selectSubElement;
                VariableOffset varOff = (VariableOffset)object;
                var = varOff.getVariable();
                text = var.getName();
                boolean bl = selectSubElement = elementCol > text.length();
                if (selectSubElement && (offsetStr = StringUtilities.findWord((String)object.toString(), (int)elementCol, (char[])UNDERSCORE_OK)) != null && offsetStr.length() > 0) {
                    text = offsetStr;
                }
                if (selectSubElement || !varOff.isIndirect()) {
                    if ((var.isStackVariable() || var.isMemoryVariable()) && (selectSubElement || varOff.getOffset() == 0L)) {
                        Varnode[] varnodes = this.getVarnodes(varOff);
                        if (varnodes == null || varnodes.length != 1) {
                            var = null;
                        } else {
                            refVarnode = varnodes[0];
                        }
                    } else if (selectSubElement) {
                        var = null;
                    }
                }
            } else {
                text = object instanceof Character ? this.buildStringFromChars(text, opLoc, opRepList) : (object instanceof LabelString ? object.toString() : StringUtilities.findWord((String)object.toString(), (int)elementCol, (char[])UNDERSCORE_AND_PERIOD_OK));
            }
        } else if (loc instanceof PcodeFieldLocation && proxyObj instanceof Instruction) {
            instr = (Instruction)proxyObj;
            int pos = ltf.screenLocationToTextOffset(row, col);
            text = StringUtilities.findWord((String)ltf.getText(), (int)pos, (char[])UNDERSCORE_OK);
            register = instr.getProgram().getRegister(text);
            if (register != null) {
                MemReferenceImpl ref = new MemReferenceImpl(instr.getAddress(), register.getAddress(), RefType.DATA, SourceType.ANALYSIS, 0, true);
                var = instr.getProgram().getReferenceManager().getReferencedVariable((Reference)ref);
                if (var != null) {
                    altText = var.getName();
                }
            }
        } else if (loc instanceof LabelFieldLocation) {
            text = ((LabelFieldLocation)loc).getName();
        } else if (proxyObj instanceof Variable) {
            var = (Variable)proxyObj;
            if (loc instanceof VariableNameFieldLocation) {
                text = var.getName();
            } else if (loc instanceof VariableLocFieldLocation) {
                int pos = ltf.screenLocationToTextOffset(row, col);
                text = StringUtilities.findWord((String)ltf.getText(), (int)pos, (char[])UNDERSCORE_OK);
                register = var.getProgram().getRegister(text);
                altText = var.getName();
            }
        }
        Address firstUseAddr = null;
        if (var != null) {
            if (register == null) {
                register = var.getRegister();
            }
            this.variableMatchFirstUseOffset = var.getFirstUseOffset();
            firstUseAddr = var.getFunction().getEntryPoint().add(this.variableMatchFirstUseOffset.longValue());
            if (instr == null) {
                instr = var.getProgram().getListing().getInstructionAt(firstUseAddr);
            }
        }
        if (register != null) {
            this.currentHighlightPattern = this.createRegisterPattern(register, text, altText);
            if (this.scopeRegisterHighlight && instr != null) {
                if (SystemUtilities.isEqual((Object)this.currentHighlightString, (Object)text)) {
                    return text;
                }
                this.scope = new AddressSet();
                this.writeScope = new AddressSet();
                this.scope.addRange(instr.getMinAddress(), instr.getMaxAddress());
                this.followScope(register, instr, firstUseAddr);
            }
            return text;
        }
        if (var != null && instr != null && (var.isStackVariable() || var.isMemoryVariable())) {
            if (SystemUtilities.isEqual((Object)this.currentHighlightString, (Object)text)) {
                return text;
            }
            this.scope = new AddressSet();
            this.writeScope = new AddressSet();
            this.scope.addRange(instr.getMinAddress(), instr.getMaxAddress());
            this.followScope(var, refVarnode, instr);
        }
        if (text == null) {
            text = ltf.getText();
            int pos = ltf.screenLocationToTextOffset(row, col);
            text = StringUtilities.findWord((String)text, (int)pos, (char[])UNDERSCORE_AND_PERIOD_OK);
        }
        if (text != null && (text = text.trim()).length() == 0) {
            text = null;
        }
        if (text != null) {
            this.currentHighlightPattern = Pattern.compile(text, 16);
        }
        return text;
    }

    private String buildStringFromChars(String text, OperandFieldLocation opLoc, OperandRepresentationList opRepList) {
        Object obj;
        StringBuilder buf = new StringBuilder();
        for (int i = opLoc.getSubOperandIndex(); i < opRepList.size() && (obj = opRepList.get(i)) instanceof Character; ++i) {
            buf.append(obj);
        }
        text = buf.toString().trim();
        if (text.length() == 0) {
            text = null;
        }
        return text;
    }

    private Set<Register> getRegisterSet(Register reg) {
        HashSet<Register> regSet = new HashSet<Register>();
        regSet.add(reg);
        for (Register r = reg.getParentRegister(); r != null; r = r.getParentRegister()) {
            regSet.add(r);
        }
        this.addChildren(reg, regSet);
        return regSet;
    }

    private void addChildren(Register reg, Set<Register> regSet) {
        for (Register r : reg.getChildRegisters()) {
            regSet.add(r);
            this.addChildren(r, regSet);
        }
    }

    private void initFunctionSubSet(AddressSet subSet, Function func, Instruction instr, Address firstUseAddr) {
        subSet.add(func.getBody());
        if (instr.getAddress().compareTo((Object)func.getEntryPoint()) < 0) {
            AddressRange rangeContaining = subSet.getRangeContaining(instr.getAddress());
            Address addr = func.getEntryPoint().previous();
            if (rangeContaining != null && addr != null) {
                rangeContaining = rangeContaining.intersectRange(rangeContaining.getMinAddress(), addr);
                subSet = subSet.intersectRange(rangeContaining.getMinAddress(), rangeContaining.getMaxAddress());
            }
        }
        if (firstUseAddr != null) {
            subSet = subSet.intersectRange(firstUseAddr, subSet.getMaxAddress());
        }
    }

    private void initUndefinedFunctionSubSet(AddressSet subSet, Instruction instr) {
        Program prog = instr.getProgram();
        int count = 0;
        Instruction followInstr = instr;
        while (count < 100 && followInstr != null && !subSet.contains(followInstr.getMinAddress())) {
            ++count;
            subSet.addRange(followInstr.getMinAddress(), followInstr.getMaxAddress());
            Address fallFrom = followInstr.getFallFrom();
            if (fallFrom == null) {
                Reference ref;
                ReferenceIterator iter = followInstr.getReferenceIteratorTo();
                if (!iter.hasNext() || (ref = iter.next()).getReferenceType().isCall()) break;
                fallFrom = ref.getFromAddress();
            }
            followInstr = prog.getListing().getInstructionContaining(fallFrom);
        }
    }

    private void setScopeBeforeInstruction(Instruction instr, AddressSet subSet, WriteChecker writeChecker) {
        Program prog = instr.getProgram();
        Stack backStack = new Stack();
        this.pushInstructionBackFlows(instr, (Stack<Address>)backStack);
        while (!backStack.isEmpty()) {
            Address addr = (Address)backStack.pop();
            if (addr == null || !subSet.contains(addr)) continue;
            subSet.deleteRange(addr, addr);
            Instruction fInstr = prog.getListing().getInstructionAt(addr);
            if (fInstr == null) continue;
            this.scope.addRange(fInstr.getMinAddress(), fInstr.getMaxAddress());
            if (writeChecker.hasWrite(fInstr)) {
                this.writeScope.addRange(fInstr.getMinAddress(), fInstr.getMaxAddress());
                continue;
            }
            this.pushInstructionBackFlows(fInstr, (Stack<Address>)backStack);
        }
    }

    private void setScopeAfterInstruction(Instruction instr, AddressSet subSet, WriteChecker writeChecker) {
        Program prog = instr.getProgram();
        Stack stack = new Stack();
        this.pushInstructionFlows(instr, (Stack<Address>)stack);
        while (!stack.isEmpty()) {
            Address addr = (Address)stack.pop();
            if (addr == null || !subSet.contains(addr)) continue;
            subSet.deleteRange(addr, addr);
            Instruction fInstr = prog.getListing().getInstructionAt(addr);
            if (fInstr == null || writeChecker.hasWrite(fInstr)) continue;
            this.scope.addRange(fInstr.getMinAddress(), fInstr.getMaxAddress());
            this.pushInstructionFlows(fInstr, (Stack<Address>)stack);
        }
    }

    private void followScope(Variable var, Varnode refVarnode, Instruction instr) {
        if (refVarnode == null) {
            return;
        }
        AddressSet subSet = new AddressSet();
        Program prog = instr.getProgram();
        Function func = var.getFunction();
        Reference[] references = prog.getReferenceManager().getReferencesTo(var);
        AddressSet writeRefSet = new AddressSet();
        for (Reference ref : references) {
            if (!ref.getReferenceType().isWrite() || ref.getReferenceType().isRead() || !refVarnode.contains(ref.getToAddress())) continue;
            writeRefSet.add(ref.getFromAddress());
        }
        this.initFunctionSubSet(subSet, func, instr, null);
        WriteChecker writeChecker = fInstr -> writeRefSet.contains(fInstr.getAddress());
        if (writeRefSet.contains(instr.getAddress())) {
            this.writeScope.addRange(instr.getMinAddress(), instr.getMaxAddress());
        } else {
            this.setScopeBeforeInstruction(instr, subSet, writeChecker);
        }
        this.setScopeAfterInstruction(instr, subSet, writeChecker);
    }

    private void followScope(Register register, Instruction instr, Address firstUseAddr) {
        Set<Register> regSet = this.getRegisterSet(register);
        AddressSet subSet = new AddressSet();
        Program prog = instr.getProgram();
        Function func = prog.getFunctionManager().getFunctionContaining(instr.getMinAddress());
        if (func != null) {
            this.initFunctionSubSet(subSet, func, instr, firstUseAddr);
        } else {
            this.initUndefinedFunctionSubSet(subSet, instr);
        }
        if (subSet.isEmpty()) {
            return;
        }
        WriteChecker writeChecker = fInstr -> this.isWriteOnly(regSet, fInstr);
        if (this.isWriteOnly(regSet, instr)) {
            this.writeScope.addRange(instr.getMinAddress(), instr.getMaxAddress());
        } else {
            this.setScopeBeforeInstruction(instr, subSet, writeChecker);
        }
        this.setScopeAfterInstruction(instr, subSet, writeChecker);
    }

    private void pushInstructionBackFlows(Instruction instr, Stack<Address> backStack) {
        ReferenceIterator refIter = instr.getReferenceIteratorTo();
        while (refIter.hasNext()) {
            Address addr;
            Reference ref = refIter.next();
            if (!ref.getReferenceType().isFlow() || (addr = ref.getFromAddress()).compareTo((Object)instr.getMinAddress()) >= 0) continue;
            backStack.push((Object)addr);
        }
        Address fallFrom = instr.getFallFrom();
        if (fallFrom != null) {
            backStack.push((Object)fallFrom);
        }
    }

    private void pushInstructionFlows(Instruction instruction, Stack<Address> stack) {
        Address[] flowAddrs;
        Instruction instr = instruction;
        for (Address addr : flowAddrs = instr.getFlows()) {
            stack.push((Object)addr);
        }
        stack.push((Object)instr.getFallThrough());
        int depth = instr.getDelaySlotDepth();
        for (int i = 0; i < depth; ++i) {
            try {
                Address nextAddr = instr.getMaxAddress().addNoWrap(1L);
                instr = instr.getProgram().getListing().getInstructionAt(nextAddr);
                stack.push((Object)nextAddr);
            }
            catch (AddressOverflowException e) {
                break;
            }
            if (instr == null) break;
            this.pushInstructionFlows(instr, stack);
        }
    }

    private boolean isWriteOnly(Set<Register> regSet, Instruction instr) {
        Object[] inObjs;
        Object[] resObjs;
        boolean isWriteOnly = false;
        Varnode vn = null;
        for (Object element : resObjs = instr.getResultObjects()) {
            Register resReg;
            if (!(element instanceof Register) || !regSet.contains(resReg = (Register)element)) continue;
            isWriteOnly = true;
            vn = new Varnode(resReg.getAddress(), resReg.getMinimumByteSize());
            break;
        }
        if (!isWriteOnly) {
            return false;
        }
        PcodeOp[] pcode = instr.getPcode();
        for (int i = pcode.length - 1; i >= 0; --i) {
            if (!vn.equals((Object)pcode[i].getOutput())) continue;
            int opcode = pcode[i].getOpcode();
            if (opcode == 26) {
                if (!pcode[i].getInput(0).equals((Object)pcode[i].getInput(1))) continue;
                return true;
            }
            if (opcode == 17 || opcode == 18) {
                return true;
            }
            if (opcode == 2) {
                return true;
            }
            if (opcode != 1) continue;
            vn = pcode[i].getInput(0);
        }
        for (Object element : inObjs = instr.getInputObjects()) {
            Register inReg;
            if (!(element instanceof Register) || !regSet.contains(inReg = (Register)element)) continue;
            isWriteOnly = false;
            break;
        }
        return isWriteOnly;
    }

    private Varnode[] getVarnodes(VariableOffset varOffset) {
        int intOff;
        DataTypeComponent cdt;
        long absOffset;
        if (varOffset.isIndirect()) {
            return null;
        }
        boolean dataAccess = varOffset.isDataAccess();
        Variable variable = varOffset.getVariable();
        long offset = varOffset.getOffset();
        long l = absOffset = offset < 0L ? -offset : offset;
        if (absOffset > Integer.MAX_VALUE) {
            return null;
        }
        VariableStorage variableStorage = variable.getVariableStorage();
        if (variableStorage.size() <= 0) {
            return null;
        }
        DataType dt = variable.getDataType();
        int varnodeOffset = 0;
        int varnodeSize = 0;
        if (dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        for (intOff = (int)absOffset; intOff > 0 || dataAccess && intOff == 0; intOff -= cdt.getOffset()) {
            if (dt instanceof TypeDef) {
                dt = ((TypeDef)dt).getBaseDataType();
            }
            if (!(dt instanceof Structure) || (cdt = ((Structure)dt).getComponentAt(intOff)) == null) break;
            varnodeOffset += cdt.getOffset();
            dt = cdt.getDataType();
        }
        if ((varnodeSize = dt.getLength()) <= 0 || intOff > varnodeSize) {
            return null;
        }
        varnodeSize -= intOff;
        varnodeOffset += intOff;
        ArrayList<Varnode> varnodes = new ArrayList<Varnode>();
        for (Varnode v : variableStorage.getVarnodes()) {
            if (varnodeOffset >= v.getSize()) {
                varnodeOffset -= v.getSize();
                continue;
            }
            int size = Math.min(v.getSize(), varnodeSize);
            varnodes.add(new Varnode(v.getAddress().add((long)varnodeOffset), size));
            if ((varnodeSize -= size) == 0) break;
            varnodeOffset = 0;
        }
        return varnodes.toArray(new Varnode[varnodes.size()]);
    }

    private void setupHighlightOptions() {
        ToolOptions opt = this.tool.getOptions("Listing Fields");
        HelpLocation hl = new HelpLocation("CodeBrowserPlugin", "Cursor_Text_Highlight");
        opt.registerOption("Cursor Text Highlight.Highlight Color", (Object)Color.YELLOW, hl, "The color to use to highlight text.");
        opt.registerOption(SCOPED_WRITE_HIGHLIGHT_COLOR, (Object)new Color(204, 204, 0), hl, "The color to use for showing a register being written.");
        opt.registerOption(SCOPED_READ_HIGHLIGHT_COLOR, (Object)new Color(0, 255, 0), hl, "The color to use for showing a register being read.");
        opt.registerOption(SCOPE_REGISTER_OPERAND, (Object)true, hl, "Enables register scoping for text highlighting.When a register is highlighted, only its scoped use is highlighted");
        opt.registerOption(DISPLAY_HIGHLIGHT_NAME, (Object)true, hl, "Enables cursor text highlighting.");
        opt.registerOption("Cursor Text Highlight.Mouse Button To Activate", (Object)GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES.MIDDLE, hl, "Selects which mouse button should be used to active cursor text highlighting");
        opt.addOptionsChangeListener((OptionsChangeListener)this);
        this.displayHighlight = opt.getBoolean(DISPLAY_HIGHLIGHT_NAME, true);
        if (!this.displayHighlight) {
            this.setHighlightString(null, null);
        }
        this.textMatchingHighlightColor = opt.getColor("Cursor Text Highlight.Highlight Color", Color.YELLOW);
        this.scopeWriteHighlightColor = opt.getColor(SCOPED_WRITE_HIGHLIGHT_COLOR, new Color(204, 204, 0));
        this.scopeReadHighlightColor = opt.getColor(SCOPED_READ_HIGHLIGHT_COLOR, new Color(0, 255, 0));
        GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES mouseButton = (GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES)opt.getEnum("Cursor Text Highlight.Mouse Button To Activate", (Enum)GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES.MIDDLE);
        this.highlightButtonOption = mouseButton.getMouseEventID();
        this.scopeRegisterHighlight = opt.getBoolean(SCOPE_REGISTER_OPERAND, true);
        opt.addOptionsChangeListener((OptionsChangeListener)this);
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (optionName.equals(DISPLAY_HIGHLIGHT_NAME)) {
            this.displayHighlight = (Boolean)newValue;
            if (!this.displayHighlight) {
                this.clearHighlight();
            }
        } else if (optionName.equals("Cursor Text Highlight.Highlight Color")) {
            this.textMatchingHighlightColor = (Color)newValue;
        } else if (optionName.equals(SCOPED_WRITE_HIGHLIGHT_COLOR)) {
            this.scopeWriteHighlightColor = (Color)newValue;
        } else if (optionName.equals(SCOPED_READ_HIGHLIGHT_COLOR)) {
            this.scopeReadHighlightColor = (Color)newValue;
        } else if (optionName.equals("Cursor Text Highlight.Mouse Button To Activate")) {
            GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES mouseButton = (GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES)((Object)newValue);
            this.highlightButtonOption = mouseButton.getMouseEventID();
        } else if (optionName.equals(SCOPE_REGISTER_OPERAND)) {
            this.scopeRegisterHighlight = (Boolean)newValue;
        }
    }

    private static interface WriteChecker {
        public boolean hasWrite(Instruction var1);
    }
}

