/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.clear;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.clear.ClearCmd;
import ghidra.app.plugin.core.clear.ClearOptions;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.disassemble.DisassemblerContextImpl;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockImpl;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.block.MultEntSubModel;
import ghidra.program.model.block.SimpleBlockModel;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;

public class ClearFlowAndRepairCmd
extends BackgroundCommand {
    private static final int FALLTHROUGH_SEARCH_LIMIT = 12;
    private AddressSetView startAddrs;
    private boolean clearData;
    private boolean clearLabels;
    private boolean clearComputedPtrRefs = true;
    private boolean clearOffcut = true;
    private boolean repair;
    private boolean repairFunctions;
    private AddressSet clearSet;
    private AddressSetView protectedSet;

    public ClearFlowAndRepairCmd(Address startAddr, boolean clearData, boolean clearLabels, boolean repair) {
        this((AddressSetView)new AddressSet(startAddr, startAddr), clearData, clearLabels, repair);
    }

    public ClearFlowAndRepairCmd(AddressSetView startAddrs, boolean clearData, boolean clearLabels, boolean repair) {
        this(startAddrs, null, clearData, clearLabels, repair);
    }

    public ClearFlowAndRepairCmd(AddressSetView startAddrs, AddressSetView protectedSet, boolean clearData, boolean clearLabels, boolean repair) {
        super("Clear Flow", false, true, true);
        this.startAddrs = startAddrs;
        this.protectedSet = protectedSet == null ? new AddressSet() : protectedSet;
        this.clearData = clearData;
        this.clearLabels = clearLabels;
        this.repair = repair;
        this.repairFunctions = repair;
    }

    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        try {
            monitor.setMessage("Examining code flow...");
            Program program = (Program)obj;
            Listing listing = program.getListing();
            Stack<Address> todoStarts = new Stack<Address>();
            CodeUnitIterator cuIter = listing.getCodeUnits(this.startAddrs, true);
            if (!cuIter.hasNext()) {
                AddressRangeIterator rangeIter = this.startAddrs.getAddressRanges();
                AddressSet expandedSet = new AddressSet(this.startAddrs);
                while (rangeIter.hasNext()) {
                    AddressRange range = (AddressRange)rangeIter.next();
                    CodeUnit cu = listing.getCodeUnitContaining(range.getMinAddress());
                    if (cu == null) continue;
                    expandedSet.addRange(cu.getMinAddress(), cu.getMaxAddress());
                }
                cuIter = listing.getCodeUnits((AddressSetView)expandedSet, true);
                this.startAddrs = expandedSet;
            }
            this.clearSet = new AddressSet();
            while (cuIter.hasNext()) {
                monitor.checkCanceled();
                CodeUnit cu = cuIter.next();
                if (cu instanceof Instruction) {
                    Instruction instr = (Instruction)cu;
                    Address ffAddr = instr.getFallFrom();
                    if (ffAddr != null && this.startAddrs.contains(ffAddr)) {
                        continue;
                    }
                } else {
                    Data d = (Data)cu;
                    if (!d.isDefined()) {
                        if (!this.startAddrs.contains(d.getAddress())) continue;
                        this.clearSet.add(d.getAddress());
                        continue;
                    }
                    if (d.isPointer() && this.clearComputedPtrRefs) {
                        this.clearComputedTableRefs(d, monitor);
                    }
                }
                todoStarts.push(cu.getMinAddress());
            }
            Address doNotRepairAddr = todoStarts.size() == 1 ? (Address)todoStarts.get(0) : null;
            AddressSet clearDataSet = new AddressSet();
            HashSet<Address> ptrDestinations = new HashSet<Address>();
            while (!todoStarts.isEmpty()) {
                Reference[] refs;
                monitor.checkCanceled();
                Address addr = (Address)todoStarts.pop();
                if (this.clearSet.contains(addr) || this.protectedSet.contains(addr)) continue;
                CodeUnit cu = listing.getCodeUnitAt(addr);
                if (cu instanceof Instruction) {
                    AddressSetView clearInstrSet = this.findInstructionFlow(program, addr, (AddressSetView)this.clearSet, todoStarts, monitor);
                    this.clearSet.add(clearInstrSet);
                    this.addDereferencedInstructionStarts(program, todoStarts, (AddressSetView)this.clearSet, clearInstrSet, monitor);
                    continue;
                }
                Data d = (Data)cu;
                if (!d.isDefined()) continue;
                AddressSet dataRange = new AddressSet(d.getMinAddress(), d.getMaxAddress());
                this.clearSet.add((AddressSetView)dataRange);
                clearDataSet.add((AddressSetView)dataRange);
                for (Reference ref : refs = d.getReferencesFrom()) {
                    ptrDestinations.add(ref.getToAddress());
                }
                this.addDereferencedInstructionStarts(program, todoStarts, (AddressSetView)this.clearSet, (AddressSetView)dataRange, monitor);
            }
            if (!this.clearData) {
                this.clearSet.delete((AddressSetView)clearDataSet);
                ClearFlowAndRepairCmd.clearBadBookmarks(program, (AddressSetView)clearDataSet, monitor);
            }
            this.clearSet.delete(this.protectedSet);
            ClearOptions opts = new ClearOptions(true);
            opts.setClearSymbols(this.clearLabels);
            ClearCmd clear = new ClearCmd((AddressSetView)this.clearSet, opts);
            clear.applyTo(obj, monitor);
            if (this.clearData && this.clearLabels) {
                SymbolTable symTable = program.getSymbolTable();
                Iterator iter = ptrDestinations.iterator();
                while (iter.hasNext()) {
                    Symbol[] syms;
                    monitor.checkCanceled();
                    Address addr = (Address)iter.next();
                    for (Symbol sym : syms = symTable.getSymbols(addr)) {
                        if (sym.getSource() == SourceType.DEFAULT) break;
                        if (sym.hasReferences()) continue;
                        sym.delete();
                    }
                }
            }
            if (this.repair) {
                this.repairFlowsInto(program, (AddressSetView)this.clearSet, doNotRepairAddr, monitor);
            }
            if (this.repairFunctions) {
                this.repairFunctions(program, (AddressSetView)this.clearSet, monitor);
            }
            return true;
        }
        catch (CancelledException e) {
            this.clearSet = null;
            return false;
        }
    }

    private void clearComputedTableRefs(Data d, TaskMonitor monitor) throws CancelledException {
        Program p = d.getProgram();
        Listing listing = p.getListing();
        ReferenceManager refMgr = p.getReferenceManager();
        Address destAddr = d.getAddress(0);
        ReferenceIterator refIter = refMgr.getReferencesTo(destAddr);
        while (refIter.hasNext()) {
            Instruction instr;
            monitor.checkCanceled();
            Reference ref = refIter.next();
            RefType refType = ref.getReferenceType();
            if (!(refType instanceof FlowType) || (instr = listing.getInstructionAt(ref.getFromAddress())) != null && !instr.getFlowType().isComputed() && !((FlowType)refType).isComputed()) continue;
            refMgr.delete(ref);
        }
    }

    private void addDereferencedInstructionStarts(Program program, Stack<Address> starts, AddressSetView clearSet, AddressSetView refFromSet, TaskMonitor monitor) throws CancelledException {
        Listing listing = program.getListing();
        ReferenceManager refMgr = program.getReferenceManager();
        AddressIterator fromAddrIter = refMgr.getReferenceSourceIterator(refFromSet, true);
        while (fromAddrIter.hasNext()) {
            Reference[] refs;
            monitor.checkCanceled();
            Address fromAddr = fromAddrIter.next();
            for (Reference ref2 : refs = refMgr.getReferencesFrom(fromAddr)) {
                Data data;
                Instruction instr;
                Address toAddr = ref2.getToAddress();
                if (clearSet.contains(toAddr) || (instr = listing.getInstructionAt(toAddr)) == null && (!this.clearData || (data = listing.getDefinedDataAt(toAddr)) == null)) continue;
                boolean clearIt = true;
                ReferenceIterator refIter = refMgr.getReferencesTo(toAddr);
                while (refIter.hasNext()) {
                    monitor.checkCanceled();
                    Reference ref = refIter.next();
                    if (clearSet.contains(ref.getFromAddress())) continue;
                    clearIt = false;
                    break;
                }
                if (!clearIt || instr != null && instr.getFallFrom() != null) continue;
                starts.push(toAddr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repairFlowContextFrom(Program program, Address fromInstrAddr, DisassemblerContextImpl context) {
        Instruction instr = program.getListing().getInstructionAt(fromInstrAddr);
        if (instr == null) {
            return;
        }
        context.flowStart(fromInstrAddr);
        try {
            program.getLanguage().parse((MemBuffer)instr, (ProcessorContext)context, instr.isInDelaySlot());
        }
        catch (Exception e) {
            return;
        }
        finally {
            context.flowAbort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repairFallThroughContextFrom(Program program, Address fromInstrAddr, DisassemblerContextImpl context) {
        Instruction instr = program.getListing().getInstructionAt(fromInstrAddr);
        if (instr == null || !instr.hasFallthrough()) {
            return;
        }
        Address fallThroughAddr = instr.getFallThrough();
        context.flowStart(fromInstrAddr);
        try {
            program.getLanguage().parse((MemBuffer)instr, (ProcessorContext)context, instr.isInDelaySlot());
            RegisterValue contextValue = context.getFlowContextValue(fallThroughAddr, true);
            program.getProgramContext().setRegisterValue(fallThroughAddr, fallThroughAddr, contextValue);
        }
        catch (Exception e) {
            return;
        }
        finally {
            context.flowAbort();
        }
    }

    private void repairFlowsInto(Program program, AddressSetView clearSet, Address ignoreStart, TaskMonitor monitor) throws CancelledException {
        AddressSetView disAddrs = this.repairFallThroughsInto(program, clearSet, ignoreStart, monitor);
        AddressSet disassemblePoints = new AddressSet();
        AddressSet dataRefSet = new AddressSet();
        ProgramContext programContext = program.getProgramContext();
        Register contextReg = programContext.getBaseContextRegister();
        DisassemblerContextImpl seedContext = null;
        ReferenceManager refMgr = program.getReferenceManager();
        if (disAddrs != null) {
            clearSet = clearSet.subtract(disAddrs);
        }
        AddressIterator addrIter = refMgr.getReferenceDestinationIterator(clearSet, true);
        while (addrIter.hasNext()) {
            monitor.checkCanceled();
            Address addr = addrIter.next();
            ReferenceIterator refIter = refMgr.getReferencesTo(addr);
            Address dataRefAddr = null;
            while (refIter.hasNext()) {
                monitor.checkCanceled();
                Reference ref = refIter.next();
                RefType refType = ref.getReferenceType();
                if (refType.isFlow()) {
                    if (addr.equals((Object)ignoreStart)) continue;
                    disassemblePoints.addRange(addr, addr);
                    if (contextReg == null) break;
                    if (seedContext == null) {
                        seedContext = new DisassemblerContextImpl(programContext);
                    }
                    this.repairFlowContextFrom(program, ref.getFromAddress(), seedContext);
                    break;
                }
                if (dataRefAddr != null || addr.equals((Object)ignoreStart) && !refType.isRead() && !refType.isWrite()) continue;
                dataRefAddr = ref.getFromAddress();
            }
            if (dataRefAddr == null || disassemblePoints.contains(addr)) continue;
            dataRefSet.addRange(dataRefAddr, dataRefAddr);
        }
        AddressIterator aiter = clearSet.getAddresses(true);
        while (aiter.hasNext()) {
            monitor.checkCanceled();
            Address addr = aiter.next();
            if (!program.getSymbolTable().isExternalEntryPoint(addr)) continue;
            disassemblePoints.addRange(addr, addr);
        }
        DisassembleCommand cmd = new DisassembleCommand((AddressSetView)disassemblePoints, null);
        cmd.setSeedContext(seedContext);
        cmd.applyTo((DomainObject)program, monitor);
        monitor.checkCanceled();
        AutoAnalysisManager analysisMgr = AutoAnalysisManager.getAnalysisManager(program);
        analysisMgr.codeDefined((AddressSetView)dataRefSet);
        analysisMgr.startAnalysis(monitor);
    }

    private AddressSetView repairFallThroughsInto(Program program, AddressSetView clearSet, Address ignoreStart, TaskMonitor monitor) throws CancelledException {
        AddressSet disassemblePoints = new AddressSet();
        Listing listing = program.getListing();
        ProgramContext programContext = program.getProgramContext();
        Register contextReg = programContext.getBaseContextRegister();
        DisassemblerContextImpl seedContext = null;
        AddressRangeIterator rangeIter = clearSet.getAddressRanges();
        block0: while (rangeIter.hasNext()) {
            monitor.checkCanceled();
            AddressRange range = (AddressRange)rangeIter.next();
            Address addr = range.getMinAddress();
            int searchCnt = 0;
            while (searchCnt < 12 && (addr = addr.previous()) != null) {
                CodeUnit cu = listing.getCodeUnitAt(addr);
                if (cu == null) {
                    if (program.getMemory().contains(addr)) continue;
                    continue block0;
                }
                if (cu instanceof Instruction) {
                    Instruction instr = (Instruction)cu;
                    if (instr.isInDelaySlot()) continue;
                    Address ftAddr = instr.getFallThrough();
                    if (ftAddr == null || ignoreStart != null && ftAddr.equals((Object)ignoreStart)) continue block0;
                    disassemblePoints.addRange(ftAddr, ftAddr);
                    if (contextReg == null) continue block0;
                    if (seedContext == null) {
                        seedContext = new DisassemblerContextImpl(programContext);
                    }
                    this.repairFallThroughContextFrom(program, instr.getMinAddress(), seedContext);
                    continue block0;
                }
                Data d = (Data)cu;
                if (d.isDefined()) continue block0;
                ++searchCnt;
            }
        }
        program.getBookmarkManager().removeBookmarks((AddressSetView)disassemblePoints, "Error", "Bad Instruction", monitor);
        DisassembleCommand cmd = new DisassembleCommand((AddressSetView)disassemblePoints, null);
        cmd.setSeedContext(seedContext);
        cmd.applyTo((DomainObject)program, monitor);
        return cmd.getDisassembledAddressSet();
    }

    void repairFunctions(Program program, AddressSetView clearSet, TaskMonitor monitor) throws CancelledException {
        FunctionManager fnMgr = program.getFunctionManager();
        MultEntSubModel subModel = new MultEntSubModel(program);
        CodeBlockIterator subIter = subModel.getCodeBlocksContaining(clearSet, monitor);
        while (subIter.hasNext()) {
            Function f;
            CodeBlock sub = subIter.next();
            HashSet<Address> starts = new HashSet<Address>(Arrays.asList(sub.getStartAddresses()));
            Iterator fnIter = fnMgr.getFunctionsOverlapping((AddressSetView)sub);
            while (fnIter.hasNext()) {
                monitor.checkCanceled();
                f = (Function)fnIter.next();
                if (starts.contains(f.getEntryPoint())) continue;
                Msg.warn((Object)((Object)this), (Object)("WARNING! Removing function with bad body at " + f.getEntryPoint()));
                fnMgr.removeFunction(f.getEntryPoint());
            }
            fnIter = fnMgr.getFunctionsOverlapping((AddressSetView)sub);
            while (fnIter.hasNext()) {
                monitor.checkCanceled();
                f = (Function)fnIter.next();
                if (!starts.remove(f.getEntryPoint())) continue;
                AddressSetView oldBody = f.getBody();
                AddressSet newBody = new AddressSet((AddressSetView)oldBody.subtract(clearSet));
                newBody.add(CreateFunctionCmd.getFunctionBody(program, f.getEntryPoint()));
                if (oldBody.equals(newBody)) continue;
                Msg.warn((Object)((Object)this), (Object)("WARNING! Repairing body of function at " + f.getEntryPoint()));
                try {
                    f.setBody((AddressSetView)newBody);
                }
                catch (OverlappingFunctionException e) {
                    Msg.error((Object)((Object)this), (Object)("... function body repair failed due to overlap with another function: " + f.getEntryPoint()));
                }
            }
            Iterator<Address> entryIter = starts.iterator();
            while (entryIter.hasNext()) {
                monitor.checkCanceled();
                Address entry = entryIter.next();
                CreateFunctionCmd cmd = new CreateFunctionCmd(entry);
                cmd.applyTo((DomainObject)program, monitor);
            }
        }
    }

    private AddressSetView findInstructionFlow(Program program, Address firstAddr, AddressSetView clearSet, Stack<Address> todoStarts, TaskMonitor monitor) throws CancelledException {
        Instruction prevInstr;
        AddressSet blockSet = new AddressSet();
        Listing listing = program.getListing();
        SymbolTable symbolTable = program.getSymbolTable();
        if (this.clearOffcut && (prevInstr = listing.getInstructionBefore(firstAddr)) != null && firstAddr.compareTo((Object)prevInstr.getMaxAddress()) <= 0) {
            this.clearOffcutFlow(listing.getInstructionAt(firstAddr), todoStarts, monitor);
            return blockSet;
        }
        Hashtable<Address, BlockVertex> vertexMap = new Hashtable<Address, BlockVertex>();
        SimpleBlockModel blockModel = new SimpleBlockModel(program);
        Stack<BlockVertex> todoVertices = new Stack<BlockVertex>();
        HashSet<Address> destAddrs = new HashSet<Address>();
        CodeBlock startBlock = blockModel.getFirstCodeBlockContaining(firstAddr, monitor);
        blockSet.add((AddressSetView)startBlock);
        BlockVertex startVertex = new BlockVertex(startBlock);
        vertexMap.put(startBlock.getMinAddress(), startVertex);
        todoVertices.push(startVertex);
        boolean neverSnipStartBlock = this.startAddrs.contains(firstAddr);
        while (!todoVertices.isEmpty()) {
            monitor.checkCanceled();
            BlockVertex fromVertex = (BlockVertex)todoVertices.pop();
            CodeBlock fromBlock = fromVertex.block;
            if (this.protectedSet.contains(fromBlock.getMinAddress())) continue;
            fromBlock = this.adjustBlockForSplitProtectedBlock(program, blockModel, fromBlock.getFirstStartAddress(), fromBlock);
            CodeBlockReferenceIterator blockRefIter = fromBlock.getDestinations(monitor);
            if (this.clearOffcut) {
                this.findDestAddrs(fromBlock, destAddrs);
            }
            while (blockRefIter.hasNext()) {
                monitor.checkCanceled();
                CodeBlockReference cbRef = blockRefIter.next();
                Address blockAddr = cbRef.getReference();
                if (this.protectedSet.contains(blockAddr) || clearSet.contains(blockAddr)) continue;
                CodeBlock destBlock = cbRef.getDestinationBlock();
                if (blockAddr.equals((Object)destBlock.getFirstStartAddress())) {
                    destBlock = this.adjustBlockForSplitProtectedBlock(program, blockModel, blockAddr, destBlock);
                }
                if (neverSnipStartBlock && destBlock.equals(startBlock)) continue;
                BlockVertex destVertex = (BlockVertex)vertexMap.get(blockAddr);
                if (destVertex == null) {
                    SourceType source;
                    Symbol s;
                    if (listing.getInstructionAt(blockAddr) == null || (s = symbolTable.getPrimarySymbol(blockAddr)) != null && s.getSymbolType() == SymbolType.FUNCTION && ((source = s.getSource()) == SourceType.USER_DEFINED || source == SourceType.IMPORTED) || this.clearOffcut && !destAddrs.contains(blockAddr) && this.clearOffcutFlow(destBlock, todoStarts, monitor)) continue;
                    blockSet.add((AddressSetView)destBlock);
                    destVertex = new BlockVertex(destBlock);
                    vertexMap.put(blockAddr, destVertex);
                    todoVertices.push(destVertex);
                }
                fromVertex.destVertices.add(destVertex);
                destVertex.srcVertices.add(fromVertex);
            }
        }
        if (!firstAddr.equals((Object)startBlock.getMinAddress())) {
            blockSet.deleteRange(startBlock.getMinAddress(), firstAddr.previous());
        }
        ReferenceManager refMgr = program.getReferenceManager();
        FunctionManager functionManager = program.getFunctionManager();
        Iterator vertexIter = vertexMap.values().iterator();
        block2: while (vertexIter.hasNext()) {
            monitor.checkCanceled();
            BlockVertex v = (BlockVertex)vertexIter.next();
            if (v == startVertex || v.srcVertices.isEmpty()) continue;
            Address addr = v.block.getMinAddress();
            Instruction instr = listing.getInstructionAt(addr);
            Address fallFrom = instr.getFallFrom();
            if (fallFrom != null && !blockSet.contains(fallFrom)) {
                this.prune(v, blockSet);
                continue;
            }
            ReferenceIterator refIter = refMgr.getReferencesTo(addr);
            if (!refIter.hasNext() && functionManager.getFunctionAt(addr) != null) {
                this.prune(v, blockSet);
                continue;
            }
            while (refIter.hasNext()) {
                monitor.checkCanceled();
                Reference ref = refIter.next();
                Address fromAddr = ref.getFromAddress();
                RefType refType = ref.getReferenceType();
                if (refType.isFlow() && !blockSet.contains(fromAddr) && !clearSet.contains(fromAddr)) {
                    this.prune(v, blockSet);
                    continue block2;
                }
                if (refType != RefType.EXTERNAL_REF || functionManager.getFunctionAt(addr) == null) continue;
                this.prune(v, blockSet);
                continue block2;
            }
        }
        if (this.repair) {
            ClearFlowAndRepairCmd.clearBadBookmarks(program, (AddressSetView)blockSet, monitor);
        }
        return blockSet;
    }

    private CodeBlock adjustBlockForSplitProtectedBlock(Program program, SimpleBlockModel blockModel, Address blockAddr, CodeBlock blockToAdjust) {
        AddressSet intersect;
        if (!(this.protectedSet.isEmpty() || (intersect = this.protectedSet.intersectRange(blockToAdjust.getMinAddress(), blockToAdjust.getMaxAddress())).isEmpty() || intersect.getMinAddress().equals((Object)blockAddr))) {
            Address[] entryPts = new Address[]{blockAddr};
            CodeBlockImpl block = new CodeBlockImpl((CodeBlockModel)blockModel, entryPts, (AddressSetView)new AddressSet(blockAddr, intersect.getMinAddress().subtract(1L)));
            blockToAdjust = block;
        }
        return blockToAdjust;
    }

    private boolean clearOffcutFlow(CodeBlock destBlock, Stack<Address> todoStarts, TaskMonitor monitor) throws CancelledException {
        Address blockEnd = destBlock.getMaxAddress();
        Address offcutStart = null;
        Instruction instr = null;
        Program program = destBlock.getModel().getProgram();
        Listing listing = program.getListing();
        InstructionIterator iter = listing.getInstructions(destBlock.getMinAddress(), true);
        while (iter.hasNext() && offcutStart == null) {
            monitor.checkCanceled();
            Instruction nextInstr = iter.next();
            Address nextInstrAddr = nextInstr.getMinAddress();
            if (nextInstrAddr.compareTo((Object)blockEnd) > 0) break;
            if (instr != null && nextInstrAddr.compareTo((Object)instr.getMaxAddress()) <= 0) {
                offcutStart = nextInstrAddr;
            }
            instr = nextInstr;
        }
        if (offcutStart == null) {
            return false;
        }
        this.clearOffcutFlow(instr, todoStarts, monitor);
        return true;
    }

    private void clearOffcutFlow(Instruction offcutInstr, Stack<Address> todoStarts, TaskMonitor monitor) throws CancelledException {
        while (offcutInstr != null) {
            Instruction prevInstr;
            Reference[] refs;
            Program program = offcutInstr.getProgram();
            Listing listing = program.getListing();
            monitor.checkCanceled();
            for (Reference ref : refs = offcutInstr.getReferencesFrom()) {
                if (!ref.getReferenceType().isFlow()) continue;
                todoStarts.add(ref.getToAddress());
            }
            Address ftAddr = offcutInstr.getFallThrough();
            if (this.repair) {
                ClearFlowAndRepairCmd.clearBadBookmarks(program, offcutInstr.getMinAddress(), offcutInstr.getMaxAddress(), monitor);
            }
            listing.clearCodeUnits(offcutInstr.getMinAddress(), offcutInstr.getMinAddress(), false);
            offcutInstr = listing.getInstructionAt(ftAddr);
            if (offcutInstr == null || (prevInstr = listing.getInstructionBefore(offcutInstr.getMinAddress())) == null || prevInstr.getMaxAddress().compareTo((Object)offcutInstr.getMinAddress()) >= 0) continue;
            offcutInstr = null;
        }
    }

    public static void clearBadBookmarks(Program program, Address start, Address end, TaskMonitor monitor) throws CancelledException {
        AddressSet set = new AddressSet(start, end);
        program.getBookmarkManager().removeBookmarks((AddressSetView)set, "Error", "Bad Instruction", monitor);
    }

    public static void clearBadBookmarks(Program program, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        BookmarkManager bookmarkMgr = program.getBookmarkManager();
        Listing listing = program.getListing();
        for (AddressRange range : set.getAddressRanges()) {
            Bookmark bookmark;
            Address nextAddr;
            monitor.checkCanceled();
            Address maxAddr = range.getMaxAddress();
            Instruction lastInstr = listing.getInstructionContaining(maxAddr);
            if (lastInstr == null || (nextAddr = lastInstr.getFallThrough()) == null || listing.getDataContaining(nextAddr) == null || (bookmark = bookmarkMgr.getBookmark(nextAddr, "Error", "Bad Instruction")) == null) continue;
            bookmarkMgr.removeBookmark(bookmark);
        }
        ReferenceManager referenceManager = program.getReferenceManager();
        AddressIterator refIter = referenceManager.getReferenceSourceIterator(set, true);
        for (Address address : refIter) {
            Reference[] referencesFrom;
            for (Reference reference : referencesFrom = referenceManager.getReferencesFrom(address)) {
                Address toAddr = reference.getToAddress();
                if (set.contains(toAddr) || listing.getInstructionAt(toAddr) != null || program.getBookmarkManager().getBookmarks(toAddr).length == 0) continue;
                int referenceCountTo = referenceManager.getReferenceCountTo(toAddr);
                if (referenceCountTo > 1) {
                    ReferenceIterator referencesTo = referenceManager.getReferencesTo(toAddr);
                    int flowCount = 0;
                    for (Reference referenceTo : referencesTo) {
                        if (!referenceTo.getReferenceType().isFlow()) continue;
                        ++flowCount;
                    }
                    if (flowCount != 1) continue;
                }
                ClearFlowAndRepairCmd.clearBadBookmarks(program, toAddr, toAddr, monitor);
            }
        }
        bookmarkMgr.removeBookmarks(set, "Error", "Bad Instruction", monitor);
    }

    private void findDestAddrs(CodeBlock block, Set<Address> destAddrs) {
        Reference[] refs;
        destAddrs.clear();
        Listing listing = block.getModel().getProgram().getListing();
        Instruction instr = listing.getInstructionContaining(block.getMaxAddress());
        while (instr != null && instr.isInDelaySlot()) {
            Address ffAddr = instr.getFallFrom();
            instr = ffAddr != null ? listing.getInstructionAt(ffAddr) : null;
        }
        if (instr == null) {
            return;
        }
        Address ftAddr = instr.getFallThrough();
        if (ftAddr != null) {
            destAddrs.add(ftAddr);
        }
        for (Reference ref : refs = instr.getReferencesFrom()) {
            if (!ref.getReferenceType().isFlow()) continue;
            destAddrs.add(ref.getToAddress());
        }
    }

    private void prune(BlockVertex v, AddressSet blockSet) {
        Stack<BlockVertex> pruneStack = new Stack<BlockVertex>();
        pruneStack.push(v);
        while (!pruneStack.isEmpty()) {
            v = (BlockVertex)pruneStack.pop();
            blockSet.delete((AddressSetView)v.block);
            for (BlockVertex fromVertex : v.srcVertices) {
                fromVertex.destVertices.remove(v);
            }
            v.srcVertices.clear();
            Iterator<BlockVertex> iter = v.destVertices.iterator();
            while (iter.hasNext()) {
                pruneStack.push(iter.next());
            }
        }
    }

    private static class BlockVertex {
        final CodeBlock block;
        final Set<BlockVertex> srcVertices = new HashSet<BlockVertex>();
        final Set<BlockVertex> destVertices = new HashSet<BlockVertex>();

        BlockVertex(CodeBlock block) {
            this.block = block;
        }
    }
}

