/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.memory;

import ghidra.app.cmd.memory.MoveBlockListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockException;
import ghidra.program.model.mem.MemoryConflictException;
import ghidra.program.util.ProgramTask;
import ghidra.util.Msg;
import ghidra.util.exception.NotFoundException;
import ghidra.util.exception.RollbackException;
import ghidra.util.task.TaskMonitor;

public class MoveBlockTask
extends ProgramTask {
    private Address currentStart;
    private Address newStart;
    private MoveBlockListener listener;
    private boolean wasCancelled;
    private boolean status;

    public MoveBlockTask(Program program, Address currentStart, Address newStart, MoveBlockListener listener) {
        super(program, "Move Block", true, false, true);
        this.currentStart = currentStart;
        this.newStart = newStart;
        this.listener = listener;
    }

    protected void doRun(TaskMonitor monitor) {
        Memory mem = this.program.getMemory();
        MemoryBlock block = mem.getBlock(this.currentStart);
        monitor.setMessage("Moving Memory Block ...");
        String msg = "";
        Throwable cause = null;
        try {
            mem.moveBlock(block, this.newStart, monitor);
            if (!monitor.isCancelled()) {
                this.status = true;
                this.listener.moveBlockCompleted(this);
                return;
            }
            this.wasCancelled = true;
        }
        catch (OutOfMemoryError e) {
            msg = "Insufficient memory to complete operation";
            monitor.setMessage("Insufficient memory to complete operation");
            cause = e;
        }
        catch (NotFoundException exc) {
            msg = "Memory block not found";
            monitor.setMessage("Memory block not found");
            cause = exc;
        }
        catch (MemoryConflictException exc) {
            msg = exc.getMessage();
            monitor.setMessage(msg);
            cause = exc;
        }
        catch (MemoryBlockException exc) {
            msg = exc.getMessage();
            monitor.setMessage(msg);
            cause = exc;
        }
        catch (IllegalArgumentException e) {
            msg = e.getMessage();
            monitor.setMessage(msg);
            cause = e;
        }
        catch (Throwable t) {
            Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + t.getMessage()), (Throwable)t);
            msg = t.getMessage();
            if (msg == null) {
                msg = t.toString();
            }
            monitor.setMessage(msg);
            cause = t;
        }
        this.listener.moveBlockCompleted(this);
        throw new RollbackException(msg, cause);
    }

    public boolean isCancelled() {
        return this.wasCancelled;
    }

    public boolean getStatus() {
        return this.status;
    }
}

