/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.symbol;

import ghidra.program.model.address.Address;
import ghidra.program.model.symbol.DynamicReference;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;

public class ThunkReference
implements DynamicReference {
    private static final int OPINDEX = -2;
    private Address fromAddr;
    private Address toAddr;

    public ThunkReference(Address thunkAddr, Address thunkedAddr) {
        this.fromAddr = thunkAddr;
        this.toAddr = thunkedAddr;
    }

    @Override
    public Address getFromAddress() {
        return this.fromAddr;
    }

    @Override
    public Address getToAddress() {
        return this.toAddr;
    }

    @Override
    public boolean isPrimary() {
        return false;
    }

    @Override
    public long getSymbolID() {
        return -1L;
    }

    @Override
    public RefType getReferenceType() {
        return RefType.THUNK;
    }

    @Override
    public int getOperandIndex() {
        return -2;
    }

    @Override
    public boolean isMnemonicReference() {
        return true;
    }

    @Override
    public boolean isOperandReference() {
        return false;
    }

    @Override
    public int compareTo(Reference ref) {
        int result = this.fromAddr.compareTo(ref.getFromAddress());
        if (result == 0 && (result = -2 - ref.getOperandIndex()) == 0) {
            return this.toAddr.compareTo(ref.getToAddress());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Reference)) {
            return false;
        }
        Reference ref = (Reference)obj;
        return ref.getReferenceType() == RefType.THUNK && this.fromAddr.equals(ref.getFromAddress()) && this.toAddr.equals(ref.getToAddress());
    }

    @Override
    public boolean isExternalReference() {
        return false;
    }

    @Override
    public boolean isOffsetReference() {
        return false;
    }

    @Override
    public boolean isShiftedReference() {
        return false;
    }

    @Override
    public boolean isEntryPointReference() {
        return false;
    }

    @Override
    public boolean isMemoryReference() {
        return false;
    }

    @Override
    public boolean isRegisterReference() {
        return false;
    }

    @Override
    public boolean isStackReference() {
        return false;
    }

    @Override
    public SourceType getSource() {
        return SourceType.DEFAULT;
    }
}

