/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public abstract class HighSymbol {
    protected String name;
    protected DataType type;
    protected int size;
    protected Address pcaddr;
    protected HighFunction function;
    private boolean namelock;
    private boolean typelock;
    private boolean readonly;
    private HighVariable highVariable;

    public HighSymbol() {
    }

    public HighSymbol(String nm, DataType tp, int sz, Address pc, HighFunction func) {
        this.name = nm;
        this.type = tp;
        this.size = sz;
        this.pcaddr = pc;
        this.namelock = false;
        this.typelock = false;
        this.function = func;
    }

    public void setHighVariable(HighVariable high) {
        this.highVariable = high;
    }

    public HighVariable getHighVariable() {
        return this.highVariable;
    }

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    public Address getPCAddress() {
        return this.pcaddr;
    }

    public HighFunction getHighFunction() {
        return this.function;
    }

    public void setTypeLock(boolean typelock) {
        this.typelock = typelock;
    }

    public void setNameLock(boolean namelock) {
        this.namelock = namelock;
    }

    public void setReadOnly(boolean readOnly) {
        this.readonly = readOnly;
    }

    public boolean isTypeLocked() {
        return this.typelock;
    }

    public boolean isNameLocked() {
        return this.namelock;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public abstract String buildXML();

    public abstract int restoreXML(XmlPullParser var1, HighFunction var2) throws PcodeXMLException;

    protected int restoreSymbolXML(XmlElement symel, HighFunction func) throws PcodeXMLException {
        this.function = func;
        int symbolId = SpecXmlUtils.decodeInt((String)symel.getAttribute("id"));
        if (symbolId == 0) {
            throw new PcodeXMLException("missing unique symbol id");
        }
        this.typelock = false;
        String typelockstr = symel.getAttribute("typelock");
        if (typelockstr != null && SpecXmlUtils.decodeBoolean((String)typelockstr)) {
            this.typelock = true;
        }
        this.namelock = false;
        String namelockstr = symel.getAttribute("namelock");
        if (namelockstr != null && SpecXmlUtils.decodeBoolean((String)namelockstr)) {
            this.namelock = true;
        }
        this.name = symel.getAttribute("name");
        return symbolId;
    }

    protected Address parseRangeList(XmlPullParser parser) {
        Address addr = null;
        XmlElement rangelistel = parser.start(new String[]{"rangelist"});
        if (parser.peek().isStart()) {
            XmlElement rangeel = parser.start(new String[]{"range"});
            String spc = rangeel.getAttribute("space");
            long offset = SpecXmlUtils.decodeLong((String)rangeel.getAttribute("first"));
            addr = this.function.getAddressFactory().getAddressSpace(spc).getAddress(offset);
            addr = this.function.getFunction().getEntryPoint().getAddressSpace().getOverlayAddress(addr);
            parser.end(rangeel);
        }
        parser.end(rangelistel);
        return addr;
    }

    public static void buildMapSymXML(StringBuilder res, String addrHashRes, Address pc, String sym) {
        res.append("<mapsym>\n");
        res.append(sym);
        res.append(addrHashRes);
        if (pc == null || pc.isExternalAddress()) {
            res.append("<rangelist/>");
        } else {
            HighSymbol.buildRangelistXML(res, pc);
        }
        res.append("</mapsym>\n");
    }

    public static void buildRangelistXML(StringBuilder res, Address pc) {
        res.append("<rangelist>");
        if (pc != null) {
            AddressSpace space = pc.getAddressSpace();
            if (space.isOverlaySpace()) {
                space = space.getPhysicalSpace();
                pc = space.getAddress(pc.getOffset());
            }
            res.append("<range");
            SpecXmlUtils.encodeStringAttribute((StringBuilder)res, (String)"space", (String)space.getName());
            long off = pc.getUnsignedOffset();
            SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)res, (String)"first", (long)off);
            SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)res, (String)"last", (long)off);
            res.append("/>");
        }
        res.append("</rangelist>\n");
    }
}

