/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataImage;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.MemBufferImageInputStream;
import ghidra.program.model.data.Resource;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Msg;
import java.awt.image.BufferedImage;
import java.nio.ByteOrder;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class JPEGDataType
extends BuiltIn
implements Dynamic,
Resource {
    public static byte[] MAGIC = new byte[]{-1, -40, 0, 0, 0, 0, 74, 70, 73, 70, 0};
    public static byte[] MAGIC_MASK = new byte[]{-1, -1, 0, 0, 0, 0, -1, -1, -1, -1, -1};

    public JPEGDataType() {
        this(null);
    }

    public JPEGDataType(DataTypeManager dtm) {
        super(null, "JPEG-Image", dtm);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public int getLength(MemBuffer buf, int maxLength) {
        try {
            if (!this.checkMagic(buf)) {
                return -1;
            }
            MemBufferImageInputStream inputStream = new MemBufferImageInputStream(buf, ByteOrder.BIG_ENDIAN);
            BufferedImage image = ImageIO.read(inputStream);
            if (image != null) {
                int length = inputStream.getConsumedLength();
                return length;
            }
        }
        catch (Exception e) {
            Msg.debug((Object)this, (Object)("Invalid JPEG data at " + buf.getAddress()));
        }
        return -1;
    }

    private boolean checkMagic(MemBuffer buf) throws MemoryAccessException {
        for (int i = 0; i < MAGIC.length; ++i) {
            if (MAGIC[i] == (buf.getByte(i) & MAGIC_MASK[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canSpecifyLength() {
        return false;
    }

    @Override
    public boolean isDynamicallySized() {
        return true;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new JPEGDataType(dtm);
    }

    @Override
    public String getDescription() {
        return "JPEG Image stored within program";
    }

    @Override
    public String getMnemonic(Settings settings) {
        return "JPG";
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "<JPEG-Image>";
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        byte[] data = new byte[length];
        if (buf.getBytes(data, 0) != length) {
            return null;
        }
        return new JPEGDataImage(data);
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return JPEGDataImage.class;
    }

    @Override
    public String getDefaultLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        return "JPEG";
    }

    @Override
    public DataType getReplacementBaseType() {
        return ByteDataType.dataType;
    }

    private static class JPEGDataImage
    extends DataImage {
        private final byte[] data;

        JPEGDataImage(byte[] data) {
            this.data = data;
        }

        @Override
        public ImageIcon getImageIcon() {
            return new ImageIcon(this.data, "<JPEG-Image>");
        }
    }
}

