/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import generic.complex.Complex;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.WrappedMemBuffer;
import java.math.BigDecimal;

public abstract class AbstractComplexDataType
extends BuiltIn {
    private static final long serialVersionUID = 1L;
    private final AbstractFloatDataType floatType;

    public AbstractComplexDataType(String name, AbstractFloatDataType floats, DataTypeManager dtm) {
        super(null, name, dtm);
        this.floatType = floats;
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.name;
    }

    @Override
    public int getLength() {
        return this.floatType.getLength() * 2;
    }

    @Override
    public String getDescription() {
        return "The data type for a complex number: a + bi";
    }

    @Override
    public boolean isDynamicallySized() {
        return false;
    }

    private static double toDouble(Object obj) {
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof Float) {
            return ((Float)obj).floatValue();
        }
        if (obj instanceof Short) {
            return ((Short)obj).shortValue();
        }
        if (obj instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)obj;
            return bd.doubleValue();
        }
        throw new IllegalArgumentException(obj + "(" + obj.getClass() + ")");
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        Object a = this.floatType.getValue(buf, settings, length / 2);
        WrappedMemBuffer wrp = new WrappedMemBuffer(buf, length / 2);
        Object b = this.floatType.getValue(wrp, settings, length / 2);
        return new Complex(AbstractComplexDataType.toDouble(a), AbstractComplexDataType.toDouble(b));
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        Object val = this.getValue(buf, settings, length);
        if (val == null) {
            return "??";
        }
        return val.toString();
    }
}

