/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.BooleanField;
import db.ByteField;
import db.DBHandle;
import db.Field;
import db.IntField;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.ManagerDB;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.code.CodeManager;
import ghidra.program.database.external.ExternalManagerDB;
import ghidra.program.database.function.FunctionManagerDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.references.ReferenceDBManager;
import ghidra.program.database.symbol.AddressSetFilteredSymbolIterator;
import ghidra.program.database.symbol.ClassSymbol;
import ghidra.program.database.symbol.CodeSymbol;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.database.symbol.GhidraClassDB;
import ghidra.program.database.symbol.GlobalRegisterSymbol;
import ghidra.program.database.symbol.LabelHistoryAdapter;
import ghidra.program.database.symbol.LibraryDB;
import ghidra.program.database.symbol.LibrarySymbol;
import ghidra.program.database.symbol.NamespaceDB;
import ghidra.program.database.symbol.NamespaceManager;
import ghidra.program.database.symbol.NamespaceSymbol;
import ghidra.program.database.symbol.OldVariableStorageManagerDB;
import ghidra.program.database.symbol.SymbolDB;
import ghidra.program.database.symbol.SymbolDatabaseAdapter;
import ghidra.program.database.symbol.SymbolMatcher;
import ghidra.program.database.symbol.VariableStorageManagerDB;
import ghidra.program.database.symbol.VariableSymbolDB;
import ghidra.program.database.util.AndQuery;
import ghidra.program.database.util.EmptyRecordIterator;
import ghidra.program.database.util.FieldMatchQuery;
import ghidra.program.database.util.OrQuery;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressMapImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OldGenericNamespaceAddress;
import ghidra.program.model.address.SpecialAddress;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.symbol.LabelHistory;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.LanguageTranslator;
import ghidra.util.Lock;
import ghidra.util.Msg;
import ghidra.util.UserSearchUtils;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class SymbolManager
implements SymbolTable,
ManagerDB {
    private static final String OLD_LOCAL_SYMBOLS_TABLE = "OldLocalSymbols";
    private static final int OLD_SYMBOL_ADDR_COL = 0;
    private static final int OLD_SYMBOL_NAME_COL = 1;
    private static final int OLD_SYMBOL_IS_PRIMARY_COL = 2;
    private static final Schema OLD_LOCAL_SYMBOLS_SCHEMA = new Schema(0, "ID", new Class[]{LongField.class, StringField.class, BooleanField.class}, new String[]{"OldAddress", "Name", "IsPrimary"});
    static final String OLD_EXTERNAL_ENTRY_TABLE_NAME = "External Entries";
    static final Byte DYNAMIC_ADDRESS_MAP_ID = 64;
    private AddressMap addrMap;
    private SymbolDatabaseAdapter adapter;
    private LabelHistoryAdapter historyAdapter;
    private DBObjectCache<SymbolDB> cache;
    private ProgramDB program;
    private ReferenceDBManager refManager;
    private NamespaceManager namespaceMgr;
    private VariableStorageManagerDB variableStorageMgr;
    private OldVariableStorageManagerDB oldVariableStorageMgr;
    private AddressMapImpl dynamicSymbolAddressMap;
    private Lock lock;
    static final Symbol[] NO_SYMBOLS = new SymbolDB[0];
    private static final int MAX_DUPLICATE_COUNT = 10;

    public SymbolManager(DBHandle handle, AddressMap addrMap, int openMode, Lock lock, TaskMonitor monitor) throws CancelledException, IOException, VersionException {
        this.addrMap = addrMap;
        this.lock = lock;
        this.dynamicSymbolAddressMap = new AddressMapImpl(64, addrMap.getAddressFactory());
        this.initializeAdapters(handle, openMode, monitor);
        this.cache = new DBObjectCache(100);
        this.variableStorageMgr = new VariableStorageManagerDB(handle, addrMap, openMode, lock, monitor);
        if (OldVariableStorageManagerDB.isOldVariableStorageManagerUpgradeRequired(handle)) {
            this.oldVariableStorageMgr = new OldVariableStorageManagerDB(handle, addrMap, openMode, lock, monitor);
        }
    }

    private void initializeAdapters(DBHandle handle, int openMode, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        VersionException versionExc = null;
        try {
            this.adapter = SymbolDatabaseAdapter.getAdapter(handle, openMode, this.addrMap, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        try {
            this.historyAdapter = LabelHistoryAdapter.getAdapter(handle, openMode, this.addrMap, monitor);
        }
        catch (VersionException e) {
            versionExc = e.combine(versionExc);
        }
        if (versionExc != null) {
            throw versionExc;
        }
    }

    public Address findVariableStorageAddress(VariableStorage storage) throws IOException {
        return this.variableStorageMgr.getVariableStorageAddress(storage, false);
    }

    @Override
    public void setProgram(ProgramDB program) {
        this.program = program;
        this.refManager = (ReferenceDBManager)program.getReferenceManager();
        this.namespaceMgr = program.getNamespaceManager();
        this.variableStorageMgr.setProgram(program);
        if (this.oldVariableStorageMgr != null) {
            this.oldVariableStorageMgr.setProgram(program);
        }
    }

    @Override
    public void programReady(int openMode, int currentRevision, TaskMonitor monitor) throws IOException, CancelledException {
        if (this.oldVariableStorageMgr != null) {
            this.oldVariableStorageMgr.programReady(openMode, currentRevision, monitor);
        }
        if (openMode == 3) {
            this.processOldLocalSymbols(monitor);
            this.processOldExternalEntryPoints(monitor);
            if (currentRevision < 10) {
                this.upgradeOldNamespaceAddresses(monitor);
                this.processOldVariableAddresses(monitor);
            }
            if (currentRevision < 17) {
                this.processOldExternalTypes(monitor);
            }
            if (this.oldVariableStorageMgr != null) {
                if (this.oldVariableStorageMgr.isUpgradeOldVariableAddressesRequired()) {
                    this.processOldVariableAddresses(monitor);
                } else {
                    this.migrateFromOldVariableStorageManager(monitor);
                }
            } else if (currentRevision == 18) {
                this.processOldVariableAddresses(monitor);
            }
        }
    }

    private boolean upgradeOldNamespaceAddresses(TaskMonitor monitor) throws IOException, CancelledException {
        Symbol[] syms;
        ReferenceDBManager refMgr = (ReferenceDBManager)this.program.getReferenceManager();
        Address nextExtAddr = this.getNextExternalSymbolAddress();
        for (Symbol sym : syms = this.getSymbols(Address.NO_ADDRESS)) {
            SymbolDB libSym = (SymbolDB)sym;
            if (libSym.getSymbolType() != SymbolType.LIBRARY) continue;
            monitor.setMessage("Processing Old External Addresses...");
            monitor.initialize(1L);
            RecordIterator recIter = this.adapter.getSymbolsByNamespace(libSym.getID());
            while (recIter.hasNext()) {
                Record rec = recIter.next();
                Address oldAddr = this.addrMap.decodeAddress(rec.getLongValue(1));
                if (!(oldAddr instanceof OldGenericNamespaceAddress)) continue;
                this.moveSymbolsAt(oldAddr, nextExtAddr);
                refMgr.moveReferencesTo(oldAddr, nextExtAddr, monitor);
                nextExtAddr = nextExtAddr.next();
            }
            libSym.setSymbolData2(0);
        }
        return true;
    }

    private void processOldExternalTypes(TaskMonitor monitor) throws IOException, CancelledException {
        monitor.setMessage("Migrating External Symbols...");
        monitor.initialize(1L);
        RecordIterator symbolRecordIterator = this.adapter.getSymbols(AddressSpace.EXTERNAL_SPACE.getMinAddress(), AddressSpace.EXTERNAL_SPACE.getMaxAddress(), true);
        while (symbolRecordIterator.hasNext()) {
            monitor.checkCanceled();
            Record rec = symbolRecordIterator.next();
            rec.setByteValue(3, SymbolType.CODE.getID());
            this.adapter.updateSymbolRecord(rec);
        }
        monitor.setProgress(1L);
    }

    private void processOldVariableAddresses(TaskMonitor monitor) throws IOException, CancelledException {
        monitor.setMessage("Upgrading Variable Symbols...");
        monitor.initialize((long)this.adapter.getSymbolCount());
        int cnt = 0;
        Table table = this.adapter.getTable();
        RecordIterator symbolRecordIterator = this.adapter.getSymbols();
        while (symbolRecordIterator.hasNext()) {
            byte typeID;
            SymbolType type;
            monitor.checkCanceled();
            monitor.setProgress((long)(++cnt));
            Record rec = symbolRecordIterator.next();
            long addr = rec.getLongValue(1);
            Address oldAddress = this.addrMap.decodeAddress(addr);
            if (!(oldAddress instanceof OldGenericNamespaceAddress) || (type = SymbolType.getSymbolType(typeID = rec.getByteValue(3))) != SymbolType.LOCAL_VAR && type != SymbolType.PARAMETER && type != SymbolType.GLOBAL_VAR) continue;
            Address storageAddr = oldAddress.getNewAddress(oldAddress.getOffset());
            this.refManager.moveReferencesTo(oldAddress, storageAddr, monitor);
            try {
                Address variableAddr = this.getUpgradedVariableAddress(storageAddr, rec.getLongValue(4));
                rec.setLongValue(1, this.addrMap.getKey(variableAddr, true));
                table.putRecord(rec);
            }
            catch (InvalidInputException e) {
                Symbol parent = this.getSymbol(rec.getLongValue(2));
                Msg.warn((Object)this, (Object)("Variable symbol upgrade problem: " + parent.getName() + ":" + rec.getString(0)));
            }
        }
    }

    public void migrateFromOldVariableStorageManager(TaskMonitor monitor) throws CancelledException {
        try {
            Address maxAddr = this.getMaxSymbolAddress(AddressSpace.VARIABLE_SPACE);
            if (maxAddr == null) {
                this.oldVariableStorageMgr.deleteTable();
                this.oldVariableStorageMgr = null;
                return;
            }
            RecordIterator recIter = this.adapter.getSymbols(AddressSpace.VARIABLE_SPACE.getMinAddress(), maxAddr, true);
            Address newVarAddr = null;
            Address curVarAddr = null;
            long curDataTypeId = -1L;
            while (recIter.hasNext()) {
                monitor.checkCanceled();
                Record rec = recIter.next();
                Address addr = this.addrMap.decodeAddress(rec.getLongValue(1));
                if (!addr.isVariableAddress()) {
                    throw new RuntimeException("Unexpected");
                }
                long dataTypeId = rec.getLongValue(4);
                if (curVarAddr == null || !addr.equals(curVarAddr) || dataTypeId != curDataTypeId) {
                    curVarAddr = addr;
                    curDataTypeId = rec.getLongValue(4);
                    Address storageAddr = this.oldVariableStorageMgr.getStorageAddress(addr);
                    try {
                        newVarAddr = this.getUpgradedVariableAddress(storageAddr, curDataTypeId);
                    }
                    catch (InvalidInputException e) {
                        Symbol parent = this.getSymbol(rec.getLongValue(2));
                        Msg.warn((Object)this, (Object)("Variable symbol upgrade problem: " + parent.getName() + ":" + rec.getString(0)));
                        curVarAddr = null;
                        newVarAddr = this.variableStorageMgr.getVariableStorageAddress(VariableStorage.BAD_STORAGE, true);
                    }
                }
                rec.setLongValue(1, this.addrMap.getKey(newVarAddr, true));
                this.adapter.updateSymbolRecord(rec);
            }
            this.oldVariableStorageMgr.deleteTable();
            this.oldVariableStorageMgr = null;
        }
        catch (IOException e) {
            this.dbError(e);
        }
    }

    private Address getUpgradedVariableAddress(Address storageAddr, long dataTypeId) throws InvalidInputException, IOException {
        DataType dt = this.getDataType(dataTypeId);
        LocalVariableImpl var = new LocalVariableImpl(null, 0, dt, storageAddr, (Program)this.program);
        return this.variableStorageMgr.getVariableStorageAddress(var.getVariableStorage(), true);
    }

    private void processOldExternalEntryPoints(TaskMonitor monitor) throws IOException, CancelledException {
        Table table = this.program.getDBHandle().getTable(OLD_EXTERNAL_ENTRY_TABLE_NAME);
        if (table == null) {
            return;
        }
        AddressMap oldAddrMap = this.addrMap.getOldAddressMap();
        monitor.setMessage("Upgrading External Entry Points...");
        monitor.initialize((long)table.getRecordCount());
        int cnt = 0;
        RecordIterator iter = table.iterator();
        while (iter.hasNext()) {
            monitor.checkCanceled();
            Record rec = iter.next();
            Address addr = oldAddrMap.decodeAddress(rec.getKey());
            this.refManager.addExternalEntryPointRef(addr);
            monitor.setProgress((long)(++cnt));
        }
        this.program.getDBHandle().deleteTable(OLD_EXTERNAL_ENTRY_TABLE_NAME);
    }

    private void processOldLocalSymbols(TaskMonitor monitor) throws IOException, CancelledException {
        Table table = this.program.getDBHandle().getScratchPad().getTable(OLD_LOCAL_SYMBOLS_TABLE);
        if (table == null) {
            return;
        }
        AddressMap oldAddrMap = this.addrMap.getOldAddressMap();
        monitor.setMessage("Upgrading Local Symbols...");
        monitor.initialize((long)table.getRecordCount());
        int cnt = 0;
        RecordIterator iter = table.iterator();
        while (iter.hasNext()) {
            monitor.checkCanceled();
            Record rec = iter.next();
            Address addr = oldAddrMap.decodeAddress(rec.getLongValue(0));
            Namespace namespace = this.namespaceMgr.getNamespaceContaining(addr);
            if (namespace.getID() != 0L) {
                Object name = rec.getString(1);
                if (SymbolUtilities.startsWithDefaultDynamicPrefix((String)name)) {
                    name = "_" + (String)name;
                }
                boolean success = false;
                while (!success) {
                    try {
                        this.addSymbolRecord(rec.getKey(), addr, namespace, (String)name, rec.getBooleanValue(2), SymbolType.CODE, SourceType.USER_DEFINED);
                        success = true;
                    }
                    catch (DuplicateNameException e) {
                        name = rec.getString(1) + ++cnt;
                    }
                }
            }
            monitor.setProgress((long)(++cnt));
        }
    }

    public static void saveLocalSymbol(DBHandle tmpHandle, long symbolID, long oldAddr, String name, boolean isPrimary) throws IOException {
        Table table = tmpHandle.getTable(OLD_LOCAL_SYMBOLS_TABLE);
        if (table == null) {
            table = tmpHandle.createTable(OLD_LOCAL_SYMBOLS_TABLE, OLD_LOCAL_SYMBOLS_SCHEMA);
        }
        Record rec = OLD_LOCAL_SYMBOLS_SCHEMA.createRecord(symbolID);
        rec.setLongValue(0, oldAddr);
        rec.setString(1, name);
        rec.setBooleanValue(2, isPrimary);
        table.putRecord(rec);
    }

    void checkDuplicateSymbolName(Address addr, String name, Namespace namespace, SymbolType type) throws DuplicateNameException {
        if (addr.isMemoryAddress() && this.getSymbol(name, addr, namespace) != null) {
            throw new DuplicateNameException("A symbol named " + name + " already exists at this address!");
        }
        if (name.length() == 0) {
            return;
        }
        if (type.allowsDuplicates()) {
            return;
        }
        List<Symbol> symbolList = this.getSymbols(name, namespace);
        for (Symbol symbol : symbolList) {
            if (symbol.getSymbolType().allowsDuplicates()) continue;
            throw new DuplicateNameException("A " + symbol.getSymbolType() + " symbol with name " + name + " already exists in namespace " + symbol.getParentNamespace().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void convertDynamicSymbol(SymbolDB symbol, String newName, long newParentID, SourceType source) {
        if (source == SourceType.DEFAULT) {
            String msg = "Can't rename dynamic symbol '" + symbol.getName() + "' and set its new source to DEFAULT.";
            throw new IllegalArgumentException(msg);
        }
        this.lock.acquire();
        try {
            long oldKey = symbol.getKey();
            Address address = symbol.getAddress();
            this.symbolRemoved(symbol, address, symbol.getName(), oldKey, 0L, null);
            Record record = this.adapter.createSymbol(newName, address, newParentID, SymbolType.CODE, 0L, 1, null, source);
            symbol.setRecord(record);
            this.symbolAdded(symbol);
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    SymbolDB getFunctionSymbol(Namespace namespace) {
        if (namespace.getID() == 0L) {
            return null;
        }
        SymbolDB symbol = (SymbolDB)namespace.getSymbol();
        while (true) {
            if (symbol.getSymbolType() == SymbolType.FUNCTION) {
                return symbol;
            }
            if (symbol.getParentID() == 0L) break;
            symbol = (SymbolDB)symbol.getParentSymbol();
        }
        return null;
    }

    private void addSymbolRecord(long symbolID, Address addr, Namespace namespace, String name, boolean isPrimary, SymbolType type, SourceType source) throws DuplicateNameException, IOException {
        if (this.getSymbol(symbolID) != null) {
            throw new IllegalArgumentException("Duplicate symbol ID");
        }
        this.checkDuplicateSymbolName(addr, name, namespace, type);
        Record rec = SymbolDatabaseAdapter.SYMBOL_SCHEMA.createRecord(symbolID);
        rec.setString(0, name);
        rec.setLongValue(1, this.addrMap.getKey(addr, true));
        rec.setLongValue(2, namespace.getID());
        rec.setByteValue(3, type.getID());
        rec.setLongValue(4, -1L);
        rec.setIntValue(5, isPrimary ? 1 : 0);
        rec.setByteValue(7, (byte)source.ordinal());
        this.adapter.updateSymbolRecord(rec);
    }

    private SymbolDB makeSymbol(Address addr, Record record, SymbolType type) {
        if (addr == null) {
            addr = this.addrMap.decodeAddress(record.getLongValue(1));
        }
        if (type == SymbolType.CLASS) {
            return new ClassSymbol(this, this.cache, addr, record);
        }
        if (type == SymbolType.CODE) {
            return new CodeSymbol(this, this.cache, addr, record);
        }
        if (type == SymbolType.NAMESPACE) {
            return new NamespaceSymbol(this, this.cache, addr, record);
        }
        if (type == SymbolType.FUNCTION) {
            return new FunctionSymbol(this, this.cache, addr, record);
        }
        if (type == SymbolType.LIBRARY) {
            return new LibrarySymbol(this, this.cache, addr, record);
        }
        if (type == SymbolType.PARAMETER || type == SymbolType.LOCAL_VAR) {
            return new VariableSymbolDB(this, this.cache, type, this.variableStorageMgr, addr, record);
        }
        if (type == SymbolType.GLOBAL_VAR) {
            return new GlobalRegisterSymbol(this, this.cache, addr, record);
        }
        throw new IllegalArgumentException("No symbol type for " + type);
    }

    @Override
    public int getNumSymbols() {
        return this.adapter.getSymbolCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean removeSymbolSpecial(Symbol sym) {
        this.lock.acquire();
        try {
            if (sym.getSymbolType() == SymbolType.FUNCTION) {
                SourceType source;
                Namespace parentNamespace;
                String name;
                Address addr = sym.getAddress();
                Function f = (Function)sym.getObject();
                Symbol nextPrimary = this.getNextPrimarySymbol(this, addr);
                if (nextPrimary == null) {
                    if (sym.getSource() == SourceType.DEFAULT) {
                        boolean bl = false;
                        return bl;
                    }
                    name = SymbolUtilities.getDefaultFunctionName(addr);
                    parentNamespace = this.getProgram().getGlobalNamespace();
                    source = SourceType.DEFAULT;
                } else {
                    name = nextPrimary.getName();
                    parentNamespace = nextPrimary.getParentNamespace();
                    source = nextPrimary.getSource();
                    this.refManager.symbolRemoved(nextPrimary);
                    nextPrimary.delete();
                }
                try {
                    f.getSymbol().setNameAndNamespace(name, parentNamespace, source);
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    boolean bl = false;
                    this.lock.release();
                    return bl;
                }
            }
            boolean bl = sym.delete();
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.lock.release();
        }
    }

    private Symbol getNextPrimarySymbol(SymbolManager sm, Address addr2) {
        Symbol[] symbols = sm.getSymbols(addr2);
        Symbol next = null;
        for (int i = symbols.length - 1; i >= 0; --i) {
            if (symbols[i].isPrimary()) continue;
            return symbols[i];
        }
        return next;
    }

    void removeChildren(SymbolDB sym) {
        ArrayList<Symbol> list = new ArrayList<Symbol>(20);
        SymbolIterator symIt = this.getChildren(sym);
        while (symIt.hasNext()) {
            list.add(symIt.next());
        }
        for (Symbol s : list) {
            s.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doRemoveSymbol(SymbolDB sym) {
        this.lock.acquire();
        try {
            if (sym == null) {
                boolean bl = false;
                return bl;
            }
            if (sym.getID() > 0L) {
                this.removeChildren(sym);
            }
            long id = sym.getKey();
            long parentId = sym.getParentID();
            SymbolType symType = sym.getSymbolType();
            try {
                Symbol[] remainingSyms;
                Address address = sym.getAddress();
                String name = sym.getName();
                boolean primary = sym.isPrimary();
                this.refManager.symbolRemoved(sym);
                this.adapter.removeSymbol(id);
                this.cache.delete(id);
                if (primary && address.isMemoryAddress() && (remainingSyms = this.getSymbols(address)).length > 0 && remainingSyms[0].getSource() != SourceType.DEFAULT) {
                    remainingSyms[remainingSyms.length - 1].setPrimary();
                }
                this.symbolRemoved(sym, address, name, id, parentId, symType);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                this.program.dbError(e);
                this.lock.release();
            }
        }
        finally {
            this.lock.release();
        }
        return false;
    }

    @Override
    public boolean hasSymbol(Address addr) {
        try {
            if (this.adapter.hasSymbol(addr)) {
                return true;
            }
            return addr.isMemoryAddress() && this.refManager.hasReferencesTo(addr);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Symbol getSymbol(long symbolID) {
        SymbolDB s;
        block12: {
            block11: {
                if (symbolID == 0L) {
                    return this.program.getGlobalNamespace().getSymbol();
                }
                this.lock.acquire();
                s = this.cache.get(symbolID);
                if (s == null) break block11;
                SymbolDB symbolDB = s;
                this.lock.release();
                return symbolDB;
            }
            Record record = this.adapter.getSymbolRecord(symbolID);
            if (record == null) break block12;
            SymbolDB symbolDB = this.createCachedSymbol(record);
            this.lock.release();
            return symbolDB;
        }
        try {
            block13: {
                break block13;
                catch (IOException e) {
                    this.program.dbError(e);
                }
            }
            try {
                Address a = this.getDynamicAddress(symbolID);
                if (a.getAddressSpace().isMemorySpace()) {
                    SymbolDB symbolDB = s = new CodeSymbol(this, this.cache, a, symbolID);
                    return symbolDB;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Symbol symbol = null;
            return symbol;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SymbolDB getDynamicSymbol(Address addr) {
        this.lock.acquire();
        try {
            long symbolID = this.getDynamicSymbolID(addr);
            SymbolDB s = this.cache.get(symbolID);
            if (s != null) {
                SymbolDB symbolDB = s;
                return symbolDB;
            }
            SymbolDB symbolDB = s = new CodeSymbol(this, this.cache, addr, symbolID);
            return symbolDB;
        }
        finally {
            this.lock.release();
        }
    }

    boolean hasDynamicSymbol(Address address) {
        if (!address.isMemoryAddress()) {
            return false;
        }
        try {
            if (this.adapter.getSymbolIDs(address).length > 0) {
                return false;
            }
            return this.refManager.hasReferencesTo(address);
        }
        catch (IOException e) {
            this.dbError(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Symbol[] getSymbols(Address addr) {
        this.lock.acquire();
        try {
            long[] symbolIDs = this.adapter.getSymbolIDs(addr);
            if (symbolIDs.length == 0) {
                if (addr.isMemoryAddress() && this.refManager.hasReferencesTo(addr)) {
                    Symbol[] symbols = new SymbolDB[]{this.getDynamicSymbol(addr)};
                    Symbol[] symbolArray = symbols;
                    return symbolArray;
                }
                Symbol[] symbols = NO_SYMBOLS;
                return symbols;
            }
            int primarySymbolIndex = 0;
            Symbol[] symbols = new Symbol[symbolIDs.length];
            for (int i = 0; i < symbols.length; ++i) {
                symbols[i] = this.getSymbol(symbolIDs[i]);
                if (!addr.isMemoryAddress() || i == 0 || !symbols[i].isPrimary()) continue;
                primarySymbolIndex = i;
            }
            if (primarySymbolIndex != 0) {
                Symbol s = symbols[primarySymbolIndex];
                symbols[primarySymbolIndex] = symbols[0];
                symbols[0] = s;
            }
            Symbol[] symbolArray = symbols;
            return symbolArray;
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return NO_SYMBOLS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Symbol[] getUserSymbols(Address addr) {
        this.lock.acquire();
        try {
            long[] symbolIDs = this.adapter.getSymbolIDs(addr);
            if (symbolIDs.length == 0) {
                Symbol[] symbolArray = NO_SYMBOLS;
                return symbolArray;
            }
            Symbol[] symbols = new Symbol[symbolIDs.length];
            for (int i = 0; i < symbols.length; ++i) {
                symbols[i] = this.getSymbol(symbolIDs[i]);
            }
            Symbol[] symbolArray = symbols;
            return symbolArray;
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return NO_SYMBOLS;
    }

    @Override
    public Symbol getSymbol(String name, Address addr, Namespace namespace) {
        if (namespace == null) {
            namespace = this.program.getGlobalNamespace();
        }
        if (addr instanceof SpecialAddress) {
            List<Symbol> symbols = this.getSymbols(name, namespace);
            for (Symbol symbol : symbols) {
                if (!symbol.getAddress().equals(addr)) continue;
                return symbol;
            }
            return null;
        }
        return this.getSymbol(name, addr, namespace.getID());
    }

    private Symbol getSymbol(String name, Address addr, long parentID) {
        Symbol[] symbols;
        for (Symbol element : symbols = this.getSymbols(addr)) {
            if (!element.getName().equals(name) || parentID != ((SymbolDB)element).getParentID()) continue;
            return element;
        }
        return null;
    }

    @Override
    public Symbol getSymbol(String name, Namespace namespace) {
        List<Symbol> symbols = this.getSymbols(name, namespace);
        return symbols.isEmpty() ? null : symbols.get(0);
    }

    private boolean hasDefaultVariablePrefix(String name) {
        return name.startsWith("local_") || name.startsWith("local_res") || name.startsWith("temp_") || name.startsWith("param_") || name.equals("this");
    }

    @Override
    public Symbol getGlobalSymbol(String name, Address addr) {
        Symbol[] symbols;
        for (Symbol symbol : symbols = this.getSymbols(addr)) {
            if (!symbol.getName().equals(name) || !symbol.isGlobal()) continue;
            return symbol;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Symbol getSymbol(String name) {
        this.lock.acquire();
        try {
            Namespace global = this.namespaceMgr.getGlobalNamespace();
            SymbolIterator it = this.getSymbols(name);
            while (it.hasNext()) {
                Symbol s = it.next();
                if (!s.getParentNamespace().equals(global)) continue;
                Symbol symbol = s;
                return symbol;
            }
            Symbol symbol = null;
            return symbol;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public List<Symbol> getGlobalSymbols(String name) {
        return this.getSymbols(name, this.namespaceMgr.getGlobalNamespace());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Symbol getLibrarySymbol(String name) {
        this.lock.acquire();
        try {
            for (Symbol s : this.getSymbols(name)) {
                if (s.getSymbolType() != SymbolType.LIBRARY) continue;
                Symbol symbol = s;
                return symbol;
            }
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Symbol> getSymbols(String name, Namespace namespace) {
        if (namespace == null) {
            namespace = this.namespaceMgr.getGlobalNamespace();
        }
        this.lock.acquire();
        try {
            if (namespace.isExternal() && SymbolUtilities.isReservedExternalDefaultName(name, this.program.getAddressFactory())) {
                List<Symbol> list = this.searchSymbolsByNamespaceFirst(name, namespace);
                return list;
            }
            if (namespace instanceof Function && this.hasDefaultVariablePrefix(name)) {
                List<Symbol> list = this.searchSymbolsByNamespaceFirst(name, namespace);
                return list;
            }
            int count = 0;
            ArrayList<Symbol> list = new ArrayList<Symbol>();
            SymbolIterator symbols = this.getSymbols(name);
            for (Symbol s : symbols) {
                if (++count == 10 && !namespace.isGlobal()) {
                    List<Symbol> list2 = this.searchSymbolsByNamespaceFirst(name, namespace);
                    return list2;
                }
                if (!s.getParentNamespace().equals(namespace)) continue;
                list.add(s);
            }
            ArrayList<Symbol> arrayList = list;
            return arrayList;
        }
        finally {
            this.lock.release();
        }
    }

    private List<Symbol> searchSymbolsByNamespaceFirst(String name, Namespace namespace) {
        ArrayList<Symbol> list = new ArrayList<Symbol>();
        SymbolIterator symbols = this.getSymbols(namespace);
        for (Symbol symbol : symbols) {
            if (!symbol.getName().equals(name)) continue;
            list.add(symbol);
        }
        return list;
    }

    @Override
    public Namespace getNamespace(String name, Namespace namespace) {
        List<Symbol> symbols = this.getSymbols(name, namespace);
        for (Symbol symbol : symbols) {
            SymbolType symbolType = symbol.getSymbolType();
            if (!symbolType.isNamespace() || symbolType.allowsDuplicates()) continue;
            return (Namespace)symbol.getObject();
        }
        return null;
    }

    @Override
    public SymbolIterator getSymbols(Namespace namespace) {
        return this.getSymbols(namespace.getID());
    }

    @Override
    public SymbolIterator getSymbols(long namespaceID) {
        try {
            RecordIterator it = this.adapter.getSymbolsByNamespace(namespaceID);
            return new SymbolRecordIterator(it, true);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SymbolIterator getSymbols(String name) {
        this.lock.acquire();
        try {
            Address addr;
            SymbolNameRecordIterator symIter = new SymbolNameRecordIterator(name);
            if (!symIter.hasNext() && (addr = SymbolUtilities.parseDynamicName(this.addrMap.getAddressFactory(), name)) != null) {
                Symbol[] symbols;
                for (Symbol symbol : symbols = this.getSymbols(addr)) {
                    if (!name.equals(symbol.getName())) continue;
                    SingleSymbolIterator singleSymbolIterator = new SingleSymbolIterator(symbol);
                    return singleSymbolIterator;
                }
                SingleSymbolIterator singleSymbolIterator = new SingleSymbolIterator(null);
                return singleSymbolIterator;
            }
            SymbolNameRecordIterator symbolNameRecordIterator = symIter;
            return symbolNameRecordIterator;
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Symbol getPrimarySymbol(Address addr) {
        if (!addr.isMemoryAddress() && !addr.isExternalAddress()) {
            return null;
        }
        this.lock.acquire();
        try {
            Symbol[] symbols;
            for (Symbol element : symbols = this.getSymbols(addr)) {
                if (!element.isPrimary()) continue;
                Symbol symbol = element;
                return symbol;
            }
            Symbol[] symbolArray = null;
            return symbolArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Symbol getSymbol(Reference ref) {
        Variable var;
        if (ref == null) {
            return null;
        }
        long symId = ref.getSymbolID();
        if (symId >= 0L) {
            return this.getSymbol(symId);
        }
        if (!ref.isExternalReference() && (var = this.refManager.getReferencedVariable(ref)) != null) {
            return var.getSymbol();
        }
        return this.getPrimarySymbol(ref.getToAddress());
    }

    public Address getMaxSymbolAddress(AddressSpace space) {
        try {
            return this.adapter.getMaxSymbolAddress(space);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    public Address getNextExternalSymbolAddress() {
        int extID = 1;
        Address maxAddr = this.getMaxSymbolAddress(AddressSpace.EXTERNAL_SPACE);
        if (maxAddr != null) {
            extID = (int)maxAddr.getOffset() + 1;
        }
        return AddressSpace.EXTERNAL_SPACE.getAddress(extID);
    }

    @Override
    public SymbolIterator getPrimarySymbolIterator(Address startAddr, boolean forward) {
        return this.getPrimarySymbolIterator(this.program.getAddressFactory().getAddressSet(startAddr, this.program.getMaxAddress()), forward);
    }

    @Override
    public SymbolIterator getPrimarySymbolIterator(AddressSetView set, boolean forward) {
        FieldMatchQuery query1 = new FieldMatchQuery(5, (Field)new IntField(1));
        FieldMatchQuery query2 = new FieldMatchQuery(3, (Field)new ByteField(SymbolType.CODE.getID()));
        FieldMatchQuery query3 = new FieldMatchQuery(3, (Field)new ByteField(SymbolType.FUNCTION.getID()));
        AndQuery query4 = new AndQuery(query1, query2);
        OrQuery query5 = new OrQuery(query3, query4);
        return new AddressSetFilteredSymbolIterator(this, set, query5, forward);
    }

    @Override
    public SymbolIterator getSymbols(AddressSetView set, SymbolType type, boolean forward) {
        FieldMatchQuery query = new FieldMatchQuery(3, (Field)new ByteField(type.getID()));
        return new AddressSetFilteredSymbolIterator(this, set, query, forward);
    }

    @Override
    public SymbolIterator getPrimarySymbolIterator(boolean forward) {
        return this.getPrimarySymbolIterator(this.program.getMemory(), forward);
    }

    @Override
    public SymbolIterator getSymbolIterator(Address startAddr, boolean forward) {
        RecordIterator it;
        try {
            it = this.adapter.getSymbolsByAddress(startAddr, forward);
        }
        catch (IOException e) {
            this.program.dbError(e);
            it = new EmptyRecordIterator();
        }
        return new SymbolRecordIterator(it, forward);
    }

    @Override
    public SymbolIterator getSymbolIterator() {
        return this.getSymbolIterator(true);
    }

    @Override
    public SymbolIterator getAllSymbols(boolean includeDynamicSymbols) {
        if (includeDynamicSymbols) {
            return new IncludeDynamicSymbolIterator();
        }
        return this.getSymbolIterator(true);
    }

    @Override
    public SymbolIterator getSymbolIterator(boolean forward) {
        try {
            RecordIterator it = this.adapter.getSymbolsByAddress(forward);
            return new SymbolRecordIterator(it, forward);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    @Override
    public SymbolIterator getSymbolIterator(String searchStr, boolean caseSensitive) {
        try {
            RecordIterator iter = this.adapter.getSymbols();
            SymbolRecordIterator symbolIterator = new SymbolRecordIterator(iter, true);
            return new SymbolQueryIterator(symbolIterator, searchStr, caseSensitive);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    @Override
    public void addExternalEntryPoint(Address addr) {
        this.refManager.addExternalEntryPointRef(addr);
    }

    @Override
    public AddressIterator getExternalEntryPointIterator() {
        return this.refManager.getExternalEntryIterator();
    }

    @Override
    public boolean isExternalEntryPoint(Address addr) {
        return this.refManager.isExternalEntryPoint(addr);
    }

    @Override
    public void removeExternalEntryPoint(Address addr) {
        this.refManager.removeExternalEntryPoint(addr);
    }

    @Override
    public boolean hasLabelHistory(Address addr) {
        try {
            RecordIterator iter = this.historyAdapter.getRecordsByAddress(this.addrMap.getKey(addr, false));
            return iter.hasNext();
        }
        catch (IOException e) {
            this.program.dbError(e);
            return false;
        }
    }

    @Override
    public Iterator<LabelHistory> getLabelHistory() {
        try {
            return new LabelHistoryIterator(this.historyAdapter.getAllRecords());
        }
        catch (IOException e) {
            this.program.dbError(e);
            return new LabelHistoryIterator(new EmptyRecordIterator());
        }
    }

    @Override
    public LabelHistory[] getLabelHistory(Address addr) {
        ArrayList<LabelHistory> list = new ArrayList<LabelHistory>();
        try {
            RecordIterator iter = this.historyAdapter.getRecordsByAddress(this.addrMap.getKey(addr, false));
            while (iter.hasNext()) {
                Record rec = iter.next();
                list.add(new LabelHistory(this.addrMap.decodeAddress(rec.getLongValue(0)), rec.getString(3), rec.getByteValue(1), rec.getString(2), new Date(rec.getLongValue(4))));
            }
            LabelHistory[] h = new LabelHistory[list.size()];
            return list.toArray(h);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return new LabelHistory[0];
        }
    }

    @Override
    public void invalidateCache(boolean all) {
        this.variableStorageMgr.invalidateCache(all);
        this.lock.acquire();
        try {
            this.cache.invalidate();
            this.dynamicSymbolAddressMap.reconcile();
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveSymbolsAt(Address oldAddr, Address newAddr) {
        this.lock.acquire();
        try {
            long oldAddrKey = this.addrMap.getKey(oldAddr, false);
            if (oldAddrKey != -1L) {
                this.invalidateCache(true);
                this.adapter.moveAddress(oldAddr, newAddr);
                this.historyAdapter.moveAddress(oldAddrKey, this.addrMap.getKey(newAddr, true));
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public long getDynamicSymbolID(Address addr) {
        return this.dynamicSymbolAddressMap.getKey(addr);
    }

    Address getDynamicAddress(long dynamicSymbolID) {
        return this.dynamicSymbolAddressMap.decodeAddress(dynamicSymbolID);
    }

    ProgramDB getProgram() {
        return this.program;
    }

    DataType getDataType(long dataTypeID) {
        return this.program.getDataTypeManager().getDataType(dataTypeID);
    }

    AddressMap getAddressMap() {
        return this.addrMap;
    }

    CodeManager getCodeManager() {
        return this.program.getCodeManager();
    }

    ReferenceDBManager getReferenceManager() {
        return this.refManager;
    }

    FunctionManagerDB getFunctionManager() {
        return (FunctionManagerDB)this.program.getFunctionManager();
    }

    ExternalManagerDB getExternalManager() {
        return (ExternalManagerDB)this.program.getExternalManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void namespaceRemoved(long namespaceID) {
        this.lock.acquire();
        try {
            try {
                ArrayList<SymbolDB> symbols = new ArrayList<SymbolDB>();
                RecordIterator iter = this.adapter.getSymbolsByNamespace(namespaceID);
                while (iter.hasNext()) {
                    Record rec = iter.next();
                    symbols.add(this.getSymbol(rec));
                }
                for (SymbolDB s : symbols) {
                    s.delete();
                }
            }
            catch (IOException e) {
                this.dbError(e);
            }
        }
        finally {
            this.lock.release();
        }
    }

    void symbolRenamed(Symbol symbol, String oldName) {
        Address addr = symbol.getAddress();
        String newName = symbol.getName();
        if (!symbol.isDynamic()) {
            this.createLabelHistoryRecord(addr, oldName, newName, (byte)2);
        }
        this.program.symbolChanged(symbol, 46, addr, symbol, oldName, newName);
    }

    void symbolNamespaceChanged(Symbol symbol, Namespace oldParentNamespace) {
        this.program.symbolChanged(symbol, 49, symbol.getAddress(), symbol, oldParentNamespace, symbol.getParentNamespace());
    }

    void primarySymbolSet(Symbol symbol, Symbol oldPrimarySymbol) {
        this.program.symbolChanged(symbol, 45, symbol.getAddress(), null, oldPrimarySymbol, symbol);
    }

    void symbolSourceChanged(Symbol symbol) {
        this.program.symbolChanged(symbol, 42, symbol.getAddress(), symbol, null, null);
    }

    void symbolAnchoredFlagChanged(Symbol symbol) {
        this.program.symbolChanged(symbol, 43, symbol.getAddress(), symbol, null, null);
    }

    void symbolDataChanged(Symbol symbol) {
        this.program.symbolChanged(symbol, 52, symbol.getAddress(), symbol, null, null);
    }

    SymbolDatabaseAdapter getDatabaseAdapter() {
        return this.adapter;
    }

    Record getSymbolRecord(long symbolID) {
        try {
            return this.adapter.getSymbolRecord(symbolID);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    void dbError(IOException e) {
        this.program.dbError(e);
    }

    void validateSource(String name, Address address, SymbolType symbolType, SourceType source) {
        if (!symbolType.isValidSourceType(source, address)) {
            String msg = "Can't set source to " + source + " for symbol '" + name + "' since it is a " + symbolType + " symbol type.";
            throw new IllegalArgumentException(msg);
        }
    }

    private void symbolAdded(Symbol symbol) {
        Address addr = symbol.getAddress();
        if (!symbol.isDynamic()) {
            this.createLabelHistoryRecord(addr, null, symbol.getName(), (byte)0);
        }
        this.refManager.symbolAdded(symbol);
        this.program.symbolAdded(symbol, 40, addr, null, symbol);
    }

    private void symbolRemoved(Symbol symbol, Address addr, String name, long symbolID, long parentId, SymbolType symType) {
        if (symType == SymbolType.CODE || symType == SymbolType.FUNCTION) {
            this.createLabelHistoryRecord(addr, null, name, (byte)1);
        }
        this.program.symbolChanged(symbol, 41, addr, symbol, name, new Long(symbolID));
    }

    void externalEntryPointRemoved(Address addr) {
        this.program.setChanged(48, addr, addr, null, null);
    }

    private void createLabelHistoryRecord(Address address, String oldName, String name, byte actionID) {
        long addr = this.addrMap.getKey(address, true);
        Object labelStr = name;
        if (actionID == 2) {
            labelStr = oldName + " to " + name;
        }
        try {
            this.historyAdapter.createRecord(addr, actionID, (String)labelStr);
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
    }

    private SymbolDB createCachedSymbol(Record record) {
        long addr = record.getLongValue(1);
        byte typeID = record.getByteValue(3);
        SymbolType type = SymbolType.getSymbolType(typeID);
        SymbolDB s = this.makeSymbol(this.addrMap.decodeAddress(addr), record, type);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SymbolDB getSymbol(Record record) {
        this.lock.acquire();
        try {
            SymbolDB s = this.cache.get(record);
            if (s != null) {
                SymbolDB symbolDB = s;
                return symbolDB;
            }
            SymbolDB symbolDB = this.createCachedSymbol(record);
            return symbolDB;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Namespace getNamespace(Address addr) {
        if (addr instanceof OldGenericNamespaceAddress) {
            throw new AssertException();
        }
        if (addr.isVariableAddress() || addr.isExternalAddress()) {
            Symbol sym = this.program.getSymbolTable().getPrimarySymbol(addr);
            if (sym != null) {
                return sym.getParentNamespace();
            }
            return null;
        }
        return this.namespaceMgr.getNamespaceContaining(addr);
    }

    @Override
    public Iterator<GhidraClass> getClassNamespaces() {
        return new ClassNamespaceIterator();
    }

    @Override
    public SymbolIterator getDefinedSymbols() {
        RecordIterator it;
        try {
            it = this.adapter.getSymbols();
        }
        catch (IOException e) {
            this.program.dbError(e);
            it = new EmptyRecordIterator();
        }
        return new SymbolRecordIterator(it, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Symbol getExternalSymbol(String name) {
        this.lock.acquire();
        try {
            SymbolIterator it = this.getExternalSymbols(name);
            if (it.hasNext()) {
                Symbol symbol = it.next();
                return symbol;
            }
            Symbol symbol = null;
            return symbol;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SymbolIterator getExternalSymbols(String name) {
        this.lock.acquire();
        try {
            ExternalSymbolNameRecordIterator symIter;
            ExternalSymbolNameRecordIterator externalSymbolNameRecordIterator = symIter = new ExternalSymbolNameRecordIterator(name);
            return externalSymbolNameRecordIterator;
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    @Override
    public SymbolIterator getExternalSymbols() {
        RecordIterator it;
        try {
            it = this.adapter.getSymbols(AddressSpace.EXTERNAL_SPACE.getMinAddress(), AddressSpace.EXTERNAL_SPACE.getMaxAddress(), true);
        }
        catch (IOException e) {
            this.program.dbError(e);
            it = new EmptyRecordIterator();
        }
        return new SymbolRecordIterator(it, true);
    }

    Lock getLock() {
        return this.lock;
    }

    @Override
    public SymbolIterator getChildren(Symbol parentSymbol) {
        try {
            RecordIterator it = this.adapter.getSymbolsByNamespace(parentSymbol.getID());
            return new SymbolRecordIterator(it, true);
        }
        catch (IOException e) {
            this.dbError(e);
            return null;
        }
    }

    public void setLanguage(LanguageTranslator translator, TaskMonitor monitor) throws CancelledException {
        this.dynamicSymbolAddressMap = new AddressMapImpl(64, this.addrMap.getAddressFactory());
        this.invalidateCache(true);
        this.variableStorageMgr.setLanguage(translator, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceDataTypes(long oldDataTypeID, long newDataTypeID) {
        this.lock.acquire();
        try {
            RecordIterator it = this.adapter.getSymbols();
            while (it.hasNext()) {
                long id;
                Address addr;
                Record rec = it.next();
                byte typeID = rec.getByteValue(3);
                if (typeID != SymbolType.PARAMETER.getID() && typeID != SymbolType.LOCAL_VAR.getID() && typeID != SymbolType.GLOBAL_VAR.getID() && (typeID != SymbolType.CODE.getID() || !(addr = this.addrMap.decodeAddress(rec.getLongValue(1))).isExternalAddress()) || (id = rec.getLongValue(4)) != oldDataTypeID) continue;
                rec.setLongValue(4, newDataTypeID);
                this.adapter.updateSymbolRecord(rec);
                this.symbolDataChanged(this.getSymbol(rec));
            }
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.cache.invalidate();
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException {
        this.lock.acquire();
        try {
            this.invalidateCache(true);
            this.adapter.moveAddressRange(fromAddr, toAddr, length, monitor);
            this.historyAdapter.moveAddressRange(fromAddr, toAddr, length, this.addrMap, monitor);
            this.fixupPinnedSymbols(toAddr, fromAddr, toAddr, toAddr.add(length - 1L));
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) throws CancelledException {
        this.lock.acquire();
        try {
            this.invalidateCache(true);
            Set<Address> notDeletedSet = this.adapter.deleteAddressRange(startAddr, endAddr, monitor);
            this.historyAdapter.deleteAddressRange(startAddr, endAddr, this.addrMap, notDeletedSet, monitor);
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        finally {
            this.lock.release();
        }
    }

    public void imageBaseChanged(Address oldBase, Address base) {
        this.fixupPinnedSymbols(base, oldBase, this.program.getMinAddress(), this.program.getMaxAddress());
    }

    private void fixupPinnedSymbols(Address currentBase, Address newBase, Address minAddr, Address maxAddr) {
        Symbol symbol;
        ArrayList<SymbolDB> fixupSymbols = new ArrayList<SymbolDB>();
        Iterator<Object> iterator = this.getSymbolIterator(minAddr, true).iterator();
        while (iterator.hasNext() && (symbol = (Symbol)iterator.next()).getAddress().compareTo(maxAddr) <= 0) {
            if (!symbol.isPinned()) continue;
            fixupSymbols.add((SymbolDB)symbol);
        }
        for (SymbolDB symbolDB : fixupSymbols) {
            if (symbolDB.getSymbolType() == SymbolType.FUNCTION) {
                String name = symbolDB.getName();
                SourceType source = symbolDB.getSource();
                try {
                    symbolDB.setPinned(false);
                    symbolDB.setName("", SourceType.DEFAULT);
                    Address symbolAddr = newBase.addNoWrap(symbolDB.getAddress().subtract(currentBase));
                    Symbol newSymbol = this.createLabel(symbolAddr, name, source);
                    newSymbol.setPinned(true);
                    this.moveLabelHistory(symbolDB.getAddress(), newSymbol.getAddress());
                    continue;
                }
                catch (Exception e) {
                    throw new AssertException("Should not get exception here.", (Throwable)e);
                }
            }
            symbolDB.move(currentBase, newBase);
        }
    }

    void moveLabelHistory(Address oldAddress, Address address) {
        try {
            this.historyAdapter.moveAddressRange(oldAddress, address, 1L, this.addrMap, TaskMonitorAdapter.DUMMY_MONITOR);
        }
        catch (CancelledException cancelledException) {
        }
        catch (IOException e) {
            this.dbError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableSymbolDB createVariableSymbol(String name, Namespace namespace, SymbolType type, int firstUseOffsetOrOrdinal, VariableStorage storage, SourceType source) throws DuplicateNameException, InvalidInputException {
        if (type != SymbolType.PARAMETER && type != SymbolType.LOCAL_VAR) {
            throw new IllegalArgumentException("Invalid symbol type for variable: " + type);
        }
        if (!(namespace instanceof Function)) {
            throw new IllegalArgumentException("Function must be namespace for local variable or parameter");
        }
        this.lock.acquire();
        try {
            source = this.adjustSourceTypeIfNecessary(name, type, source, storage);
            Address varAddr = this.variableStorageMgr.getVariableStorageAddress(storage, true);
            VariableSymbolDB variableSymbolDB = (VariableSymbolDB)this.createSpecialSymbol(varAddr, name, namespace, type, -1L, firstUseOffsetOrOrdinal, null, source);
            return variableSymbolDB;
        }
        catch (IOException e) {
            this.dbError(e);
        }
        finally {
            this.lock.release();
        }
        return null;
    }

    private SourceType adjustSourceTypeIfNecessary(String name, SymbolType type, SourceType source, VariableStorage storage) {
        if (type == SymbolType.PARAMETER && SymbolUtilities.isDefaultParameterName(name)) {
            return SourceType.DEFAULT;
        }
        if (SymbolUtilities.isDefaultLocalName(this.program, name, storage)) {
            return SourceType.DEFAULT;
        }
        return source;
    }

    @Override
    public GhidraClass createClass(Namespace parent, String name, SourceType source) throws DuplicateNameException, InvalidInputException {
        SymbolDB s = this.createSpecialSymbol(Address.NO_ADDRESS, name, parent, SymbolType.CLASS, -1L, -1, null, source);
        return new GhidraClassDB(s, this.namespaceMgr);
    }

    @Override
    public Library createExternalLibrary(String name, SourceType source) throws DuplicateNameException, InvalidInputException {
        SymbolDB s = this.createSpecialSymbol(Address.NO_ADDRESS, name, null, SymbolType.LIBRARY, -1L, -1, null, source);
        return new LibraryDB(s, this.namespaceMgr);
    }

    @Override
    public Namespace createNameSpace(Namespace parent, String name, SourceType source) throws DuplicateNameException, InvalidInputException {
        SymbolDB s = this.createSpecialSymbol(Address.NO_ADDRESS, name, parent, SymbolType.NAMESPACE, -1L, -1, null, source);
        return new NamespaceDB(s, this.namespaceMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SymbolDB createSpecialSymbol(Address addr, String name, Namespace parent, SymbolType symbolType, long data1, int data2, String data3, SourceType source) throws DuplicateNameException, InvalidInputException {
        this.lock.acquire();
        try {
            parent = this.validateNamespace(parent, addr, symbolType);
            source = this.validateSource(source, name, addr, symbolType);
            name = this.validateName(name, addr, symbolType, source);
            this.checkDuplicateSymbolName(addr, name, parent, symbolType);
            SymbolDB symbolDB = this.doCreateSymbol(name, addr, parent, symbolType, data1, data2, data3, source);
            return symbolDB;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public Symbol createSymbol(Address addr, String name, SourceType source) throws InvalidInputException {
        return this.createLabel(addr, name, source);
    }

    @Override
    public Symbol createLabel(Address addr, String name, SourceType source) throws InvalidInputException {
        return this.createLabel(addr, name, null, source);
    }

    @Override
    public Symbol createSymbol(Address addr, String name, Namespace namespace, SourceType source) throws InvalidInputException, DuplicateNameException {
        return this.createLabel(addr, name, namespace, source);
    }

    @Override
    public Symbol createLabel(Address addr, String name, Namespace namespace, SourceType source) throws InvalidInputException {
        return this.createCodeSymbol(addr, name, namespace, source, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Symbol createCodeSymbol(Address addr, String name, Namespace namespace, SourceType source, String data3) throws InvalidInputException {
        this.lock.acquire();
        try {
            namespace = this.validateNamespace(namespace, addr, SymbolType.CODE);
            source = this.validateSource(source, name, addr, SymbolType.CODE);
            name = this.validateName(name, addr, SymbolType.CODE, source);
            Symbol symbol = this.getSymbol(name, addr, namespace);
            if (symbol != null) {
                Symbol symbol2 = symbol;
                return symbol2;
            }
            Symbol functionSymbol = this.tryUpdatingDefaultFunction(addr, name, namespace, source);
            if (functionSymbol != null) {
                Symbol symbol3 = functionSymbol;
                return symbol3;
            }
            Symbol primary = this.getPrimarySymbol(addr);
            if (primary != null && primary.isDynamic()) {
                this.deleteDynamicSymbol(primary);
                primary = null;
            }
            boolean makePrimary = primary == null;
            SymbolDB symbolDB = this.doCreateSymbol(name, addr, namespace, SymbolType.CODE, -1L, makePrimary ? 1 : 0, data3, source);
            return symbolDB;
        }
        finally {
            this.lock.release();
        }
    }

    public Symbol createFunctionSymbol(Address addr, String name, Namespace namespace, SourceType source, String data3) throws InvalidInputException {
        namespace = this.validateNamespace(namespace, addr, SymbolType.FUNCTION);
        source = this.validateSource(source, name, addr, SymbolType.FUNCTION);
        name = this.validateName(name, addr, SymbolType.FUNCTION, source);
        Symbol[] symbols = this.getSymbols(addr);
        Symbol matching = this.findMatchingSymbol(symbols, new SymbolMatcher(name, namespace, SymbolType.FUNCTION));
        if (matching != null) {
            return matching;
        }
        if (this.findMatchingSymbol(symbols, s -> s.getSymbolType() == SymbolType.FUNCTION) != null) {
            throw new InvalidInputException("Function already exists at: " + addr);
        }
        Symbol symbolToPromote = this.findSymbolToPromote(symbols, name, namespace, source);
        if (symbolToPromote != null) {
            name = symbolToPromote.getName();
            namespace = symbolToPromote.getParentNamespace();
            source = symbolToPromote.getSource();
        }
        boolean needsPinning = symbolToPromote == null ? false : symbolToPromote.isPinned();
        this.cleanUpSymbols(symbols, symbolToPromote);
        SymbolDB symbol = this.doCreateSymbol(name, addr, namespace, SymbolType.FUNCTION, -1L, -1, data3, source);
        if (needsPinning) {
            symbol.setPinned(true);
        }
        return symbol;
    }

    private Symbol findSymbolToPromote(Symbol[] symbols, String name, Namespace namespace, SourceType source) {
        if (source == SourceType.DEFAULT) {
            Symbol primary = this.findMatchingSymbol(symbols, s -> s.isPrimary());
            if (primary != null && !primary.isDynamic()) {
                return primary;
            }
            return null;
        }
        return this.findMatchingSymbol(symbols, new SymbolMatcher(name, namespace, SymbolType.CODE));
    }

    private void cleanUpSymbols(Symbol[] symbols, Symbol symbolToPromote) {
        if (symbolToPromote != null) {
            if (symbolToPromote.isDynamic()) {
                this.deleteDynamicSymbol(symbolToPromote);
            } else {
                symbolToPromote.delete();
            }
        }
        for (Symbol symbol : symbols) {
            if (symbol == symbolToPromote || !symbol.isPrimary()) continue;
            ((CodeSymbol)symbol).setPrimary(false);
        }
    }

    private Symbol findMatchingSymbol(Symbol[] symbols, Predicate<Symbol> matcher) {
        for (Symbol symbol : symbols) {
            if (!matcher.test(symbol)) continue;
            return symbol;
        }
        return null;
    }

    private Namespace validateNamespace(Namespace namespace, Address addr, SymbolType type) throws InvalidInputException {
        namespace = namespace == null ? this.namespaceMgr.getGlobalNamespace() : namespace;
        this.checkAddressAndNameSpaceValidForSymbolType(addr, namespace, type);
        return namespace;
    }

    private SymbolDB doCreateSymbol(String name, Address addr, Namespace namespace, SymbolType type, long data1, int data2, String data3, SourceType source) {
        try {
            Record record = this.adapter.createSymbol(name, addr, namespace.getID(), type, data1, data2, data3, source);
            SymbolDB newSymbol = this.makeSymbol(addr, record, type);
            this.symbolAdded(newSymbol);
            return newSymbol;
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    private String validateName(String name, Address addr, SymbolType type, SourceType source) throws InvalidInputException {
        if (source == SourceType.DEFAULT) {
            return "";
        }
        SymbolUtilities.validateName(name, addr, type, this.addrMap.getAddressFactory());
        return name;
    }

    private SourceType validateSource(SourceType source, String name, Address addr, SymbolType type) {
        this.validateSource(name, addr, type, source);
        if (addr.isExternalAddress() && source != SourceType.DEFAULT && (StringUtils.isBlank((CharSequence)name) || SymbolUtilities.isReservedDynamicLabelName(name, this.addrMap.getAddressFactory()))) {
            return SourceType.DEFAULT;
        }
        return source;
    }

    private void deleteDynamicSymbol(Symbol dynamic) {
        long key = ((SymbolDB)dynamic).getKey();
        Address address = dynamic.getAddress();
        String name = dynamic.getName();
        long namespaceID = dynamic.getParentNamespace().getID();
        this.cache.delete(key);
        this.symbolRemoved(dynamic, address, name, key, namespaceID, null);
    }

    private Symbol tryUpdatingDefaultFunction(Address addr, String name, Namespace namespace, SourceType source) throws InvalidInputException {
        if (!addr.isMemoryAddress()) {
            return null;
        }
        Function function = this.program.getFunctionManager().getFunctionAt(addr);
        if (function == null || function.getSymbol().getSource() != SourceType.DEFAULT) {
            return null;
        }
        if (this.isInFunctionNamespace(namespace)) {
            return null;
        }
        Symbol functionSym = function.getSymbol();
        try {
            functionSym.setNameAndNamespace(name, namespace, source);
        }
        catch (CircularDependencyException e) {
            throw new AssertException("Unexpected CircularDependencyException");
        }
        catch (DuplicateNameException e) {
            throw new AssertException("Unexpected DuplicateNameException");
        }
        return functionSym;
    }

    private boolean isInFunctionNamespace(Namespace namespace) {
        while (namespace != null) {
            if (namespace instanceof Function) {
                return true;
            }
            namespace = namespace.getParentNamespace();
        }
        return false;
    }

    private void checkAddressAndNameSpaceValidForSymbolType(Address addr, Namespace parentNamespace, SymbolType type) throws InvalidInputException {
        if (!type.isValidAddress(this.program, addr)) {
            throw new IllegalArgumentException("Invalid address specified for new " + type + " symbol: " + addr);
        }
        boolean isExternal = this.isExternal(type, addr, parentNamespace);
        if (!type.isValidParent(this.program, parentNamespace, addr, isExternal)) {
            throw new InvalidInputException("Invalid parent namespace specified for new " + type + " symbol: " + parentNamespace.getName(true));
        }
    }

    private boolean isExternal(SymbolType type, Address addr, Namespace parentNamespace) {
        if (type == SymbolType.CODE || type == SymbolType.FUNCTION) {
            return addr.isExternalAddress();
        }
        return parentNamespace.isExternal();
    }

    @Override
    public Symbol getClassSymbol(String name, Namespace namespace) {
        return this.getSpecificSymbol(name, namespace, SymbolType.CLASS);
    }

    @Override
    public Symbol getParameterSymbol(String name, Namespace namespace) {
        return this.getSpecificSymbol(name, namespace, SymbolType.PARAMETER);
    }

    @Override
    public Symbol getLocalVariableSymbol(String name, Namespace namespace) {
        return this.getSpecificSymbol(name, namespace, SymbolType.LOCAL_VAR);
    }

    @Override
    public Symbol getNamespaceSymbol(String name, Namespace namespace) {
        return this.getSpecificSymbol(name, namespace, SymbolType.NAMESPACE);
    }

    @Override
    public List<Symbol> getLabelOrFunctionSymbols(String name, Namespace namespace) {
        List<Symbol> symbols = this.getSymbols(name, namespace);
        ArrayList<Symbol> filtered = new ArrayList<Symbol>();
        for (Symbol symbol : symbols) {
            SymbolType type = symbol.getSymbolType();
            if (type != SymbolType.FUNCTION && type != SymbolType.CODE) continue;
            filtered.add(symbol);
        }
        return filtered;
    }

    @Override
    public Symbol getVariableSymbol(String name, Function function) {
        return this.findFirstSymbol(name, function, s -> {
            SymbolType t = s.getSymbolType();
            return t == SymbolType.PARAMETER || t == SymbolType.LOCAL_VAR;
        });
    }

    private Symbol getSpecificSymbol(String name, Namespace namespace, SymbolType type) {
        return this.findFirstSymbol(name, namespace, s -> s.getSymbolType() == type);
    }

    private Symbol findFirstSymbol(String name, Namespace namespace, Predicate<Symbol> test) {
        List<Symbol> symbols = this.getSymbols(name, namespace);
        return symbols.stream().filter(test).findFirst().orElse(null);
    }

    private class ClassNamespaceIterator
    implements Iterator<GhidraClass> {
        private Iterator<Symbol> symbols;

        ClassNamespaceIterator() {
            ArrayList<Symbol> list = new ArrayList<Symbol>();
            SymbolIterator iter = SymbolManager.this.getSymbols(SymbolManager.this.namespaceMgr.getGlobalNamespace());
            while (iter.hasNext()) {
                Symbol s = iter.next();
                if (s.getSymbolType() != SymbolType.CLASS) continue;
                list.add(s);
            }
            this.symbols = list.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.symbols.hasNext();
        }

        @Override
        public GhidraClass next() {
            if (this.symbols.hasNext()) {
                return (GhidraClass)this.symbols.next().getObject();
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class LabelHistoryIterator
    implements Iterator<LabelHistory> {
        private RecordIterator iter;

        LabelHistoryIterator(RecordIterator iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.iter.hasNext();
            }
            catch (IOException e) {
                SymbolManager.this.program.dbError(e);
                return false;
            }
        }

        @Override
        public LabelHistory next() {
            try {
                Record rec = this.iter.next();
                if (rec != null) {
                    return new LabelHistory(SymbolManager.this.addrMap.decodeAddress(rec.getLongValue(0)), rec.getString(3), rec.getByteValue(1), rec.getString(2), new Date(rec.getLongValue(4)));
                }
            }
            catch (IOException e) {
                SymbolManager.this.program.dbError(e);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove records through iterator!");
        }
    }

    private class ExternalSymbolNameRecordIterator
    implements SymbolIterator {
        private RecordIterator it;
        private Symbol nextMatch;

        ExternalSymbolNameRecordIterator(String name) throws IOException {
            this.it = SymbolManager.this.adapter.getSymbolsByName(name);
        }

        @Override
        public boolean hasNext() {
            if (this.nextMatch == null) {
                this.findNextMatch();
            }
            return this.nextMatch != null;
        }

        @Override
        public Symbol next() {
            if (this.hasNext()) {
                Symbol next = this.nextMatch;
                this.nextMatch = null;
                return next;
            }
            return null;
        }

        private void findNextMatch() {
            try {
                while (this.it.hasNext()) {
                    SymbolDB sym = SymbolManager.this.getSymbol(this.it.next());
                    if (!sym.isExternal()) continue;
                    this.nextMatch = sym;
                    return;
                }
                this.nextMatch = null;
            }
            catch (IOException e) {
                SymbolManager.this.dbError(e);
                this.nextMatch = null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Symbol> iterator() {
            return this;
        }
    }

    private class SymbolNameRecordIterator
    implements SymbolIterator {
        private RecordIterator it;

        SymbolNameRecordIterator(String name) throws IOException {
            this.it = SymbolManager.this.adapter.getSymbolsByName(name);
        }

        @Override
        public boolean hasNext() {
            try {
                return this.it.hasNext();
            }
            catch (IOException e) {
                SymbolManager.this.dbError(e);
                return false;
            }
        }

        @Override
        public Symbol next() {
            if (this.hasNext()) {
                try {
                    return SymbolManager.this.getSymbol(this.it.next());
                }
                catch (IOException e) {
                    SymbolManager.this.dbError(e);
                }
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Symbol> iterator() {
            return this;
        }
    }

    private class SymbolQueryIterator
    implements SymbolIterator {
        private SymbolIterator it;
        private Symbol nextMatch;
        private Pattern pattern;

        SymbolQueryIterator(SymbolIterator it, String query, boolean caseSensitive) {
            this.it = it;
            this.pattern = UserSearchUtils.createSearchPattern((String)query, (boolean)caseSensitive);
        }

        @Override
        public boolean hasNext() {
            if (this.nextMatch == null) {
                this.findNextMatch();
            }
            return this.nextMatch != null;
        }

        @Override
        public Symbol next() {
            if (this.hasNext()) {
                Symbol next = this.nextMatch;
                this.nextMatch = null;
                return next;
            }
            return null;
        }

        private void findNextMatch() {
            while (this.it.hasNext()) {
                Symbol s = this.it.next();
                Matcher matcher = this.pattern.matcher(s.getName());
                if (!matcher.matches()) continue;
                this.nextMatch = s;
                return;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Symbol> iterator() {
            return this;
        }
    }

    private class SymbolRecordIterator
    implements SymbolIterator {
        private Symbol nextSymbol;
        private RecordIterator it;
        private boolean forward;

        SymbolRecordIterator(RecordIterator it, boolean forward) {
            this.it = it;
            this.forward = forward;
        }

        @Override
        public boolean hasNext() {
            if (this.nextSymbol != null) {
                return true;
            }
            try {
                boolean hasNext;
                SymbolManager.this.lock.acquire();
                boolean bl = hasNext = this.forward ? this.it.hasNext() : this.it.hasPrevious();
                if (hasNext) {
                    Record rec = this.forward ? this.it.next() : this.it.previous();
                    this.nextSymbol = SymbolManager.this.getSymbol(rec);
                }
                boolean bl2 = hasNext;
                return bl2;
            }
            catch (IOException e) {
                SymbolManager.this.program.dbError(e);
            }
            finally {
                SymbolManager.this.lock.release();
            }
            return false;
        }

        @Override
        public Symbol next() {
            if (this.hasNext()) {
                Symbol returnedSymbol = this.nextSymbol;
                this.nextSymbol = null;
                return returnedSymbol;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Symbol> iterator() {
            return this;
        }
    }

    private class IncludeDynamicSymbolIterator
    implements SymbolIterator {
        private SymbolIterator symbolIt;
        private AddressIterator addrIt;
        private Symbol nextDynamicSymbol;
        private Symbol nextRealSymbol;
        private Symbol nextSymbol;

        IncludeDynamicSymbolIterator() {
            this.symbolIt = SymbolManager.this.getSymbolIterator(true);
            this.addrIt = SymbolManager.this.refManager.getReferenceDestinationIterator(SymbolManager.this.program.getAddressFactory().getAddressSet(), true);
        }

        @Override
        public boolean hasNext() {
            if (this.nextSymbol == null) {
                this.findNext();
            }
            return this.nextSymbol != null;
        }

        @Override
        public Symbol next() {
            if (this.hasNext()) {
                Symbol s = this.nextSymbol;
                this.nextSymbol = null;
                return s;
            }
            return null;
        }

        private void findNext() {
            if (this.nextRealSymbol == null) {
                this.findNextRealSymbol();
            }
            if (this.nextDynamicSymbol == null) {
                this.findNextDynamicSymbol();
            }
            if (this.compareSymbols(this.nextRealSymbol, this.nextDynamicSymbol) < 0) {
                this.nextSymbol = this.nextRealSymbol;
                this.nextRealSymbol = null;
            } else {
                this.nextSymbol = this.nextDynamicSymbol;
                this.nextDynamicSymbol = null;
            }
        }

        private int compareSymbols(Symbol sym1, Symbol sym2) {
            if (sym1 == null) {
                return 1;
            }
            if (sym2 == null) {
                return -1;
            }
            return sym1.getAddress().compareTo(sym2.getAddress());
        }

        private void findNextRealSymbol() {
            this.nextRealSymbol = this.symbolIt.next();
        }

        private void findNextDynamicSymbol() {
            while (this.addrIt.hasNext()) {
                Symbol[] symbols = SymbolManager.this.getSymbols(this.addrIt.next());
                if (symbols.length != 1 || !symbols[0].isDynamic()) continue;
                this.nextDynamicSymbol = symbols[0];
                return;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Symbol> iterator() {
            return this;
        }
    }

    private class SingleSymbolIterator
    implements SymbolIterator {
        Symbol sym;

        SingleSymbolIterator(Symbol sym) {
            this.sym = sym;
        }

        @Override
        public boolean hasNext() {
            return this.sym != null;
        }

        @Override
        public Symbol next() {
            Symbol s = this.sym;
            this.sym = null;
            return s;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Symbol> iterator() {
            return this;
        }
    }
}

