/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.Record;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.data.ArrayDBAdapter;
import ghidra.program.database.data.DataTypeDB;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ArrayStringable;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.InvalidNameException;
import ghidra.util.UniversalID;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

class ArrayDB
extends DataTypeDB
implements Array {
    private volatile String displayName;
    private ArrayDBAdapter adapter;

    public ArrayDB(DataTypeManagerDB dataMgr, DBObjectCache<DataTypeDB> cache, ArrayDBAdapter adapter, Record record) {
        super(dataMgr, cache, record);
        this.adapter = adapter;
    }

    @Override
    protected String doGetName() {
        return DataTypeUtilities.getName(this, true);
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return DataTypeUtilities.getArrayValueClass(this, settings);
    }

    @Override
    protected long doGetCategoryID() {
        return this.record.getLongValue(3);
    }

    @Override
    protected void refreshName() {
        super.refreshName();
        this.displayName = null;
    }

    @Override
    protected boolean refresh() {
        try {
            Record rec = this.adapter.getRecord(this.key);
            if (rec != null) {
                this.record = rec;
                return super.refresh();
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        return false;
    }

    @Override
    public String getDisplayName() {
        this.validate(this.lock);
        String localDisplayName = this.displayName;
        if (localDisplayName == null) {
            this.displayName = localDisplayName = DataTypeUtilities.getDisplayName(this, false);
        }
        return localDisplayName;
    }

    @Override
    public String getMnemonic(Settings settings) {
        return DataTypeUtilities.getMnemonic(this, false, settings);
    }

    @Override
    public boolean isDynamicallySized() {
        return this.getDataType().isDynamicallySized();
    }

    @Override
    public int getLength() {
        this.checkIsValid();
        return this.getNumElements() * this.getElementLength();
    }

    @Override
    public String getDescription() {
        this.checkIsValid();
        return "Array of " + this.getDataType().getDescription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataType getDataType() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            long dataTypeID = this.record.getLongValue(0);
            DataType dt = this.dataMgr.getDataType(dataTypeID);
            if (dt == null) {
                dt = DataType.DEFAULT;
            }
            DataType dataType = dt;
            return dataType;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public SettingsDefinition[] getSettingsDefinitions() {
        return this.getDataType().getSettingsDefinitions();
    }

    @Override
    public int getElementLength() {
        DataType dt = this.getDataType();
        int elementLen = dt instanceof Dynamic ? this.record.getIntValue(2) : dt.getLength();
        if (elementLen <= 0) {
            elementLen = 1;
        }
        return elementLen;
    }

    @Override
    public int getNumElements() {
        return this.record.getIntValue(1);
    }

    @Override
    public DataType copy(DataTypeManager dtm) {
        return new ArrayDataType(this.getDataType().clone(dtm), this.getNumElements(), this.getElementLength(), dtm);
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new ArrayDataType(this.getDataType().clone(dtm), this.getNumElements(), this.getElementLength(), dtm);
    }

    @Override
    public DataTypeManager getDataTypeManager() {
        return this.dataMgr;
    }

    @Override
    public boolean isEquivalent(DataType dt) {
        if (dt == null) {
            return false;
        }
        if (dt == this) {
            return true;
        }
        if (!(dt instanceof Array)) {
            return false;
        }
        Array array = (Array)dt;
        if (this.getNumElements() != array.getNumElements()) {
            return false;
        }
        DataType dataType = this.getDataType();
        if (!dataType.isEquivalent(array.getDataType())) {
            return false;
        }
        return !(dataType instanceof Dynamic) || this.getElementLength() == array.getElementLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
        block10: {
            this.lock.acquire();
            try {
                String myOldName = this.getOldName();
                this.checkIsValid();
                if (newDt == this || newDt.getLength() < 0) {
                    newDt = DataType.DEFAULT;
                }
                if (oldDt != this.getDataType()) break block10;
                oldDt.removeParent(this);
                newDt.addParent(this);
                int oldLength = this.getLength();
                this.record.setLongValue(0, this.dataMgr.getResolvedID(newDt));
                if (newDt instanceof Dynamic || newDt instanceof FactoryDataType) {
                    newDt = DataType.DEFAULT;
                }
                this.record.setIntValue(2, -1);
                try {
                    this.adapter.updateRecord(this.record);
                }
                catch (IOException e) {
                    this.dataMgr.dbError(e);
                }
                this.refreshName();
                if (!this.getName().equals(myOldName)) {
                    this.notifyNameChanged(myOldName);
                }
                if (this.getLength() != oldLength) {
                    this.notifySizeChanged();
                } else {
                    this.dataMgr.dataTypeChanged(this);
                }
            }
            finally {
                this.lock.release();
            }
        }
    }

    @Override
    public void setName(String name) throws InvalidNameException, DuplicateNameException {
    }

    @Override
    public void dataTypeSizeChanged(DataType dt) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (dt == this.getDataType()) {
                this.notifySizeChanged();
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    protected void doSetCategoryPathRecord(long categoryID) throws IOException {
        this.record.setLongValue(3, categoryID);
        this.adapter.updateRecord(this.record);
    }

    @Override
    protected void doSetNameRecord(String newName) throws InvalidNameException {
        throw new InvalidNameException("Can't set the name of an array!");
    }

    @Override
    public void dataTypeDeleted(DataType dt) {
        if (this.getDataType() == dt) {
            this.dataMgr.addDataTypeToDelete(this.key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
        this.lock.acquire();
        try {
            String myOldName = this.getOldName();
            if (this.checkIsValid() && dt == this.getDataType()) {
                this.refreshName();
                if (!this.getName().equals(myOldName)) {
                    this.notifyNameChanged(myOldName);
                }
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    protected void updatePath(DataTypeDB dt) {
        if (dt == DataTypeUtilities.getBaseDataType(this)) {
            CategoryPath oldPath = this.getCategoryPath();
            CategoryPath currentPath = dt.getCategoryPath();
            if (!currentPath.equals(oldPath)) {
                try {
                    super.setCategoryPath(currentPath);
                }
                catch (DuplicateNameException duplicateNameException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void setCategoryPath(CategoryPath path) throws DuplicateNameException {
    }

    @Override
    public boolean dependsOn(DataType dt) {
        DataType myDt = this.getDataType();
        return myDt == dt || myDt.dependsOn(dt);
    }

    @Override
    public String getDefaultLabelPrefix() {
        DataType dt = this.getDataType();
        if (dt == DataType.DEFAULT) {
            return "ARRAY";
        }
        return dt.getDefaultLabelPrefix() + "_ARRAY";
    }

    @Override
    public String getDefaultLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options) {
        String prefix = ArrayStringable.getArrayStringableLabelPrefix(this, buf, settings, len, options);
        return prefix != null ? prefix : super.getDefaultLabelPrefix(buf, settings, len, options);
    }

    @Override
    public String getDefaultOffcutLabelPrefix(MemBuffer buf, Settings settings, int len, DataTypeDisplayOptions options, int offcutLength) {
        String prefix = ArrayStringable.getArrayStringableOffcutLabelPrefix(this, buf, settings, len, options, offcutLength);
        return prefix != null ? prefix : super.getDefaultOffcutLabelPrefix(buf, settings, len, options, offcutLength);
    }

    @Override
    public long getLastChangeTime() {
        return 0L;
    }

    @Override
    public long getLastChangeTimeInSourceArchive() {
        return 0L;
    }

    @Override
    public void setLastChangeTime(long lastChangeTime) {
    }

    @Override
    public void setLastChangeTimeInSourceArchive(long lastChangeTimeInSourceArchive) {
    }

    @Override
    public UniversalID getUniversalID() {
        return null;
    }

    @Override
    protected void setUniversalID(UniversalID id) {
    }

    @Override
    protected UniversalID getSourceArchiveID() {
        return DataTypeManager.LOCAL_ARCHIVE_UNIVERSAL_ID;
    }

    @Override
    protected void setSourceArchiveID(UniversalID id) {
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return DataTypeUtilities.getArrayValue(this, buf, settings, length);
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return DataTypeUtilities.getArrayRepresentation(this, buf, settings, length);
    }
}

