/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh;

import ghidra.app.plugin.processors.sleigh.ContextChange;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighDebugLogger;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.NumericUtilities;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class ContextOp
implements ContextChange {
    PatternExpression patexp;
    int num;
    int mask;
    int shift;

    @Override
    public void apply(ParserWalker walker, SleighDebugLogger debug) throws MemoryAccessException {
        int val = (int)this.patexp.getValue(walker);
        walker.getParserContext().setContextWord(this.num, val <<= this.shift, this.mask);
        if (debug != null) {
            debug.dumpContextSet(walker.getParserContext(), this.num, val, this.mask);
        }
    }

    @Override
    public void restoreXml(XmlPullParser parser, SleighLanguage lang) {
        XmlElement el = parser.start(new String[]{"context_op"});
        this.num = SpecXmlUtils.decodeInt((String)el.getAttribute("i"));
        this.shift = SpecXmlUtils.decodeInt((String)el.getAttribute("shift"));
        this.mask = SpecXmlUtils.decodeInt((String)el.getAttribute("mask"));
        this.patexp = PatternExpression.restoreExpression(parser, lang);
        parser.end(el);
    }

    public PatternExpression getPatternExpression() {
        return this.patexp;
    }

    public int getWordIndex() {
        return this.num;
    }

    public int getMask() {
        return this.mask;
    }

    public int getShift() {
        return this.shift;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ctx&");
        for (int i = 0; i < this.num; ++i) {
            sb.append("SS:SS:SS:SS:");
        }
        sb.append(NumericUtilities.convertMaskToHexString((long)this.mask, (int)8, (boolean)false, (int)2, (String)":"));
        sb.append(" := ");
        sb.append(this.patexp);
        sb.append("( << ");
        sb.append(this.shift);
        sb.append(")");
        return sb.toString();
    }
}

