/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform;

import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalLensGraphMouse;
import edu.uci.ics.jung.visualization.picking.LayoutLensShapePickSupport;
import edu.uci.ics.jung.visualization.transform.AbstractLensSupport;
import edu.uci.ics.jung.visualization.transform.HyperbolicTransformer;
import edu.uci.ics.jung.visualization.transform.LensSupport;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import java.awt.Dimension;

public class LayoutLensSupport<V, E>
extends AbstractLensSupport<V, E>
implements LensSupport {
    protected GraphElementAccessor<V, E> pickSupport;

    public LayoutLensSupport(VisualizationViewer<V, E> vv) {
        this(vv, new HyperbolicTransformer(vv, vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT)), new ModalLensGraphMouse());
    }

    public LayoutLensSupport(VisualizationViewer<V, E> vv, LensTransformer lensTransformer, ModalGraphMouse lensGraphMouse) {
        super(vv, lensGraphMouse);
        this.lensTransformer = lensTransformer;
        this.pickSupport = vv.getPickSupport();
        Dimension d = vv.getSize();
        if (d.width <= 0 || d.height <= 0) {
            d = vv.getPreferredSize();
        }
        lensTransformer.setViewRadius(d.width / 5);
    }

    @Override
    public void activate() {
        if (this.lens == null) {
            this.lens = new AbstractLensSupport.Lens(this.lensTransformer);
        }
        if (this.lensControls == null) {
            this.lensControls = new AbstractLensSupport.LensControls(this.lensTransformer);
        }
        this.vv.getRenderContext().setPickSupport(new LayoutLensShapePickSupport(this.vv));
        this.vv.getRenderContext().getMultiLayerTransformer().setTransformer(Layer.LAYOUT, this.lensTransformer);
        this.vv.prependPreRenderPaintable(this.lens);
        this.vv.addPostRenderPaintable(this.lensControls);
        this.vv.setGraphMouse(this.lensGraphMouse);
        this.vv.setToolTipText("<html><center>Mouse-Drag the Lens center to move it<p>Mouse-Drag the Lens edge to resize it<p>Ctrl+MouseWheel to change magnification</center></html>");
        this.vv.repaint();
    }

    @Override
    public void deactivate() {
        if (this.lensTransformer != null) {
            this.vv.removePreRenderPaintable(this.lens);
            this.vv.removePostRenderPaintable(this.lensControls);
            this.vv.getRenderContext().getMultiLayerTransformer().setTransformer(Layer.LAYOUT, this.lensTransformer.getDelegate());
        }
        this.vv.getRenderContext().setPickSupport(this.pickSupport);
        this.vv.setToolTipText(this.defaultToolTipText);
        this.vv.setGraphMouse(this.graphMouse);
        this.vv.repaint();
    }
}

