/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.Array;
import ghidra.util.datastruct.DataTable;
import java.io.Serializable;

public class IntArray
implements Array,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MIN_SIZE = 4;
    int[] ints = new int[4];
    int lastNonZeroIndex = -1;

    public void put(int index, int value) {
        if (value == 0) {
            this.remove(index);
            return;
        }
        if (index >= this.ints.length) {
            this.adjustArray(Math.max(index + 1, this.ints.length * 2));
        }
        this.ints[index] = value;
        if (index > this.lastNonZeroIndex) {
            this.lastNonZeroIndex = index;
        }
    }

    @Override
    public void remove(int index) {
        if (index >= this.ints.length) {
            return;
        }
        this.ints[index] = 0;
        if (index == this.lastNonZeroIndex) {
            this.lastNonZeroIndex = this.findLastNonZeroIndex();
        }
        if (this.lastNonZeroIndex < this.ints.length / 4) {
            this.adjustArray(this.lastNonZeroIndex * 2);
        }
    }

    private int findLastNonZeroIndex() {
        for (int i = this.lastNonZeroIndex; i >= 0; --i) {
            if (this.ints[i] == 0) continue;
            return i;
        }
        return -1;
    }

    public int get(int index) {
        if (index < this.ints.length) {
            return this.ints[index];
        }
        return 0;
    }

    private void adjustArray(int size) {
        if (size < 4) {
            size = 4;
        }
        int[] newints = new int[size];
        int len = Math.min(size, this.ints.length);
        System.arraycopy(this.ints, 0, newints, 0, len);
        this.ints = newints;
    }

    @Override
    public int getLastNonEmptyIndex() {
        return this.lastNonZeroIndex;
    }

    @Override
    public void copyDataTo(int index, DataTable table, int toIndex, int toCol) {
        table.putInt(toIndex, toCol, this.get(index));
    }
}

