/*
 * Decompiled with CFR 0.152.
 */
package ghidra.net;

import ghidra.framework.preferences.Preferences;
import ghidra.net.ApplicationKeyStore;
import ghidra.util.Msg;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ApplicationTrustManagerFactory {
    public static final String GHIDRA_CACERTS_PATH_PROPERTY = "ghidra.cacerts";
    private static X509TrustManager trustManager;
    private static TrustManager[] wrappedTrustManagers;
    private static boolean hasCAs;
    private static Exception caError;
    private static final X509Certificate[] NO_CERTS;

    private ApplicationTrustManagerFactory() {
    }

    private static void init() {
        String cacertsPath;
        if (wrappedTrustManagers == null) {
            wrappedTrustManagers = new WrappedTrustManager[]{new WrappedTrustManager()};
        }
        if (!((cacertsPath = System.getProperty(GHIDRA_CACERTS_PATH_PROPERTY)) != null && cacertsPath.length() != 0 || (cacertsPath = Preferences.getProperty(GHIDRA_CACERTS_PATH_PROPERTY)) != null && cacertsPath.length() != 0)) {
            Msg.info(ApplicationTrustManagerFactory.class, (Object)"Trust manager disabled, cacerts have not been set");
            trustManager = new OpenTrustManager();
            return;
        }
        try {
            TrustManager[] trustManagers;
            Msg.info(ApplicationTrustManagerFactory.class, (Object)("Trust manager initializing with cacerts: " + cacertsPath));
            KeyStore keyStore = ApplicationKeyStore.getCertificateStoreInstance(cacertsPath);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            for (TrustManager trustManager2 : trustManagers = tmf.getTrustManagers()) {
                if (!(trustManager2 instanceof X509TrustManager)) continue;
                X509TrustManager mgr = (X509TrustManager)trustManager2;
                ApplicationKeyStore.logCerts(mgr.getAcceptedIssuers());
                trustManager = mgr;
                break;
            }
            hasCAs = true;
        }
        catch (IOException | GeneralSecurityException e) {
            caError = e;
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            Msg.error(ApplicationTrustManagerFactory.class, (Object)("Failed to process cacerts (" + cacertsPath + "): " + msg), (Throwable)e);
        }
    }

    public static boolean hasCertificateAuthorities() {
        return hasCAs;
    }

    static boolean hasCertError() {
        return caError != null;
    }

    static Exception getCertError() {
        return caError;
    }

    static synchronized TrustManager[] getTrustManagers() {
        if (trustManager == null) {
            ApplicationTrustManagerFactory.init();
        }
        return (TrustManager[])wrappedTrustManagers.clone();
    }

    static synchronized void invalidateTrustManagers() {
        trustManager = null;
        caError = null;
    }

    static {
        NO_CERTS = new X509Certificate[0];
    }

    private static class OpenTrustManager
    implements X509TrustManager {
        private OpenTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    private static class WrappedTrustManager
    implements X509TrustManager {
        private WrappedTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (trustManager == null) {
                throw new CertificateException("Trust manager not properly initialized");
            }
            trustManager.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            if (trustManager == null) {
                throw new CertificateException("Trust manager not properly initialized");
            }
            trustManager.checkServerTrusted(chain, authType);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            if (trustManager == null) {
                return NO_CERTS;
            }
            return trustManager.getAcceptedIssuers();
        }
    }
}

