/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.dyldcache;

import generic.continues.GenericFactory;
import generic.continues.RethrowContinuesFactory;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.Section;
import ghidra.app.util.bin.format.macho.commands.DyldInfoCommand;
import ghidra.app.util.bin.format.macho.commands.DynamicSymbolTableCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.app.util.bin.format.macho.commands.SymbolTableCommand;
import ghidra.formats.gfilesystem.GFile;
import ghidra.util.Conv;
import ghidra.util.DataConverter;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class FixupMacho32bitArmOffsets {
    private DataConverter converter = new LittleEndianDataConverter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File fix(GFile file, long offsetAdjustment, ByteProvider provider, TaskMonitor monitor) throws IOException, MachException {
        HashMap<Long, byte[]> changeMap = new HashMap<Long, byte[]>();
        MachHeader header = MachHeader.createMachHeader((GenericFactory)RethrowContinuesFactory.INSTANCE, (ByteProvider)provider, (long)offsetAdjustment, (boolean)false);
        header.parse();
        List commands = header.getLoadCommands();
        block11: for (LoadCommand loadCommand : commands) {
            if (monitor.isCancelled()) break;
            block2 : switch (loadCommand.getCommandType()) {
                case 1: {
                    long newOffset;
                    SegmentCommand segmentCommand = (SegmentCommand)loadCommand;
                    if (segmentCommand.getFileOffset() > 0L) {
                        newOffset = segmentCommand.getFileOffset() - offsetAdjustment;
                        changeMap.put(segmentCommand.getStartIndex() + 32L - offsetAdjustment, this.converter.getBytes((int)newOffset));
                    }
                    if (segmentCommand.getNumberOfSections() <= 0) break;
                    long sectionStartIndex = segmentCommand.getStartIndex() + 56L - offsetAdjustment;
                    for (Section section : segmentCommand.getSections()) {
                        long newOffset2;
                        if (monitor.isCancelled()) break block2;
                        if (section.getOffset() > 0 && (long)section.getOffset() > offsetAdjustment) {
                            newOffset2 = Conv.intToLong((int)section.getOffset()) - offsetAdjustment;
                            changeMap.put(sectionStartIndex + 40L, this.converter.getBytes((int)newOffset2));
                        }
                        if (section.getRelocationOffset() > 0 && (long)section.getRelocationOffset() > offsetAdjustment) {
                            newOffset2 = Conv.intToLong((int)section.getRelocationOffset()) - offsetAdjustment;
                            changeMap.put(sectionStartIndex + 48L, this.converter.getBytes((int)newOffset2));
                        }
                        try {
                            sectionStartIndex += (long)section.toDataType().getLength();
                        }
                        catch (DuplicateNameException e) {
                            throw new IOException(e);
                        }
                    }
                    continue block11;
                }
                case 2: {
                    long newOffset;
                    SymbolTableCommand symbolTableCommand = (SymbolTableCommand)loadCommand;
                    if (symbolTableCommand.getSymbolOffset() > 0) {
                        newOffset = Conv.intToLong((int)symbolTableCommand.getSymbolOffset()) - offsetAdjustment;
                        changeMap.put(symbolTableCommand.getStartIndex() + 8L - offsetAdjustment, this.converter.getBytes((int)newOffset));
                    }
                    if (symbolTableCommand.getStringTableOffset() <= 0) break;
                    newOffset = Conv.intToLong((int)symbolTableCommand.getStringTableOffset()) - offsetAdjustment;
                    changeMap.put(symbolTableCommand.getStartIndex() + 16L - offsetAdjustment, this.converter.getBytes((int)newOffset));
                    break;
                }
                case 11: {
                    long newOffset;
                    DynamicSymbolTableCommand dynamicSymbolTableCommand = (DynamicSymbolTableCommand)loadCommand;
                    if (dynamicSymbolTableCommand.getTableOfContentsOffset() > 0) {
                        newOffset = Conv.intToLong((int)dynamicSymbolTableCommand.getTableOfContentsOffset()) - offsetAdjustment;
                        changeMap.put(dynamicSymbolTableCommand.getStartIndex() + 32L - offsetAdjustment, this.converter.getBytes((int)newOffset));
                    }
                    if (dynamicSymbolTableCommand.getModuleTableOffset() > 0) {
                        newOffset = Conv.intToLong((int)dynamicSymbolTableCommand.getModuleTableOffset()) - offsetAdjustment;
                        changeMap.put(dynamicSymbolTableCommand.getStartIndex() + 40L - offsetAdjustment, this.converter.getBytes((int)newOffset));
                    }
                    if (dynamicSymbolTableCommand.getReferencedSymbolTableOffset() > 0) {
                        newOffset = Conv.intToLong((int)dynamicSymbolTableCommand.getReferencedSymbolTableOffset()) - offsetAdjustment;
                        changeMap.put(dynamicSymbolTableCommand.getStartIndex() + 48L - offsetAdjustment, this.converter.getBytes((int)newOffset));
                    }
                    if (dynamicSymbolTableCommand.getIndirectSymbolTableOffset() > 0) {
                        newOffset = Conv.intToLong((int)dynamicSymbolTableCommand.getIndirectSymbolTableOffset()) - offsetAdjustment;
                        changeMap.put(dynamicSymbolTableCommand.getStartIndex() + 56L - offsetAdjustment, this.converter.getBytes((int)newOffset));
                    }
                    if (dynamicSymbolTableCommand.getExternalRelocationOffset() > 0) {
                        newOffset = Conv.intToLong((int)dynamicSymbolTableCommand.getExternalRelocationOffset()) - offsetAdjustment;
                        changeMap.put(dynamicSymbolTableCommand.getStartIndex() + 64L - offsetAdjustment, this.converter.getBytes((int)newOffset));
                    }
                    if (dynamicSymbolTableCommand.getLocalRelocationOffset() <= 0) break;
                    newOffset = Conv.intToLong((int)dynamicSymbolTableCommand.getLocalRelocationOffset()) - offsetAdjustment;
                    changeMap.put(dynamicSymbolTableCommand.getStartIndex() + 72L - offsetAdjustment, this.converter.getBytes((int)newOffset));
                    break;
                }
                case -2147483614: 
                case 34: {
                    long newOffset;
                    DyldInfoCommand dyldInfoCommand = (DyldInfoCommand)loadCommand;
                    if (dyldInfoCommand.getRebaseOffset() > 0) {
                        newOffset = Conv.intToLong((int)dyldInfoCommand.getRebaseOffset()) - offsetAdjustment;
                        changeMap.put(dyldInfoCommand.getStartIndex() + 8L - offsetAdjustment, this.converter.getBytes((int)newOffset));
                    }
                    if (dyldInfoCommand.getBindOffset() > 0) {
                        newOffset = Conv.intToLong((int)dyldInfoCommand.getBindOffset()) - offsetAdjustment;
                        changeMap.put(dyldInfoCommand.getStartIndex() + 16L - offsetAdjustment, this.converter.getBytes((int)newOffset));
                    }
                    if (dyldInfoCommand.getWeakBindOffset() > 0) {
                        newOffset = Conv.intToLong((int)dyldInfoCommand.getWeakBindOffset()) - offsetAdjustment;
                        changeMap.put(dyldInfoCommand.getStartIndex() + 24L - offsetAdjustment, this.converter.getBytes((int)newOffset));
                    }
                    if (dyldInfoCommand.getLazyBindOffset() > 0) {
                        newOffset = Conv.intToLong((int)dyldInfoCommand.getLazyBindOffset()) - offsetAdjustment;
                        changeMap.put(dyldInfoCommand.getStartIndex() + 32L - offsetAdjustment, this.converter.getBytes((int)newOffset));
                    }
                    if (dyldInfoCommand.getExportOffset() <= 0) break;
                    newOffset = Conv.intToLong((int)dyldInfoCommand.getExportOffset()) - offsetAdjustment;
                    changeMap.put(dyldInfoCommand.getStartIndex() + 40L - offsetAdjustment, this.converter.getBytes((int)newOffset));
                    break;
                }
            }
        }
        ArrayList indexList = new ArrayList(changeMap.keySet());
        Collections.sort(indexList);
        File tempMachoFile = File.createTempFile("ghidra_" + file.getName() + "_", ".macho.tmp");
        try (FileOutputStream tempOut = new FileOutputStream(tempMachoFile);){
            long tempIndex = offsetAdjustment;
            while (!monitor.isCancelled()) {
                int length = 65536;
                byte[] buffer = provider.readBytes(tempIndex, 65536L);
                for (Long index : indexList) {
                    if (index + offsetAdjustment < tempIndex || index + offsetAdjustment >= tempIndex + 65536L) continue;
                    byte[] changedBytes = (byte[])changeMap.get(index);
                    System.arraycopy(changedBytes, 0, buffer, index.intValue(), changedBytes.length);
                }
                ((OutputStream)tempOut).write(buffer);
                monitor.setMessage("0x" + Long.toHexString(tempIndex += (long)buffer.length));
                if (tempIndex <= provider.length()) continue;
                break;
            }
        }
        return tempMachoFile;
    }
}

