/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.dyldcache;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.ios.dyldcache.DyldArchitecture;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.NotYetImplementedException;

public final class DyldCacheUtil {
    public static final boolean isDyldCache(Program program) {
        if (program == null) {
            return false;
        }
        if (program.getMemory().getSize() < 16L) {
            return false;
        }
        byte[] bytes = new byte[16];
        try {
            Address address = program.getMinAddress();
            program.getMemory().getBytes(address, bytes);
        }
        catch (MemoryAccessException memoryAccessException) {
            // empty catch block
        }
        return DyldCacheUtil.isDyldCache(new String(bytes).trim());
    }

    public static final boolean isDyldCache(ByteProvider provider) {
        throw new NotYetImplementedException();
    }

    public static final boolean isDyldCache(String signature) {
        for (DyldArchitecture architecture : DyldArchitecture.ARCHITECTURES) {
            if (!architecture.getSignature().equals(signature)) continue;
            return true;
        }
        return false;
    }
}

