/*
 * Decompiled with CFR 0.152.
 */
package ghidra.server.security;

import ghidra.framework.remote.GhidraPrincipal;
import ghidra.server.UserManager;
import ghidra.server.security.AuthenticationModule;
import java.io.IOException;
import java.util.Arrays;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;

public class PasswordFileAuthenticationModule
implements AuthenticationModule {
    private final boolean nameCallbackAllowed;

    public PasswordFileAuthenticationModule(boolean nameCallbackAllowed) {
        this.nameCallbackAllowed = nameCallbackAllowed;
    }

    @Override
    public boolean anonymousCallbacksAllowed() {
        return true;
    }

    @Override
    public Callback[] getAuthenticationCallbacks() {
        PasswordCallback passCb = new PasswordCallback("Password:", false);
        if (this.nameCallbackAllowed) {
            NameCallback nameCb = new NameCallback("User ID:");
            return new Callback[]{nameCb, passCb};
        }
        return new Callback[]{passCb};
    }

    @Override
    public boolean isNameCallbackAllowed() {
        return this.nameCallbackAllowed;
    }

    @Override
    public String authenticate(UserManager userMgr, Subject subject, Callback[] callbacks) throws LoginException {
        GhidraPrincipal user = GhidraPrincipal.getGhidraPrincipal((Subject)subject);
        if (user == null) {
            throw new FailedLoginException("GhidraPrincipal required");
        }
        String username = user.getName();
        NameCallback nameCb = null;
        PasswordCallback passCb = null;
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    nameCb = (NameCallback)callbacks[i];
                    continue;
                }
                if (!(callbacks[i] instanceof PasswordCallback)) continue;
                passCb = (PasswordCallback)callbacks[i];
            }
        }
        if (this.nameCallbackAllowed && nameCb != null) {
            username = nameCb.getName();
        }
        if (username == null || username.length() == 0) {
            throw new FailedLoginException("User ID must be specified");
        }
        if (passCb == null) {
            throw new FailedLoginException("Password callback required");
        }
        char[] pass = null;
        try {
            pass = passCb.getPassword();
            passCb.clearPassword();
            userMgr.authenticateUser(username, pass);
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            throw new FailedLoginException(msg);
        }
        finally {
            if (pass != null) {
                Arrays.fill(pass, ' ');
            }
        }
        return username;
    }
}

