/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel.internal;

import docking.widgets.fieldpanel.internal.EmptyFieldBackgroundColorManager;
import docking.widgets.fieldpanel.internal.FieldBackgroundColorManager;
import docking.widgets.fieldpanel.internal.FullySelectedFieldBackgroundColorManager;
import docking.widgets.fieldpanel.internal.LayoutBackgroundColorManager;
import docking.widgets.fieldpanel.internal.MixedFieldBackgroundColorManager;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import java.awt.Color;
import java.math.BigInteger;

public class MixedLayoutBackgroundColorManager
implements LayoutBackgroundColorManager {
    private final Color backgroundColor;
    private final Color selectionColor;
    private final Color highlightColor;
    private final Color mixedColor;
    private final BigInteger index;
    private final FieldSelection selection;
    private final FieldSelection highlight;
    private final Color leftBorderColor;
    private final Color rightBorderColor;

    public MixedLayoutBackgroundColorManager(BigInteger index, FieldSelection selection, FieldSelection highlight, Color backgroundColor, Color selectionColor, Color highlightColor, Color mixedColor, Color leftBorderColor, Color rightBorderColor) {
        this.index = index;
        this.selection = selection;
        this.highlight = highlight;
        this.backgroundColor = backgroundColor;
        this.selectionColor = selectionColor;
        this.highlightColor = highlightColor;
        this.mixedColor = mixedColor;
        this.leftBorderColor = leftBorderColor;
        this.rightBorderColor = rightBorderColor;
    }

    @Override
    public FieldBackgroundColorManager getFieldBackgroundColorManager(int fieldNum) {
        FieldLocation start = new FieldLocation(this.index, fieldNum, 0, 0);
        FieldLocation end = new FieldLocation(this.index, fieldNum + 1, 0, 0);
        FieldRange range = new FieldRange(start, end);
        boolean isHighlighted = this.highlight.containsEntirely(range);
        if (this.selection.containsEntirely(range)) {
            Color color = isHighlighted ? this.mixedColor : this.selectionColor;
            return new FullySelectedFieldBackgroundColorManager(color);
        }
        if (this.selection.excludesEntirely(range)) {
            if (isHighlighted) {
                return new FullySelectedFieldBackgroundColorManager(this.highlightColor);
            }
            return EmptyFieldBackgroundColorManager.EMPTY_INSTANCE;
        }
        Color fieldBackgroundColor = isHighlighted ? this.highlightColor : this.backgroundColor;
        return new MixedFieldBackgroundColorManager(this.index, fieldNum, this, this.selectionColor, fieldBackgroundColor);
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public Color getPaddingColor(int padIndex) {
        Color paddingColor = null;
        paddingColor = padIndex == 0 ? this.leftBorderColor : (padIndex == -1 ? this.rightBorderColor : this.getPaddingColorBetweenFields(padIndex));
        if (paddingColor == this.backgroundColor) {
            return null;
        }
        return paddingColor;
    }

    private Color getPaddingColorBetweenFields(int padIndex) {
        FieldLocation start = new FieldLocation(this.index, padIndex - 1, Integer.MAX_VALUE, Integer.MAX_VALUE);
        FieldLocation end = new FieldLocation(this.index, padIndex, 0, 1);
        FieldRange range = new FieldRange(start, end);
        boolean gapSelected = this.selection.containsEntirely(range);
        boolean gapHighlighted = this.highlight.containsEntirely(range);
        if (gapSelected && gapHighlighted) {
            return this.mixedColor;
        }
        if (gapSelected) {
            return this.selectionColor;
        }
        if (gapHighlighted) {
            return this.highlightColor;
        }
        return this.backgroundColor;
    }

    public FieldSelection getSelection() {
        return this.selection;
    }

    @Override
    public Color getBackgroundColor(FieldLocation location) {
        boolean isSelected = this.selection.contains(location);
        boolean isHighlighted = this.highlight.contains(location);
        if (isSelected && isHighlighted) {
            return this.mixedColor;
        }
        if (isSelected) {
            return this.selectionColor;
        }
        if (isHighlighted) {
            return this.highlightColor;
        }
        return this.backgroundColor;
    }
}

