/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel;

import docking.ToolTipManager;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.AnchoredLayout;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.HoverProvider;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Timer;

public class HoverHandler
implements ActionListener {
    private Timer hoverTimer;
    private MouseEvent lastMouseMovedEvent;
    private HoverProvider hoverProvider;
    private FieldPanel fieldPanel;

    HoverHandler(FieldPanel fieldPanel) {
        this.fieldPanel = fieldPanel;
    }

    public void hoverExited() {
        this.stopTimer();
    }

    public void startHover(MouseEvent e) {
        this.lastMouseMovedEvent = e;
        if (this.hoverTimer != null) {
            this.hoverTimer.restart();
        }
    }

    public void stopHover() {
        this.stopTimer();
        if (this.hoverProvider != null) {
            this.hoverProvider.closeHover();
        }
    }

    private void stopTimer() {
        if (this.hoverTimer != null) {
            this.hoverTimer.stop();
        }
    }

    public void setHoverProvider(HoverProvider hoverProvider) {
        this.hoverProvider = hoverProvider;
        if (hoverProvider != null && this.hoverTimer == null) {
            int timeout = ToolTipManager.sharedInstance().getInitialDelay();
            this.hoverTimer = new Timer(timeout, this);
            this.hoverTimer.setRepeats(false);
            this.hoverTimer.stop();
        } else if (hoverProvider == null && this.hoverTimer != null) {
            this.hoverTimer.stop();
            this.hoverTimer = null;
        }
    }

    public void scroll(int scrollAmount) {
        if (this.hoverProvider != null) {
            this.hoverProvider.scroll(scrollAmount);
        }
    }

    public boolean isHoverShowing() {
        if (this.hoverProvider != null) {
            return this.hoverProvider.isShowing();
        }
        return false;
    }

    public boolean isEnabled() {
        return this.hoverProvider != null;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.mouseHovered(this.lastMouseMovedEvent);
    }

    public void mouseHovered(MouseEvent e) {
        this.stopTimer();
        AnchoredLayout layout = this.fieldPanel.findLayoutAt(e.getY());
        if (layout != null) {
            int x = e.getX();
            int y = e.getY();
            FieldLocation newLoc = new FieldLocation();
            layout.setCursor(newLoc, x, y);
            Field mouseField = layout.getField(newLoc.fieldNum);
            if (x < mouseField.getStartX()) {
                return;
            }
            Rectangle rect = layout.getCursorRect(newLoc.fieldNum, newLoc.row, newLoc.col);
            if (x < rect.x - 10 || x > rect.x + 10) {
                return;
            }
            rect.x = mouseField.getStartX();
            rect.width = mouseField.getWidth();
            this.hoverProvider.mouseHovered(newLoc, mouseField, rect, e);
        }
    }
}

