/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.dialogs;

import docking.DialogComponentProvider;
import docking.DockingUtils;
import docking.DockingWindowManager;
import docking.widgets.OptionDialog;
import ghidra.util.HTMLUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.text.DefaultCaret;
import org.apache.commons.lang3.StringUtils;

public class MultiLineMessageDialog
extends DialogComponentProvider {
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;

    public static void showModalMessageDialog(Component parent, String title, String shortMessage, String detailedMessage, int messageType) {
        MultiLineMessageDialog mlmd = new MultiLineMessageDialog(title, shortMessage, detailedMessage, messageType, true);
        DockingWindowManager.showDialog(parent, mlmd);
    }

    public static void showMessageDialog(Component parent, String title, String shortMessage, String detailedMessage, int messageType) {
        MultiLineMessageDialog mlmd = new MultiLineMessageDialog(title, shortMessage, detailedMessage, messageType, false);
        DockingWindowManager.showDialog(parent, mlmd);
    }

    public MultiLineMessageDialog(String title, String shortMessage, String detailedMessage, int messageType, boolean modal) {
        super(title, modal, false, true, false);
        Icon icon;
        JPanel workPanel = new JPanel(new BorderLayout());
        workPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (!StringUtils.isBlank((CharSequence)shortMessage)) {
            JLabel shortMessageLabel = new JLabel(shortMessage);
            shortMessageLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 10));
            workPanel.add((Component)shortMessageLabel, "North");
        }
        if (!StringUtils.isBlank((CharSequence)detailedMessage)) {
            if (HTMLUtilities.isHTML((String)detailedMessage)) {
                JTextPane textpane = new JTextPane();
                String fontfamily = textpane.getFont().getFamily();
                detailedMessage = "<html><body style=\"font-family: " + fontfamily + "\">" + ((String)detailedMessage).substring(6);
                DefaultCaret caret = (DefaultCaret)textpane.getCaret();
                caret.setUpdatePolicy(1);
                textpane.setContentType("text/html");
                textpane.setText((String)detailedMessage);
                textpane.setEditable(false);
                DockingUtils.setTransparent(textpane);
                JScrollPane scrollPane = new JScrollPane(textpane);
                DockingUtils.setTransparent(scrollPane);
                scrollPane.setBorder(BorderFactory.createEmptyBorder());
                workPanel.add((Component)scrollPane, "Center");
            } else {
                JTextArea textarea = new JTextArea((String)detailedMessage);
                textarea.setEditable(false);
                DockingUtils.setTransparent(textarea);
                JScrollPane scrollPane = new JScrollPane(textarea);
                DockingUtils.setTransparent(scrollPane);
                scrollPane.setBorder(BorderFactory.createEmptyBorder());
                workPanel.add((Component)scrollPane, "Center");
            }
        }
        if ((icon = OptionDialog.getIconForMessageType(messageType)) != null) {
            JLabel iconLabel = new JLabel(icon);
            iconLabel.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 10));
            workPanel.add((Component)iconLabel, "West");
        }
        this.addWorkPanel(workPanel);
        this.addOKButton();
        this.setFocusComponent(this.okButton);
        this.setDefaultButton(this.okButton);
        this.setRememberSize(false);
    }

    @Override
    protected void okCallback() {
        this.close();
    }
}

