/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.ComponentPlaceholder;
import docking.DockableComponent;
import docking.DockableHeader;
import docking.DockingActionManager;
import docking.DockingUtils;
import docking.DockingWindowManager;
import docking.GenericHeader;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import docking.menu.MenuGroupMap;
import docking.menu.MenuHandler;
import docking.menu.MenuManager;
import docking.menu.ToolBarItemManager;
import docking.menu.ToolBarManager;
import ghidra.util.exception.AssertException;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import resources.ResourceManager;

class DockableToolBarManager {
    private static final ImageIcon closeIcon = ResourceManager.loadImage((String)"images/close16.gif");
    private static final ImageIcon menuIcon = ResourceManager.loadImage((String)"images/menu16.gif");
    private GenericHeader dockableHeader;
    private ToolBarManager toolBarManager;
    private MenuGroupMap menuGroupMap;
    private MenuManager menuManager;
    private ToolBarItemManager menuButtonManager;
    private ToolBarItemManager closeButtonManager;
    private SwingUpdateManager headerUpdater = new SwingUpdateManager(() -> this.dockableHeader.update());

    DockableToolBarManager(GenericHeader header) {
        this.dockableHeader = header;
        this.initialize(null, null, new ArrayList().iterator());
    }

    DockableToolBarManager(DockableComponent dockableComp, DockableHeader header) {
        this.dockableHeader = header;
        ComponentPlaceholder placeholder = dockableComp.getComponentWindowingPlaceholder();
        DockingWindowManager winMgr = dockableComp.getComponentWindowingPlaceholder().getNode().winMgr;
        DockingActionManager actionManager = winMgr.getActionManager();
        this.menuGroupMap = actionManager.getMenuGroupMap();
        MenuHandler menuHandler = actionManager.getMenuHandler();
        Iterator<DockingActionIf> iter = placeholder.getActions();
        this.initialize(winMgr, menuHandler, iter);
        this.closeButtonManager = new ToolBarItemManager(new ToolBarCloseAction(dockableComp), winMgr);
    }

    private void initialize(DockingWindowManager winMgr, MenuHandler menuHandler, Iterator<DockingActionIf> actions) {
        this.toolBarManager = new ToolBarManager(winMgr);
        this.menuManager = new MenuManager(null, '\u0000', null, false, menuHandler, this.menuGroupMap);
        this.menuButtonManager = new ToolBarItemManager(new ToolBarMenuAction(), winMgr);
        while (actions.hasNext()) {
            DockingActionIf action = actions.next();
            this.addAction(action);
        }
        this.updateToolBar();
    }

    JComponent getToolBar() {
        return this.toolBarManager.getToolBar();
    }

    JComponent getMenuCloseToolBar() {
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        if (this.closeButtonManager == null) {
            return panel;
        }
        if (!this.toolBarManager.isEmpty()) {
            panel.add(DockingUtils.createToolbarSeparator());
        }
        if (!this.menuManager.isEmpty()) {
            panel.add(this.menuButtonManager.getButton());
        }
        panel.add(this.closeButtonManager.getButton());
        return panel;
    }

    void addAction(DockingActionIf action) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new AssertException("Actions must be added from Swing thread");
        }
        if (action.getMenuBarData() != null) {
            this.menuManager.addAction(action);
        }
        if (action.getToolBarData() != null) {
            this.toolBarManager.addAction(action);
        }
        this.updateToolBar();
    }

    synchronized DockingActionIf getAction(String name) {
        DockingActionIf action = this.menuManager.getAction(name);
        if (action != null) {
            return action;
        }
        return this.toolBarManager.getAction(name);
    }

    void removeAction(DockingActionIf action) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new AssertException("Actions must be removed from Swing thread");
        }
        this.menuManager.removeAction(action);
        this.toolBarManager.removeAction(action);
        this.updateToolBar();
    }

    private void updateToolBar() {
        this.headerUpdater.update();
    }

    void dispose() {
        this.headerUpdater.dispose();
        this.menuManager.dispose();
        this.toolBarManager.dispose();
    }

    private class ToolBarMenuAction
    extends DockingAction {
        ToolBarMenuAction() {
            super("Local Menu", "DockingWindows");
            this.setDescription("Menu");
            this.setToolBarData(new ToolBarData(menuIcon, null));
        }

        @Override
        public void actionPerformed(ActionContext context) {
            JComponent src = (JComponent)context.getSourceObject();
            Dimension d = src.getSize();
            JPopupMenu popupMenu = DockableToolBarManager.this.menuManager.getPopupMenu();
            popupMenu.addPopupMenuListener(DockableToolBarManager.this.menuManager.getMenuHandler());
            popupMenu.show(src, 0, d.height);
        }
    }

    private class ToolBarCloseAction
    extends DockingAction {
        private DockableComponent dockableComponent;

        ToolBarCloseAction(DockableComponent dockableComponent) {
            super("Close Window", "DockingWindows");
            this.dockableComponent = dockableComponent;
            this.setDescription("Close Window");
            this.setToolBarData(new ToolBarData(closeIcon, null));
        }

        @Override
        public void actionPerformed(ActionContext context) {
            ComponentPlaceholder placeholder = this.dockableComponent.getComponentWindowingPlaceholder();
            if (placeholder != null) {
                placeholder.close();
            }
        }
    }
}

