/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.format;

import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockAccessException;
import ghidra.app.plugin.core.format.UniversalDataFormatModel;
import ghidra.util.HelpLocation;
import java.math.BigInteger;

public class HexFormatModel
implements UniversalDataFormatModel {
    public static final String NAME = "Hex";
    private int symbolSize;
    private int unitByteSize = this.groupSize;
    private boolean prefixEnabled = false;
    private boolean alphaCapsEnabled = false;
    private int groupSize = 1;
    private static final String GOOD_CHARS = "0123456789abcdefABCDEF";

    public HexFormatModel() {
        this.symbolSize = this.prefixEnabled ? 4 * this.groupSize : 2 * this.groupSize;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getUnitByteSize() {
        return this.unitByteSize;
    }

    @Override
    public int getDataUnitSymbolSize() {
        return this.symbolSize;
    }

    @Override
    public int getGroupSize() {
        return this.groupSize;
    }

    @Override
    public void setGroupSize(int groupSize) {
        this.groupSize = groupSize;
        this.unitByteSize = groupSize;
        this.symbolSize = 2 * groupSize;
    }

    public boolean isSpaceByGroupSize() {
        return false;
    }

    @Override
    public int getByteOffset(ByteBlock block, int pos) {
        if (this.prefixEnabled) {
            if (pos <= 3) {
                return 0;
            }
            if (pos < 2 + this.unitByteSize * 2) {
                return (pos - 2) / 2;
            }
            return this.unitByteSize - 1;
        }
        if (pos < this.unitByteSize * 2) {
            return pos / 2;
        }
        return this.unitByteSize - 1;
    }

    @Override
    public int getColumnPosition(ByteBlock block, int byteOffset) {
        if (this.prefixEnabled) {
            return byteOffset * 2 + 2;
        }
        return byteOffset * 2;
    }

    public int getInsertionPosition(int pos) {
        if (this.prefixEnabled) {
            if (pos <= 2) {
                return 2;
            }
            if (pos < this.symbolSize) {
                return pos;
            }
            return this.symbolSize - 1;
        }
        if (pos <= 0) {
            return 0;
        }
        if (pos < this.symbolSize) {
            return pos;
        }
        return this.symbolSize - 1;
    }

    @Override
    public String getDataRepresentation(ByteBlock block, BigInteger index) throws ByteBlockAccessException {
        StringBuffer sb = new StringBuffer();
        if (this.prefixEnabled) {
            sb.append("0x");
        }
        StringBuffer strBuff = new StringBuffer();
        BigInteger byteIndex = index;
        boolean qflag = false;
        for (int idx = 0; idx < this.unitByteSize; ++idx) {
            try {
                byte b = block.getByte(byteIndex);
                strBuff.append(this.adjust(Integer.toHexString(b)));
                byteIndex = byteIndex.add(BigInteger.ONE);
                continue;
            }
            catch (ByteBlockAccessException bbae) {
                if (idx != 0 && !qflag) continue;
                strBuff.append("??");
                qflag = true;
            }
        }
        String str = strBuff.toString();
        if (this.alphaCapsEnabled) {
            str = str.toUpperCase();
        }
        sb.append(str);
        return new String(sb);
    }

    public String getDataRepresentation(ByteBlock block, BigInteger index, int numUnits) throws ByteBlockAccessException {
        StringBuffer sb = new StringBuffer();
        System.out.println("representation: = " + block.getLocationRepresentation(index) + ", index = " + index);
        int n = 0;
        while (n < numUnits) {
            String str = this.getDataRepresentation(block, index);
            sb.append(str);
            ++n;
            index = index.add(BigInteger.ONE);
        }
        return new String(sb);
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public int getUnitDelimiterSize() {
        return 1;
    }

    @Override
    public boolean replaceValue(ByteBlock block, BigInteger index, int charPosition, char c) throws ByteBlockAccessException {
        if (GOOD_CHARS.indexOf(c) == -1) {
            return false;
        }
        if (this.prefixEnabled && (charPosition < 2 || charPosition >= this.symbolSize) || !this.prefixEnabled && (charPosition < 0 || charPosition >= this.symbolSize)) {
            return false;
        }
        int byteNo = this.getByteOffset(block, charPosition);
        index = index.add(BigInteger.valueOf(byteNo));
        byte b = block.getByte(index);
        char[] charArray = new char[]{c};
        byte cb = Byte.parseByte(new String(charArray), 16);
        if (charPosition % 2 == 0) {
            b = (byte)(b & 0xF);
            cb = (byte)(cb << 4);
            b = (byte)(b + cb);
        } else {
            b = (byte)(b & 0xF0);
            b = (byte)(b + cb);
        }
        block.setByte(index, b);
        return true;
    }

    @Override
    public boolean validateBytesPerLine(int bytesPerLine) {
        return true;
    }

    private String adjust(String value) {
        StringBuffer sb = new StringBuffer();
        int strLen = value.length();
        if (strLen > 2) {
            sb.append(value.substring(strLen - 2));
        } else {
            int len = 2 - strLen;
            for (int i = 0; i < len; ++i) {
                sb.append("0");
            }
            sb.append(value);
        }
        return sb.toString();
    }

    @Override
    public HelpLocation getHelpLocation() {
        return new HelpLocation("ByteViewerPlugin", NAME);
    }

    @Override
    public void dispose() {
    }
}

