/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import ghidra.app.plugin.core.format.ByteEditInfo;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.ToolEventName;
import ghidra.program.model.listing.Program;
import java.lang.ref.WeakReference;

@ToolEventName(value="ByteBlockChange")
public final class ByteBlockChangePluginEvent
extends PluginEvent {
    static final String NAME = "ByteBlockChange";
    private WeakReference<Program> programRef;
    private ByteEditInfo edit;

    public ByteBlockChangePluginEvent(String src, ByteEditInfo edit, Program program) {
        super(src, NAME);
        this.edit = edit;
        this.programRef = new WeakReference<Program>(program);
    }

    public Program getProgram() {
        return (Program)this.programRef.get();
    }

    public ByteEditInfo getByteEditInfo() {
        return this.edit;
    }

    protected String getDetails() {
        return "Address of Block Change==> " + this.edit.getBlockAddress() + ", offset ==> " + this.edit.getOffset();
    }
}

