/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.protocol.ghidra;

import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.protocol.ghidra.Handler;
import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.regex.Pattern;

public class GhidraURL {
    public static final String PROTOCOL = "ghidra";
    private static Pattern IS_LOCAL_URL_PATTERN = Pattern.compile("^ghidra:/[^/].*");
    public static final String MARKER_FILE_EXTENSION = ".gpr";
    public static final String PROJECT_DIRECTORY_EXTENSION = ".rep";

    private GhidraURL() {
    }

    public static boolean localProjectExists(URL url) {
        if (!GhidraURL.isLocalProjectURL(url)) {
            return false;
        }
        String path = url.getPath();
        if (Platform.CURRENT_PLATFORM.getOperatingSystem() == OperatingSystem.WINDOWS && path.indexOf(":/") == 2) {
            path = path.substring(1);
        }
        File markerFile = new File(path + MARKER_FILE_EXTENSION);
        File projectDir = new File(path + PROJECT_DIRECTORY_EXTENSION);
        return markerFile.isFile() && projectDir.isDirectory();
    }

    public static boolean isLocalProjectURL(URL url) {
        return IS_LOCAL_URL_PATTERN.matcher(url.toExternalForm()).matches();
    }

    public static String getProjectName(URL localProjectURL) {
        if (!GhidraURL.isLocalProjectURL(localProjectURL)) {
            throw new IllegalArgumentException("Invalid local Ghidra project URL");
        }
        String path = localProjectURL.getPath();
        int index = path.lastIndexOf(47);
        return path.substring(index + 1);
    }

    public static String getProjectLocation(URL localProjectURL) {
        if (!GhidraURL.isLocalProjectURL(localProjectURL)) {
            throw new IllegalArgumentException("Invalid local Ghidra project URL");
        }
        String path = localProjectURL.getPath();
        int index = path.lastIndexOf(47);
        if ((path = path.substring(0, index)).indexOf(":/") == 2) {
            path = path.substring(1);
            path = path.replace('/', File.separatorChar);
        }
        return path;
    }

    public static ProjectLocator getProjectStorageLocator(URL localProjectURL) {
        int index;
        if (!GhidraURL.isLocalProjectURL(localProjectURL)) {
            throw new IllegalArgumentException("Invalid local Ghidra project URL");
        }
        String path = localProjectURL.getPath();
        String dirPath = path.substring(0, index = path.lastIndexOf(47));
        if (dirPath.indexOf(":/") == 2) {
            dirPath = dirPath.substring(1);
            dirPath = dirPath.replace('/', File.separatorChar);
        }
        String name = path.substring(index + 1);
        return new ProjectLocator(dirPath, name);
    }

    public static boolean isServerRepositoryURL(URL url) {
        String path = url.getPath();
        return GhidraURL.isServerURL(url) && path != null && path.length() > 0;
    }

    public static boolean isServerURL(URL url) {
        if (!PROTOCOL.equals(url.getProtocol())) {
            return false;
        }
        return Handler.isSupportedURL(url);
    }

    private static String checkAbsolutePath(String path) {
        if (!((String)(path = ((String)path).replace('\\', '/'))).startsWith("/")) {
            if (((String)path).length() >= 3 && ((String)path).substring(1).startsWith(":/")) {
                path = "/" + (String)path;
            } else {
                throw new IllegalArgumentException("Absolute directory path required");
            }
        }
        return path;
    }

    public static URL toURL(String projectPathOrURL) {
        Object path = projectPathOrURL;
        if (!((String)path).startsWith("ghidra:")) {
            path = GhidraURL.checkAbsolutePath(projectPathOrURL);
            int index = ((String)path).lastIndexOf(47);
            if (index <= 0 || index == ((String)path).length() - 1) {
                throw new IllegalArgumentException("Invalid project path or URL");
            }
            path = "ghidra:" + (String)path;
        }
        try {
            return new URL((String)path);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static URL getNormalizedURL(URL url) {
        if (!GhidraURL.isServerRepositoryURL(url)) {
            return url;
        }
        String host = url.getHost();
        try {
            InetAddress addr = InetAddress.getByName(host);
            host = addr.getHostAddress();
        }
        catch (UnknownHostException addr) {
            // empty catch block
        }
        try {
            return new URL(PROTOCOL, host, url.getPort(), url.getPath());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getDisplayString(URL url) {
        if (GhidraURL.isLocalProjectURL(url)) {
            String path = url.getPath();
            if (path.indexOf(":/") == 2) {
                path = path.substring(1);
                path = path.replace('/', '\\');
            }
            return path;
        }
        return url.toString();
    }

    public static URL makeURL(File projectMarkerFile) {
        String name = projectMarkerFile.getName();
        if (Platform.CURRENT_PLATFORM.getOperatingSystem() == OperatingSystem.WINDOWS ? !name.endsWith(MARKER_FILE_EXTENSION) && !name.toLowerCase().endsWith(MARKER_FILE_EXTENSION) : !name.endsWith(MARKER_FILE_EXTENSION)) {
            throw new IllegalArgumentException("Invalid project marker file");
        }
        name = name.substring(0, name.length() - MARKER_FILE_EXTENSION.length());
        String location = projectMarkerFile.getParentFile().getAbsolutePath();
        return GhidraURL.makeURL(location, name);
    }

    public static URL makeURL(String dirPath, String projectName) {
        Object path = GhidraURL.checkAbsolutePath(dirPath);
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        try {
            return new URL("ghidra:" + (String)path + projectName);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static URL makeURL(String host, int port, String repositoryName, String repositoryPath) {
        return GhidraURL.makeURL(host, port, repositoryName, repositoryPath, null, null);
    }

    public static URL makeURL(String host, int port, String repositoryName, String repositoryPath, String fileName, String ref) {
        if (host == null) {
            throw new IllegalArgumentException("host required");
        }
        if (repositoryName == null) {
            throw new IllegalArgumentException("repository name required");
        }
        if (port == 0 || port == 13100) {
            port = -1;
        }
        String path = "/" + repositoryName;
        if (repositoryPath != null) {
            if (!repositoryPath.startsWith("/") || repositoryPath.indexOf(92) >= 0) {
                throw new IllegalArgumentException("Invalid repository path");
            }
            path = path + repositoryPath;
        } else {
            path = path + "/";
        }
        if (fileName != null) {
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            path = path + fileName;
        }
        if (ref != null) {
            path = path + "#" + ref;
        }
        try {
            return new URL(PROTOCOL, host, port, path);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static URL makeURL(String host, int port, String repositoryName) {
        return GhidraURL.makeURL(host, port, repositoryName, null);
    }
}

