/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.project.tool;

import generic.Images;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.File;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class ToolIconURL
implements Comparable<ToolIconURL> {
    private static final int MAX_IMAGE_LOAD_TIME = 5000;
    private String location;
    private ImageIcon baseIcon;
    private ImageIcon smallIcon;
    private ImageIcon largeIcon;
    private byte[] iconBytes;
    private boolean hasCheckedForAnimatedStatus;
    private boolean isAnimated;
    private int checkStatus;

    public ToolIconURL(String location) {
        if (location == null) {
            location = Images.BOMB;
        }
        this.location = location;
        this.loadIconFromLocation(location);
    }

    private void loadIconFromLocation(String iconLocation) {
        this.baseIcon = ResourceManager.loadImage((String)iconLocation);
        if (this.baseIcon == ResourceManager.getDefaultIcon()) {
            this.baseIcon = this.loadFromKnownImageResources(iconLocation);
        }
    }

    public ToolIconURL(String location, byte[] bytes) {
        this.location = location;
        this.iconBytes = bytes;
        File file = new File(location);
        this.baseIcon = ResourceManager.loadImage((String)file.getName(), (byte[])bytes);
    }

    @Override
    public int compareTo(ToolIconURL that) {
        return this.location.compareToIgnoreCase(that.location);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ToolIconURL other = (ToolIconURL)obj;
        return !(this.location == null ? other.location != null : !this.location.equals(other.location));
    }

    public String toString() {
        return this.location;
    }

    private ImageIcon getSmallIcon(ImageIcon unscaledIcon) {
        if (unscaledIcon.getIconHeight() == 16 && unscaledIcon.getIconHeight() == 16) {
            return unscaledIcon;
        }
        ImageIcon image = this.findCompatibleImageForSize(this.location, 16);
        if (image != null) {
            return image;
        }
        return ResourceManager.getScaledIcon((Icon)unscaledIcon, (int)16, (int)16);
    }

    private ImageIcon getLargeIcon(ImageIcon unscaledIcon) {
        if (unscaledIcon.getIconHeight() == 24 && unscaledIcon.getIconHeight() == 24) {
            return unscaledIcon;
        }
        ImageIcon image = this.findCompatibleImageForSize(this.location, 24);
        if (image != null) {
            return image;
        }
        image = this.findCompatibleImageForSize(this.location, 22);
        if (image != null) {
            return image;
        }
        if (unscaledIcon == ResourceManager.getDefaultIcon()) {
            return ResourceManager.loadImage((String)Images.BIG_BOMB);
        }
        return ResourceManager.getScaledIcon((Icon)unscaledIcon, (int)24, (int)24);
    }

    private ImageIcon findCompatibleImageForSize(String imagePath, int desiredSize) {
        ImageIcon image;
        Object name = imagePath;
        int dotIndex = ((String)name).lastIndexOf(46);
        if (dotIndex != -1) {
            name = ((String)name).substring(0, dotIndex);
        }
        name = this.stripSizeOffName((String)name);
        name = (String)name + desiredSize;
        if (dotIndex != -1) {
            name = (String)name + this.location.substring(dotIndex);
        }
        if ((image = this.getImageIcon((String)name)) != null) {
            return image;
        }
        return null;
    }

    private String stripSizeOffName(String name) {
        char character = name.charAt(name.length() - 1);
        if (!Character.isDigit(character)) {
            return name;
        }
        character = name.charAt(name.length() - 2);
        if (!Character.isDigit(character)) {
            return name.substring(0, name.length() - 1);
        }
        return name.substring(0, name.length() - 2);
    }

    private ImageIcon getImageIcon(String name) {
        ImageIcon defaultIcon;
        ImageIcon image = ResourceManager.loadImage((String)name);
        if (image == (defaultIcon = ResourceManager.getDefaultIcon())) {
            if (!name.startsWith("images")) {
                return this.getImageIcon("images/" + name);
            }
            return null;
        }
        return image;
    }

    public boolean isAnimated() {
        if (!this.hasCheckedForAnimatedStatus) {
            this.checkAnimated(this.baseIcon);
            this.hasCheckedForAnimatedStatus = true;
        }
        return this.isAnimated;
    }

    public String getLocation() {
        return this.location;
    }

    public ImageIcon getSmallIcon() {
        if (this.smallIcon == null) {
            this.smallIcon = this.getSmallIcon(this.baseIcon);
        }
        return this.smallIcon;
    }

    public ImageIcon getIcon() {
        if (this.largeIcon == null) {
            this.largeIcon = this.getLargeIcon(this.baseIcon);
        }
        return this.largeIcon;
    }

    public byte[] getIconBytes() {
        return this.iconBytes;
    }

    private ImageIcon loadFromKnownImageResources(String name) {
        String filename = "defaultTools/images/" + name;
        ImageIcon image = ResourceManager.loadImage((String)filename);
        if (image == ResourceManager.getDefaultIcon()) {
            filename = "images/" + name;
            image = ResourceManager.loadImage((String)filename);
        }
        return image;
    }

    private void checkAnimated(ImageIcon imgIcon) {
        if (imgIcon == null) {
            return;
        }
        this.setImageLoadingStatus(-1);
        ImageProducer ip = imgIcon.getImage().getSource();
        ToolIconImageConsumer ic = new ToolIconImageConsumer();
        ip.startProduction(ic);
        long sleepTime = 50L;
        try {
            for (long waitTime = 0L; !this.isImageLoadingComplete() && waitTime < 5000L; waitTime += sleepTime) {
                Thread.sleep(sleepTime);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ip.removeConsumer(ic);
        this.isAnimated = this.checkStatus == 2;
    }

    private synchronized void setImageLoadingStatus(int status) {
        this.checkStatus = status;
    }

    private synchronized boolean isImageLoadingComplete() {
        return this.checkStatus >= 0;
    }

    private class ToolIconImageConsumer
    implements ImageConsumer {
        private ToolIconImageConsumer() {
        }

        @Override
        public void imageComplete(int status) {
            ToolIconURL.this.setImageLoadingStatus(status);
        }

        @Override
        public void setHints(int hintflags) {
        }

        @Override
        public void setDimensions(int width, int height) {
        }

        @Override
        public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        }

        @Override
        public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        }

        @Override
        public void setColorModel(ColorModel model) {
        }

        @Override
        public void setProperties(Hashtable<?, ?> props) {
        }
    }
}

