/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.help.Help;
import docking.help.HelpService;
import docking.widgets.tabbedpane.DockingTabRenderer;
import ghidra.framework.main.FrontEndPlugin;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.datatable.ProjectDataTablePanel;
import ghidra.framework.main.datatree.ProjectDataTreePanel;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.model.ProjectManager;
import ghidra.framework.options.SaveState;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

class ProjectDataPanel
extends JSplitPane {
    private static final String BORDER_PREFIX = "Active Project: ";
    private static final String READ_ONLY_BORDER = "READ-ONLY Project Data";
    private static final int TYPICAL_NUM_VIEWS = 2;
    private static final int DIVIDER_SIZE = 2;
    private static final double DIVIDER_LOCATION = 0.5;
    private static final String EXPANDED_PATHS = "EXPANDED_PATHS";
    private FrontEndPlugin frontEndPlugin;
    private JTabbedPane projectTabPanel;
    private JTabbedPane readOnlyTab;
    private Map<ProjectLocator, ProjectDataTreePanel> readOnlyViews;
    private FrontEndTool tool;
    private ProjectDataTreePanel treePanel;
    private ProjectDataTablePanel tablePanel;
    private JPanel bugFixPanel;

    ProjectDataPanel(FrontEndPlugin plugin, ProjectDataTreePanel activePanel, ProjectDataTablePanel tablePanel, String projectName) {
        this.frontEndPlugin = plugin;
        this.tablePanel = tablePanel;
        this.tool = (FrontEndTool)plugin.getTool();
        this.treePanel = activePanel;
        this.readOnlyViews = new HashMap<ProjectLocator, ProjectDataTreePanel>(2);
        this.projectTabPanel = new JTabbedPane(3);
        this.projectTabPanel.setBorder(BorderFactory.createTitledBorder(BORDER_PREFIX));
        this.projectTabPanel.addChangeListener(e -> this.frontEndPlugin.getTool().contextChanged(null));
        this.projectTabPanel.addTab("Tree View", activePanel);
        this.projectTabPanel.addTab("Table View", tablePanel);
        this.add((Component)this.projectTabPanel, "left");
        this.projectTabPanel.setBorder(BorderFactory.createTitledBorder(BORDER_PREFIX));
        this.bugFixPanel = new JPanel(new BorderLayout());
        this.readOnlyTab = new JTabbedPane(3);
        this.bugFixPanel.add((Component)this.readOnlyTab, "Center");
        this.bugFixPanel.setBorder(BorderFactory.createTitledBorder(READ_ONLY_BORDER));
        this.setHelpOnReadOnlyTab();
        this.add((Component)this.bugFixPanel, "right");
        this.setViewsVisible(false);
    }

    private void setHelpOnReadOnlyTab() {
        HelpService help = Help.getHelpService();
        help.registerHelp((Object)this.readOnlyTab, new HelpLocation(this.frontEndPlugin.getName(), "ReadOnlyProjectDataPanel"));
    }

    private void populateReadOnlyViews(Project project) {
        if (project == null) {
            this.setViewsVisible(false);
            return;
        }
        ProjectLocator[] views = project.getProjectViews();
        HelpLocation helpLocation = new HelpLocation(this.frontEndPlugin.getName(), "ReadOnlyProjectDataPanel");
        for (ProjectLocator view : views) {
            try {
                ProjectData projectData = project.getProjectData(view);
                ProjectLocator projectLocator = projectData.getProjectLocator();
                String viewName = projectLocator.getName();
                ProjectDataTreePanel dtp = new ProjectDataTreePanel(viewName, false, this.frontEndPlugin, null);
                dtp.setProjectData(viewName, projectData);
                dtp.setHelpLocation(helpLocation);
                this.readOnlyTab.addTab(viewName, dtp);
                int index = this.readOnlyTab.indexOfComponent(dtp);
                this.readOnlyTab.setTabComponentAt(index, (Component)new DockingTabRenderer(this.readOnlyTab, viewName, viewName, e -> this.viewRemoved(dtp, this.getProjectURL(dtp), true)));
                this.readOnlyViews.put(view, dtp);
            }
            catch (Exception e2) {
                Msg.showError((Object)this, null, (String)"Error", (Object)"Cannot restore project view", (Throwable)e2);
            }
        }
        this.setViewsVisible(views.length > 0);
    }

    private void clearReadOnlyViews() {
        this.readOnlyTab.removeAll();
        this.readOnlyViews.clear();
        this.setViewsVisible(false);
    }

    private void setViewsVisible(boolean visible) {
        this.bugFixPanel.setVisible(visible);
        this.setDividerSize(visible ? 2 : 0);
        this.setDividerLocation(visible ? 0.5 : 1.0);
    }

    void openView(URL projectView) {
        ProjectManager projectManager = this.tool.getProjectManager();
        Project activeProject = this.tool.getProject();
        ProjectDataTreePanel dtp = this.getViewPanel(projectView);
        if (dtp != null) {
            this.readOnlyTab.setSelectedComponent(dtp);
            try {
                activeProject.addProjectView(projectView);
                projectManager.rememberViewedProject(projectView);
            }
            catch (Exception e2) {
                projectManager.forgetViewedProject(projectView);
                Msg.showError(this.getClass(), (Component)this.tool.getToolFrame(), (String)"Error Adding View", (Object)e2.toString());
            }
            return;
        }
        try {
            ProjectData projectData = activeProject.addProjectView(projectView);
            projectManager.rememberViewedProject(projectView);
            String viewName = projectData.getProjectLocator().getName();
            ProjectDataTreePanel newPanel = new ProjectDataTreePanel(viewName, false, this.frontEndPlugin, null);
            newPanel.setProjectData(viewName, projectData);
            newPanel.setHelpLocation(new HelpLocation(this.frontEndPlugin.getName(), "ReadOnlyProjectDataPanel"));
            this.readOnlyTab.insertTab(viewName, null, newPanel, null, 0);
            int index = this.readOnlyTab.indexOfComponent(newPanel);
            this.readOnlyTab.setTabComponentAt(index, (Component)new DockingTabRenderer(this.readOnlyTab, viewName, viewName, e -> this.viewRemoved(newPanel, this.getProjectURL(newPanel), true)));
            this.readOnlyTab.setSelectedIndex(0);
            this.readOnlyViews.put(projectData.getProjectLocator(), newPanel);
            this.setViewsVisible(true);
        }
        catch (Exception e3) {
            projectManager.forgetViewedProject(projectView);
            Msg.showError(this.getClass(), (Component)this.tool.getToolFrame(), (String)"Error Adding View", (Object)("Failed to view project/repository: " + e3.getMessage()));
        }
        this.validate();
    }

    ProjectLocator[] getProjectViews() {
        int numViews = this.readOnlyViews.size();
        ProjectLocator[] projViews = new ProjectLocator[numViews];
        this.readOnlyViews.keySet().toArray(projViews);
        return projViews;
    }

    ProjectData getProjectData(ProjectLocator projectView) {
        ProjectDataTreePanel dtp = this.readOnlyViews.get(projectView);
        if (dtp != null) {
            return dtp.getProjectData();
        }
        return null;
    }

    void closeView(URL projectView) {
        Project activeProject = this.tool.getProject();
        if (activeProject == null) {
            Msg.showError(this.getClass(), (Component)this.tool.getToolFrame(), (String)"Views Only Allowed With Active Project", (Object)("Cannot remove project view: " + projectView));
            return;
        }
        ProjectDataTreePanel dtp = this.getViewPanel(projectView);
        if (dtp == null) {
            Msg.showError(this.getClass(), (Component)this.tool.getToolFrame(), (String)"Cannot Remove Project Not In View", (Object)("Project view: " + projectView + " not found."));
            return;
        }
        this.viewRemoved(dtp, projectView, false);
    }

    private ProjectDataTreePanel getViewPanel(URL projectView) {
        for (ProjectLocator locator : this.readOnlyViews.keySet()) {
            if (!projectView.equals(locator.getURL())) continue;
            return this.readOnlyViews.get(locator);
        }
        return null;
    }

    private void removeViewPanel(URL projectView) {
        for (ProjectLocator locator : this.readOnlyViews.keySet()) {
            if (!projectView.equals(locator.getURL())) continue;
            this.readOnlyViews.remove(locator);
            break;
        }
    }

    URL getCurrentView() {
        return this.getProjectURL(this.treePanel);
    }

    private URL getProjectURL(ProjectDataTreePanel panel) {
        return panel.getProjectData().getProjectLocator().getURL();
    }

    private void viewRemoved(Component view, URL url, boolean notify) {
        this.removeViewPanel(url);
        this.readOnlyTab.remove(view);
        ((ProjectDataTreePanel)view).dispose();
        if (this.readOnlyViews.size() == 0) {
            this.setViewsVisible(false);
        }
        this.tool.getProject().removeProjectView(url);
        this.validate();
    }

    void setActiveProject(Project project) {
        this.treePanel.closeRootFolder();
        this.clearReadOnlyViews();
        if (project != null) {
            this.treePanel.setProjectData(project.getName(), project.getProjectData());
            this.tablePanel.setProjectData(project.getName(), project.getProjectData());
            this.populateReadOnlyViews(project);
        } else {
            this.tablePanel.setProjectData("No Active Project", null);
        }
        this.validate();
    }

    void setBorder(String projectName) {
        this.projectTabPanel.setBorder(BorderFactory.createTitledBorder(BORDER_PREFIX + projectName));
        this.treePanel.updateProjectName(projectName);
    }

    ActionContext getActionContext(ComponentProvider provider, MouseEvent e) {
        Component comp;
        Component component = comp = e == null ? this.projectTabPanel.getSelectedComponent() : e.getComponent();
        while (comp != null) {
            if (comp instanceof JTabbedPane) {
                return new ActionContext(provider, (Object)comp);
            }
            if (comp instanceof ProjectDataTreePanel) {
                ProjectDataTreePanel panel = (ProjectDataTreePanel)comp;
                return panel.getActionContext(provider, e);
            }
            if (comp instanceof ProjectDataTablePanel) {
                ProjectDataTablePanel panel = (ProjectDataTablePanel)comp;
                return panel.getActionContext(provider, e);
            }
            comp = comp.getParent();
        }
        return null;
    }

    void writeDataState(SaveState saveState) {
        String[] expandedPaths = this.treePanel.getExpandedPathsByNodeName();
        if (expandedPaths == null || expandedPaths.length == 0) {
            return;
        }
        saveState.putStrings(EXPANDED_PATHS, expandedPaths);
        saveState.putBoolean("SHOW_TABLE", this.isTableShowing());
    }

    void readDataState(SaveState saveState) {
        String[] expandedPaths = saveState.getStrings(EXPANDED_PATHS, null);
        if (expandedPaths == null) {
            return;
        }
        this.treePanel.setExpandedPathsByNodeName(expandedPaths);
        boolean showTable = saveState.getBoolean("SHOW_TABLE", false);
        if (showTable) {
            this.showTable();
        }
    }

    private void showTable() {
        this.projectTabPanel.setSelectedIndex(1);
    }

    private boolean isTableShowing() {
        return this.projectTabPanel.getSelectedIndex() == 1;
    }
}

