/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.exceptionhandling;

import ghidra.app.cmd.data.AbstractCreateDataTypeModel;
import ghidra.app.cmd.data.EHDataTypeUtilities;
import ghidra.app.cmd.data.TypeDescriptorModel;
import ghidra.app.cmd.data.exceptionhandling.EHCatchHandlerTypeModifier;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.app.util.datatype.microsoft.MSDataTypeUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ImageBaseOffset32DataType;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.UnsignedIntegerDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.exception.AssertException;

public class EHCatchHandlerModel
extends AbstractCreateDataTypeModel {
    public static final String DATA_TYPE_NAME = "HandlerType";
    private static String STRUCTURE_NAME = "_s_HandlerType";
    private static final int ADJECTIVES_ORDINAL = 0;
    private static final int TYPE_DESCRIPTOR_ORDINAL = 1;
    private static final int CATCH_OBJECT_ORDINAL = 2;
    private static final int HANDLER_ORDINAL = 3;
    private static final int FUNCTION_FRAME_ORDINAL = 4;
    private DataType dataType;

    public EHCatchHandlerModel(Program program, int catchHandlerCount, Address catchHandlerMapAddress, DataValidationOptions validationOptions) {
        super(program, catchHandlerCount, catchHandlerMapAddress, validationOptions);
    }

    @Override
    public String getName() {
        return DATA_TYPE_NAME;
    }

    @Override
    protected void validateModelSpecificInfo() throws InvalidDataTypeException {
        Program program = this.getProgram();
        int numEntries = this.getCount();
        for (int catchHandlerOrdinal = 0; catchHandlerOrdinal < numEntries; ++catchHandlerOrdinal) {
            Address catchHandlerAddress = this.getCatchHandlerAddress(catchHandlerOrdinal);
            if (catchHandlerAddress == null || !EHDataTypeUtilities.isValidForFunction(program, catchHandlerAddress)) {
                throw new InvalidDataTypeException(this.getName() + " data type at " + this.getAddress() + " doesn't refer to a valid location for a catch handler for entry " + catchHandlerOrdinal + ".");
            }
            Address typeDescriptorAddress = this.getTypeDescriptorAddress(catchHandlerOrdinal);
            if (typeDescriptorAddress == null || EHDataTypeUtilities.isValidAddress(program, typeDescriptorAddress)) continue;
            throw new InvalidDataTypeException(this.getName() + " data type at " + this.getAddress() + " doesn't refer to a valid location for the type descriptor for entry " + catchHandlerOrdinal + ".");
        }
    }

    public static DataType getDataType(Program program) {
        DataTypeManager dataTypeManager = program.getDataTypeManager();
        boolean isRelative = EHCatchHandlerModel.isRelative(program);
        CategoryPath categoryPath = new CategoryPath(CATEGORY_PATH);
        StructureDataType struct = MSDataTypeUtils.getAlignedPack4Structure((DataTypeManager)dataTypeManager, (CategoryPath)categoryPath, (String)STRUCTURE_NAME);
        Object compDt = new UnsignedIntegerDataType(dataTypeManager);
        struct.add((DataType)compDt, "adjectives", null);
        if (isRelative) {
            compDt = new ImageBaseOffset32DataType(dataTypeManager);
            struct.add((DataType)compDt, "dispType", null);
        } else {
            compDt = new PointerDataType(TypeDescriptorModel.getDataType(program), dataTypeManager);
            struct.add((DataType)compDt, "pType", null);
        }
        compDt = isRelative ? new IntegerDataType(dataTypeManager) : new TypedefDataType(new CategoryPath("/crtdefs.h"), "ptrdiff_t", (DataType)new IntegerDataType(dataTypeManager), dataTypeManager);
        struct.add((DataType)compDt, "dispCatchObj", null);
        if (isRelative) {
            compDt = new ImageBaseOffset32DataType(dataTypeManager);
            struct.add((DataType)compDt, "dispOfHandler", null);
        } else {
            compDt = new PointerDataType((DataType)new VoidDataType(dataTypeManager), dataTypeManager);
            struct.add((DataType)compDt, "addressOfHandler", null);
        }
        if (isRelative) {
            compDt = new DWordDataType(dataTypeManager);
            struct.add((DataType)compDt, "dispFrame", null);
        }
        TypedefDataType typeDefDt = new TypedefDataType(categoryPath, DATA_TYPE_NAME, (DataType)struct, dataTypeManager);
        return MSDataTypeUtils.getMatchingDataType((Program)program, (DataType)typeDefDt);
    }

    @Override
    public DataType getDataType() {
        if (this.dataType == null) {
            this.dataType = EHCatchHandlerModel.getDataType(this.getProgram());
        }
        return this.dataType;
    }

    @Override
    protected int getDataTypeLength() {
        return this.getDataType().getLength();
    }

    public TypeDescriptorModel getTypeDescriptorModel(int catchHandlerOrdinal) throws InvalidDataTypeException {
        this.checkValidity(catchHandlerOrdinal);
        Address typeDescriptorAddress = this.getTypeDescriptorAddress(catchHandlerOrdinal);
        if (typeDescriptorAddress != null) {
            return new TypeDescriptorModel(this.getProgram(), typeDescriptorAddress, this.validationOptions);
        }
        return null;
    }

    public Address getTypeDescriptorAddress(int catchHandlerOrdinal) throws InvalidDataTypeException {
        this.checkValidity(catchHandlerOrdinal);
        DataType catchHandlerDt = this.getDataType();
        MemBuffer specificMemBuffer = this.getSpecificMemBuffer(catchHandlerOrdinal, catchHandlerDt);
        Address refAddress = EHDataTypeUtilities.getAddress(catchHandlerDt, 1, specificMemBuffer);
        return this.getAdjustedAddress(refAddress, 0);
    }

    public Address getComponentAddressOfTypeDescriptorAddress(int catchHandlerOrdinal) throws InvalidDataTypeException {
        this.checkValidity(catchHandlerOrdinal);
        DataType catchHandlerDt = this.getDataType();
        MemBuffer specificMemBuffer = this.getSpecificMemBuffer(catchHandlerOrdinal, catchHandlerDt);
        return EHDataTypeUtilities.getComponentAddress(catchHandlerDt, 1, specificMemBuffer);
    }

    public Address getCatchHandlerAddress(int catchHandlerOrdinal) throws InvalidDataTypeException {
        this.checkValidity(catchHandlerOrdinal);
        DataType catchHandlerDt = this.getDataType();
        MemBuffer specificMemBuffer = this.getSpecificMemBuffer(catchHandlerOrdinal, catchHandlerDt);
        Address refAddress = EHDataTypeUtilities.getAddress(catchHandlerDt, 3, specificMemBuffer);
        return this.getAdjustedAddress(refAddress, 0);
    }

    public Address getComponentAddressOfCatchHandlerAddress(int catchHandlerOrdinal) throws InvalidDataTypeException {
        this.checkValidity(catchHandlerOrdinal);
        DataType dt = this.getDataType();
        MemBuffer specificMemBuffer = this.getSpecificMemBuffer(catchHandlerOrdinal, dt);
        return EHDataTypeUtilities.getComponentAddress(dt, 3, specificMemBuffer);
    }

    public EHCatchHandlerTypeModifier getModifiers(int catchHandlerOrdinal) throws InvalidDataTypeException {
        this.checkValidity(catchHandlerOrdinal);
        DataType dt = this.getDataType();
        if (dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        Structure struct = (Structure)dt;
        DataTypeComponent component = struct.getComponent(0);
        int offset = component.getOffset();
        MemBuffer specificMemBuffer = this.getSpecificMemBuffer(catchHandlerOrdinal, dt);
        try {
            int modifiers = specificMemBuffer.getInt(offset);
            return new EHCatchHandlerTypeModifier(modifiers);
        }
        catch (MemoryAccessException e) {
            throw new AssertException((Throwable)e);
        }
    }

    public String getCatchHandlerName(int catchHandlerOrdinal) throws InvalidDataTypeException {
        Object name = "Catch";
        DataType dt = this.getDataType();
        if (dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        if (!(dt instanceof Structure)) {
            return name;
        }
        EHCatchHandlerTypeModifier modifiers = this.getModifiers(catchHandlerOrdinal);
        if (modifiers.isAllCatch()) {
            name = (String)name + "_All";
        }
        return name;
    }

    public Scalar getCatchObjectDisplacement(int catchHandlerOrdinal) throws InvalidDataTypeException {
        this.checkValidity(catchHandlerOrdinal);
        DataType catchHandlerDt = this.getDataType();
        MemBuffer specificMemBuffer = this.getSpecificMemBuffer(catchHandlerOrdinal, catchHandlerDt);
        return EHDataTypeUtilities.getScalarValue(catchHandlerDt, 2, specificMemBuffer);
    }

    public Scalar getFunctionFrameAddressDisplacement(int catchHandlerOrdinal) throws InvalidDataTypeException {
        this.checkValidity(catchHandlerOrdinal);
        DataType catchHandlerDt = this.getDataType();
        MemBuffer specificMemBuffer = this.getSpecificMemBuffer(catchHandlerOrdinal, catchHandlerDt);
        return EHDataTypeUtilities.getScalarValue(catchHandlerDt, 4, specificMemBuffer);
    }
}

