/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.panel.BuildingPanel;
import net.sf.freecol.client.gui.panel.GoodsLabel;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.TypeCountMap;

public final class ReportProductionPanel
extends ReportPanel {
    private static final int NUMBER_OF_GOODS = 4;
    private final List<GoodsType> goodsTypes;
    private final List<JComboBox<String>> boxes = new ArrayList<JComboBox<String>>();

    public ReportProductionPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportProductionAction");
        this.goodsTypes = new ArrayList<GoodsType>();
        ArrayList<String> goodsNames = new ArrayList<String>();
        goodsNames.add(Messages.message("nothing"));
        for (GoodsType goodsType : this.getSpecification().getGoodsTypeList()) {
            if (goodsType.isFarmed()) continue;
            this.goodsTypes.add(goodsType);
            goodsNames.add(Messages.getName(goodsType));
        }
        String[] model = goodsNames.toArray(new String[0]);
        for (int index = 0; index < 4; ++index) {
            JComboBox<String> newBox = new JComboBox<String>(model);
            newBox.setSelectedIndex(0);
            this.boxes.add(newBox);
        }
        this.reportPanel.setLayout(new MigLayout("gap 0 0", "[fill]", "[fill]"));
        this.update();
    }

    private void update() {
        this.reportPanel.removeAll();
        JLabel selectLabel = Utility.localizedLabel("report.production.selectGoods");
        this.reportPanel.add(selectLabel);
        JButton selectButton = Utility.localizedButton("report.production.update");
        selectButton.addActionListener(ae -> this.update());
        this.reportPanel.add((Component)selectButton, "wrap");
        ArrayList<GoodsType> selectedTypes = new ArrayList<GoodsType>();
        for (int index = 0; index < 4; ++index) {
            JComboBox<String> box = this.boxes.get(index);
            this.reportPanel.add(box);
            int selectedIndex = box.getSelectedIndex();
            if (selectedIndex <= 0) continue;
            selectedTypes.add(this.goodsTypes.get(selectedIndex - 1));
        }
        if (!selectedTypes.isEmpty()) {
            TypeCountMap<BuildingType> buildingCount = new TypeCountMap<BuildingType>();
            ArrayList basicBuildingTypes = new ArrayList();
            for (GoodsType goodsType : selectedTypes) {
                ArrayList<BuildingType> buildingTypes = new ArrayList<BuildingType>();
                for (BuildingType buildingType : this.getSpecification().getBuildingTypeList()) {
                    BuildingType firstLevel;
                    if (!goodsType.equals(buildingType.getProducedGoodsType()) && !buildingType.hasModifier(goodsType.getId()) || buildingTypes.contains(firstLevel = buildingType.getFirstLevel())) continue;
                    buildingTypes.add(firstLevel);
                }
                basicBuildingTypes.add(buildingTypes);
            }
            JLabel newLabel = Utility.localizedLabel("Colony");
            newLabel.setBorder(Utility.TOPLEFTCELLBORDER);
            this.reportPanel.add((Component)newLabel, "newline 20");
            for (int index = 0; index < selectedTypes.size(); ++index) {
                newLabel = Utility.localizedLabel((Named)selectedTypes.get(index));
                newLabel.setBorder(Utility.TOPCELLBORDER);
                this.reportPanel.add(newLabel);
                for (BuildingType buildingType : (List)basicBuildingTypes.get(index)) {
                    newLabel = Utility.localizedLabel(buildingType);
                    newLabel.setBorder(Utility.TOPCELLBORDER);
                    this.reportPanel.add(newLabel);
                }
            }
            int[] totalProduction = new int[selectedTypes.size()];
            for (Colony colony : this.getFreeColClient().getMySortedColonies()) {
                JButton colonyButton = Utility.getLinkButton(colony.getName(), null, colony.getId());
                colonyButton.setBorder(Utility.LEFTCELLBORDER);
                colonyButton.addActionListener(this);
                this.reportPanel.add((Component)colonyButton, "newline");
                for (int index = 0; index < selectedTypes.size(); ++index) {
                    GoodsType goodsType = (GoodsType)selectedTypes.get(index);
                    int newValue = colony.getNetProductionOf(goodsType);
                    int n = index;
                    totalProduction[n] = totalProduction[n] + newValue;
                    Goods goods = new Goods(colony.getGame(), colony, goodsType, newValue);
                    GoodsLabel goodsLabel = new GoodsLabel(this.getGUI(), goods);
                    goodsLabel.setHorizontalAlignment(10);
                    goodsLabel.setBorder(Utility.CELLBORDER);
                    this.reportPanel.add(goodsLabel);
                    for (BuildingType buildingType : (List)basicBuildingTypes.get(index)) {
                        Building building = colony.getBuilding(buildingType);
                        if (building == null) {
                            newLabel = new JLabel();
                            newLabel.setBorder(Utility.CELLBORDER);
                            this.reportPanel.add(newLabel);
                            continue;
                        }
                        buildingCount.incrementCount(building.getType(), 1);
                        BuildingPanel buildingPanel = new BuildingPanel(this.getFreeColClient(), building);
                        buildingPanel.setBorder(Utility.CELLBORDER);
                        buildingPanel.initialize();
                        this.reportPanel.add(buildingPanel);
                    }
                }
            }
        }
        this.revalidate();
        this.repaint();
    }
}

