InlineEditor.BezierEditor=class extends UI.VBox{constructor(){super(true);this.registerRequiredCSS('inline_editor/bezierEditor.css');this.contentElement.tabIndex=0;this.setDefaultFocusedElement(this.contentElement);this._previewElement=this.contentElement.createChild('div','bezier-preview-container');this._previewElement.createChild('div','bezier-preview-animation');this._previewElement.addEventListener('click',this._startPreviewAnimation.bind(this));this._previewOnion=this.contentElement.createChild('div','bezier-preview-onion');this._previewOnion.addEventListener('click',this._startPreviewAnimation.bind(this));this._outerContainer=this.contentElement.createChild('div','bezier-container');this._presetsContainer=this._outerContainer.createChild('div','bezier-presets');this._presetUI=new InlineEditor.BezierUI(40,40,0,2,false);this._presetCategories=[];for(let i=0;i<InlineEditor.BezierEditor.Presets.length;i++){this._presetCategories[i]=this._createCategory(InlineEditor.BezierEditor.Presets[i]);this._presetsContainer.appendChild(this._presetCategories[i].icon);}
this._curveUI=new InlineEditor.BezierUI(150,250,50,7,true);this._curve=this._outerContainer.createSVGChild('svg','bezier-curve');UI.installDragHandle(this._curve,this._dragStart.bind(this),this._dragMove.bind(this),this._dragEnd.bind(this),'default');this._header=this.contentElement.createChild('div','bezier-header');const minus=this._createPresetModifyIcon(this._header,'bezier-preset-minus','M 12 6 L 8 10 L 12 14');const plus=this._createPresetModifyIcon(this._header,'bezier-preset-plus','M 8 6 L 12 10 L 8 14');minus.addEventListener('click',this._presetModifyClicked.bind(this,false));plus.addEventListener('click',this._presetModifyClicked.bind(this,true));this._label=this._header.createChild('span','source-code bezier-display-value');}
setBezier(bezier){if(!bezier)
return;this._bezier=bezier;this._updateUI();}
bezier(){return this._bezier;}
wasShown(){this._unselectPresets();for(const category of this._presetCategories){for(let i=0;i<category.presets.length;i++){if(this._bezier.asCSSText()===category.presets[i].value){category.presetIndex=i;this._presetCategorySelected(category);}}}
this._updateUI();this._startPreviewAnimation();}
_onchange(){this._updateUI();this.dispatchEventToListeners(InlineEditor.BezierEditor.Events.BezierChanged,this._bezier.asCSSText());}
_updateUI(){const labelText=this._selectedCategory?this._selectedCategory.presets[this._selectedCategory.presetIndex].name:this._bezier.asCSSText().replace(/\s(-\d\.\d)/g,'$1');this._label.textContent=Common.UIString(labelText);this._curveUI.drawCurve(this._bezier,this._curve);this._previewOnion.removeChildren();}
_dragStart(event){this._mouseDownPosition=new UI.Geometry.Point(event.x,event.y);const ui=this._curveUI;this._controlPosition=new UI.Geometry.Point(Number.constrain((event.offsetX-ui.radius)/ui.curveWidth(),0,1),(ui.curveHeight()+ui.marginTop+ui.radius-event.offsetY)/ui.curveHeight());const firstControlPointIsCloser=this._controlPosition.distanceTo(this._bezier.controlPoints[0])<this._controlPosition.distanceTo(this._bezier.controlPoints[1]);this._selectedPoint=firstControlPointIsCloser?0:1;this._bezier.controlPoints[this._selectedPoint]=this._controlPosition;this._unselectPresets();this._onchange();event.consume(true);return true;}
_updateControlPosition(mouseX,mouseY){const deltaX=(mouseX-this._mouseDownPosition.x)/this._curveUI.curveWidth();const deltaY=(mouseY-this._mouseDownPosition.y)/this._curveUI.curveHeight();const newPosition=new UI.Geometry.Point(Number.constrain(this._controlPosition.x+deltaX,0,1),this._controlPosition.y-deltaY);this._bezier.controlPoints[this._selectedPoint]=newPosition;}
_dragMove(event){this._updateControlPosition(event.x,event.y);this._onchange();}
_dragEnd(event){this._updateControlPosition(event.x,event.y);this._onchange();this._startPreviewAnimation();}
_createCategory(presetGroup){const presetElement=createElementWithClass('div','bezier-preset-category');const iconElement=presetElement.createSVGChild('svg','bezier-preset monospace');const category={presets:presetGroup,presetIndex:0,icon:presetElement};this._presetUI.drawCurve(UI.Geometry.CubicBezier.parse(category.presets[0].value),iconElement);iconElement.addEventListener('click',this._presetCategorySelected.bind(this,category));return category;}
_createPresetModifyIcon(parentElement,className,drawPath){const icon=parentElement.createSVGChild('svg','bezier-preset-modify '+className);icon.setAttribute('width',20);icon.setAttribute('height',20);const path=icon.createSVGChild('path');path.setAttribute('d',drawPath);return icon;}
_unselectPresets(){for(const category of this._presetCategories)
category.icon.classList.remove('bezier-preset-selected');delete this._selectedCategory;this._header.classList.remove('bezier-header-active');}
_presetCategorySelected(category,event){if(this._selectedCategory===category)
return;this._unselectPresets();this._header.classList.add('bezier-header-active');this._selectedCategory=category;this._selectedCategory.icon.classList.add('bezier-preset-selected');this.setBezier(UI.Geometry.CubicBezier.parse(category.presets[category.presetIndex].value));this._onchange();this._startPreviewAnimation();if(event)
event.consume(true);}
_presetModifyClicked(intensify,event){if(!this._selectedCategory)
return;const length=this._selectedCategory.presets.length;this._selectedCategory.presetIndex=(this._selectedCategory.presetIndex+(intensify?1:-1)+length)%length;this.setBezier(UI.Geometry.CubicBezier.parse(this._selectedCategory.presets[this._selectedCategory.presetIndex].value));this._onchange();this._startPreviewAnimation();}
_startPreviewAnimation(){if(this._previewAnimation)
this._previewAnimation.cancel();const animationDuration=1600;const numberOnionSlices=20;const keyframes=[{offset:0,transform:'translateX(0px)',easing:this._bezier.asCSSText(),opacity:1},{offset:0.9,transform:'translateX(218px)',opacity:1},{offset:1,transform:'translateX(218px)',opacity:0}];this._previewAnimation=this._previewElement.animate(keyframes,animationDuration);this._previewOnion.removeChildren();for(let i=0;i<=numberOnionSlices;i++){const slice=this._previewOnion.createChild('div','bezier-preview-animation');const player=slice.animate([{transform:'translateX(0px)',easing:this._bezier.asCSSText()},{transform:'translateX(218px)'}],{duration:animationDuration,fill:'forwards'});player.pause();player.currentTime=animationDuration*i/numberOnionSlices;}}};InlineEditor.BezierEditor.Events={BezierChanged:Symbol('BezierChanged')};InlineEditor.BezierEditor.Presets=[[{name:'ease-in-out',value:'ease-in-out'},{name:'In Out · Sine',value:'cubic-bezier(0.45, 0.05, 0.55, 0.95)'},{name:'In Out · Quadratic',value:'cubic-bezier(0.46, 0.03, 0.52, 0.96)'},{name:'In Out · Cubic',value:'cubic-bezier(0.65, 0.05, 0.36, 1)'},{name:'Fast Out, Slow In',value:'cubic-bezier(0.4, 0, 0.2, 1)'},{name:'In Out · Back',value:'cubic-bezier(0.68, -0.55, 0.27, 1.55)'}],[{name:'Fast Out, Linear In',value:'cubic-bezier(0.4, 0, 1, 1)'},{name:'ease-in',value:'ease-in'},{name:'In · Sine',value:'cubic-bezier(0.47, 0, 0.75, 0.72)'},{name:'In · Quadratic',value:'cubic-bezier(0.55, 0.09, 0.68, 0.53)'},{name:'In · Cubic',value:'cubic-bezier(0.55, 0.06, 0.68, 0.19)'},{name:'In · Back',value:'cubic-bezier(0.6, -0.28, 0.74, 0.05)'}],[{name:'ease-out',value:'ease-out'},{name:'Out · Sine',value:'cubic-bezier(0.39, 0.58, 0.57, 1)'},{name:'Out · Quadratic',value:'cubic-bezier(0.25, 0.46, 0.45, 0.94)'},{name:'Out · Cubic',value:'cubic-bezier(0.22, 0.61, 0.36, 1)'},{name:'Linear Out, Slow In',value:'cubic-bezier(0, 0, 0.2, 1)'},{name:'Out · Back',value:'cubic-bezier(0.18, 0.89, 0.32, 1.28)'}]];InlineEditor.BezierEditor.PresetCategory;;InlineEditor.BezierUI=class{constructor(width,height,marginTop,controlPointRadius,linearLine){this.width=width;this.height=height;this.marginTop=marginTop;this.radius=controlPointRadius;this.linearLine=linearLine;}
static drawVelocityChart(bezier,path,width){const height=InlineEditor.BezierUI.Height;let pathBuilder=['M',0,height];const sampleSize=1/40;let prev=bezier.evaluateAt(0);for(let t=sampleSize;t<1+sampleSize;t+=sampleSize){const current=bezier.evaluateAt(t);let slope=(current.y-prev.y)/(current.x-prev.x);const weightedX=prev.x*(1-t)+current.x*t;slope=Math.tanh(slope/1.5);pathBuilder=pathBuilder.concat(['L',(weightedX*width).toFixed(2),(height-slope*height).toFixed(2)]);prev=current;}
pathBuilder=pathBuilder.concat(['L',width.toFixed(2),height,'Z']);path.setAttribute('d',pathBuilder.join(' '));}
curveWidth(){return this.width-this.radius*2;}
curveHeight(){return this.height-this.radius*2-this.marginTop*2;}
_drawLine(parentElement,className,x1,y1,x2,y2){const line=parentElement.createSVGChild('line',className);line.setAttribute('x1',x1+this.radius);line.setAttribute('y1',y1+this.radius+this.marginTop);line.setAttribute('x2',x2+this.radius);line.setAttribute('y2',y2+this.radius+this.marginTop);}
_drawControlPoints(parentElement,startX,startY,controlX,controlY){this._drawLine(parentElement,'bezier-control-line',startX,startY,controlX,controlY);const circle=parentElement.createSVGChild('circle','bezier-control-circle');circle.setAttribute('cx',controlX+this.radius);circle.setAttribute('cy',controlY+this.radius+this.marginTop);circle.setAttribute('r',this.radius);}
drawCurve(bezier,svg){if(!bezier)
return;const width=this.curveWidth();const height=this.curveHeight();svg.setAttribute('width',this.width);svg.setAttribute('height',this.height);svg.removeChildren();const group=svg.createSVGChild('g');if(this.linearLine)
this._drawLine(group,'linear-line',0,height,width,0);const curve=group.createSVGChild('path','bezier-path');const curvePoints=[new UI.Geometry.Point(bezier.controlPoints[0].x*width+this.radius,(1-bezier.controlPoints[0].y)*height+this.radius+this.marginTop),new UI.Geometry.Point(bezier.controlPoints[1].x*width+this.radius,(1-bezier.controlPoints[1].y)*height+this.radius+this.marginTop),new UI.Geometry.Point(width+this.radius,this.marginTop+this.radius)];curve.setAttribute('d','M'+this.radius+','+(height+this.radius+this.marginTop)+' C'+curvePoints.join(' '));this._drawControlPoints(group,0,height,bezier.controlPoints[0].x*width,(1-bezier.controlPoints[0].y)*height);this._drawControlPoints(group,width,0,bezier.controlPoints[1].x*width,(1-bezier.controlPoints[1].y)*height);}};InlineEditor.BezierUI.Height=26;;InlineEditor.ColorSwatch=class extends HTMLSpanElement{constructor(){super();const root=UI.createShadowRootWithCoreStyles(this,'inline_editor/colorSwatch.css');this._iconElement=root.createChild('span','color-swatch');this._iconElement.title=Common.UIString('Shift-click to change color format');this._swatchInner=this._iconElement.createChild('span','color-swatch-inner');this._swatchInner.addEventListener('dblclick',e=>e.consume(),false);this._swatchInner.addEventListener('mousedown',e=>e.consume(),false);this._swatchInner.addEventListener('click',this._handleClick.bind(this),true);root.createChild('slot');this._colorValueElement=this.createChild('span');}
static create(){if(!InlineEditor.ColorSwatch._constructor){InlineEditor.ColorSwatch._constructor=UI.registerCustomElement('span','color-swatch',InlineEditor.ColorSwatch);}
return(InlineEditor.ColorSwatch._constructor());}
static _nextColorFormat(color,curFormat){const cf=Common.Color.Format;switch(curFormat){case cf.Original:return!color.hasAlpha()?cf.RGB:cf.RGBA;case cf.RGB:case cf.RGBA:return!color.hasAlpha()?cf.HSL:cf.HSLA;case cf.HSL:case cf.HSLA:if(color.nickname())
return cf.Nickname;return color.detectHEXFormat();case cf.ShortHEX:return cf.HEX;case cf.ShortHEXA:return cf.HEXA;case cf.HEXA:case cf.HEX:return cf.Original;case cf.Nickname:return color.detectHEXFormat();default:return cf.RGBA;}}
color(){return this._color;}
setColor(color){this._color=color;this._format=this._color.format();const colorString=(this._color.asString(this._format));this.setText(colorString);this._swatchInner.style.backgroundColor=colorString;}
hideText(hide){this._colorValueElement.hidden=hide;}
setText(text,tooltip){this._colorValueElement.textContent=text;this._colorValueElement.title=tooltip;}
format(){return this._format;}
setFormat(format){this._format=format;this.setText(this._color.asString(this._format));}
toggleNextFormat(){let currentValue;do{this._format=InlineEditor.ColorSwatch._nextColorFormat(this._color,this._format);currentValue=this._color.asString(this._format);}while(currentValue===this._colorValueElement.textContent);this.setText(currentValue);}
iconElement(){return this._iconElement;}
_handleClick(event){if(!event.shiftKey)
return;event.target.parentNode.parentNode.host.toggleNextFormat();event.consume(true);}};InlineEditor.BezierSwatch=class extends HTMLSpanElement{constructor(){super();const root=UI.createShadowRootWithCoreStyles(this,'inline_editor/bezierSwatch.css');this._iconElement=UI.Icon.create('smallicon-bezier','bezier-swatch-icon');root.appendChild(this._iconElement);this._textElement=this.createChild('span');root.createChild('slot');}
static create(){if(!InlineEditor.BezierSwatch._constructor){InlineEditor.BezierSwatch._constructor=UI.registerCustomElement('span','bezier-swatch',InlineEditor.BezierSwatch);}
return(InlineEditor.BezierSwatch._constructor());}
bezierText(){return this._textElement.textContent;}
setBezierText(text){this._textElement.textContent=text;}
hideText(hide){this._textElement.hidden=hide;}
iconElement(){return this._iconElement;}};InlineEditor.CSSShadowSwatch=class extends HTMLSpanElement{constructor(){super();const root=UI.createShadowRootWithCoreStyles(this,'inline_editor/cssShadowSwatch.css');this._iconElement=UI.Icon.create('smallicon-shadow','shadow-swatch-icon');root.appendChild(this._iconElement);root.createChild('slot');this._contentElement=this.createChild('span');}
static create(){if(!InlineEditor.CSSShadowSwatch._constructor){InlineEditor.CSSShadowSwatch._constructor=UI.registerCustomElement('span','css-shadow-swatch',InlineEditor.CSSShadowSwatch);}
return(InlineEditor.CSSShadowSwatch._constructor());}
model(){return this._model;}
setCSSShadow(model){this._model=model;this._contentElement.removeChildren();const results=TextUtils.TextUtils.splitStringByRegexes(model.asCSSText(),[/inset/g,Common.Color.Regex]);for(let i=0;i<results.length;i++){const result=results[i];if(result.regexIndex===1){if(!this._colorSwatch)
this._colorSwatch=InlineEditor.ColorSwatch.create();this._colorSwatch.setColor(model.color());this._contentElement.appendChild(this._colorSwatch);}else{this._contentElement.appendChild(createTextNode(result.value));}}}
hideText(hide){this._contentElement.hidden=hide;}
iconElement(){return this._iconElement;}
colorSwatch(){return this._colorSwatch;}};;InlineEditor.CSSShadowEditor=class extends UI.VBox{constructor(){super(true);this.registerRequiredCSS('inline_editor/cssShadowEditor.css');this.contentElement.tabIndex=0;this.setDefaultFocusedElement(this.contentElement);this._typeField=this.contentElement.createChild('div','shadow-editor-field shadow-editor-flex-field');this._typeField.createChild('label','shadow-editor-label').textContent=Common.UIString('Type');this._outsetButton=this._typeField.createChild('button','shadow-editor-button-left');this._outsetButton.textContent=Common.UIString('Outset');this._outsetButton.addEventListener('click',this._onButtonClick.bind(this),false);this._insetButton=this._typeField.createChild('button','shadow-editor-button-right');this._insetButton.textContent=Common.UIString('Inset');this._insetButton.addEventListener('click',this._onButtonClick.bind(this),false);const xField=this.contentElement.createChild('div','shadow-editor-field');this._xInput=this._createTextInput(xField,Common.UIString('X offset'));const yField=this.contentElement.createChild('div','shadow-editor-field');this._yInput=this._createTextInput(yField,Common.UIString('Y offset'));this._xySlider=xField.createChild('canvas','shadow-editor-2D-slider');this._xySlider.width=InlineEditor.CSSShadowEditor.canvasSize;this._xySlider.height=InlineEditor.CSSShadowEditor.canvasSize;this._xySlider.tabIndex=-1;this._halfCanvasSize=InlineEditor.CSSShadowEditor.canvasSize/2;this._innerCanvasSize=this._halfCanvasSize-InlineEditor.CSSShadowEditor.sliderThumbRadius;UI.installDragHandle(this._xySlider,this._dragStart.bind(this),this._dragMove.bind(this),null,'default');this._xySlider.addEventListener('keydown',this._onCanvasArrowKey.bind(this),false);this._xySlider.addEventListener('blur',this._onCanvasBlur.bind(this),false);const blurField=this.contentElement.createChild('div','shadow-editor-field shadow-editor-flex-field shadow-editor-blur-field');this._blurInput=this._createTextInput(blurField,Common.UIString('Blur'));this._blurSlider=this._createSlider(blurField);this._spreadField=this.contentElement.createChild('div','shadow-editor-field shadow-editor-flex-field');this._spreadInput=this._createTextInput(this._spreadField,Common.UIString('Spread'));this._spreadSlider=this._createSlider(this._spreadField);}
_createTextInput(field,propertyName){const label=field.createChild('label','shadow-editor-label');label.textContent=propertyName;label.setAttribute('for',propertyName);const textInput=UI.createInput('shadow-editor-text-input','text');field.appendChild(textInput);textInput.id=propertyName;textInput.addEventListener('keydown',this._handleValueModification.bind(this),false);textInput.addEventListener('mousewheel',this._handleValueModification.bind(this),false);textInput.addEventListener('input',this._onTextInput.bind(this),false);textInput.addEventListener('blur',this._onTextBlur.bind(this),false);return textInput;}
_createSlider(field){const slider=UI.createSlider(0,InlineEditor.CSSShadowEditor.maxRange,-1);slider.addEventListener('input',this._onSliderInput.bind(this),false);field.appendChild(slider);return slider;}
wasShown(){this._updateUI();}
setModel(model){this._model=model;this._typeField.classList.toggle('hidden',!model.isBoxShadow());this._spreadField.classList.toggle('hidden',!model.isBoxShadow());this._updateUI();}
_updateUI(){this._updateButtons();this._xInput.value=this._model.offsetX().asCSSText();this._yInput.value=this._model.offsetY().asCSSText();this._blurInput.value=this._model.blurRadius().asCSSText();this._spreadInput.value=this._model.spreadRadius().asCSSText();this._blurSlider.value=this._model.blurRadius().amount;this._spreadSlider.value=this._model.spreadRadius().amount;this._updateCanvas(false);}
_updateButtons(){this._insetButton.classList.toggle('enabled',this._model.inset());this._outsetButton.classList.toggle('enabled',!this._model.inset());}
_updateCanvas(drawFocus){const context=this._xySlider.getContext('2d');context.clearRect(0,0,this._xySlider.width,this._xySlider.height);context.save();context.setLineDash([1,1]);context.strokeStyle='rgba(210, 210, 210, 0.8)';context.beginPath();context.moveTo(this._halfCanvasSize,0);context.lineTo(this._halfCanvasSize,InlineEditor.CSSShadowEditor.canvasSize);context.moveTo(0,this._halfCanvasSize);context.lineTo(InlineEditor.CSSShadowEditor.canvasSize,this._halfCanvasSize);context.stroke();context.restore();const thumbPoint=this._sliderThumbPosition();context.save();context.translate(this._halfCanvasSize,this._halfCanvasSize);context.lineWidth=2;context.strokeStyle='rgba(130, 130, 130, 0.75)';context.beginPath();context.moveTo(0,0);context.lineTo(thumbPoint.x,thumbPoint.y);context.stroke();if(drawFocus){context.beginPath();context.fillStyle='rgba(66, 133, 244, 0.4)';context.arc(thumbPoint.x,thumbPoint.y,InlineEditor.CSSShadowEditor.sliderThumbRadius+2,0,2*Math.PI);context.fill();}
context.beginPath();context.fillStyle='#4285F4';context.arc(thumbPoint.x,thumbPoint.y,InlineEditor.CSSShadowEditor.sliderThumbRadius,0,2*Math.PI);context.fill();context.restore();}
_onButtonClick(event){const insetClicked=(event.currentTarget===this._insetButton);if(insetClicked&&this._model.inset()||!insetClicked&&!this._model.inset())
return;this._model.setInset(insetClicked);this._updateButtons();this.dispatchEventToListeners(InlineEditor.CSSShadowEditor.Events.ShadowChanged,this._model);}
_handleValueModification(event){const modifiedValue=UI.createReplacementString(event.currentTarget.value,event,customNumberHandler);if(!modifiedValue)
return;const length=InlineEditor.CSSLength.parse(modifiedValue);if(!length)
return;if(event.currentTarget===this._blurInput&&length.amount<0)
length.amount=0;event.currentTarget.value=length.asCSSText();event.currentTarget.selectionStart=0;event.currentTarget.selectionEnd=event.currentTarget.value.length;this._onTextInput(event);event.consume(true);function customNumberHandler(prefix,number,suffix){if(!suffix.length)
suffix=InlineEditor.CSSShadowEditor.defaultUnit;return prefix+number+suffix;}}
_onTextInput(event){this._changedElement=event.currentTarget;this._changedElement.classList.remove('invalid');const length=InlineEditor.CSSLength.parse(event.currentTarget.value);if(!length||event.currentTarget===this._blurInput&&length.amount<0)
return;if(event.currentTarget===this._xInput){this._model.setOffsetX(length);this._updateCanvas(false);}else if(event.currentTarget===this._yInput){this._model.setOffsetY(length);this._updateCanvas(false);}else if(event.currentTarget===this._blurInput){this._model.setBlurRadius(length);this._blurSlider.value=length.amount;}else if(event.currentTarget===this._spreadInput){this._model.setSpreadRadius(length);this._spreadSlider.value=length.amount;}
this.dispatchEventToListeners(InlineEditor.CSSShadowEditor.Events.ShadowChanged,this._model);}
_onTextBlur(){if(!this._changedElement)
return;let length=!this._changedElement.value.trim()?InlineEditor.CSSLength.zero():InlineEditor.CSSLength.parse(this._changedElement.value);if(!length)
length=InlineEditor.CSSLength.parse(this._changedElement.value+InlineEditor.CSSShadowEditor.defaultUnit);if(!length){this._changedElement.classList.add('invalid');this._changedElement=null;return;}
if(this._changedElement===this._xInput){this._model.setOffsetX(length);this._xInput.value=length.asCSSText();this._updateCanvas(false);}else if(this._changedElement===this._yInput){this._model.setOffsetY(length);this._yInput.value=length.asCSSText();this._updateCanvas(false);}else if(this._changedElement===this._blurInput){if(length.amount<0)
length=InlineEditor.CSSLength.zero();this._model.setBlurRadius(length);this._blurInput.value=length.asCSSText();this._blurSlider.value=length.amount;}else if(this._changedElement===this._spreadInput){this._model.setSpreadRadius(length);this._spreadInput.value=length.asCSSText();this._spreadSlider.value=length.amount;}
this._changedElement=null;this.dispatchEventToListeners(InlineEditor.CSSShadowEditor.Events.ShadowChanged,this._model);}
_onSliderInput(event){if(event.currentTarget===this._blurSlider){this._model.setBlurRadius(new InlineEditor.CSSLength(this._blurSlider.value,this._model.blurRadius().unit||InlineEditor.CSSShadowEditor.defaultUnit));this._blurInput.value=this._model.blurRadius().asCSSText();this._blurInput.classList.remove('invalid');}else if(event.currentTarget===this._spreadSlider){this._model.setSpreadRadius(new InlineEditor.CSSLength(this._spreadSlider.value,this._model.spreadRadius().unit||InlineEditor.CSSShadowEditor.defaultUnit));this._spreadInput.value=this._model.spreadRadius().asCSSText();this._spreadInput.classList.remove('invalid');}
this.dispatchEventToListeners(InlineEditor.CSSShadowEditor.Events.ShadowChanged,this._model);}
_dragStart(event){this._xySlider.focus();this._updateCanvas(true);this._canvasOrigin=new UI.Geometry.Point(this._xySlider.totalOffsetLeft()+this._halfCanvasSize,this._xySlider.totalOffsetTop()+this._halfCanvasSize);const clickedPoint=new UI.Geometry.Point(event.x-this._canvasOrigin.x,event.y-this._canvasOrigin.y);const thumbPoint=this._sliderThumbPosition();if(clickedPoint.distanceTo(thumbPoint)>=InlineEditor.CSSShadowEditor.sliderThumbRadius)
this._dragMove(event);return true;}
_dragMove(event){let point=new UI.Geometry.Point(event.x-this._canvasOrigin.x,event.y-this._canvasOrigin.y);if(event.shiftKey)
point=this._snapToClosestDirection(point);const constrainedPoint=this._constrainPoint(point,this._innerCanvasSize);const newX=Math.round((constrainedPoint.x/this._innerCanvasSize)*InlineEditor.CSSShadowEditor.maxRange);const newY=Math.round((constrainedPoint.y/this._innerCanvasSize)*InlineEditor.CSSShadowEditor.maxRange);if(event.shiftKey){this._model.setOffsetX(new InlineEditor.CSSLength(newX,this._model.offsetX().unit||InlineEditor.CSSShadowEditor.defaultUnit));this._model.setOffsetY(new InlineEditor.CSSLength(newY,this._model.offsetY().unit||InlineEditor.CSSShadowEditor.defaultUnit));}else{if(!event.altKey){this._model.setOffsetX(new InlineEditor.CSSLength(newX,this._model.offsetX().unit||InlineEditor.CSSShadowEditor.defaultUnit));}
if(!UI.KeyboardShortcut.eventHasCtrlOrMeta(event)){this._model.setOffsetY(new InlineEditor.CSSLength(newY,this._model.offsetY().unit||InlineEditor.CSSShadowEditor.defaultUnit));}}
this._xInput.value=this._model.offsetX().asCSSText();this._yInput.value=this._model.offsetY().asCSSText();this._xInput.classList.remove('invalid');this._yInput.classList.remove('invalid');this._updateCanvas(true);this.dispatchEventToListeners(InlineEditor.CSSShadowEditor.Events.ShadowChanged,this._model);}
_onCanvasBlur(){this._updateCanvas(false);}
_onCanvasArrowKey(event){let shiftX=0;let shiftY=0;if(event.key==='ArrowRight')
shiftX=1;else if(event.key==='ArrowLeft')
shiftX=-1;else if(event.key==='ArrowUp')
shiftY=-1;else if(event.key==='ArrowDown')
shiftY=1;if(!shiftX&&!shiftY)
return;event.consume(true);if(shiftX){const offsetX=this._model.offsetX();const newAmount=Number.constrain(offsetX.amount+shiftX,-InlineEditor.CSSShadowEditor.maxRange,InlineEditor.CSSShadowEditor.maxRange);if(newAmount===offsetX.amount)
return;this._model.setOffsetX(new InlineEditor.CSSLength(newAmount,offsetX.unit||InlineEditor.CSSShadowEditor.defaultUnit));this._xInput.value=this._model.offsetX().asCSSText();this._xInput.classList.remove('invalid');}
if(shiftY){const offsetY=this._model.offsetY();const newAmount=Number.constrain(offsetY.amount+shiftY,-InlineEditor.CSSShadowEditor.maxRange,InlineEditor.CSSShadowEditor.maxRange);if(newAmount===offsetY.amount)
return;this._model.setOffsetY(new InlineEditor.CSSLength(newAmount,offsetY.unit||InlineEditor.CSSShadowEditor.defaultUnit));this._yInput.value=this._model.offsetY().asCSSText();this._yInput.classList.remove('invalid');}
this._updateCanvas(true);this.dispatchEventToListeners(InlineEditor.CSSShadowEditor.Events.ShadowChanged,this._model);}
_constrainPoint(point,max){if(Math.abs(point.x)<=max&&Math.abs(point.y)<=max)
return new UI.Geometry.Point(point.x,point.y);return point.scale(max/Math.max(Math.abs(point.x),Math.abs(point.y)));}
_snapToClosestDirection(point){let minDistance=Number.MAX_VALUE;let closestPoint=point;const directions=[new UI.Geometry.Point(0,-1),new UI.Geometry.Point(1,-1),new UI.Geometry.Point(1,0),new UI.Geometry.Point(1,1)];for(const direction of directions){const projection=point.projectOn(direction);const distance=point.distanceTo(projection);if(distance<minDistance){minDistance=distance;closestPoint=projection;}}
return closestPoint;}
_sliderThumbPosition(){const x=(this._model.offsetX().amount/InlineEditor.CSSShadowEditor.maxRange)*this._innerCanvasSize;const y=(this._model.offsetY().amount/InlineEditor.CSSShadowEditor.maxRange)*this._innerCanvasSize;return this._constrainPoint(new UI.Geometry.Point(x,y),this._innerCanvasSize);}};InlineEditor.CSSShadowEditor.Events={ShadowChanged:Symbol('ShadowChanged')};InlineEditor.CSSShadowEditor.maxRange=20;InlineEditor.CSSShadowEditor.defaultUnit='px';InlineEditor.CSSShadowEditor.sliderThumbRadius=6;InlineEditor.CSSShadowEditor.canvasSize=88;;InlineEditor.SwatchPopoverHelper=class extends Common.Object{constructor(){super();this._popover=new UI.GlassPane();this._popover.registerRequiredCSS('inline_editor/swatchPopover.css');this._popover.setSizeBehavior(UI.GlassPane.SizeBehavior.MeasureContent);this._popover.setMarginBehavior(UI.GlassPane.MarginBehavior.Arrow);this._popover.element.addEventListener('mousedown',e=>e.consume(),false);this._hideProxy=this.hide.bind(this,true);this._boundOnKeyDown=this._onKeyDown.bind(this);this._boundFocusOut=this._onFocusOut.bind(this);this._isHidden=true;}
_onFocusOut(event){if(!event.relatedTarget||event.relatedTarget.isSelfOrDescendant(this._view.contentElement))
return;this._hideProxy();}
isShowing(){return this._popover.isShowing();}
show(view,anchorElement,hiddenCallback){if(this._popover.isShowing()){if(this._anchorElement===anchorElement)
return;this.hide(true);}
delete this._isHidden;this._anchorElement=anchorElement;this._view=view;this._hiddenCallback=hiddenCallback;this.reposition();view.focus();const document=this._popover.element.ownerDocument;document.addEventListener('mousedown',this._hideProxy,false);document.defaultView.addEventListener('resize',this._hideProxy,false);this._view.contentElement.addEventListener('keydown',this._boundOnKeyDown,false);}
reposition(){this._view.contentElement.removeEventListener('focusout',this._boundFocusOut,false);this._view.show(this._popover.contentElement);this._popover.setContentAnchorBox(this._anchorElement.boxInWindow());this._popover.show(this._anchorElement.ownerDocument);this._view.contentElement.addEventListener('focusout',this._boundFocusOut,false);if(!this._focusRestorer)
this._focusRestorer=new UI.WidgetFocusRestorer(this._view);}
hide(commitEdit){if(this._isHidden)
return;const document=this._popover.element.ownerDocument;this._isHidden=true;this._popover.hide();document.removeEventListener('mousedown',this._hideProxy,false);document.defaultView.removeEventListener('resize',this._hideProxy,false);if(this._hiddenCallback)
this._hiddenCallback.call(null,!!commitEdit);this._focusRestorer.restore();delete this._anchorElement;if(this._view){this._view.detach();this._view.contentElement.removeEventListener('keydown',this._boundOnKeyDown,false);this._view.contentElement.removeEventListener('focusout',this._boundFocusOut,false);delete this._view;}}
_onKeyDown(event){if(event.key==='Enter'){this.hide(true);event.consume(true);return;}
if(event.key==='Escape'){this.hide(false);event.consume(true);}}};;InlineEditor.CSSShadowModel=class{constructor(isBoxShadow){this._isBoxShadow=isBoxShadow;this._inset=false;this._offsetX=InlineEditor.CSSLength.zero();this._offsetY=InlineEditor.CSSLength.zero();this._blurRadius=InlineEditor.CSSLength.zero();this._spreadRadius=InlineEditor.CSSLength.zero();this._color=(Common.Color.parse('black'));this._format=[InlineEditor.CSSShadowModel._Part.OffsetX,InlineEditor.CSSShadowModel._Part.OffsetY];}
static parseTextShadow(text){return InlineEditor.CSSShadowModel._parseShadow(text,false);}
static parseBoxShadow(text){return InlineEditor.CSSShadowModel._parseShadow(text,true);}
static _parseShadow(text,isBoxShadow){const shadowTexts=[];const splits=TextUtils.TextUtils.splitStringByRegexes(text,[Common.Color.Regex,/,/g]);let currentIndex=0;for(let i=0;i<splits.length;i++){if(splits[i].regexIndex===1){const comma=splits[i];shadowTexts.push(text.substring(currentIndex,comma.position));currentIndex=comma.position+1;}}
shadowTexts.push(text.substring(currentIndex,text.length));const shadows=[];for(let i=0;i<shadowTexts.length;i++){const shadow=new InlineEditor.CSSShadowModel(isBoxShadow);shadow._format=[];let nextPartAllowed=true;const regexes=[/inset/gi,Common.Color.Regex,InlineEditor.CSSLength.Regex];const results=TextUtils.TextUtils.splitStringByRegexes(shadowTexts[i],regexes);for(let j=0;j<results.length;j++){const result=results[j];if(result.regexIndex===-1){if(/\S/.test(result.value))
return[];nextPartAllowed=true;}else{if(!nextPartAllowed)
return[];nextPartAllowed=false;if(result.regexIndex===0){shadow._inset=true;shadow._format.push(InlineEditor.CSSShadowModel._Part.Inset);}else if(result.regexIndex===1){const color=Common.Color.parse(result.value);if(!color)
return[];shadow._color=color;shadow._format.push(InlineEditor.CSSShadowModel._Part.Color);}else if(result.regexIndex===2){const length=InlineEditor.CSSLength.parse(result.value);if(!length)
return[];const previousPart=shadow._format.length>0?shadow._format[shadow._format.length-1]:'';if(previousPart===InlineEditor.CSSShadowModel._Part.OffsetX){shadow._offsetY=length;shadow._format.push(InlineEditor.CSSShadowModel._Part.OffsetY);}else if(previousPart===InlineEditor.CSSShadowModel._Part.OffsetY){shadow._blurRadius=length;shadow._format.push(InlineEditor.CSSShadowModel._Part.BlurRadius);}else if(previousPart===InlineEditor.CSSShadowModel._Part.BlurRadius){shadow._spreadRadius=length;shadow._format.push(InlineEditor.CSSShadowModel._Part.SpreadRadius);}else{shadow._offsetX=length;shadow._format.push(InlineEditor.CSSShadowModel._Part.OffsetX);}}}}
if(invalidCount(shadow,InlineEditor.CSSShadowModel._Part.OffsetX,1,1)||invalidCount(shadow,InlineEditor.CSSShadowModel._Part.OffsetY,1,1)||invalidCount(shadow,InlineEditor.CSSShadowModel._Part.Color,0,1)||invalidCount(shadow,InlineEditor.CSSShadowModel._Part.BlurRadius,0,1)||invalidCount(shadow,InlineEditor.CSSShadowModel._Part.Inset,0,isBoxShadow?1:0)||invalidCount(shadow,InlineEditor.CSSShadowModel._Part.SpreadRadius,0,isBoxShadow?1:0))
return[];shadows.push(shadow);}
return shadows;function invalidCount(shadow,part,min,max){let count=0;for(let i=0;i<shadow._format.length;i++){if(shadow._format[i]===part)
count++;}
return count<min||count>max;}}
setInset(inset){this._inset=inset;if(this._format.indexOf(InlineEditor.CSSShadowModel._Part.Inset)===-1)
this._format.unshift(InlineEditor.CSSShadowModel._Part.Inset);}
setOffsetX(offsetX){this._offsetX=offsetX;}
setOffsetY(offsetY){this._offsetY=offsetY;}
setBlurRadius(blurRadius){this._blurRadius=blurRadius;if(this._format.indexOf(InlineEditor.CSSShadowModel._Part.BlurRadius)===-1){const yIndex=this._format.indexOf(InlineEditor.CSSShadowModel._Part.OffsetY);this._format.splice(yIndex+1,0,InlineEditor.CSSShadowModel._Part.BlurRadius);}}
setSpreadRadius(spreadRadius){this._spreadRadius=spreadRadius;if(this._format.indexOf(InlineEditor.CSSShadowModel._Part.SpreadRadius)===-1){this.setBlurRadius(this._blurRadius);const blurIndex=this._format.indexOf(InlineEditor.CSSShadowModel._Part.BlurRadius);this._format.splice(blurIndex+1,0,InlineEditor.CSSShadowModel._Part.SpreadRadius);}}
setColor(color){this._color=color;if(this._format.indexOf(InlineEditor.CSSShadowModel._Part.Color)===-1)
this._format.push(InlineEditor.CSSShadowModel._Part.Color);}
isBoxShadow(){return this._isBoxShadow;}
inset(){return this._inset;}
offsetX(){return this._offsetX;}
offsetY(){return this._offsetY;}
blurRadius(){return this._blurRadius;}
spreadRadius(){return this._spreadRadius;}
color(){return this._color;}
asCSSText(){const parts=[];for(let i=0;i<this._format.length;i++){const part=this._format[i];if(part===InlineEditor.CSSShadowModel._Part.Inset&&this._inset)
parts.push('inset');else if(part===InlineEditor.CSSShadowModel._Part.OffsetX)
parts.push(this._offsetX.asCSSText());else if(part===InlineEditor.CSSShadowModel._Part.OffsetY)
parts.push(this._offsetY.asCSSText());else if(part===InlineEditor.CSSShadowModel._Part.BlurRadius)
parts.push(this._blurRadius.asCSSText());else if(part===InlineEditor.CSSShadowModel._Part.SpreadRadius)
parts.push(this._spreadRadius.asCSSText());else if(part===InlineEditor.CSSShadowModel._Part.Color)
parts.push(this._color.asString(this._color.format()));}
return parts.join(' ');}};InlineEditor.CSSShadowModel._Part={Inset:'I',OffsetX:'X',OffsetY:'Y',BlurRadius:'B',SpreadRadius:'S',Color:'C'};InlineEditor.CSSLength=class{constructor(amount,unit){this.amount=amount;this.unit=unit;}
static parse(text){const lengthRegex=new RegExp('^(?:'+InlineEditor.CSSLength.Regex.source+')$','i');const match=text.match(lengthRegex);if(!match)
return null;if(match.length>2&&match[2])
return new InlineEditor.CSSLength(parseFloat(match[1]),match[2]);return InlineEditor.CSSLength.zero();}
static zero(){return new InlineEditor.CSSLength(0,'');}
asCSSText(){return this.amount+this.unit;}};InlineEditor.CSSLength.Regex=(function(){const number='([+-]?(?:[0-9]*[.])?[0-9]+(?:[eE][+-]?[0-9]+)?)';const unit='(ch|cm|em|ex|in|mm|pc|pt|px|rem|vh|vmax|vmin|vw)';const zero='[+-]?(?:0*[.])?0+(?:[eE][+-]?[0-9]+)?';return new RegExp(number+unit+'|'+zero,'gi');})();;Runtime.cachedResources["inline_editor/bezierEditor.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n:host {\n    width: 270px;\n    height: 350px;\n    -webkit-user-select: none;\n    padding: 16px;\n    overflow: hidden;\n}\n\n.bezier-preset-selected > svg {\n    background-color: var(--selection-bg-color);\n}\n\n.bezier-preset {\n    width: 50px;\n    height: 50px;\n    padding: 5px;\n    margin: auto;\n    background-color: #f5f5f5;\n    border-radius: 3px;\n}\n\n.bezier-preset line.bezier-control-line {\n    stroke: #666;\n    stroke-width: 1;\n    stroke-linecap: round;\n    fill: none;\n}\n\n.bezier-preset circle.bezier-control-circle {\n    fill: #666;\n}\n\n.bezier-preset path.bezier-path {\n    stroke: black;\n    stroke-width: 2;\n    stroke-linecap: round;\n    fill: none;\n}\n\n.bezier-preset-selected path.bezier-path, .bezier-preset-selected line.bezier-control-line {\n    stroke: white;\n}\n\n.bezier-preset-selected circle.bezier-control-circle {\n    fill: white;\n}\n\n.bezier-curve line.linear-line {\n    stroke: rgb(238, 238, 238);\n    stroke-width: 2;\n    stroke-linecap: round;\n    fill: none;\n}\n\n:host-context(.-theme-with-dark-background) .bezier-curve line.linear-line {\n    stroke: rgb(138, 138, 138);\n}\n\n.bezier-curve line.bezier-control-line {\n    stroke: #9C27B0;\n    stroke-width: 2;\n    stroke-linecap: round;\n    fill: none;\n    opacity: 0.6;\n}\n\n.bezier-curve circle.bezier-control-circle {\n    fill: #9C27B0;\n    cursor: pointer;\n}\n\n.bezier-curve path.bezier-path {\n    stroke: black;\n    stroke-width: 3;\n    stroke-linecap: round;\n    fill: none;\n}\n\n.bezier-preview-container {\n    position: relative;\n    background-color: white;\n    overflow: hidden;\n    border-radius: 20px;\n    width: 200%;\n    height: 20px;\n    z-index: 2;\n    flex-shrink: 0;\n    opacity: 0;\n}\n\n.bezier-preview-animation {\n    background-color: #9C27B0;\n    width: 20px;\n    height: 20px;\n    border-radius: 20px;\n    position: absolute;\n}\n\n.bezier-preview-onion {\n    margin-top: -20px;\n    position: relative;\n    z-index: 1;\n}\n\n.bezier-preview-onion > .bezier-preview-animation {\n    opacity: 0.1;\n}\n\nsvg.bezier-preset-modify {\n    background-color: #f5f5f5;\n    border-radius: 35px;\n    display: inline-block;\n    visibility: hidden;\n    transition: transform 100ms cubic-bezier(0.4, 0, 0.2, 1);\n    cursor: pointer;\n    position: absolute;\n}\n\nsvg.bezier-preset-modify:hover, .bezier-preset:hover {\n    background-color: #999;\n}\n\n.bezier-preset-selected .bezier-preset:hover {\n    background-color: var(--selection-bg-color);\n}\n\n.bezier-preset-modify path {\n    stroke-width: 2;\n    stroke: black;\n    fill: none;\n}\n\n.bezier-preset-selected .bezier-preset-modify {\n    opacity: 1;\n}\n\n.bezier-preset-category {\n    width: 50px;\n    margin: 20px 0;\n    cursor: pointer;\n    transition: transform 100ms cubic-bezier(0.4, 0, 0.2, 1);\n}\n\nspan.bezier-display-value {\n    width: 100%;\n    -webkit-user-select: text;\n    display: block;\n    text-align: center;\n    line-height: 20px;\n    height: 20px;\n    cursor: text;\n    white-space: nowrap !important;\n}\n\n.bezier-container {\n    display: flex;\n    margin-top: 38px;\n}\n\nsvg.bezier-curve {\n    margin-left: 32px;\n    margin-top: -8px;\n}\n\nsvg.bezier-preset-modify.bezier-preset-plus {\n    right: 0;\n}\n\n.bezier-header {\n    margin-top: 16px;\n}\n\nsvg.bezier-preset-modify:active {\n    transform: scale(1.1);\n    background-color: var(--selection-bg-color);\n}\n\n.bezier-preset-category:active {\n    transform: scale(1.05);\n}\n\n.bezier-header-active > svg.bezier-preset-modify {\n    visibility: visible;\n}\n\n.bezier-preset-modify:active path {\n    stroke: white;\n}\n\n/*# sourceURL=inline_editor/bezierEditor.css */";Runtime.cachedResources["inline_editor/colorSwatch.css"]="/*\n * Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n:host {\n    white-space: nowrap;\n}\n\n.color-swatch {\n    position: relative;\n    margin-left: 1px;\n    margin-right: 2px;\n    width: 10px;\n    height: 10px;\n    top: 1px;\n    display: inline-block;\n    -webkit-user-select: none;\n    background-image: url(Images/checker.png);\n    line-height: 10px;\n}\n\n.color-swatch-inner {\n    width: 100%;\n    height: 100%;\n    display: inline-block;\n    border: 1px solid rgba(128, 128, 128, 0.6);\n    cursor: default;\n}\n\n.color-swatch-inner:hover {\n    border: 1px solid rgba(64, 64, 64, 0.8);\n}\n\n/*# sourceURL=inline_editor/colorSwatch.css */";Runtime.cachedResources["inline_editor/bezierSwatch.css"]="/*\n * Copyright 2016 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n:host {\n    white-space: nowrap;\n}\n\n.bezier-swatch-icon {\n    position: relative;\n    margin-left: 1px;\n    margin-right: 2px;\n    top: 1px;\n    -webkit-user-select: none;\n    line-height: 10px;\n    background-color: #9C27B0;\n    cursor: default;\n}\n\n.bezier-swatch-icon:hover {\n    background-color: #800080;\n}\n\n/*# sourceURL=inline_editor/bezierSwatch.css */";Runtime.cachedResources["inline_editor/cssShadowSwatch.css"]="/*\n * Copyright 2016 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n:host {\n    white-space: nowrap;\n}\n\n.shadow-swatch-icon {\n    position: relative;\n    margin-left: 1px;\n    margin-right: 2px;\n    top: 1px;\n    -webkit-user-select: none;\n    line-height: 10px;\n    background-color: #9C27B0;\n}\n\n.shadow-swatch-icon:hover {\n    background-color: #800080;\n}\n\n/*# sourceURL=inline_editor/cssShadowSwatch.css */";Runtime.cachedResources["inline_editor/cssShadowEditor.css"]="/*\n * Copyright 2016 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n:host {\n    -webkit-user-select: none;\n    padding: 4px 12px 12px 12px;\n}\n\n.shadow-editor-field:last-of-type {\n    margin-bottom: 8px;\n}\n\n.shadow-editor-field {\n    height: 24px;\n    margin-top: 8px;\n    font-size: 12px;\n    flex-shrink: 0;\n}\n\n.shadow-editor-flex-field {\n    display: flex;\n    align-items: center;\n    flex-direction: row;\n}\n\n.shadow-editor-field.shadow-editor-blur-field {\n    margin-top: 40px;\n}\n\n.shadow-editor-2D-slider {\n    position: absolute;\n    height: 88px;\n    width: 88px;\n    border: 1px solid rgba(0, 0, 0, 0.14);\n    border-radius: 2px;\n}\n\n.shadow-editor-label {\n    display: inline-block;\n    width: 52px;\n    height: 24px;\n    line-height: 24px;\n    margin-right: 8px;\n    text-align: right;\n}\n\n.shadow-editor-button-left, .shadow-editor-button-right {\n    width: 74px;\n    height: 24px;\n    padding: 3px 7px;\n    line-height: 16px;\n    border: 1px solid rgba(0, 0, 0, 0.14);\n    background-color: #ffffff;\n    text-align: center;\n    font-weight: 500;\n}\n\n.shadow-editor-button-left {\n    border-radius: 2px 0 0 2px;\n}\n\n.shadow-editor-button-right {\n    border-radius: 0 2px 2px 0;\n    border-left-width: 0;\n}\n\n.shadow-editor-button-left:hover, .shadow-editor-button-right:hover {\n    box-shadow: 0 1px 1px rgba(0, 0, 0, 0.1);\n}\n\n.shadow-editor-button-left:focus, .shadow-editor-button-right:focus {\n    background-color: #eeeeee;\n}\n\n.shadow-editor-button-left.enabled, .shadow-editor-button-right.enabled, -theme-preserve {\n    background-color: #4285F4;\n    color: #ffffff;\n}\n\n.shadow-editor-button-left.enabled:focus, .shadow-editor-button-right.enabled:focus, -theme-preserve  {\n    background-color: #3B78E7;\n}\n\n.shadow-editor-text-input {\n    width: 52px;\n    margin-right: 8px;\n    text-align: right;\n    box-shadow: var(--focus-ring-inactive-shadow);\n}\n\n/*# sourceURL=inline_editor/cssShadowEditor.css */";Runtime.cachedResources["inline_editor/swatchPopover.css"]="/*\n * Copyright 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.widget {\n    display: flex;\n    background: white;\n    box-shadow: var(--drop-shadow);\n    border-radius: 2px;\n    overflow: auto;\n    -webkit-user-select: text;\n    line-height: 11px;\n}\n\n/*# sourceURL=inline_editor/swatchPopover.css */";