/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.geo.Polygon;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.geo.GeoShapeType;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.builders.CoordinatesBuilder;
import org.elasticsearch.common.geo.builders.LineStringBuilder;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.geo.parsers.ShapeParser;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class PolygonBuilder
extends ShapeBuilder<JtsGeometry, PolygonBuilder> {
    public static final GeoShapeType TYPE = GeoShapeType.POLYGON;
    private static final Coordinate[][] EMPTY = new Coordinate[0][];
    private ShapeBuilder.Orientation orientation = ShapeBuilder.Orientation.RIGHT;
    private LineStringBuilder shell;
    private final List<LineStringBuilder> holes = new ArrayList<LineStringBuilder>();

    public PolygonBuilder(LineStringBuilder lineString, ShapeBuilder.Orientation orientation, boolean coerce) {
        this.orientation = orientation;
        if (coerce) {
            lineString.close();
        }
        PolygonBuilder.validateLinearRing(lineString);
        this.shell = lineString;
    }

    public PolygonBuilder(LineStringBuilder lineString, ShapeBuilder.Orientation orientation) {
        this(lineString, orientation, false);
    }

    public PolygonBuilder(CoordinatesBuilder coordinates, ShapeBuilder.Orientation orientation) {
        this(new LineStringBuilder(coordinates), orientation, false);
    }

    public PolygonBuilder(CoordinatesBuilder coordinates) {
        this(coordinates, ShapeBuilder.Orientation.RIGHT);
    }

    public PolygonBuilder(StreamInput in) throws IOException {
        this.shell = new LineStringBuilder(in);
        this.orientation = ShapeBuilder.Orientation.readFrom(in);
        int holes = in.readVInt();
        for (int i = 0; i < holes; ++i) {
            this.hole(new LineStringBuilder(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shell.writeTo(out);
        this.orientation.writeTo(out);
        out.writeVInt(this.holes.size());
        for (LineStringBuilder hole : this.holes) {
            hole.writeTo(out);
        }
    }

    public ShapeBuilder.Orientation orientation() {
        return this.orientation;
    }

    public PolygonBuilder hole(LineStringBuilder hole) {
        return this.hole(hole, false);
    }

    public PolygonBuilder hole(LineStringBuilder hole, boolean coerce) {
        if (coerce) {
            hole.close();
        }
        PolygonBuilder.validateLinearRing(hole);
        this.holes.add(hole);
        return this;
    }

    public List<LineStringBuilder> holes() {
        return this.holes;
    }

    public LineStringBuilder shell() {
        return this.shell;
    }

    public PolygonBuilder close() {
        this.shell.close();
        return this;
    }

    private static void validateLinearRing(LineStringBuilder lineString) {
        List points = lineString.coordinates;
        if (points.size() < 4) {
            throw new IllegalArgumentException("invalid number of points in LinearRing (found [" + points.size() + "] - must be >= 4)");
        }
        if (!((Coordinate)points.get(0)).equals(points.get(points.size() - 1))) {
            throw new IllegalArgumentException("invalid LinearRing found (coordinates are not closed)");
        }
    }

    protected void validateHole(LineStringBuilder shell, LineStringBuilder hole) {
        HashSet exterior = Sets.newHashSet(shell.coordinates);
        HashSet interior = Sets.newHashSet(hole.coordinates);
        exterior.retainAll(interior);
        if (exterior.size() >= 2) {
            throw new InvalidShapeException("Invalid polygon, interior cannot share more than one point with the exterior");
        }
    }

    public Coordinate[][][] coordinates() {
        int numEdges = this.shell.coordinates.size() - 1;
        for (int i = 0; i < this.holes.size(); ++i) {
            numEdges += this.holes.get((int)i).coordinates.size() - 1;
            this.validateHole(this.shell, this.holes.get(i));
        }
        ShapeBuilder.Edge[] edges = new ShapeBuilder.Edge[numEdges];
        ShapeBuilder.Edge[] holeComponents = new ShapeBuilder.Edge[this.holes.size()];
        AtomicBoolean translated = new AtomicBoolean(false);
        int offset = PolygonBuilder.createEdges(0, this.orientation, this.shell, null, edges, 0, translated);
        for (int i = 0; i < this.holes.size(); ++i) {
            int length = PolygonBuilder.createEdges(i + 1, this.orientation, this.shell, this.holes.get(i), edges, offset, translated);
            holeComponents[i] = edges[offset];
            offset += length;
        }
        int numHoles = holeComponents.length;
        numHoles = PolygonBuilder.merge(edges, 0, PolygonBuilder.intersections(180.0, edges), holeComponents, numHoles);
        numHoles = PolygonBuilder.merge(edges, 0, PolygonBuilder.intersections(-180.0, edges), holeComponents, numHoles);
        return PolygonBuilder.compose(edges, holeComponents, numHoles);
    }

    @Override
    public JtsGeometry buildS4J() {
        return this.jtsGeometry(this.buildS4JGeometry(FACTORY, this.wrapdateline));
    }

    @Override
    public Object buildLucene() {
        if (this.wrapdateline) {
            Coordinate[][][] polygons = this.coordinates();
            return polygons.length == 1 ? PolygonBuilder.polygonLucene(polygons[0]) : PolygonBuilder.multipolygonLucene(polygons);
        }
        return this.toPolygonLucene();
    }

    protected XContentBuilder coordinatesArray(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.shell.coordinatesToXcontent(builder, true);
        for (LineStringBuilder hole : this.holes) {
            hole.coordinatesToXcontent(builder, true);
        }
        return builder;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ShapeParser.FIELD_TYPE.getPreferredName(), TYPE.shapeName());
        builder.field(ShapeParser.FIELD_ORIENTATION.getPreferredName(), this.orientation.name().toLowerCase(Locale.ROOT));
        builder.startArray(ShapeParser.FIELD_COORDINATES.getPreferredName());
        this.coordinatesArray(builder, params);
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public Geometry buildS4JGeometry(GeometryFactory factory, boolean fixDateline) {
        if (fixDateline) {
            Coordinate[][][] polygons = this.coordinates();
            return polygons.length == 1 ? PolygonBuilder.polygonS4J(factory, polygons[0]) : PolygonBuilder.multipolygonS4J(factory, polygons);
        }
        return this.toPolygonS4J(factory);
    }

    public org.locationtech.jts.geom.Polygon toPolygonS4J() {
        return this.toPolygonS4J(FACTORY);
    }

    protected org.locationtech.jts.geom.Polygon toPolygonS4J(GeometryFactory factory) {
        LinearRing shell = PolygonBuilder.linearRingS4J(factory, this.shell.coordinates);
        LinearRing[] holes = new LinearRing[this.holes.size()];
        Iterator<LineStringBuilder> iterator = this.holes.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            holes[i] = PolygonBuilder.linearRingS4J(factory, iterator.next().coordinates);
            ++i;
        }
        return factory.createPolygon(shell, holes);
    }

    public Object toPolygonLucene() {
        Polygon[] holes = new Polygon[this.holes.size()];
        for (int i2 = 0; i2 < holes.length; ++i2) {
            holes[i2] = PolygonBuilder.linearRing(this.holes.get((int)i2).coordinates);
        }
        return new Polygon(this.shell.coordinates.stream().mapToDouble(i -> GeoUtils.normalizeLat(i.y)).toArray(), this.shell.coordinates.stream().mapToDouble(i -> GeoUtils.normalizeLon(i.x)).toArray(), holes);
    }

    protected static Polygon linearRing(List<Coordinate> coordinates) {
        return new Polygon(coordinates.stream().mapToDouble(i -> GeoUtils.normalizeLat(i.y)).toArray(), coordinates.stream().mapToDouble(i -> GeoUtils.normalizeLon(i.x)).toArray(), new Polygon[0]);
    }

    protected static LinearRing linearRingS4J(GeometryFactory factory, List<Coordinate> coordinates) {
        return factory.createLinearRing(coordinates.toArray(new Coordinate[coordinates.size()]));
    }

    @Override
    public GeoShapeType type() {
        return TYPE;
    }

    @Override
    public int numDimensions() {
        if (this.shell == null) {
            throw new IllegalStateException("unable to get number of dimensions, Polygon has not yet been initialized");
        }
        return this.shell.numDimensions();
    }

    protected static org.locationtech.jts.geom.Polygon polygonS4J(GeometryFactory factory, Coordinate[][] polygon) {
        LinearRing[] holes;
        LinearRing shell = factory.createLinearRing(polygon[0]);
        if (polygon.length > 1) {
            holes = new LinearRing[polygon.length - 1];
            for (int i = 0; i < holes.length; ++i) {
                holes[i] = factory.createLinearRing(polygon[i + 1]);
            }
        } else {
            holes = null;
        }
        return factory.createPolygon(shell, holes);
    }

    protected static Polygon polygonLucene(Coordinate[][] polygon) {
        Polygon[] holes;
        Coordinate[] shell = polygon[0];
        if (polygon.length > 1) {
            holes = new Polygon[polygon.length - 1];
            for (int i = 0; i < holes.length; ++i) {
                Coordinate[] coords = polygon[i + 1];
                double[] x = new double[coords.length];
                double[] y = new double[coords.length];
                for (int c = 0; c < coords.length; ++c) {
                    x[c] = GeoUtils.normalizeLon(coords[c].x);
                    y[c] = GeoUtils.normalizeLat(coords[c].y);
                }
                holes[i] = new Polygon(y, x, new Polygon[0]);
            }
        } else {
            holes = new Polygon[]{};
        }
        double[] x = new double[shell.length];
        double[] y = new double[shell.length];
        for (int i = 0; i < shell.length; ++i) {
            x[i] = Math.abs(shell[i].x) > 180.0 ? GeoUtils.normalizeLon(shell[i].x) : shell[i].x;
            y[i] = GeoUtils.normalizeLat(shell[i].y);
        }
        return new Polygon(y, x, holes);
    }

    protected static MultiPolygon multipolygonS4J(GeometryFactory factory, Coordinate[][][] polygons) {
        org.locationtech.jts.geom.Polygon[] polygonSet = new org.locationtech.jts.geom.Polygon[polygons.length];
        for (int i = 0; i < polygonSet.length; ++i) {
            polygonSet[i] = PolygonBuilder.polygonS4J(factory, polygons[i]);
        }
        return factory.createMultiPolygon(polygonSet);
    }

    protected static Polygon[] multipolygonLucene(Coordinate[][][] polygons) {
        Polygon[] polygonSet = new Polygon[polygons.length];
        for (int i = 0; i < polygonSet.length; ++i) {
            polygonSet[i] = PolygonBuilder.polygonLucene(polygons[i]);
        }
        return polygonSet;
    }

    private static int component(ShapeBuilder.Edge edge, int id, ArrayList<ShapeBuilder.Edge> edges) {
        double shiftOffset;
        ShapeBuilder.Edge any = edge;
        while ((any.coordinate.x == 180.0 || any.coordinate.x == -180.0) && (any = any.next) != edge) {
        }
        double d = any.coordinate.x > 180.0 ? 180.0 : (shiftOffset = any.coordinate.x < -180.0 ? -180.0 : 0.0);
        if (PolygonBuilder.debugEnabled()) {
            LOGGER.debug("shift: [{}]", (Object)shiftOffset);
        }
        int length = 0;
        int connectedComponents = 0;
        int splitIndex = 1;
        ShapeBuilder.Edge current = edge;
        ShapeBuilder.Edge prev = edge;
        HashMap<Coordinate, Tuple> visitedEdge = new HashMap<Coordinate, Tuple>();
        do {
            current.coordinate = PolygonBuilder.shift(current.coordinate, shiftOffset);
            current.component = id;
            if (edges != null) {
                if (visitedEdge.containsKey(current.coordinate)) {
                    if (connectedComponents > 0 && current.next != edge) {
                        throw new InvalidShapeException("Shape contains more than one shared point");
                    }
                    int visitID = -id;
                    ShapeBuilder.Edge firstAppearance = (ShapeBuilder.Edge)((Tuple)visitedEdge.get(current.coordinate)).v2();
                    ShapeBuilder.Edge temp = firstAppearance.next;
                    firstAppearance.next = current.next;
                    current.next = temp;
                    current.component = visitID;
                    do {
                        prev.component = visitID;
                        prev = (ShapeBuilder.Edge)((Tuple)visitedEdge.get(prev.coordinate)).v1();
                        ++splitIndex;
                    } while (!current.coordinate.equals((Object)prev.coordinate));
                    ++connectedComponents;
                } else {
                    visitedEdge.put(current.coordinate, new Tuple((Object)prev, (Object)current));
                }
                edges.add(current);
                prev = current;
            }
            ++length;
        } while (connectedComponents == 0 && (current = current.next) != edge);
        return splitIndex != 1 ? length - splitIndex : length;
    }

    private static Coordinate[] coordinates(ShapeBuilder.Edge component, Coordinate[] coordinates) {
        for (int i = 0; i < coordinates.length; ++i) {
            component = component.next;
            coordinates[i] = component.coordinate;
        }
        return coordinates;
    }

    private static Coordinate[][][] buildCoordinates(List<List<Coordinate[]>> components) {
        int i;
        Coordinate[][][] result = new Coordinate[components.size()][][];
        for (i = 0; i < result.length; ++i) {
            List<Coordinate[]> component = components.get(i);
            result[i] = (Coordinate[][])component.toArray((T[])new Coordinate[component.size()][]);
        }
        if (PolygonBuilder.debugEnabled()) {
            for (i = 0; i < result.length; ++i) {
                LOGGER.debug("Component [{}]:", (Object)i);
                for (int j = 0; j < result[i].length; ++j) {
                    LOGGER.debug("\t{}", (Object)Arrays.toString(result[i][j]));
                }
            }
        }
        return result;
    }

    private static Coordinate[][] holes(ShapeBuilder.Edge[] holes, int numHoles) {
        if (numHoles == 0) {
            return EMPTY;
        }
        Coordinate[][] points = new Coordinate[numHoles][];
        for (int i = 0; i < numHoles; ++i) {
            int length = PolygonBuilder.component(holes[i], -(i + 1), null);
            points[i] = PolygonBuilder.coordinates(holes[i], new Coordinate[length + 1]);
        }
        return points;
    }

    private static ShapeBuilder.Edge[] edges(ShapeBuilder.Edge[] edges, int numHoles, List<List<Coordinate[]>> components) {
        ArrayList<ShapeBuilder.Edge> mainEdges = new ArrayList<ShapeBuilder.Edge>(edges.length);
        for (int i = 0; i < edges.length; ++i) {
            if (edges[i].component < 0) continue;
            int length = PolygonBuilder.component(edges[i], -(components.size() + numHoles + 1), mainEdges);
            ArrayList<Coordinate[]> component = new ArrayList<Coordinate[]>();
            component.add(PolygonBuilder.coordinates(edges[i], new Coordinate[length + 1]));
            components.add(component);
        }
        return mainEdges.toArray(new ShapeBuilder.Edge[mainEdges.size()]);
    }

    private static Coordinate[][][] compose(ShapeBuilder.Edge[] edges, ShapeBuilder.Edge[] holes, int numHoles) {
        ArrayList<List<Coordinate[]>> components = new ArrayList<List<Coordinate[]>>();
        PolygonBuilder.assign(holes, PolygonBuilder.holes(holes, numHoles), numHoles, PolygonBuilder.edges(edges, numHoles, components), components);
        return PolygonBuilder.buildCoordinates(components);
    }

    private static void assign(ShapeBuilder.Edge[] holes, Coordinate[][] points, int numHoles, ShapeBuilder.Edge[] edges, List<List<Coordinate[]>> components) {
        if (PolygonBuilder.debugEnabled()) {
            LOGGER.debug("Holes: {}", (Object)Arrays.toString(holes));
        }
        for (int i = 0; i < numHoles; ++i) {
            ShapeBuilder.Edge current = new ShapeBuilder.Edge(holes[i].coordinate, holes[i].next);
            current.intersect = current.coordinate;
            int intersections = PolygonBuilder.intersections(current.coordinate.x, edges);
            if (intersections == 0) {
                throw new InvalidShapeException("Invalid shape: Hole is not within polygon");
            }
            boolean sharedVertex = false;
            int pos = Arrays.binarySearch(edges, 0, intersections, current, INTERSECTION_ORDER);
            if (pos >= 0 && !(sharedVertex = edges[pos].intersect.compareTo((Object)current.coordinate) == 0)) {
                throw new InvalidShapeException("Invalid shape: Hole is not within polygon");
            }
            int index = sharedVertex ? 0 : (pos == -1 ? 0 : -(pos + 2));
            int component = -edges[index].component - numHoles - 1;
            if (PolygonBuilder.debugEnabled()) {
                LOGGER.debug("\tposition ({}) of edge {}: {}", (Object)index, (Object)current, (Object)edges[index]);
                LOGGER.debug("\tComponent: {}", (Object)component);
                LOGGER.debug("\tHole intersections ({}): {}", (Object)current.coordinate.x, (Object)Arrays.toString(edges));
            }
            components.get(component).add(points[i]);
        }
    }

    private static int merge(ShapeBuilder.Edge[] intersections, int offset, int length, ShapeBuilder.Edge[] holes, int numHoles) {
        for (int i = 0; i < length; i += 2) {
            ShapeBuilder.Edge e1 = intersections[offset + i + 0];
            ShapeBuilder.Edge e2 = intersections[offset + i + 1];
            if (e2.component > 0) {
                holes[e2.component - 1] = holes[--numHoles];
                holes[numHoles] = null;
            }
            if (e1.intersect == ShapeBuilder.Edge.MAX_COORDINATE || e2.intersect == ShapeBuilder.Edge.MAX_COORDINATE || e1.next.next.coordinate.equals3D(e2.coordinate) && Math.abs(e1.next.coordinate.x) == 180.0 && Math.abs(e2.coordinate.x) == 180.0) continue;
            PolygonBuilder.connect(e1, e2);
        }
        return numHoles;
    }

    private static void connect(ShapeBuilder.Edge in, ShapeBuilder.Edge out) {
        assert (in != null && out != null);
        assert (in != out);
        if (in.intersect != in.next.coordinate) {
            ShapeBuilder.Edge e1 = new ShapeBuilder.Edge(in.intersect, in.next);
            if (out.intersect != out.next.coordinate) {
                ShapeBuilder.Edge e2 = new ShapeBuilder.Edge(out.intersect, out.next);
                in.next = new ShapeBuilder.Edge(in.intersect, e2, in.intersect);
            } else {
                in.next = new ShapeBuilder.Edge(in.intersect, out.next, in.intersect);
            }
            out.next = new ShapeBuilder.Edge(out.intersect, e1, out.intersect);
        } else if (in.next != out && in.coordinate != out.intersect) {
            ShapeBuilder.Edge e2 = new ShapeBuilder.Edge(out.intersect, in.next, out.intersect);
            if (out.intersect != out.next.coordinate) {
                ShapeBuilder.Edge e1 = new ShapeBuilder.Edge(out.intersect, out.next);
                in.next = new ShapeBuilder.Edge(in.intersect, e1, in.intersect);
            } else {
                in.next = new ShapeBuilder.Edge(in.intersect, out.next, in.intersect);
            }
            out.next = e2;
        }
    }

    private static int createEdges(int component, ShapeBuilder.Orientation orientation, LineStringBuilder shell, LineStringBuilder hole, ShapeBuilder.Edge[] edges, int offset, AtomicBoolean translated) {
        boolean direction = component == 0 ^ orientation == ShapeBuilder.Orientation.RIGHT;
        Coordinate[] points = hole != null ? hole.coordinates(false) : shell.coordinates(false);
        PolygonBuilder.ring(component, direction, orientation == ShapeBuilder.Orientation.LEFT, points, 0, edges, offset, points.length - 1, translated);
        return points.length - 1;
    }

    private static ShapeBuilder.Edge[] ring(int component, boolean direction, boolean handedness, Coordinate[] points, int offset, ShapeBuilder.Edge[] edges, int toffset, int length, AtomicBoolean translated) {
        boolean incorrectOrientation;
        boolean orientation = PolygonBuilder.getOrientation(points, offset, length);
        double[] range = PolygonBuilder.range(points, offset, length);
        double rng = range[1] - range[0];
        boolean bl = incorrectOrientation = component == 0 && handedness != orientation;
        if (incorrectOrientation && rng > 180.0 && rng != 360.0 || translated.get() && component != 0) {
            PolygonBuilder.translate(points);
            if (component == 0) {
                translated.set(true);
            }
            if (component == 0 || component != 0 && handedness == orientation) {
                orientation = !orientation;
            }
        }
        return PolygonBuilder.concat(component, direction ^ orientation, points, offset, edges, toffset, length);
    }

    private static boolean getOrientation(Coordinate[] points, int offset, int length) {
        int top = PolygonBuilder.top(points, offset, length);
        int prev = (top + length - 1) % length;
        int next = (top + 1) % length;
        int determinantSign = org.apache.lucene.geo.GeoUtils.orient((double)points[offset + prev].x, (double)points[offset + prev].y, (double)points[offset + top].x, (double)points[offset + top].y, (double)points[offset + next].x, (double)points[offset + next].y);
        if (determinantSign == 0) {
            throw new InvalidShapeException("Cannot determine orientation: edges adjacent to (" + points[offset + top].x + "," + points[offset + top].y + ") coincide");
        }
        return determinantSign < 0;
    }

    private static int top(Coordinate[] points, int offset, int length) {
        int top = 0;
        for (int i = 1; i < length; ++i) {
            if (points[offset + i].y < points[offset + top].y) {
                top = i;
                continue;
            }
            if (points[offset + i].y != points[offset + top].y || !(points[offset + i].x < points[offset + top].x)) continue;
            top = i;
        }
        return top;
    }

    private static double[] range(Coordinate[] points, int offset, int length) {
        double minX = points[0].x;
        double maxX = points[0].x;
        double minY = points[0].y;
        double maxY = points[0].y;
        for (int i = 1; i < length; ++i) {
            if (points[offset + i].x < minX) {
                minX = points[offset + i].x;
            }
            if (points[offset + i].x > maxX) {
                maxX = points[offset + i].x;
            }
            if (points[offset + i].y < minY) {
                minY = points[offset + i].y;
            }
            if (!(points[offset + i].y > maxY)) continue;
            maxY = points[offset + i].y;
        }
        return new double[]{minX, maxX, minY, maxY};
    }

    private static ShapeBuilder.Edge[] concat(int component, boolean direction, Coordinate[] points, int pointOffset, ShapeBuilder.Edge[] edges, int edgeOffset, int length) {
        assert (edges.length >= length + edgeOffset);
        assert (points.length >= length + pointOffset);
        edges[edgeOffset] = new ShapeBuilder.Edge(points[pointOffset], null);
        for (int i = 1; i < length; ++i) {
            if (direction) {
                edges[edgeOffset + i] = new ShapeBuilder.Edge(points[pointOffset + i], edges[edgeOffset + i - 1]);
                edges[edgeOffset + i].component = component;
                continue;
            }
            if (!edges[edgeOffset + i - 1].coordinate.equals((Object)points[pointOffset + i])) {
                ShapeBuilder.Edge edge = new ShapeBuilder.Edge(points[pointOffset + i], null);
                edges[edgeOffset + i] = edge;
                edges[edgeOffset + i - 1].next = edge;
                edges[edgeOffset + i - 1].component = component;
                continue;
            }
            throw new InvalidShapeException("Provided shape has duplicate consecutive coordinates at: " + points[pointOffset + i]);
        }
        if (direction) {
            edges[edgeOffset].setNext(edges[edgeOffset + length - 1]);
            edges[edgeOffset].component = component;
        } else {
            edges[edgeOffset + length - 1].setNext(edges[edgeOffset]);
            edges[edgeOffset + length - 1].component = component;
        }
        return edges;
    }

    private static void translate(Coordinate[] points) {
        for (Coordinate c : points) {
            if (!(c.x < 0.0)) continue;
            c.x += 360.0;
        }
    }

    @Override
    protected StringBuilder contentToWKT() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append((CharSequence)ShapeBuilder.coordinateListToWKT(this.shell.coordinates));
        for (LineStringBuilder hole : this.holes) {
            sb.append(", ");
            sb.append((CharSequence)ShapeBuilder.coordinateListToWKT(hole.coordinates));
        }
        sb.append(')');
        return sb;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.shell, this.holes, this.orientation});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PolygonBuilder other = (PolygonBuilder)obj;
        return Objects.equals(this.shell, other.shell) && Objects.equals(this.holes, other.holes) && Objects.equals((Object)this.orientation, (Object)other.orientation);
    }
}

