/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.jasmin;

import com.googlecode.d2j.jasmin.JasminDumper;
import com.googlecode.d2j.jasmin.JasminLexer;
import com.googlecode.d2j.jasmin.JasminParser;
import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.ClassNode;

@BaseCmd.Syntax(cmd="d2j-jasmin2jar", syntax="[options] <jar>", desc="Assemble .j files to .class file", onlineHelp="https://code.google.com/p/dex2jar/wiki/Jasmin")
public class Jasmin2JarCmd
extends BaseCmd
implements Opcodes {
    private static int[] versions;
    @BaseCmd.Opt(opt="g", longOpt="autogenerate-linenumbers", hasArg=false, description="autogenerate-linenumbers")
    boolean autogenLines = false;
    @BaseCmd.Opt(opt="f", longOpt="force", hasArg=false, description="force overwrite")
    private boolean forceOverwrite = false;
    @BaseCmd.Opt(opt="o", longOpt="output", description="output .jar file, default is $current_dir/[jar-name]-jasmin2jar.jar", argName="out-jar-file")
    private Path output;
    @BaseCmd.Opt(opt="e", longOpt="encoding", description="encoding for .j files, default is UTF-8", argName="enc")
    private String encoding = "UTF-8";
    @BaseCmd.Opt(opt="d", longOpt="dump", description="dump to stdout", hasArg=false)
    private boolean dump;
    @BaseCmd.Opt(opt="cv", longOpt="class-version", description="default .class version, [1~9], default 6 for JAVA6")
    private int classVersion = 6;

    static {
        int[] nArray = new int[10];
        nArray[1] = 196653;
        nArray[2] = 46;
        nArray[3] = 47;
        nArray[4] = 48;
        nArray[5] = 49;
        nArray[6] = 50;
        nArray[7] = 51;
        nArray[8] = 52;
        nArray[9] = 53;
        versions = nArray;
    }

    public static void main(String ... args) throws ClassNotFoundException, SecurityException {
        new Jasmin2JarCmd().doMain(args);
    }

    protected void doCommandLine() throws Exception {
        if (this.remainingArgs.length != 1) {
            this.usage();
            return;
        }
        if (this.classVersion < 1 || this.classVersion > 9) {
            throw new BaseCmd.HelpException("-cv,--class-version out of range, 1-9 is supported.");
        }
        Path jar = new File(this.remainingArgs[0]).toPath().toAbsolutePath();
        if (!Files.exists(jar, new LinkOption[0])) {
            System.err.println(jar + " is not exists");
            this.usage();
            return;
        }
        if (this.output == null) {
            this.output = new File(String.valueOf(Jasmin2JarCmd.getBaseName((Path)jar)) + "-jar2jasmin/").toPath();
        }
        if (Files.exists(this.output, new LinkOption[0]) && !this.forceOverwrite) {
            System.err.println(this.output + " exists, use --force to overwrite");
            this.usage();
            return;
        }
        System.out.println("assemble " + jar + " -> " + this.output);
        if (!this.output.toString().endsWith(".jar") && !this.output.toString().endsWith(".zip")) {
            this.assemble0(jar, this.output);
        } else {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileSystem fs = Jasmin2JarCmd.createZip((Path)this.output);){
                this.assemble0(jar, fs.getPath("/", new String[0]));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void assemble0(Path in, Path output) throws IOException, URISyntaxException {
        if (Files.isDirectory(in, new LinkOption[0])) {
            this.travelFileTree(in, output);
        } else if (in.toString().endsWith(".j")) {
            this.assemble1(in, output);
        } else {
            Throwable throwable = null;
            Object var4_5 = null;
            try (FileSystem fs = Jasmin2JarCmd.openZip((Path)in);){
                this.travelFileTree(fs.getPath("/", new String[0]), output);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void travelFileTree(Path in, final Path output) throws IOException {
        Files.walkFileTree(in, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.getFileName().toString().endsWith(".j")) {
                    Jasmin2JarCmd.this.assemble1(file, output);
                }
                return super.visitFile(file, attrs);
            }
        });
    }

    private void assemble1(Path file, Path output) throws IOException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader bufferedReader = Files.newBufferedReader(file, Charset.forName(this.encoding));){
                ANTLRReaderStream is = new ANTLRReaderStream((Reader)bufferedReader);
                is.name = file.toString();
                JasminLexer lexer = new JasminLexer((CharStream)is);
                CommonTokenStream ts = new CommonTokenStream((TokenSource)lexer);
                JasminParser parser = new JasminParser((TokenStream)ts);
                parser.rebuildLine = this.autogenLines;
                ClassWriter cw = new ClassWriter(2);
                ClassNode cn = parser.parse();
                if (cn.version == 0) {
                    cn.version = versions[this.classVersion];
                }
                if (this.dump) {
                    new JasminDumper(new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8), true)).dump(cn);
                }
                cn.accept((ClassVisitor)cw);
                Path clzFile = output.resolve(String.valueOf(cn.name.replace('.', '/')) + ".class");
                Jasmin2JarCmd.createParentDirectories((Path)clzFile);
                Files.write(clzFile, cw.toByteArray(), new OpenOption[0]);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (RecognitionException e) {
            System.err.println("Fail to assemble " + file);
            e.printStackTrace();
        }
    }
}

