/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.enterprise;

import ca.sqlpower.dao.PersistedSPOProperty;
import ca.sqlpower.dao.PersistedSPObject;
import ca.sqlpower.dao.RemovedObjectEntry;
import ca.sqlpower.dao.SPPersistenceException;
import ca.sqlpower.dao.SPPersister;
import ca.sqlpower.dao.SPPersisterListener;
import ca.sqlpower.dao.json.SPJSONMessageDecoder;
import ca.sqlpower.dao.session.SessionPersisterSuperConverter;
import ca.sqlpower.enterprise.JSONMessage;
import ca.sqlpower.enterprise.JSONResponseHandler;
import ca.sqlpower.enterprise.client.ProjectLocation;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.util.RunnableDispatcher;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.UserPrompter;
import ca.sqlpower.util.UserPrompterFactory;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.security.AccessDeniedException;

public abstract class AbstractNetworkConflictResolver
extends Thread {
    protected static final int MAX_CONFLICTS_TO_DISPLAY = 10;
    protected static final int AVG_WAIT_TIME_FOR_PERSIST = 12;
    private static final Logger logger = Logger.getLogger(AbstractNetworkConflictResolver.class);
    protected AtomicBoolean postingJSON = new AtomicBoolean(false);
    protected boolean updating = false;
    protected SPPersisterListener listener;
    protected SessionPersisterSuperConverter converter;
    protected UserPrompterFactory upf;
    protected int currentRevision = 0;
    protected long serverTimestamp = 0L;
    protected long retryDelay = 1000L;
    protected double currentWaitPerPersist = 12.0;
    protected final SPJSONMessageDecoder jsonDecoder;
    protected final ProjectLocation projectLocation;
    protected final HttpClient outboundHttpClient;
    protected final HttpClient inboundHttpClient;
    protected String contextRelativePath;
    protected volatile boolean cancelled;
    protected JSONArray messageBuffer = new JSONArray();
    protected HashMap<String, PersistedSPObject> inboundObjectsToAdd = new HashMap();
    protected Multimap<String, PersistedSPOProperty> inboundPropertiesToChange = LinkedListMultimap.create();
    protected HashMap<String, RemovedObjectEntry> inboundObjectsToRemove = new HashMap();
    protected Map<String, PersistedSPObject> outboundObjectsToAdd = new LinkedHashMap<String, PersistedSPObject>();
    protected Multimap<String, PersistedSPOProperty> outboundPropertiesToChange = LinkedListMultimap.create();
    protected Map<String, RemovedObjectEntry> outboundObjectsToRemove = new LinkedHashMap<String, RemovedObjectEntry>();
    protected List<UpdateListener> updateListeners = new ArrayList<UpdateListener>();
    private final RunnableDispatcher runnable;

    public AbstractNetworkConflictResolver(ProjectLocation projectLocation, SPJSONMessageDecoder jsonDecoder, HttpClient inboundHttpClient, HttpClient outboundHttpClient, RunnableDispatcher runnable) {
        super("updater-" + projectLocation.getUUID());
        this.jsonDecoder = jsonDecoder;
        this.projectLocation = projectLocation;
        this.inboundHttpClient = inboundHttpClient;
        this.outboundHttpClient = outboundHttpClient;
        this.runnable = runnable;
        this.contextRelativePath = "/rest/project/" + projectLocation.getUUID();
    }

    public int getRevision() {
        return this.currentRevision;
    }

    public long getServerTimestamp() {
        return this.serverTimestamp;
    }

    public void addListener(UpdateListener listener) {
        this.updateListeners.add(listener);
    }

    protected String getPersistedObjectName(PersistedSPObject o) {
        for (PersistedSPOProperty p : this.outboundPropertiesToChange.get((Object)o.getUUID())) {
            if (!p.getPropertyName().equals("name")) continue;
            return (String)p.getNewValue();
        }
        throw new IllegalArgumentException("Persisted Object with UUID " + o.getUUID() + " and type " + o.getType() + " has no name property");
    }

    public void clear() {
        this.clear(false);
    }

    protected void clear(boolean reflush) {
        this.messageBuffer = new JSONArray();
        if (reflush) {
            this.inboundObjectsToAdd.clear();
            this.inboundPropertiesToChange.clear();
            this.inboundObjectsToRemove.clear();
            this.outboundObjectsToAdd.clear();
            this.outboundPropertiesToChange.clear();
            this.outboundObjectsToRemove.clear();
        }
    }

    public void send(JSONObject content) throws SPPersistenceException {
        this.messageBuffer.put(content);
    }

    public void setUserPrompterFactory(UserPrompterFactory promptSession) {
        this.upf = promptSession;
    }

    public UserPrompterFactory getUserPrompterFactory() {
        return this.upf;
    }

    public void setListener(SPPersisterListener listener) {
        this.listener = listener;
    }

    public void setConverter(SessionPersisterSuperConverter converter) {
        this.converter = converter;
    }

    public List<UpdateListener> getListeners() {
        return this.updateListeners;
    }

    public void flush() {
        this.flush(false);
    }

    protected void decodeMessage(JSONTokener tokener, int newRevision, long timestamp) {
        try {
            if (this.currentRevision < newRevision) {
                ArrayList<UpdateListener> updateListenersCopy = new ArrayList<UpdateListener>(this.updateListeners);
                for (UpdateListener listener : this.updateListeners) {
                    listener.preUpdatePerformed(this);
                }
                this.jsonDecoder.decode(tokener);
                this.currentRevision = newRevision;
                this.serverTimestamp = timestamp;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Setting currentRevision to: " + this.currentRevision + " and serverTimestamp to: " + this.serverTimestamp));
                }
                for (UpdateListener listener : updateListenersCopy) {
                    if (!listener.updatePerformed(this)) continue;
                    this.updateListeners.remove(listener);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to decode the message from the server.", e);
        }
    }

    protected void fillOutboundPersistedLists() {
        for (PersistedSPObject obj : this.listener.getPersistedObjects()) {
            this.outboundObjectsToAdd.put(obj.getUUID(), obj);
        }
        for (PersistedSPOProperty prop : this.listener.getPersistedProperties()) {
            this.outboundPropertiesToChange.put((Object)prop.getUUID(), (Object)prop);
        }
        for (RemovedObjectEntry rem : this.listener.getObjectsToRemove().values()) {
            this.outboundObjectsToRemove.put(rem.getRemovedChild().getUUID(), rem);
        }
    }

    @Override
    public void interrupt() {
        super.interrupt();
        this.cancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.isInterrupted() && !this.cancelled) {
                try {
                    while (this.updating) {
                        AbstractNetworkConflictResolver abstractNetworkConflictResolver = this;
                        synchronized (abstractNetworkConflictResolver) {
                            this.wait();
                        }
                    }
                    this.updating = true;
                    JSONMessage message = this.getJsonArray(this.inboundHttpClient);
                    if (message.getStatusCode() == 410) {
                        for (UpdateListener listener : this.updateListeners) {
                            listener.workspaceDeleted();
                        }
                        this.updateListeners.clear();
                        this.interrupt();
                    } else {
                        if (message.getStatusCode() == 412) {
                            this.upf.createUserPrompter(message.getBody(), UserPrompterFactory.UserPromptType.MESSAGE, UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, null, "OK").promptUser(new Object[0]);
                            continue;
                        }
                        if (message.getStatusCode() == 403) {
                            this.updateListeners.clear();
                            this.interrupt();
                            if (this.projectLocation.getUUID().equals("system")) {
                                this.upf.createUserPrompter("Server at " + this.projectLocation.getServiceInfo().getServerAddress() + "has failed since your session began." + " Please restart the program to synchronize the system workspace with the server.", UserPrompterFactory.UserPromptType.MESSAGE, UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, null, "OK").promptUser(new Object[0]);
                            } else {
                                this.upf.createUserPrompter("Server at " + this.projectLocation.getServiceInfo().getServerAddress() + " has failed since your session began." + " Please use the refresh button to synchronize workspace " + this.projectLocation.getName() + " with the server.", UserPrompterFactory.UserPromptType.MESSAGE, UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, null, "OK").promptUser(new Object[0]);
                            }
                        }
                    }
                    if (!this.isInterrupted() && !this.cancelled) {
                        JSONObject json = new JSONObject(message.getBody());
                        final JSONTokener tokener = new JSONTokener(json.getString("data"));
                        final int jsonRevision = json.getInt("currentRevision");
                        final long jsonTimestamp = json.getLong("serverTimestamp");
                        this.runnable.runInForeground(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                block20: {
                                    try {
                                        if (!AbstractNetworkConflictResolver.this.postingJSON.get()) {
                                            AbstractNetworkConflictResolver.this.decodeMessage(tokener, jsonRevision, jsonTimestamp);
                                        }
                                    }
                                    catch (AccessDeniedException e) {
                                        AbstractNetworkConflictResolver.this.interrupt();
                                        ArrayList<UpdateListener> listenersToRemove = new ArrayList<UpdateListener>();
                                        for (UpdateListener listener : AbstractNetworkConflictResolver.this.updateListeners) {
                                            if (!listener.updateException(AbstractNetworkConflictResolver.this, e)) continue;
                                            listenersToRemove.add(listener);
                                        }
                                        AbstractNetworkConflictResolver.this.updateListeners.removeAll(listenersToRemove);
                                        if (AbstractNetworkConflictResolver.this.upf != null) {
                                            AbstractNetworkConflictResolver.this.upf.createUserPrompter("You do not have sufficient privileges to perform that action. Please hit the refresh button to synchronize with the server.", UserPrompterFactory.UserPromptType.MESSAGE, UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, "OK", "OK").promptUser("");
                                            break block20;
                                        }
                                        throw e;
                                    }
                                    catch (Exception e) {
                                        AbstractNetworkConflictResolver.this.interrupt();
                                        ArrayList<UpdateListener> listenersToRemove = new ArrayList<UpdateListener>();
                                        for (UpdateListener listener : AbstractNetworkConflictResolver.this.updateListeners) {
                                            if (!listener.updateException(AbstractNetworkConflictResolver.this, e)) continue;
                                            listenersToRemove.add(listener);
                                        }
                                        AbstractNetworkConflictResolver.this.updateListeners.removeAll(listenersToRemove);
                                        throw new RuntimeException("Update from server failed! Unable to decode the message: ", e);
                                    }
                                    finally {
                                        AbstractNetworkConflictResolver e = AbstractNetworkConflictResolver.this;
                                        synchronized (e) {
                                            AbstractNetworkConflictResolver.this.updating = false;
                                            AbstractNetworkConflictResolver.this.notify();
                                        }
                                    }
                                }
                            }
                        });
                    }
                    break;
                }
                catch (Exception ex) {
                    for (Throwable root = ex; root != null; root = root.getCause()) {
                        if (!(root instanceof SPPersistenceException)) continue;
                        this.getUserPrompterFactory().createUserPrompter("An exception occurred while updating from the server. See logs for more details.", UserPrompterFactory.UserPromptType.MESSAGE, UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, true, "OK").promptUser(new Object[0]);
                        break;
                    }
                    logger.error((Object)("Failed to contact server. Will retry in " + this.retryDelay + " ms."), (Throwable)ex);
                    Thread.sleep(this.retryDelay);
                }
            }
        }
        catch (InterruptedException ex) {
            logger.info((Object)"Updater thread exiting normally due to interruption.");
        }
        this.inboundHttpClient.getConnectionManager().shutdown();
    }

    protected JSONMessage getJsonArray(HttpClient client) {
        try {
            URI uri = new URI("http", null, this.projectLocation.getServiceInfo().getServerAddress(), this.projectLocation.getServiceInfo().getPort(), this.projectLocation.getServiceInfo().getPath() + this.contextRelativePath, "oldRevisionNo=" + this.currentRevision + "&serverTimestamp=" + this.serverTimestamp, null);
            logger.debug((Object)("GETting URI: " + uri.toString()));
            HttpGet request = new HttpGet(uri);
            return (JSONMessage)client.execute((HttpUriRequest)request, (ResponseHandler)new JSONResponseHandler());
        }
        catch (AccessDeniedException ade) {
            throw new AccessDeniedException("Access Denied");
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to get json from server", ex);
        }
    }

    protected JSONMessage postJsonArray(String jsonArray) {
        try {
            URI serverURI = new URI("http", null, this.projectLocation.getServiceInfo().getServerAddress(), this.projectLocation.getServiceInfo().getPort(), this.projectLocation.getServiceInfo().getPath() + "/" + "rest" + "/project/" + this.projectLocation.getUUID(), "currentRevision=" + this.currentRevision + "&serverTimestamp=" + this.serverTimestamp, null);
            logger.debug((Object)("POSTing URI: " + serverURI.toString()));
            HttpPost postRequest = new HttpPost(serverURI);
            postRequest.setEntity((HttpEntity)new StringEntity(jsonArray));
            postRequest.setHeader("Content-Type", "application/json");
            HttpPost request = postRequest;
            return (JSONMessage)this.outboundHttpClient.execute((HttpUriRequest)request, (ResponseHandler)new JSONResponseHandler());
        }
        catch (AccessDeniedException ade) {
            throw ade;
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to post json to server", ex);
        }
    }

    protected void fillInboundPersistedLists(String json) {
        try {
            JSONArray array = new JSONArray(json);
            for (int i = 0; i < array.length(); ++i) {
                String parentUUID;
                JSONObject obj = array.getJSONObject(i);
                if (obj.getString("method").equals("persistObject")) {
                    parentUUID = obj.getString("parentUUID");
                    String type = obj.getString("type");
                    String uuid = obj.getString("uuid");
                    int index = obj.getInt("index");
                    this.inboundObjectsToAdd.put(uuid, new PersistedSPObject(parentUUID, type, uuid, index));
                    continue;
                }
                if (obj.getString("method").equals("persistProperty")) {
                    String uuid = obj.getString("uuid");
                    String propertyName = obj.getString("propertyName");
                    SPPersister.DataType type = SPPersister.DataType.valueOf(obj.getString("type"));
                    Object oldValue = null;
                    try {
                        oldValue = SPJSONMessageDecoder.getWithType(obj, type, "oldValue");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    Object newValue = SPJSONMessageDecoder.getWithType(obj, type, "newValue");
                    boolean unconditional = false;
                    PersistedSPOProperty property = new PersistedSPOProperty(uuid, propertyName, type, oldValue, newValue, unconditional);
                    if (this.inboundPropertiesToChange.keySet().contains(uuid)) {
                        ((Collection)this.inboundPropertiesToChange.asMap().get(uuid)).add(property);
                        continue;
                    }
                    this.inboundPropertiesToChange.put((Object)uuid, (Object)property);
                    continue;
                }
                if (!obj.getString("method").equals("removeObject")) continue;
                parentUUID = obj.getString("parentUUID");
                String uuid = obj.getString("uuid");
                SPObject objectToRemove = SQLPowerUtils.findByUuid(this.getWorkspace(), uuid, SPObject.class);
                this.inboundObjectsToRemove.put(uuid, new RemovedObjectEntry(parentUUID, objectToRemove, objectToRemove.getParent().getChildren().indexOf(objectToRemove)));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to create persisted lists: ", ex);
        }
    }

    protected List<ConflictMessage> checkForSimultaneousEdit() {
        LinkedList<ConflictMessage> conflicts = new LinkedList<ConflictMessage>();
        HashSet<String> inboundAddedObjectParents = new HashSet<String>();
        HashSet<String> inboundRemovedObjectParents = new HashSet<String>();
        HashSet<String> inboundChangedObjects = new HashSet<String>();
        HashMap<String, String> inboundCreatedDependencies = new HashMap<String, String>();
        HashSet<String> duplicateMoves = new HashSet<String>();
        for (String string : this.inboundPropertiesToChange.keys()) {
            inboundChangedObjects.add(string);
            for (PersistedSPOProperty p : this.inboundPropertiesToChange.get((Object)string)) {
                if (p.getDataType() != SPPersister.DataType.REFERENCE) continue;
                inboundCreatedDependencies.put((String)p.getNewValue(), p.getUUID());
            }
        }
        for (PersistedSPObject persistedSPObject : this.inboundObjectsToAdd.values()) {
            inboundAddedObjectParents.add(persistedSPObject.getParentUUID());
        }
        for (RemovedObjectEntry removedObjectEntry : this.inboundObjectsToRemove.values()) {
            inboundRemovedObjectParents.add(removedObjectEntry.getParentUUID());
        }
        HashSet<String> checkedIfCanAddToTree = new HashSet<String>();
        Iterator<PersistedSPObject> iterator = this.outboundObjectsToAdd.values().iterator();
        while (iterator.hasNext()) {
            PersistedSPObject o = iterator.next();
            if (inboundAddedObjectParents.contains(o.getParentUUID()) || inboundRemovedObjectParents.contains(o.getParentUUID())) {
                conflicts.add(new ConflictMessage(ConflictCase.SIMULTANEOUS_ADDITION, o.getUUID(), this.getPersistedObjectName(o)));
            }
            if (inboundChangedObjects.contains(o.getParentUUID())) {
                conflicts.add(new ConflictMessage(ConflictCase.ADDITION_UNDER_CHANGE, o.getUUID(), this.getPersistedObjectName(o), o.getParentUUID(), SQLPowerUtils.findByUuid(this.getWorkspace(), o.getParentUUID(), SPObject.class).getName()));
            }
            PersistedSPObject highestAddition = o;
            while (this.outboundObjectsToAdd.containsKey(highestAddition.getParentUUID()) && !checkedIfCanAddToTree.contains(highestAddition.getParentUUID())) {
                checkedIfCanAddToTree.add(highestAddition.getUUID());
                highestAddition = this.outboundObjectsToAdd.get(highestAddition.getParentUUID());
            }
            checkedIfCanAddToTree.add(highestAddition.getUUID());
            if (checkedIfCanAddToTree.add(highestAddition.getParentUUID()) && SQLPowerUtils.findByUuid(this.getWorkspace(), highestAddition.getParentUUID(), SPObject.class) == null) {
                conflicts.add(new ConflictMessage(ConflictCase.ADDITION_UNDER_REMOVAL, highestAddition.getUUID(), this.getPersistedObjectName(highestAddition)));
            }
            if (!this.inboundObjectsToAdd.containsKey(o.getUUID())) continue;
            if (this.inboundObjectsToAdd.get(o.getUUID()).equals(o)) {
                iterator.remove();
                this.outboundPropertiesToChange.removeAll((Object)o.getUUID());
                duplicateMoves.add(o.getUUID());
                continue;
            }
            conflicts.add(new ConflictMessage(ConflictCase.DIFFERENT_MOVE, o.getUUID(), this.getPersistedObjectName(o)));
        }
        Iterator<RemovedObjectEntry> removedObjects = this.outboundObjectsToRemove.values().iterator();
        while (removedObjects.hasNext()) {
            RemovedObjectEntry object = removedObjects.next();
            String uuid = object.getRemovedChild().getUUID();
            SPObject removedObject = SQLPowerUtils.findByUuid(this.getWorkspace(), uuid, SPObject.class);
            if (removedObject == null) {
                if (this.outboundObjectsToAdd.containsKey(uuid)) {
                    conflicts.add(new ConflictMessage(ConflictCase.MOVE_OF_REMOVED, object.getRemovedChild().getUUID(), object.getRemovedChild().getName()));
                    continue;
                }
                removedObjects.remove();
                continue;
            }
            if (inboundCreatedDependencies.containsKey(uuid)) {
                String uuidOfDependent = (String)inboundCreatedDependencies.get(uuid);
                conflicts.add(new ConflictMessage(ConflictCase.REMOVAL_OF_DEPENDENCY, uuid, removedObject.getName(), uuidOfDependent, SQLPowerUtils.findByUuid(this.getWorkspace(), uuid, SPObject.class).getName()));
                continue;
            }
            if (!duplicateMoves.contains(uuid)) continue;
            removedObjects.remove();
        }
        for (String uuid : this.outboundPropertiesToChange.keys()) {
            SPObject changedObject = SQLPowerUtils.findByUuid(this.getWorkspace(), uuid, SPObject.class);
            if (this.outboundObjectsToAdd.containsKey(uuid)) continue;
            if (changedObject == null) {
                conflicts.add(new ConflictMessage(ConflictCase.CHANGE_OF_REMOVED, uuid, uuid));
                continue;
            }
            if (changedObject.getParent() != null && inboundChangedObjects.contains(changedObject.getParent().getUUID())) {
                conflicts.add(new ConflictMessage(ConflictCase.CHANGE_UNDER_CHANGE, uuid, changedObject.getName(), changedObject.getParent().getUUID(), changedObject.getParent().getName()));
            }
            if (inboundChangedObjects.contains(uuid)) {
                ConflictMessage message = new ConflictMessage(ConflictCase.SIMULTANEOUS_OBJECT_CHANGE, uuid, SQLPowerUtils.findByUuid(this.getWorkspace(), uuid, SPObject.class).getName());
                HashMap<String, Object> inboundPropertiesMap = new HashMap<String, Object>();
                for (PersistedSPOProperty p : this.inboundPropertiesToChange.get((Object)uuid)) {
                    inboundPropertiesMap.put(p.getPropertyName(), p.getNewValue());
                }
                Iterator properties = this.outboundPropertiesToChange.get((Object)uuid).iterator();
                while (properties.hasNext()) {
                    PersistedSPOProperty p;
                    p = (PersistedSPOProperty)properties.next();
                    if (inboundPropertiesMap.containsKey(p.getPropertyName())) {
                        if (inboundPropertiesMap.get(p.getPropertyName()).equals(p.getNewValue())) {
                            properties.remove();
                            continue;
                        }
                        conflicts.add(message);
                        break;
                    }
                    conflicts.add(message);
                    break;
                }
            }
            ArrayList<SPObject> children = new ArrayList<SPObject>();
            if (changedObject instanceof SQLObject) {
                children.addAll(((SQLObject)changedObject).getChildrenWithoutPopulating());
            } else {
                children.addAll(changedObject.getChildren());
            }
            for (SPObject child : children) {
                if (inboundChangedObjects.contains(child.getUUID())) {
                    conflicts.add(new ConflictMessage(ConflictCase.CHANGE_UNDER_CHANGE, uuid, changedObject.getName(), child.getUUID(), child.getName()));
                }
                if (!this.inboundObjectsToAdd.containsKey(child.getUUID()) || this.inboundObjectsToRemove.containsKey(child.getUUID())) continue;
                conflicts.add(new ConflictMessage(ConflictCase.CHANGE_AFTER_ADDITION, uuid, changedObject.getName(), child.getUUID(), child.getName()));
            }
        }
        return conflicts;
    }

    protected abstract void flush(boolean var1);

    protected abstract List<ConflictMessage> detectConflicts();

    protected abstract SPObject getWorkspace();

    public SPPersisterListener getPersisterListener() {
        return this.listener;
    }

    public static interface UpdateListener {
        public boolean updatePerformed(AbstractNetworkConflictResolver var1);

        public boolean updateException(AbstractNetworkConflictResolver var1, Throwable var2);

        public void workspaceDeleted();

        public void preUpdatePerformed(AbstractNetworkConflictResolver var1);
    }

    protected static enum ConflictCase {
        NO_CONFLICT("There were no conflicts"),
        ADDITION_UNDER_REMOVAL("The %s you tried adding could not be added because its ancestor was removed"),
        MOVE_OF_REMOVED("Could not move %s because it was removed"),
        CHANGE_OF_REMOVED("Could not change %s because it was removed"),
        SIMULTANEOUS_ADDITION("Could not add %s because a sibling was added/removed"),
        ADDITION_UNDER_CHANGE("Could not add %s because its parent %s was modified"),
        CHANGE_AFTER_ADDITION("Could not change %s because child %s was added"),
        CHANGE_UNDER_CHANGE("Could not change %s because its parent/child %s was modified"),
        REMOVAL_OF_DEPENDENCY("Could not remove %s because another object %s is now dependent on it"),
        SIMULTANEOUS_OBJECT_CHANGE("Could not change %s because it was changed by another user"),
        DIFFERENT_MOVE("Could not move %s because it was moved somewhere else"),
        SPECIAL_CASE("");

        private final String message;

        private ConflictCase(String s) {
            this.message = s;
        }

        public int numArgs() {
            return this.message.length() - this.message.replace("%s", "1").length();
        }
    }

    protected class ConflictMessage {
        private final ConflictCase conflict;
        private final String message;
        private final List<String> objectIds = new LinkedList<String>();
        private final List<String> objectNames = new LinkedList<String>();

        public ConflictMessage(ConflictCase conflict, String ... uuidsAndNames) {
            this.conflict = conflict;
            for (int i = 0; i < uuidsAndNames.length; i += 2) {
                this.objectIds.add(uuidsAndNames[i]);
                this.objectNames.add(uuidsAndNames[i + 1]);
            }
            if (this.objectIds.size() != conflict.numArgs()) {
                throw new IllegalArgumentException("Number of arguments passed in does not match number requested by conflict type");
            }
            try {
                this.message = String.format(conflict.message, this.objectNames.toArray());
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public ConflictMessage(String message, ConflictCase conflict, String ... uuids) {
            this.message = message;
            this.conflict = conflict;
            this.objectIds.addAll(Arrays.asList(uuids));
        }

        public String getObjectId(int index) {
            return this.objectIds.get(index);
        }

        public ConflictCase getConflictCase() {
            return this.conflict;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return this.message;
        }
    }
}

