/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job;

import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.Messages;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobHopMeta
implements Cloneable,
XMLInterface {
    public JobEntryCopy from_entry;
    public JobEntryCopy to_entry;
    private boolean enabled;
    private boolean split;
    private boolean evaluation;
    private boolean unconditional;
    private boolean changed;
    private long id;

    public JobHopMeta() {
        this((JobEntryCopy)null, (JobEntryCopy)null);
    }

    public JobHopMeta(JobEntryCopy from, JobEntryCopy to) {
        this.from_entry = from;
        this.to_entry = to;
        this.enabled = true;
        this.split = false;
        this.evaluation = true;
        this.unconditional = false;
        this.id = -1L;
        if (from.isStart()) {
            this.setUnconditional();
        }
    }

    public JobHopMeta(Node hopnode, JobMeta job) throws KettleXMLException {
        try {
            String from_name = XMLHandler.getTagValue((Node)hopnode, (String)"from");
            String to_name = XMLHandler.getTagValue((Node)hopnode, (String)"to");
            String sfrom_nr = XMLHandler.getTagValue((Node)hopnode, (String)"from_nr");
            String sto_nr = XMLHandler.getTagValue((Node)hopnode, (String)"to_nr");
            String senabled = XMLHandler.getTagValue((Node)hopnode, (String)"enabled");
            String sevaluation = XMLHandler.getTagValue((Node)hopnode, (String)"evaluation");
            String sunconditional = XMLHandler.getTagValue((Node)hopnode, (String)"unconditional");
            int from_nr = Const.toInt((String)sfrom_nr, (int)0);
            int to_nr = Const.toInt((String)sto_nr, (int)0);
            this.from_entry = job.findJobEntry(from_name, from_nr, true);
            this.to_entry = job.findJobEntry(to_name, to_nr, true);
            this.enabled = senabled == null ? true : "Y".equalsIgnoreCase(senabled);
            this.evaluation = sevaluation == null ? true : "Y".equalsIgnoreCase(sevaluation);
            this.unconditional = "Y".equalsIgnoreCase(sunconditional);
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("JobHopMeta.Exception.UnableToLoadHopInfoXML"), (Throwable)e);
        }
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        if (null != this.from_entry && null != this.to_entry) {
            retval.append("    <hop>").append(Const.CR);
            retval.append("      ").append(XMLHandler.addTagValue((String)"from", (String)this.from_entry.getName()));
            retval.append("      ").append(XMLHandler.addTagValue((String)"to", (String)this.to_entry.getName()));
            retval.append("      ").append(XMLHandler.addTagValue((String)"from_nr", (int)this.from_entry.getNr()));
            retval.append("      ").append(XMLHandler.addTagValue((String)"to_nr", (int)this.to_entry.getNr()));
            retval.append("      ").append(XMLHandler.addTagValue((String)"enabled", (boolean)this.enabled));
            retval.append("      ").append(XMLHandler.addTagValue((String)"evaluation", (boolean)this.evaluation));
            retval.append("      ").append(XMLHandler.addTagValue((String)"unconditional", (boolean)this.unconditional));
            retval.append("    </hop>").append(Const.CR);
        }
        return retval.toString();
    }

    public JobHopMeta(Repository rep, long id_job_hop, JobMeta job, List<JobEntryCopy> jobcopies) throws KettleException {
        try {
            RowMetaAndData r = rep.getJobHop(id_job_hop);
            if (r != null) {
                long id_jobentry_copy_from = r.getInteger("ID_JOBENTRY_COPY_FROM", -1L);
                long id_jobentry_copy_to = r.getInteger("ID_JOBENTRY_COPY_TO", -1L);
                this.enabled = r.getBoolean("ENABLED", true);
                this.evaluation = r.getBoolean("EVALUATION", true);
                this.unconditional = r.getBoolean("UNCONDITIONAL", !this.evaluation);
                this.from_entry = JobMeta.findJobEntryCopy(jobcopies, id_jobentry_copy_from);
                this.to_entry = JobMeta.findJobEntryCopy(jobcopies, id_jobentry_copy_to);
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobHopMeta.Exception.UnableToLoadHopInfoRep", "" + id_job_hop), (Throwable)dbe);
        }
    }

    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            long id_jobentry_from = -1L;
            long id_jobentry_to = -1L;
            id_jobentry_from = this.from_entry == null ? -1L : this.from_entry.getID();
            id_jobentry_to = this.to_entry == null ? -1L : this.to_entry.getID();
            this.setID(rep.insertJobHop(id_job, id_jobentry_from, id_jobentry_to, this.enabled, this.evaluation, this.unconditional));
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobHopMeta.Exception.UnableToSaveHopInfoRep", "" + id_job), (Throwable)dbe);
        }
    }

    public void setID(long id) {
        this.id = id;
    }

    public long getID() {
        return this.id;
    }

    public Object clone() {
        try {
            Object retval = super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setChanged() {
        this.setChanged(true);
    }

    public void setChanged(boolean ch) {
        this.changed = ch;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setEnabled() {
        this.setEnabled(true);
    }

    public void setEnabled(boolean en) {
        this.enabled = en;
        this.setChanged();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean getEvaluation() {
        return this.evaluation;
    }

    public void setEvaluation() {
        this.setEvaluation(true);
    }

    public void setEvaluation(boolean e) {
        this.evaluation = e;
    }

    public void setUnconditional() {
        if (!this.unconditional) {
            this.setChanged();
        }
        this.unconditional = true;
    }

    public void setConditional() {
        if (this.unconditional) {
            this.setChanged();
        }
        this.unconditional = false;
    }

    public boolean isUnconditional() {
        return this.unconditional;
    }

    public void setSplit(boolean split) {
        if (this.split != split) {
            this.setChanged();
        }
        this.split = split;
    }

    public boolean isSplit() {
        return this.split;
    }

    public String getDescription() {
        if (this.isUnconditional()) {
            return Messages.getString("JobHopMeta.Msg.ExecNextJobEntryUncondition");
        }
        if (this.getEvaluation()) {
            return Messages.getString("JobHopMeta.Msg.ExecNextJobEntryFlawLess");
        }
        return Messages.getString("JobHopMeta.Msg.ExecNextJobEntryFailed");
    }

    public String toString() {
        return this.getDescription();
    }
}

