/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.config;

import java.beans.Introspector;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.SetNextRule;
import org.apache.commons.digester.SetPropertiesRule;
import org.pentaho.di.core.annotations.Inject;
import org.pentaho.di.core.config.ConfigManager;
import org.pentaho.di.core.exception.KettleConfigException;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KettleConfig {
    private static final String KETTLE_CONFIG = "kettle-config/config";
    private static final String KETTLE_CONFIG_PROPERTY = "kettle-config/config/property";
    private static final String KETTLE_CONFIG_CLASS = "kettle-config/config/config-class";
    private static KettleConfig config;
    private Map<String, ConfigManager<?>> configs = new HashMap();

    private KettleConfig() {
        Digester digester = this.createDigester();
        try {
            digester.parse(Thread.currentThread().getContextClassLoader().getResource(this.getClass().getPackage().getName().replace('.', '/') + "/kettle-config.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KettleConfig getInstance() {
        if (config != null) return config;
        Class<KettleConfig> clazz = KettleConfig.class;
        synchronized (KettleConfig.class) {
            config = new KettleConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return config;
        }
    }

    public ConfigManager<?> getManager(String name) {
        return this.configs.get(name);
    }

    public Collection<ConfigManager<?>> getManagers() {
        return this.configs.values();
    }

    private Digester createDigester() {
        Digester digester = new Digester();
        digester.addObjectCreate(KETTLE_CONFIG, TempConfig.class);
        digester.addBeanPropertySetter(KETTLE_CONFIG_CLASS, "clazz");
        digester.addSetProperties(KETTLE_CONFIG, "id", "id");
        digester.addRule(KETTLE_CONFIG_PROPERTY, (Rule)new SetPropertiesRule(){

            public void begin(String name, String namespace, Attributes attrs) throws Exception {
                ((TempConfig)this.digester.peek()).parms.put(attrs.getValue("name"), attrs.getValue("value"));
            }
        });
        digester.addRule(KETTLE_CONFIG, (Rule)new SetNextRule(""){

            public void end(String nameSpace, String name) throws Exception {
                TempConfig cfg = (TempConfig)this.digester.peek();
                Class<ConfigManager> cfclass = Class.forName(cfg.clazz).asSubclass(ConfigManager.class);
                ConfigManager parms = cfclass.newInstance();
                KettleConfig.this.inject(cfclass.getMethods(), cfg, parms);
                KettleConfig.this.inject(cfclass.getDeclaredFields(), cfg, parms);
                KettleConfig.this.configs.put(cfg.id, parms);
            }
        });
        return digester;
    }

    private <E extends AccessibleObject> void inject(E[] elems, TempConfig cfg, ConfigManager<?> parms) throws IllegalAccessException, InvocationTargetException {
        for (E elem : elems) {
            Inject inj = ((AccessibleObject)elem).getAnnotation(Inject.class);
            if (inj == null) continue;
            ((AccessibleObject)elem).setAccessible(true);
            String property = inj.property();
            if (elem instanceof Method) {
                Method meth = (Method)elem;
                property = property.equals("") ? Introspector.decapitalize(meth.getName().substring(3)) : property;
                meth.invoke(parms, cfg.parms.get(property));
                continue;
            }
            if (!(elem instanceof Field)) continue;
            Field field = (Field)elem;
            field.set(parms, cfg.parms.get(property.equals("") ? field.getName() : property));
        }
    }

    public void addConfig(String name, ConfigManager<?> mgr) throws KettleConfigException {
        ConfigManager<?> cmgr = this.configs.get(name);
        if (cmgr != null) {
            throw new KettleConfigException(name + " is already registered as a manager");
        }
        this.configs.put(name, mgr);
    }

    public static class TempConfig {
        private String clazz;
        private String id;
        private Map<String, String> parms = new HashMap<String, String>();

        public String getClazz() {
            return this.clazz;
        }

        public void setClazz(String clazz) {
            this.clazz = clazz;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }
}

