/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.spring31.properties;

import java.io.IOException;
import java.util.Properties;
import org.jasypt.commons.CommonUtils;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.properties.PropertyValueEncryptionUtils;
import org.jasypt.util.text.TextEncryptor;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

public final class EncryptablePropertySourcesPlaceholderConfigurer
extends PropertySourcesPlaceholderConfigurer {
    private final StringEncryptor stringEncryptor;
    private final TextEncryptor textEncryptor;
    private boolean alreadyConverted = false;

    public EncryptablePropertySourcesPlaceholderConfigurer(StringEncryptor stringEncryptor) {
        CommonUtils.validateNotNull((Object)stringEncryptor, (String)"Encryptor cannot be null");
        this.stringEncryptor = stringEncryptor;
        this.textEncryptor = null;
    }

    public EncryptablePropertySourcesPlaceholderConfigurer(TextEncryptor textEncryptor) {
        CommonUtils.validateNotNull((Object)textEncryptor, (String)"Encryptor cannot be null");
        this.stringEncryptor = null;
        this.textEncryptor = textEncryptor;
    }

    protected Properties mergeProperties() throws IOException {
        Properties mergedProperties = super.mergeProperties();
        this.convertProperties(mergedProperties);
        return mergedProperties;
    }

    protected void convertProperties(Properties props) {
        if (!this.alreadyConverted) {
            super.convertProperties(props);
            this.alreadyConverted = true;
        }
    }

    protected String convertPropertyValue(String originalValue) {
        if (!PropertyValueEncryptionUtils.isEncryptedValue((String)originalValue)) {
            return originalValue;
        }
        if (this.stringEncryptor != null) {
            return PropertyValueEncryptionUtils.decrypt((String)originalValue, (StringEncryptor)this.stringEncryptor);
        }
        return PropertyValueEncryptionUtils.decrypt((String)originalValue, (TextEncryptor)this.textEncryptor);
    }
}

