/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.mvn;

import java.net.MalformedURLException;
import org.ops4j.pax.url.maven.commons.MavenRepositoryURL;

public class Parser {
    public static final String VERSION_LATEST = "LATEST";
    private static final String SYNTAX = "mvn:[repository_url!]groupId/artifactId[/[version]/[type]]";
    private static final String REPOSITORY_SEPARATOR = "!";
    private static final String ARTIFACT_SEPARATOR = "/";
    private static final String VERSION_SNAPSHOT = "SNAPSHOT";
    private static final String TYPE_JAR = "jar";
    public static final String FILE_SEPARATOR = "/";
    private static final String GROUP_SEPARATOR = "\\.";
    private static final String VERSION_SEPARATOR = "-";
    private static final String TYPE_SEPARATOR = ".";
    private static final String CLASSIFIER_SEPARATOR = "-";
    private static final String METADATA_FILE = "maven-metadata.xml";
    private static final String METADATA_FILE_LOCAL = "maven-metadata-local.xml";
    private MavenRepositoryURL m_repositoryURL;
    private String m_group;
    private String m_artifact;
    private String m_version;
    private String m_type;
    private String m_classifier;
    private String m_fullClassifier;

    public Parser(String path) throws MalformedURLException {
        if (path == null) {
            throw new MalformedURLException("Path cannot be null. Syntax mvn:[repository_url!]groupId/artifactId[/[version]/[type]]");
        }
        if (path.startsWith(REPOSITORY_SEPARATOR) || path.endsWith(REPOSITORY_SEPARATOR)) {
            throw new MalformedURLException("Path cannot start or end with !. Syntax mvn:[repository_url!]groupId/artifactId[/[version]/[type]]");
        }
        if (path.contains(REPOSITORY_SEPARATOR)) {
            int pos = path.lastIndexOf(REPOSITORY_SEPARATOR);
            this.parseArtifactPart(path.substring(pos + 1));
            this.m_repositoryURL = new MavenRepositoryURL(path.substring(0, pos) + "@snapshots");
        } else {
            this.parseArtifactPart(path);
        }
    }

    private void parseArtifactPart(String part) throws MalformedURLException {
        String[] segments = part.split("/");
        if (segments.length < 2) {
            throw new MalformedURLException("Invalid path. Syntax mvn:[repository_url!]groupId/artifactId[/[version]/[type]]");
        }
        this.m_group = segments[0];
        if (this.m_group.trim().length() == 0) {
            throw new MalformedURLException("Invalid groupId. Syntax mvn:[repository_url!]groupId/artifactId[/[version]/[type]]");
        }
        this.m_artifact = segments[1];
        if (this.m_artifact.trim().length() == 0) {
            throw new MalformedURLException("Invalid artifactId. Syntax mvn:[repository_url!]groupId/artifactId[/[version]/[type]]");
        }
        this.m_version = VERSION_LATEST;
        if (segments.length >= 3 && segments[2].trim().length() > 0) {
            this.m_version = segments[2];
        }
        this.m_type = TYPE_JAR;
        if (segments.length >= 4 && segments[3].trim().length() > 0) {
            this.m_type = segments[3];
        }
        this.m_fullClassifier = "";
        if (segments.length >= 5 && segments[4].trim().length() > 0) {
            this.m_classifier = segments[4];
            this.m_fullClassifier = "-" + this.m_classifier;
        }
    }

    public MavenRepositoryURL getRepositoryURL() {
        return this.m_repositoryURL;
    }

    public String getGroup() {
        return this.m_group;
    }

    public String getArtifact() {
        return this.m_artifact;
    }

    public String getVersion() {
        return this.m_version;
    }

    public String getType() {
        return this.m_type;
    }

    public String getClassifier() {
        return this.m_classifier;
    }

    public String getArtifactPath() {
        return this.getArtifactPath(this.m_version);
    }

    public String getArtifactPath(String version) {
        return this.m_group.replaceAll(GROUP_SEPARATOR, "/") + "/" + this.m_artifact + "/" + version + "/" + this.m_artifact + "-" + version + this.m_fullClassifier + TYPE_SEPARATOR + this.m_type;
    }

    public String getSnapshotVersion(String version, String timestamp, String buildnumber) {
        return version.replace(VERSION_SNAPSHOT, timestamp) + "-" + buildnumber;
    }

    public String getSnapshotPath(String version, String timestamp, String buildnumber) {
        return this.m_group.replaceAll(GROUP_SEPARATOR, "/") + "/" + this.m_artifact + "/" + version + "/" + this.m_artifact + "-" + this.getSnapshotVersion(version, timestamp, buildnumber) + this.m_fullClassifier + TYPE_SEPARATOR + this.m_type;
    }

    public String getVersionMetadataPath(String version) {
        return this.m_group.replaceAll(GROUP_SEPARATOR, "/") + "/" + this.m_artifact + "/" + version + "/" + METADATA_FILE;
    }

    public String getVersionLocalMetadataPath(String version) {
        return this.m_group.replaceAll(GROUP_SEPARATOR, "/") + "/" + this.m_artifact + "/" + version + "/" + METADATA_FILE_LOCAL;
    }

    public String getArtifactLocalMetdataPath() {
        return this.m_group.replaceAll(GROUP_SEPARATOR, "/") + "/" + this.m_artifact + "/" + METADATA_FILE_LOCAL;
    }

    public String getArtifactMetdataPath() {
        return this.m_group.replaceAll(GROUP_SEPARATOR, "/") + "/" + this.m_artifact + "/" + METADATA_FILE;
    }
}

