/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

final class SceneComponent
extends JComponent
implements Accessible,
MouseListener,
MouseMotionListener,
KeyListener,
MouseWheelListener,
FocusListener,
DropTargetListener {
    private Scene scene;
    private Widget lockedWidget;
    private WidgetAction lockedAction;
    private long eventIDcounter = 0L;
    private JComponent.AccessibleJComponent accessible = new AccessibleSceneComponent();

    public SceneComponent(Scene scene) {
        this.scene = scene;
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        this.setLayout(null);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.setDropTarget(new DropTarget(this, 3, this));
        this.setAutoscrolls(true);
        this.setRequestFocusEnabled(true);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
    }

    public void addNotify() {
        super.addNotify();
        ToolTipManager.sharedInstance().registerComponent(this);
        this.scene.setGraphics((Graphics2D)this.getGraphics());
        this.scene.revalidate();
        this.scene.setViewShowing(true);
        this.scene.validate();
    }

    public void removeNotify() {
        super.removeNotify();
        ToolTipManager.sharedInstance().unregisterComponent(this);
        this.scene.setViewShowing(false);
    }

    public AccessibleContext getAccessibleContext() {
        return this.accessible;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        Rectangle rectangle = this.scene.getBounds();
        double d = this.scene.getZoomFactor();
        if (rectangle != null && n3 == (int)((double)rectangle.width * d) && n4 == (int)((double)rectangle.height * d)) {
            return;
        }
        this.scene.revalidate();
        this.scene.validate();
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (object instanceof Map) {
            graphics2D.addRenderingHints((Map)object);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.scene.setGraphics(graphics2D);
        AffineTransform affineTransform = graphics2D.getTransform();
        double d = this.scene.getZoomFactor();
        graphics2D.scale(d, d);
        this.scene.setPaintEverything(false);
        this.scene.paint();
        this.scene.setPaintEverything(true);
        graphics2D.setTransform(affineTransform);
        graphics.setColor(Color.BLACK);
        super.paint(graphics);
    }

    public void focusGained(FocusEvent focusEvent) {
        this.processOperator(Operator.FOCUS_GAINED, new WidgetAction.WidgetFocusEvent(++this.eventIDcounter, focusEvent));
    }

    public void focusLost(FocusEvent focusEvent) {
        this.processOperator(Operator.FOCUS_LOST, new WidgetAction.WidgetFocusEvent(++this.eventIDcounter, focusEvent));
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.processLocationOperator(Operator.MOUSE_CLICKED, new WidgetAction.WidgetMouseEvent(++this.eventIDcounter, mouseEvent));
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.processLocationOperator(Operator.MOUSE_PRESSED, new WidgetAction.WidgetMouseEvent(++this.eventIDcounter, mouseEvent));
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.processLocationOperator(Operator.MOUSE_RELEASED, new WidgetAction.WidgetMouseEvent(++this.eventIDcounter, mouseEvent));
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.processLocationOperator(Operator.MOUSE_ENTERED, new WidgetAction.WidgetMouseEvent(++this.eventIDcounter, mouseEvent));
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.processLocationOperator(Operator.MOUSE_EXITED, new WidgetAction.WidgetMouseEvent(++this.eventIDcounter, mouseEvent));
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.processLocationOperator(Operator.MOUSE_DRAGGED, new WidgetAction.WidgetMouseEvent(++this.eventIDcounter, mouseEvent));
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        MouseContext mouseContext = new MouseContext();
        Point point = this.scene.convertViewToScene(mouseEvent.getPoint());
        this.resolveContext(this.scene, point, mouseContext);
        mouseContext.commit(this);
        this.processLocationOperator(Operator.MOUSE_MOVED, new WidgetAction.WidgetMouseEvent(++this.eventIDcounter, mouseEvent));
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.processLocationOperator(Operator.MOUSE_WHEEL, new WidgetAction.WidgetMouseWheelEvent(++this.eventIDcounter, mouseWheelEvent));
    }

    public void keyTyped(KeyEvent keyEvent) {
        WidgetAction.State state;
        if ((state = this.processKeyOperator(Operator.KEY_TYPED, new WidgetAction.WidgetKeyEvent(++this.eventIDcounter, keyEvent))).isConsumed()) {
            keyEvent.consume();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object;
        if (keyEvent.getKeyCode() == 112 && (keyEvent.getModifiers() & 2) == 2) {
            object = new MouseContext();
            this.resolveContext(this.scene.getFocusedWidget(), (MouseContext)object);
            ((MouseContext)object).commit(this);
            Widget widget = this.scene.getFocusedWidget();
            Point point = widget.getScene().convertSceneToView(widget.convertLocalToScene(widget.getBounds().getLocation()));
            MouseEvent mouseEvent = new MouseEvent(this, 0, 0L, 0, point.x, point.y, 0, false);
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            toolTipManager.mouseEntered(mouseEvent);
            toolTipManager.mouseMoved(mouseEvent);
        }
        if (((WidgetAction.State)(object = this.processKeyOperator(Operator.KEY_PRESSED, new WidgetAction.WidgetKeyEvent(++this.eventIDcounter, keyEvent)))).isConsumed()) {
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        WidgetAction.State state;
        if ((state = this.processKeyOperator(Operator.KEY_RELEASED, new WidgetAction.WidgetKeyEvent(++this.eventIDcounter, keyEvent))).isConsumed()) {
            keyEvent.consume();
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        WidgetAction.State state;
        if (!(state = this.processLocationOperator(Operator.DRAG_ENTER, new WidgetAction.WidgetDropTargetDragEvent(++this.eventIDcounter, dropTargetDragEvent))).isConsumed()) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        WidgetAction.State state;
        if (!(state = this.processLocationOperator(Operator.DRAG_OVER, new WidgetAction.WidgetDropTargetDragEvent(++this.eventIDcounter, dropTargetDragEvent))).isConsumed()) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        WidgetAction.State state;
        if (!(state = this.processLocationOperator(Operator.DROP_ACTION_CHANGED, new WidgetAction.WidgetDropTargetDragEvent(++this.eventIDcounter, dropTargetDragEvent))).isConsumed()) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.processOperator(Operator.DRAG_EXIT, new WidgetAction.WidgetDropTargetEvent(++this.eventIDcounter, dropTargetEvent));
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        WidgetAction.State state;
        if (!(state = this.processLocationOperator(Operator.DROP, new WidgetAction.WidgetDropTargetDropEvent(++this.eventIDcounter, dropTargetDropEvent))).isConsumed()) {
            dropTargetDropEvent.rejectDrop();
        } else {
            dropTargetDropEvent.dropComplete(true);
        }
    }

    private WidgetAction.State processLocationOperator(Operator operator, WidgetAction.WidgetLocationEvent widgetLocationEvent) {
        WidgetAction.State state;
        Point point;
        Point point2 = this.scene.getLocation();
        Rectangle rectangle = this.getVisibleRect();
        Point point3 = widgetLocationEvent.getPoint();
        Point point4 = this.scene.convertViewToScene(point3);
        widgetLocationEvent.setPoint(new Point(point4));
        String string = this.scene.getActiveTool();
        WidgetAction.Chain chain = this.scene.getPriorActions();
        if (!chain.getActions().isEmpty()) {
            point = this.scene.getLocation();
            widgetLocationEvent.translatePoint(point.x, point.y);
            if (operator.operate(chain, this.scene, widgetLocationEvent).isConsumed()) {
                return WidgetAction.State.CONSUMED;
            }
            widgetLocationEvent.translatePoint(-point.x, -point.y);
        }
        if (this.lockedAction != null) {
            point = this.lockedWidget.convertSceneToLocal(new Point());
            widgetLocationEvent.translatePoint(point.x, point.y);
            state = operator.operate(this.lockedAction, this.lockedWidget, widgetLocationEvent);
            widgetLocationEvent.translatePoint(-point.x, -point.y);
            if (!state.isConsumed()) {
                point = this.scene.getLocation();
                widgetLocationEvent.translatePoint(point.x, point.y);
                state = this.processLocationOperator(operator, string, this.scene, widgetLocationEvent);
            }
        } else {
            point = this.scene.getLocation();
            widgetLocationEvent.translatePoint(point.x, point.y);
            state = this.processLocationOperator(operator, string, this.scene, widgetLocationEvent);
        }
        this.lockedWidget = state.getLockedWidget();
        this.lockedAction = state.getLockedAction();
        this.scene.validate();
        if (this.lockedAction != null) {
            Point point5 = this.scene.getLocation();
            Rectangle rectangle2 = this.getVisibleRect();
            int n = (int)((double)(point5.x - point2.x) * this.scene.getZoomFactor());
            int n2 = (int)((double)(point5.y - point2.y) * this.scene.getZoomFactor());
            if (n != 0 || n2 != 0) {
                this.scrollRectToVisible(new Rectangle(rectangle.x + n, rectangle.y + n2, rectangle2.width, rectangle2.height));
            }
            this.scrollRectToVisible(new Rectangle(this.scene.convertSceneToView(point4)));
        }
        return state;
    }

    private WidgetAction.State processLocationOperator(Operator operator, String string, Widget widget, WidgetAction.WidgetLocationEvent widgetLocationEvent) {
        if (!widget.isVisible() || !widget.isEnabled()) {
            return WidgetAction.State.REJECTED;
        }
        Point point = widget.getLocation();
        widgetLocationEvent.translatePoint(-point.x, -point.y);
        Rectangle rectangle = widget.getBounds();
        assert (rectangle != null) : "Scene.validate was not called after last change. Widget is not validated. See first Q/A at http://graph.netbeans.org/faq.html page.";
        if (rectangle.contains(widgetLocationEvent.getPoint())) {
            WidgetAction.State state;
            List<Widget> list = widget.getChildren();
            Widget[] widgetArray = list.toArray(new Widget[list.size()]);
            for (int i = widgetArray.length - 1; i >= 0; --i) {
                Widget widget2 = widgetArray[i];
                state = this.processLocationOperator(operator, string, widget2, widgetLocationEvent);
                if (!state.isConsumed()) continue;
                return state;
            }
            if (widget.isHitAt(widgetLocationEvent.getPoint())) {
                WidgetAction.Chain chain = widget.getActions();
                state = operator.operate(chain, widget, widgetLocationEvent);
                if (state.isConsumed()) {
                    return state;
                }
                chain = widget.getActions(string);
                if (chain != null && (state = operator.operate(chain, widget, widgetLocationEvent)).isConsumed()) {
                    return state;
                }
            }
        }
        widgetLocationEvent.translatePoint(point.x, point.y);
        return WidgetAction.State.REJECTED;
    }

    private WidgetAction.State processOperator(Operator operator, WidgetAction.WidgetEvent widgetEvent) {
        WidgetAction.State state;
        String string = this.scene.getActiveTool();
        WidgetAction.Chain chain = this.scene.getPriorActions();
        if (!chain.getActions().isEmpty() && operator.operate(chain, this.scene, widgetEvent).isConsumed()) {
            return WidgetAction.State.CONSUMED;
        }
        if (this.lockedAction != null) {
            state = operator.operate(this.lockedAction, this.lockedWidget, widgetEvent);
            if (!state.isConsumed()) {
                state = this.processOperator(operator, string, this.scene, widgetEvent);
            }
        } else {
            state = this.processOperator(operator, string, this.scene, widgetEvent);
        }
        this.lockedWidget = state.getLockedWidget();
        this.lockedAction = state.getLockedAction();
        this.scene.validate();
        if (this.lockedWidget != null) {
            this.scrollRectToVisible(this.scene.convertSceneToView(this.lockedWidget.convertLocalToScene(this.lockedWidget.getBounds())));
        }
        return state;
    }

    private WidgetAction.State processOperator(Operator operator, String string, Widget widget, WidgetAction.WidgetEvent widgetEvent) {
        WidgetAction.State state;
        if (!widget.isVisible() || !widget.isEnabled()) {
            return WidgetAction.State.REJECTED;
        }
        List<Widget> list = widget.getChildren();
        Widget[] widgetArray = list.toArray(new Widget[list.size()]);
        for (int i = widgetArray.length - 1; i >= 0; --i) {
            Widget widget2 = widgetArray[i];
            state = this.processOperator(operator, string, widget2, widgetEvent);
            if (!state.isConsumed()) continue;
            return state;
        }
        state = operator.operate(widget.getActions(), widget, widgetEvent);
        if (state.isConsumed()) {
            return state;
        }
        WidgetAction.Chain chain = widget.getActions(string);
        if (chain != null && (state = operator.operate(chain, widget, widgetEvent)).isConsumed()) {
            return state;
        }
        return WidgetAction.State.REJECTED;
    }

    private WidgetAction.State processSingleOperator(Operator operator, String string, Widget widget, WidgetAction.WidgetEvent widgetEvent) {
        WidgetAction.State state = operator.operate(widget.getActions(), widget, widgetEvent);
        if (state.isConsumed()) {
            return state;
        }
        WidgetAction.Chain chain = widget.getActions(string);
        if (chain != null && (state = operator.operate(chain, widget, widgetEvent)).isConsumed()) {
            return state;
        }
        return WidgetAction.State.REJECTED;
    }

    private WidgetAction.State processParentOperator(Operator operator, String string, Widget widget, WidgetAction.WidgetKeyEvent widgetKeyEvent) {
        while (widget != null) {
            WidgetAction.State state = operator.operate(widget.getActions(), widget, widgetKeyEvent);
            if (state.isConsumed()) {
                return state;
            }
            WidgetAction.Chain chain = widget.getActions(string);
            if (chain != null && (state = operator.operate(chain, widget, widgetKeyEvent)).isConsumed()) {
                return state;
            }
            widget = widget.getParentWidget();
        }
        return WidgetAction.State.REJECTED;
    }

    private Widget resolveTopMostDisabledWidget(Widget widget) {
        Widget widget2 = null;
        for (Widget widget3 = widget; widget3 != null; widget3 = widget3.getParentWidget()) {
            if (widget3.isVisible() && widget3.isEnabled()) continue;
            widget2 = widget3;
        }
        return widget2;
    }

    private WidgetAction.State processKeyOperator(Operator operator, WidgetAction.WidgetKeyEvent widgetKeyEvent) {
        WidgetAction.State state;
        String string = this.scene.getActiveTool();
        WidgetAction.Chain chain = this.scene.getPriorActions();
        if (!chain.getActions().isEmpty() && operator.operate(chain, this.scene, widgetKeyEvent).isConsumed()) {
            return WidgetAction.State.CONSUMED;
        }
        if (this.lockedAction != null) {
            state = operator.operate(this.lockedAction, this.lockedWidget, widgetKeyEvent);
            if (!state.isConsumed()) {
                state = this.processKeyOperator(operator, string, this.scene, widgetKeyEvent);
            }
        } else {
            state = this.processKeyOperator(operator, string, this.scene, widgetKeyEvent);
        }
        this.lockedWidget = state.getLockedWidget();
        this.lockedAction = state.getLockedAction();
        this.scene.validate();
        if (this.lockedWidget != null) {
            this.scrollRectToVisible(this.scene.convertSceneToView(this.lockedWidget.convertLocalToScene(this.lockedWidget.getBounds())));
        }
        return state;
    }

    private WidgetAction.State processKeyOperator(Operator operator, String string, Scene scene, WidgetAction.WidgetKeyEvent widgetKeyEvent) {
        Widget widget = scene.getFocusedWidget();
        switch (scene.getKeyEventProcessingType()) {
            case ALL_WIDGETS: {
                return this.processOperator(operator, string, scene, widgetKeyEvent);
            }
            case FOCUSED_WIDGET_AND_ITS_PARENTS: {
                Widget widget2 = this.resolveTopMostDisabledWidget(widget);
                return this.processParentOperator(operator, string, widget2 != null ? widget2.getParentWidget() : widget, widgetKeyEvent);
            }
            case FOCUSED_WIDGET_AND_ITS_CHILDREN: {
                Widget widget3 = this.resolveTopMostDisabledWidget(widget);
                if (widget3 != null) {
                    return WidgetAction.State.REJECTED;
                }
                WidgetAction.State state = this.processSingleOperator(operator, string, widget, widgetKeyEvent);
                if (state.isConsumed()) {
                    return state;
                }
                return this.processOperator(operator, string, widget, widgetKeyEvent);
            }
            case FOCUSED_WIDGET_AND_ITS_CHILDREN_AND_ITS_PARENTS: {
                Widget widget4 = this.resolveTopMostDisabledWidget(widget);
                if (widget4 == null) {
                    WidgetAction.State state = this.processSingleOperator(operator, string, widget, widgetKeyEvent);
                    if (state.isConsumed()) {
                        return state;
                    }
                    state = this.processOperator(operator, string, widget, widgetKeyEvent);
                    if (state.isConsumed()) {
                        return state;
                    }
                }
                return this.processParentOperator(operator, string, widget4 != null ? widget4.getParentWidget() : widget.getParentWidget(), widgetKeyEvent);
            }
        }
        throw new IllegalStateException();
    }

    private boolean resolveContext(Widget widget, Point point, MouseContext mouseContext) {
        if (widget.getBounds().contains(point)) {
            List<Widget> list = widget.getChildren();
            for (int i = list.size() - 1; i >= 0; --i) {
                Widget widget2 = list.get(i);
                Point point2 = widget2.getLocation();
                point.translate(-point2.x, -point2.y);
                boolean bl = this.resolveContext(widget2, point, mouseContext);
                point.translate(point2.x, point2.y);
                if (!bl) continue;
                return true;
            }
            if (widget.isHitAt(point)) {
                mouseContext.update(widget, point);
            }
        }
        return false;
    }

    private void resolveContext(Widget widget, MouseContext mouseContext) {
        if (widget == null) {
            return;
        }
        mouseContext.update(widget, null);
        this.resolveContext(widget.getParentWidget(), mouseContext);
    }

    private class AccessibleSceneComponent
    extends JComponent.AccessibleJComponent {
        private AccessibleSceneComponent() {
            super(SceneComponent.this);
        }

        public int getAccessibleChildrenCount() {
            return 1;
        }

        public Accessible getAccessibleChild(int n) {
            return n == 0 ? SceneComponent.this.scene : null;
        }
    }

    private static final class MouseContext {
        private String toolTipText;
        private Cursor cursor;

        private MouseContext() {
        }

        public boolean update(Widget widget, Point point) {
            if (this.cursor == null && point != null) {
                this.cursor = widget.getCursorAt(point);
            }
            if (this.toolTipText == null) {
                this.toolTipText = widget.getToolTipText();
            }
            return this.cursor == null || this.toolTipText == null;
        }

        public void commit(SceneComponent sceneComponent) {
            sceneComponent.setToolTipText(this.toolTipText);
            sceneComponent.setCursor(this.cursor);
        }
    }

    private static interface Operator {
        public static final Operator MOUSE_CLICKED = new Operator(){

            public WidgetAction.State operate(WidgetAction widgetAction, Widget widget, WidgetAction.WidgetEvent widgetEvent) {
                return widgetAction.mouseClicked(widget, (WidgetAction.WidgetMouseEvent)widgetEvent);
            }
        };
        public static final Operator MOUSE_PRESSED = new Operator(){

            public WidgetAction.State operate(WidgetAction widgetAction, Widget widget, WidgetAction.WidgetEvent widgetEvent) {
                return widgetAction.mousePressed(widget, (WidgetAction.WidgetMouseEvent)widgetEvent);
            }
        };
        public static final Operator MOUSE_RELEASED = new Operator(){

            public WidgetAction.State operate(WidgetAction widgetAction, Widget widget, WidgetAction.WidgetEvent widgetEvent) {
                return widgetAction.mouseReleased(widget, (WidgetAction.WidgetMouseEvent)widgetEvent);
            }
        };
        public static final Operator MOUSE_ENTERED = new Operator(){

            public WidgetAction.State operate(WidgetAction widgetAction, Widget widget, WidgetAction.WidgetEvent widgetEvent) {
                return widgetAction.mouseEntered(widget, (WidgetAction.WidgetMouseEvent)widgetEvent);
            }
        };
        public static final Operator MOUSE_EXITED = new Operator(){

            public WidgetAction.State operate(WidgetAction widgetAction, Widget widget, WidgetAction.WidgetEvent widgetEvent) {
                return widgetAction.mouseExited(widget, (WidgetAction.WidgetMouseEvent)widgetEvent);
            }
        };
        public static final Operator MOUSE_DRAGGED = new Operator(){

            public WidgetAction.State operate(WidgetAction widgetAction, Widget widget, WidgetAction.WidgetEvent widgetEvent) {
                return widgetAction.mouseDragged(widget, (WidgetAction.WidgetMouseEvent)widgetEvent);
            }
        };
        public static final Operator MOUSE_MOVED = new Operator(){

            public WidgetAction.State operate(WidgetAction widgetAction, Widget widget, WidgetAction.WidgetEvent widgetEvent) {
                return widgetAction.mouseMoved(widget, (WidgetAction.WidgetMouseEvent)widgetEvent);
            }
        };
        public static final Operator MOUSE_WHEEL = new Operator(){

            public WidgetAction.State operate(WidgetAction widgetAction, Widget widget, WidgetAction.WidgetEvent widgetEvent) {
                return widgetAction.mouseWheelMoved(widget, (WidgetAction.WidgetMouseWheelEvent)widgetEvent);
            }
        };
        public static final Operator KEY_TYPED = new Operator(){

            public WidgetAction.State operate(WidgetAction widgetAction, Widget widget, WidgetAction.WidgetEvent widgetEvent) {
                return widgetAction.keyTyped(widget, (WidgetAction.WidgetKeyEvent)widgetEvent);
            }
        };
        public static final Operator KEY_PRESSED = new Operator(){

            public WidgetAction.State operate(WidgetAction widgetAction, Widget widget, WidgetAction.WidgetEvent widgetEvent) {
                return widgetAction.keyPressed(widget, (WidgetAction.WidgetKeyEvent)widgetEvent);
            }
        };
        public static final Operator KEY_RELEASED = new Operator(){

            public WidgetAction.State operate(WidgetAction widgetAction, Widget widget, WidgetAction.WidgetEvent widgetEvent) {
                return widgetAction.keyReleased(widget, (WidgetAction.WidgetKeyEvent)widgetEvent);
            }
        };
        public static final Operator FOCUS_GAINED = new Operator(){

            public WidgetAction.State operate(WidgetAction widgetAction, Widget widget, WidgetAction.WidgetEvent widgetEvent) {
                return widgetAction.focusGained(widget, (WidgetAction.WidgetFocusEvent)widgetEvent);
            }
        };
        public static final Operator FOCUS_LOST = new Operator(){

            public WidgetAction.State operate(WidgetAction widgetAction, Widget widget, WidgetAction.WidgetEvent widgetEvent) {
                return widgetAction.focusLost(widget, (WidgetAction.WidgetFocusEvent)widgetEvent);
            }
        };
        public static final Operator DRAG_ENTER = new Operator(){

            public WidgetAction.State operate(WidgetAction widgetAction, Widget widget, WidgetAction.WidgetEvent widgetEvent) {
                return widgetAction.dragEnter(widget, (WidgetAction.WidgetDropTargetDragEvent)widgetEvent);
            }
        };
        public static final Operator DRAG_OVER = new Operator(){

            public WidgetAction.State operate(WidgetAction widgetAction, Widget widget, WidgetAction.WidgetEvent widgetEvent) {
                return widgetAction.dragOver(widget, (WidgetAction.WidgetDropTargetDragEvent)widgetEvent);
            }
        };
        public static final Operator DROP_ACTION_CHANGED = new Operator(){

            public WidgetAction.State operate(WidgetAction widgetAction, Widget widget, WidgetAction.WidgetEvent widgetEvent) {
                return widgetAction.dropActionChanged(widget, (WidgetAction.WidgetDropTargetDragEvent)widgetEvent);
            }
        };
        public static final Operator DRAG_EXIT = new Operator(){

            public WidgetAction.State operate(WidgetAction widgetAction, Widget widget, WidgetAction.WidgetEvent widgetEvent) {
                return widgetAction.dragExit(widget, (WidgetAction.WidgetDropTargetEvent)widgetEvent);
            }
        };
        public static final Operator DROP = new Operator(){

            public WidgetAction.State operate(WidgetAction widgetAction, Widget widget, WidgetAction.WidgetEvent widgetEvent) {
                return widgetAction.drop(widget, (WidgetAction.WidgetDropTargetDropEvent)widgetEvent);
            }
        };

        public WidgetAction.State operate(WidgetAction var1, Widget var2, WidgetAction.WidgetEvent var3);
    }
}

