/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import org.apache.lucene.geo.Rectangle2D;
import org.apache.lucene.geo.XYEncodingUtils;
import org.apache.lucene.geo.XYRectangle;

public class XYRectangle2D
extends Rectangle2D {
    protected XYRectangle2D(double minX, double maxX, double minY, double maxY) {
        super(XYEncodingUtils.encode(minX), XYEncodingUtils.encode(maxX), XYEncodingUtils.encode(minY), XYEncodingUtils.encode(maxY));
    }

    public static XYRectangle2D create(XYRectangle rectangle) {
        return new XYRectangle2D(rectangle.minX, rectangle.maxX, rectangle.minY, rectangle.maxY);
    }

    @Override
    public boolean crossesDateline() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XYRectangle(x=");
        sb.append(XYEncodingUtils.decode(this.minX));
        sb.append(" TO ");
        sb.append(XYEncodingUtils.decode(this.maxX));
        sb.append(" y=");
        sb.append(XYEncodingUtils.decode(this.minY));
        sb.append(" TO ");
        sb.append(XYEncodingUtils.decode(this.maxY));
        sb.append(")");
        return sb.toString();
    }
}

