/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eq.StreamEqualitor;
import org.apache.solr.client.solrj.io.stream.BiJoinStream;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class InnerJoinStream
extends BiJoinStream
implements Expressible {
    private LinkedList<Tuple> joinedTuples = new LinkedList();
    private LinkedList<Tuple> leftTupleGroup = new LinkedList();
    private LinkedList<Tuple> rightTupleGroup = new LinkedList();

    public InnerJoinStream(TupleStream leftStream, TupleStream rightStream, StreamEqualitor eq) throws IOException {
        super(leftStream, rightStream, eq);
    }

    public InnerJoinStream(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Tuple read() throws IOException {
        if (this.joinedTuples.size() > 0) {
            return this.joinedTuples.removeFirst();
        }
        while (true) {
            Object firstMember;
            if (0 == this.leftTupleGroup.size()) {
                firstMember = this.loadEqualTupleGroup(this.leftStream, this.leftTupleGroup, this.leftStreamComparator);
                if (((Tuple)firstMember).EOF) {
                    return firstMember;
                }
            }
            if (0 == this.rightTupleGroup.size()) {
                firstMember = this.loadEqualTupleGroup(this.rightStream, this.rightTupleGroup, this.rightStreamComparator);
                if (((Tuple)firstMember).EOF) {
                    return firstMember;
                }
            }
            if (this.eq.test(this.leftTupleGroup.get(0), this.rightTupleGroup.get(0))) {
                for (Tuple left : this.leftTupleGroup) {
                    for (Tuple right : this.rightTupleGroup) {
                        Tuple clone = left.clone();
                        clone.merge(right);
                        this.joinedTuples.add(clone);
                    }
                }
                this.leftTupleGroup.clear();
                this.rightTupleGroup.clear();
                return this.joinedTuples.removeFirst();
            }
            int c = this.iterationComparator.compare(this.leftTupleGroup.get(0), this.rightTupleGroup.get(0));
            if (c < 0) {
                this.leftTupleGroup.clear();
                continue;
            }
            this.rightTupleGroup.clear();
        }
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.iterationComparator;
    }
}

