/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mov.metadata;

import com.drew.imaging.quicktime.QuickTimeHandler;
import com.drew.lang.ByteUtil;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Metadata;
import com.drew.metadata.mov.QuickTimeMetadataHandler;
import com.drew.metadata.mov.atoms.Atom;
import com.drew.metadata.mov.metadata.QuickTimeMetadataDirectory;
import java.io.IOException;
import java.util.ArrayList;

public class QuickTimeDataHandler
extends QuickTimeMetadataHandler {
    private int currentIndex = 0;
    private ArrayList<String> keys = new ArrayList();

    public QuickTimeDataHandler(Metadata metadata) {
        super(metadata);
    }

    @Override
    protected boolean shouldAcceptAtom(@NotNull Atom atom) {
        return atom.type.equals("hdlr") || atom.type.equals("keys") || atom.type.equals("data");
    }

    @Override
    protected boolean shouldAcceptContainer(@NotNull Atom atom) {
        return atom.type.equals("ilst") || ByteUtil.getInt32(atom.type.getBytes(), 0, true) <= this.keys.size();
    }

    @Override
    protected QuickTimeHandler processAtom(@NotNull Atom atom, @Nullable byte[] payload) throws IOException {
        if (payload != null) {
            SequentialByteArrayReader reader = new SequentialByteArrayReader(payload);
            if (atom.type.equals("keys")) {
                this.processKeys(reader);
            } else if (atom.type.equals("data")) {
                this.processData(payload, reader);
            }
        } else {
            int numValue = ByteUtil.getInt32(atom.type.getBytes(), 0, true);
            if (numValue > 0 && numValue < this.keys.size() + 1) {
                this.currentIndex = numValue - 1;
            }
        }
        return this;
    }

    @Override
    protected void processKeys(@NotNull SequentialByteArrayReader reader) throws IOException {
        reader.skip(4L);
        int entryCount = reader.getInt32();
        for (int i = 0; i < entryCount; ++i) {
            int keySize = reader.getInt32();
            reader.skip(4L);
            String keyValue = new String(reader.getBytes(keySize - 8));
            this.keys.add(keyValue);
        }
    }

    @Override
    protected void processData(@NotNull byte[] payload, @NotNull SequentialByteArrayReader reader) throws IOException {
        reader.skip(8L);
        String value = new String(reader.getBytes(payload.length - 8));
        this.directory.setString(QuickTimeMetadataDirectory._tagIntegerMap.get(this.keys.get(this.currentIndex)), value);
    }
}

