/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.pdftk_java;

import com.gitlab.pdftk_java.LoadableInt;
import com.gitlab.pdftk_java.LoadableString;

class PdfBookmark {
    static final String m_prefix = "Bookmark";
    static final String m_begin_mark = "BookmarkBegin";
    static final String m_title_label = "BookmarkTitle:";
    static final String m_level_label = "BookmarkLevel:";
    static final String m_page_number_label = "BookmarkPageNumber:";
    String m_title = null;
    int m_level = -1;
    int m_page_num = -1;

    PdfBookmark() {
    }

    boolean valid() {
        return 0 < this.m_level && 0 <= this.m_page_num && this.m_title != null;
    }

    public String toString() {
        return m_begin_mark + System.lineSeparator() + "BookmarkTitle: " + this.m_title + System.lineSeparator() + "BookmarkLevel: " + this.m_level + System.lineSeparator() + "BookmarkPageNumber: " + this.m_page_num + System.lineSeparator();
    }

    boolean loadTitle(String buff) {
        LoadableString loader = new LoadableString(this.m_title);
        boolean success = loader.LoadString(buff, m_title_label);
        this.m_title = loader.ss;
        return success;
    }

    boolean loadLevel(String buff) {
        LoadableInt loader = new LoadableInt(this.m_level);
        boolean success = loader.LoadInt(buff, m_level_label);
        this.m_level = loader.ii;
        return success;
    }

    boolean loadPageNum(String buff) {
        LoadableInt loader = new LoadableInt(this.m_page_num);
        boolean success = loader.LoadInt(buff, m_page_number_label);
        this.m_page_num = loader.ii;
        return success;
    }
}

