/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.expression;

import org.jd.core.v1.model.javasyntax.expression.AbstractLineNumberTypeExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor;
import org.jd.core.v1.model.javasyntax.expression.NullExpression;
import org.jd.core.v1.model.javasyntax.type.Type;

public class TernaryOperatorExpression
extends AbstractLineNumberTypeExpression {
    protected Expression condition;
    protected Expression expressionTrue;
    protected Expression expressionFalse;

    public TernaryOperatorExpression(Expression condition, Expression expressionTrue, Expression expressionFalse) {
        super(TernaryOperatorExpression.getType(expressionTrue, expressionFalse));
        this.condition = condition;
        this.expressionTrue = expressionTrue;
        this.expressionFalse = expressionFalse;
    }

    public TernaryOperatorExpression(Type type, Expression condition, Expression expressionTrue, Expression expressionFalse) {
        super(type);
        this.condition = condition;
        this.expressionTrue = expressionTrue;
        this.expressionFalse = expressionFalse;
    }

    public TernaryOperatorExpression(int lineNumber, Expression condition, Expression expressionTrue, Expression expressionFalse) {
        super(lineNumber, TernaryOperatorExpression.getType(expressionTrue, expressionFalse));
        this.condition = condition;
        this.expressionTrue = expressionTrue;
        this.expressionFalse = expressionFalse;
    }

    public TernaryOperatorExpression(int lineNumber, Type type, Expression condition, Expression expressionTrue, Expression expressionFalse) {
        super(lineNumber, type);
        this.condition = condition;
        this.expressionTrue = expressionTrue;
        this.expressionFalse = expressionFalse;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    public Expression getExpressionTrue() {
        return this.expressionTrue;
    }

    public void setExpressionTrue(Expression expressionTrue) {
        this.expressionTrue = expressionTrue;
    }

    public Expression getExpressionFalse() {
        return this.expressionFalse;
    }

    public void setExpressionFalse(Expression expressionFalse) {
        this.expressionFalse = expressionFalse;
    }

    @Override
    public int getPriority() {
        return 15;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "TernaryOperatorExpression{" + this.condition + " ? " + this.expressionTrue + " : " + this.expressionFalse + "}";
    }

    protected static Type getType(Expression expressionTrue, Expression expressionFalse) {
        if (expressionTrue instanceof NullExpression) {
            return expressionFalse.getType();
        }
        return expressionTrue.getType();
    }
}

