/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.IgnoreEdgeAttr;
import jadx.core.dex.attributes.nodes.PhiListAttr;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.PhiInsn;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.mods.TernaryInsn;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.conditions.IfCondition;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class BlockUtils {
    private BlockUtils() {
    }

    public static BlockNode getBlockByOffset(int offset, Iterable<BlockNode> casesBlocks) {
        for (BlockNode block : casesBlocks) {
            if (block.getStartOffset() != offset) continue;
            return block;
        }
        throw new JadxRuntimeException("Can't find block by offset: " + InsnUtils.formatOffset(offset) + " in list " + casesBlocks);
    }

    public static BlockNode selectOther(BlockNode node, List<BlockNode> blocks) {
        List<BlockNode> list = blocks;
        if (list.size() > 2) {
            list = BlockUtils.cleanBlockList(list);
        }
        if (list.size() != 2) {
            throw new JadxRuntimeException("Incorrect nodes count for selectOther: " + node + " in " + list);
        }
        BlockNode first = list.get(0);
        if (first != node) {
            return first;
        }
        return list.get(1);
    }

    public static BlockNode selectOtherSafe(BlockNode node, List<BlockNode> blocks) {
        int size = blocks.size();
        if (size == 1) {
            BlockNode first = blocks.get(0);
            return first != node ? first : null;
        }
        if (size == 2) {
            BlockNode first = blocks.get(0);
            return first != node ? first : blocks.get(1);
        }
        return null;
    }

    public static boolean isBlockMustBeCleared(BlockNode b) {
        if (b.contains(AType.EXC_HANDLER) || b.contains(AFlag.REMOVE)) {
            return true;
        }
        if (b.contains(AFlag.SYNTHETIC)) {
            List<BlockNode> s = b.getSuccessors();
            return s.size() == 1 && s.get(0).contains(AType.EXC_HANDLER);
        }
        return false;
    }

    private static List<BlockNode> cleanBlockList(List<BlockNode> list) {
        ArrayList<BlockNode> ret = new ArrayList<BlockNode>(list.size());
        for (BlockNode block : list) {
            if (BlockUtils.isBlockMustBeCleared(block)) continue;
            ret.add(block);
        }
        return ret;
    }

    public static void cleanBitSet(MethodNode mth, BitSet bs) {
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            BlockNode block = mth.getBasicBlocks().get(i);
            if (BlockUtils.isBlockMustBeCleared(block)) {
                bs.clear(i);
            }
            i = bs.nextSetBit(i + 1);
        }
    }

    public static List<BlockNode> filterPredecessors(BlockNode block) {
        List<BlockNode> predecessors = block.getPredecessors();
        ArrayList<BlockNode> list = new ArrayList<BlockNode>(predecessors.size());
        for (BlockNode pred : predecessors) {
            IgnoreEdgeAttr edgeAttr = pred.get(AType.IGNORE_EDGE);
            if (edgeAttr != null && edgeAttr.contains(block)) continue;
            list.add(pred);
        }
        return list;
    }

    public static boolean isBackEdge(BlockNode from, BlockNode to) {
        if (to == null) {
            return false;
        }
        if (from.getCleanSuccessors().contains(to)) {
            return false;
        }
        return from.getSuccessors().contains(to);
    }

    public static boolean blockContains(BlockNode block, InsnNode insn) {
        for (InsnNode bi : block.getInstructions()) {
            if (bi != insn) continue;
            return true;
        }
        return false;
    }

    public static boolean checkLastInsnType(IBlock block, InsnType expectedType) {
        InsnNode insn = BlockUtils.getLastInsn(block);
        return insn != null && insn.getType() == expectedType;
    }

    @Nullable
    public static InsnNode getLastInsn(@Nullable IBlock block) {
        if (block == null) {
            return null;
        }
        List<InsnNode> insns = block.getInstructions();
        if (insns.isEmpty()) {
            return null;
        }
        return insns.get(insns.size() - 1);
    }

    public static BlockNode getBlockByInsn(MethodNode mth, InsnNode insn) {
        if (insn instanceof PhiInsn) {
            return BlockUtils.searchBlockWithPhi(mth, (PhiInsn)insn);
        }
        if (insn.contains(AFlag.WRAPPED)) {
            return BlockUtils.getBlockByWrappedInsn(mth, insn);
        }
        for (BlockNode bn : mth.getBasicBlocks()) {
            if (!BlockUtils.blockContains(bn, insn)) continue;
            return bn;
        }
        return null;
    }

    public static BlockNode searchBlockWithPhi(MethodNode mth, PhiInsn insn) {
        for (BlockNode block : mth.getBasicBlocks()) {
            PhiListAttr phiListAttr = block.get(AType.PHI_LIST);
            if (phiListAttr == null) continue;
            for (PhiInsn phiInsn : phiListAttr.getList()) {
                if (phiInsn != insn) continue;
                return block;
            }
        }
        return null;
    }

    private static BlockNode getBlockByWrappedInsn(MethodNode mth, InsnNode insn) {
        for (BlockNode bn : mth.getBasicBlocks()) {
            for (InsnNode bi : bn.getInstructions()) {
                if (bi != insn && BlockUtils.foundWrappedInsn(bi, insn) == null) continue;
                return bn;
            }
        }
        return null;
    }

    public static InsnNode searchInsnParent(MethodNode mth, InsnNode insn) {
        InsnArg insnArg = BlockUtils.searchWrappedInsnParent(mth, insn);
        if (insnArg == null) {
            return null;
        }
        return insnArg.getParentInsn();
    }

    public static InsnArg searchWrappedInsnParent(MethodNode mth, InsnNode insn) {
        if (!insn.contains(AFlag.WRAPPED)) {
            return null;
        }
        for (BlockNode bn : mth.getBasicBlocks()) {
            for (InsnNode bi : bn.getInstructions()) {
                InsnArg res = BlockUtils.foundWrappedInsn(bi, insn);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    private static InsnArg foundWrappedInsn(InsnNode container, InsnNode insn) {
        for (InsnArg arg : container.getArguments()) {
            if (!arg.isInsnWrap()) continue;
            InsnNode wrapInsn = ((InsnWrapArg)arg).getWrapInsn();
            if (wrapInsn == insn) {
                return arg;
            }
            InsnArg res = BlockUtils.foundWrappedInsn(wrapInsn, insn);
            if (res == null) continue;
            return res;
        }
        if (container instanceof TernaryInsn) {
            return BlockUtils.foundWrappedInsnInCondition(((TernaryInsn)container).getCondition(), insn);
        }
        return null;
    }

    private static InsnArg foundWrappedInsnInCondition(IfCondition cond, InsnNode insn) {
        if (cond.isCompare()) {
            IfNode cmpInsn = cond.getCompare().getInsn();
            return BlockUtils.foundWrappedInsn(cmpInsn, insn);
        }
        for (IfCondition nestedCond : cond.getArgs()) {
            InsnArg res = BlockUtils.foundWrappedInsnInCondition(nestedCond, insn);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public static BitSet blocksToBitSet(MethodNode mth, List<BlockNode> blocks) {
        BitSet bs = new BitSet(mth.getBasicBlocks().size());
        for (BlockNode block : blocks) {
            bs.set(block.getId());
        }
        return bs;
    }

    public static List<BlockNode> bitSetToBlocks(MethodNode mth, BitSet bs) {
        if (bs == null) {
            return Collections.emptyList();
        }
        int size = bs.cardinality();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<BlockNode> blocks = new ArrayList<BlockNode>(size);
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            BlockNode block = mth.getBasicBlocks().get(i);
            blocks.add(block);
            i = bs.nextSetBit(i + 1);
        }
        return blocks;
    }

    public static BlockNode getNextBlock(BlockNode block) {
        List<BlockNode> s = block.getCleanSuccessors();
        return s.isEmpty() ? null : s.get(0);
    }

    public static BlockNode getNextBlockToPath(BlockNode block, BlockNode pathEnd) {
        List<BlockNode> successors = block.getCleanSuccessors();
        if (successors.contains(pathEnd)) {
            return pathEnd;
        }
        Set<BlockNode> path = BlockUtils.getAllPathsBlocks(block, pathEnd);
        for (BlockNode s : successors) {
            if (!path.contains(s)) continue;
            return s;
        }
        return null;
    }

    public static Set<BlockNode> getAllPathsBlocks(BlockNode start, BlockNode end) {
        HashSet<BlockNode> set = new HashSet<BlockNode>();
        set.add(start);
        if (start != end) {
            BlockUtils.addPredecessors(set, end, start);
        }
        return set;
    }

    private static void addPredecessors(Set<BlockNode> set, BlockNode from, BlockNode until) {
        set.add(from);
        for (BlockNode pred : from.getPredecessors()) {
            if (pred == until || set.contains(pred)) continue;
            BlockUtils.addPredecessors(set, pred, until);
        }
    }

    private static boolean traverseSuccessorsUntil(BlockNode from, BlockNode until, BitSet visited, boolean clean) {
        List<BlockNode> nodes = clean ? from.getCleanSuccessors() : from.getSuccessors();
        for (BlockNode s : nodes) {
            if (s == until) {
                return true;
            }
            int id = s.getId();
            if (visited.get(id)) continue;
            visited.set(id);
            if (until.isDominator(s)) {
                return true;
            }
            if (!BlockUtils.traverseSuccessorsUntil(s, until, visited, clean)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPathExists(BlockNode start, BlockNode end) {
        if (start == end || end.isDominator(start) || start.getCleanSuccessors().contains(end)) {
            return true;
        }
        if (start.getPredecessors().contains(end)) {
            return false;
        }
        return BlockUtils.traverseSuccessorsUntil(start, end, new BitSet(), true);
    }

    public static boolean isAnyPathExists(BlockNode start, BlockNode end) {
        if (start == end || end.isDominator(start) || start.getSuccessors().contains(end)) {
            return true;
        }
        if (start.getPredecessors().contains(end)) {
            return false;
        }
        return BlockUtils.traverseSuccessorsUntil(start, end, new BitSet(), false);
    }

    public static BlockNode getTopBlock(Collection<BlockNode> blocks) {
        if (blocks.size() == 1) {
            return blocks.iterator().next();
        }
        for (BlockNode from : blocks) {
            boolean top = true;
            for (BlockNode to : blocks) {
                if (from == to || BlockUtils.isAnyPathExists(from, to)) continue;
                top = false;
                break;
            }
            if (!top) continue;
            return from;
        }
        return null;
    }

    public static boolean isOnlyOnePathExists(BlockNode start, BlockNode end) {
        if (start == end) {
            return true;
        }
        if (!end.isDominator(start)) {
            return false;
        }
        BlockNode currentNode = start;
        while (currentNode.getCleanSuccessors().size() == 1) {
            if ((currentNode = currentNode.getCleanSuccessors().get(0)) != end) continue;
            return true;
        }
        return false;
    }

    public static BlockNode traverseWhileDominates(BlockNode dom, BlockNode start) {
        for (BlockNode node : start.getCleanSuccessors()) {
            if (!node.isDominator(dom)) {
                return node;
            }
            BlockNode out = BlockUtils.traverseWhileDominates(dom, node);
            if (out == null) continue;
            return out;
        }
        return null;
    }

    public static BlockNode getPathCross(MethodNode mth, BlockNode b1, BlockNode b2) {
        BlockNode end;
        if (b1 == null || b2 == null) {
            return null;
        }
        if (b1.getDomFrontier() == null || b2.getDomFrontier() == null) {
            return null;
        }
        BitSet b = new BitSet();
        b.or(b1.getDomFrontier());
        b.and(b2.getDomFrontier());
        b.clear(b1.getId());
        b.clear(b2.getId());
        if (b.cardinality() == 1 && BlockUtils.isPathExists(b1, end = mth.getBasicBlocks().get(b.nextSetBit(0))) && BlockUtils.isPathExists(b2, end)) {
            return end;
        }
        if (BlockUtils.isPathExists(b1, b2)) {
            return b2;
        }
        if (BlockUtils.isPathExists(b2, b1)) {
            return b1;
        }
        return null;
    }

    public static List<BlockNode> collectBlocksDominatedBy(BlockNode dominator, BlockNode start) {
        ArrayList<BlockNode> result = new ArrayList<BlockNode>();
        HashSet<BlockNode> visited = new HashSet<BlockNode>();
        BlockUtils.collectWhileDominates(dominator, start, result, visited);
        return result;
    }

    private static void collectWhileDominates(BlockNode dominator, BlockNode child, List<BlockNode> result, Set<BlockNode> visited) {
        if (visited.contains(child)) {
            return;
        }
        visited.add(child);
        for (BlockNode node : child.getCleanSuccessors()) {
            if (!node.isDominator(dominator)) continue;
            result.add(node);
            BlockUtils.collectWhileDominates(dominator, node, result, visited);
        }
    }

    public static List<BlockNode> buildSimplePath(BlockNode block) {
        LinkedList<BlockNode> list = new LinkedList<BlockNode>();
        BlockNode currentBlock = block;
        while (currentBlock != null && currentBlock.getCleanSuccessors().size() < 2 && currentBlock.getPredecessors().size() == 1) {
            list.add(currentBlock);
            currentBlock = BlockUtils.getNextBlock(currentBlock);
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return list;
    }

    public static void skipPredSyntheticPaths(BlockNode block) {
        for (BlockNode pred : block.getPredecessors()) {
            if (!pred.contains(AFlag.SYNTHETIC) || pred.contains(AType.SPLITTER_BLOCK) || !pred.getInstructions().isEmpty()) continue;
            pred.add(AFlag.DONT_GENERATE);
            BlockUtils.skipPredSyntheticPaths(pred);
        }
    }

    public static boolean isEmptySimplePath(BlockNode start, BlockNode end) {
        if (start == end && start.getInstructions().isEmpty()) {
            return true;
        }
        if (!start.getInstructions().isEmpty() || start.getCleanSuccessors().size() != 1) {
            return false;
        }
        BlockNode block = BlockUtils.getNextBlock(start);
        while (block != null && block != end && block.getCleanSuccessors().size() < 2 && block.getPredecessors().size() == 1 && block.getInstructions().isEmpty()) {
            block = BlockUtils.getNextBlock(block);
        }
        return block == end;
    }

    public static BlockNode skipSyntheticSuccessor(BlockNode block) {
        if (block.isSynthetic() && block.getSuccessors().size() == 1) {
            return block.getSuccessors().get(0);
        }
        return block;
    }

    public static BlockNode skipSyntheticPredecessor(BlockNode block) {
        if (block.isSynthetic() && block.getPredecessors().size() == 1) {
            return block.getPredecessors().get(0);
        }
        return block;
    }

    public static boolean isAllBlocksEmpty(List<BlockNode> blocks) {
        for (BlockNode block : blocks) {
            if (block.getInstructions().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static List<InsnNode> collectAllInsns(List<BlockNode> blocks) {
        ArrayList<InsnNode> insns = new ArrayList<InsnNode>();
        blocks.forEach(block -> insns.addAll(block.getInstructions()));
        return insns;
    }

    public static void replaceInsn(BlockNode block, int i, InsnNode insn) {
        InsnNode prevInsn = block.getInstructions().get(i);
        insn.copyAttributesFrom(prevInsn);
        insn.setSourceLine(prevInsn.getSourceLine());
        insn.setOffset(prevInsn.getOffset());
        block.getInstructions().set(i, insn);
    }

    public static boolean replaceInsn(BlockNode block, InsnNode oldInsn, InsnNode newInsn) {
        List<InsnNode> instructions = block.getInstructions();
        int size = instructions.size();
        for (int i = 0; i < size; ++i) {
            InsnNode instruction = instructions.get(i);
            if (instruction != oldInsn) continue;
            BlockUtils.replaceInsn(block, i, newInsn);
            return true;
        }
        return false;
    }

    public static boolean replaceInsn(MethodNode mth, InsnNode oldInsn, InsnNode newInsn) {
        for (BlockNode block : mth.getBasicBlocks()) {
            if (!BlockUtils.replaceInsn(block, oldInsn, newInsn)) continue;
            return true;
        }
        return false;
    }
}

