/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.JadxArgs;
import jadx.api.JadxArgsValidator;
import jadx.api.JavaClass;
import jadx.api.JavaField;
import jadx.api.JavaMethod;
import jadx.api.JavaPackage;
import jadx.api.ResourceFile;
import jadx.api.ResourcesLoader;
import jadx.core.Jadx;
import jadx.core.ProcessClass;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.IDexTreeVisitor;
import jadx.core.dex.visitors.SaveCode;
import jadx.core.export.ExportGradleProject;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.utils.files.InputFile;
import jadx.core.xmlgen.BinaryXMLParser;
import jadx.core.xmlgen.ResourcesSaver;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.jf.baksmali.Adaptors.ClassDefinition;
import org.jf.baksmali.BaksmaliOptions;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.util.IndentingWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JadxDecompiler {
    private static final Logger LOG = LoggerFactory.getLogger(JadxDecompiler.class);
    private JadxArgs args;
    private final List<InputFile> inputFiles = new ArrayList<InputFile>();
    private RootNode root;
    private List<IDexTreeVisitor> passes;
    private List<JavaClass> classes;
    private List<ResourceFile> resources;
    private BinaryXMLParser xmlParser;
    private Map<ClassNode, JavaClass> classesMap = new ConcurrentHashMap<ClassNode, JavaClass>();
    private Map<MethodNode, JavaMethod> methodsMap = new ConcurrentHashMap<MethodNode, JavaMethod>();
    private Map<FieldNode, JavaField> fieldsMap = new ConcurrentHashMap<FieldNode, JavaField>();

    public JadxDecompiler() {
        this(new JadxArgs());
    }

    public JadxDecompiler(JadxArgs args) {
        this.args = args;
    }

    public void load() {
        this.reset();
        JadxArgsValidator.validate(this.args);
        this.init();
        LOG.info("loading ...");
        this.loadFiles(this.args.getInputFiles());
        this.root = new RootNode(this.args);
        this.root.load(this.inputFiles);
        this.root.initClassPath();
        this.root.loadResources(this.getResources());
        this.initVisitors();
    }

    void init() {
        this.passes = Jadx.getPassesList(this.args);
    }

    void reset() {
        this.classes = null;
        this.resources = null;
        this.xmlParser = null;
        this.root = null;
        this.passes = null;
    }

    public static String getVersion() {
        return Jadx.getVersion();
    }

    private void loadFiles(List<File> files) {
        if (files.isEmpty()) {
            throw new JadxRuntimeException("Empty file list");
        }
        this.inputFiles.clear();
        for (File file : files) {
            try {
                InputFile.addFilesFrom(file, this.inputFiles, this.args.isSkipSources());
            }
            catch (Exception e) {
                throw new JadxRuntimeException("Error load file: " + file, e);
            }
        }
    }

    public void save() {
        this.save(!this.args.isSkipSources(), !this.args.isSkipResources());
    }

    public void saveSources() {
        this.save(true, false);
    }

    public void saveResources() {
        this.save(false, true);
    }

    private void save(boolean saveSources, boolean saveResources) {
        ExecutorService ex = this.getSaveExecutor(saveSources, saveResources);
        ex.shutdown();
        try {
            ex.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            LOG.error("Save interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public ExecutorService getSaveExecutor() {
        return this.getSaveExecutor(!this.args.isSkipSources(), !this.args.isSkipResources());
    }

    private ExecutorService getSaveExecutor(boolean saveSources, boolean saveResources) {
        File resOutDir;
        File sourcesOutDir;
        if (this.root == null) {
            throw new JadxRuntimeException("No loaded files");
        }
        int threadsCount = this.args.getThreadsCount();
        LOG.debug("processing threads count: {}", (Object)threadsCount);
        LOG.info("processing ...");
        ExecutorService executor = Executors.newFixedThreadPool(threadsCount);
        if (this.args.isExportAsGradleProject()) {
            ExportGradleProject export = new ExportGradleProject(this.root, this.args.getOutDir());
            export.init();
            sourcesOutDir = export.getSrcOutDir();
            resOutDir = export.getResOutDir();
        } else {
            sourcesOutDir = this.args.getOutDirSrc();
            resOutDir = this.args.getOutDirRes();
        }
        if (saveResources) {
            this.appendResourcesSave(executor, resOutDir);
        }
        if (saveSources) {
            this.appendSourcesSave(executor, sourcesOutDir);
        }
        return executor;
    }

    private void appendResourcesSave(ExecutorService executor, File outDir) {
        for (ResourceFile resourceFile : this.getResources()) {
            executor.execute(new ResourcesSaver(outDir, resourceFile));
        }
    }

    private void appendSourcesSave(ExecutorService executor, File outDir) {
        Predicate<String> classFilter = this.args.getClassFilter();
        for (JavaClass cls : this.getClasses()) {
            if (cls.getClassNode().contains(AFlag.DONT_GENERATE) || classFilter != null && !classFilter.test(cls.getFullName())) continue;
            executor.execute(() -> {
                try {
                    cls.decompile();
                    SaveCode.save(outDir, cls.getClassNode());
                }
                catch (Exception e) {
                    LOG.error("Error saving class: {}", (Object)cls.getFullName(), (Object)e);
                }
            });
        }
    }

    public List<JavaClass> getClasses() {
        if (this.root == null) {
            return Collections.emptyList();
        }
        if (this.classes == null) {
            List<ClassNode> classNodeList = this.root.getClasses(false);
            ArrayList<JavaClass> clsList = new ArrayList<JavaClass>(classNodeList.size());
            this.classesMap.clear();
            for (ClassNode classNode : classNodeList) {
                if (classNode.contains(AFlag.DONT_GENERATE)) continue;
                JavaClass javaClass = new JavaClass(classNode, this);
                clsList.add(javaClass);
                this.classesMap.put(classNode, javaClass);
            }
            this.classes = Collections.unmodifiableList(clsList);
        }
        return this.classes;
    }

    public List<ResourceFile> getResources() {
        if (this.resources == null) {
            if (this.root == null) {
                return Collections.emptyList();
            }
            this.resources = new ResourcesLoader(this).load(this.inputFiles);
        }
        return this.resources;
    }

    public List<JavaPackage> getPackages() {
        List<JavaClass> classList = this.getClasses();
        if (classList.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, List> map = new HashMap<String, List>();
        for (JavaClass javaClass : classList) {
            String string = javaClass.getPackage();
            List clsList = map.computeIfAbsent(string, k -> new ArrayList());
            clsList.add(javaClass);
        }
        ArrayList<JavaPackage> packages = new ArrayList<JavaPackage>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            packages.add(new JavaPackage((String)entry.getKey(), (List)entry.getValue()));
        }
        Collections.sort(packages);
        for (JavaPackage javaPackage : packages) {
            javaPackage.getClasses().sort(Comparator.comparing(JavaClass::getName, String.CASE_INSENSITIVE_ORDER));
        }
        return Collections.unmodifiableList(packages);
    }

    public int getErrorsCount() {
        if (this.root == null) {
            return 0;
        }
        return this.root.getErrorsCounter().getErrorCount();
    }

    public int getWarnsCount() {
        if (this.root == null) {
            return 0;
        }
        return this.root.getErrorsCounter().getWarnsCount();
    }

    public void printErrorsReport() {
        if (this.root == null) {
            return;
        }
        this.root.getClsp().printMissingClasses();
        this.root.getErrorsCounter().printReport();
    }

    private void initVisitors() {
        for (IDexTreeVisitor pass : this.passes) {
            try {
                pass.init(this.root);
            }
            catch (Exception e) {
                LOG.error("Visitor init failed: {}", (Object)pass.getClass().getSimpleName(), (Object)e);
            }
        }
    }

    void processClass(ClassNode cls) {
        ProcessClass.process(cls, this.passes, true);
    }

    void generateSmali(ClassNode cls) {
        Path path = cls.dex().getDexFile().getPath();
        String className = Utils.makeQualifiedObjectName(cls.getClassInfo().getType().getObject());
        try {
            DexBackedDexFile dexFile = DexFileFactory.loadDexFile((File)path.toFile(), (Opcodes)Opcodes.getDefault());
            boolean decompiled = false;
            for (DexBackedClassDef classDef : dexFile.getClasses()) {
                if (!classDef.getType().equals(className)) continue;
                ClassDefinition classDefinition = new ClassDefinition(new BaksmaliOptions(), (ClassDef)classDef);
                StringWriter sw = new StringWriter();
                classDefinition.writeTo(new IndentingWriter((Writer)sw));
                cls.setSmali(sw.toString());
                decompiled = true;
                break;
            }
            if (!decompiled) {
                LOG.error("Failed to find smali class {}", (Object)className);
            }
        }
        catch (Exception e) {
            LOG.error("Error generating smali", (Throwable)e);
        }
    }

    RootNode getRoot() {
        return this.root;
    }

    List<IDexTreeVisitor> getPasses() {
        return this.passes;
    }

    synchronized BinaryXMLParser getXmlParser() {
        if (this.xmlParser == null) {
            this.xmlParser = new BinaryXMLParser(this.root);
        }
        return this.xmlParser;
    }

    Map<ClassNode, JavaClass> getClassesMap() {
        return this.classesMap;
    }

    Map<MethodNode, JavaMethod> getMethodsMap() {
        return this.methodsMap;
    }

    JavaMethod getJavaMethodByNode(MethodNode mth) {
        JavaMethod javaMethod = this.methodsMap.get(mth);
        if (javaMethod != null) {
            return javaMethod;
        }
        JavaClass javaClass = this.classesMap.get(mth.getParentClass());
        if (javaClass != null) {
            javaClass.decompile();
            return this.methodsMap.get(mth);
        }
        return null;
    }

    Map<FieldNode, JavaField> getFieldsMap() {
        return this.fieldsMap;
    }

    JavaField getJavaFieldByNode(FieldNode fld) {
        JavaField javaField = this.fieldsMap.get(fld);
        if (javaField != null) {
            return javaField;
        }
        JavaClass javaClass = this.classesMap.get(fld.getParentClass());
        if (javaClass != null) {
            javaClass.decompile();
            return this.fieldsMap.get(fld);
        }
        return null;
    }

    public JadxArgs getArgs() {
        return this.args;
    }

    public String toString() {
        return "jadx decompiler " + JadxDecompiler.getVersion();
    }
}

