/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.rewriter;

import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.base.reference.BaseMethodReference;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.MethodParameter;
import org.jf.dexlib2.rewriter.Rewriter;
import org.jf.dexlib2.rewriter.RewriterUtils;
import org.jf.dexlib2.rewriter.Rewriters;

public class MethodRewriter
implements Rewriter<Method> {
    @Nonnull
    protected final Rewriters rewriters;

    public MethodRewriter(@Nonnull Rewriters rewriters) {
        this.rewriters = rewriters;
    }

    @Override
    @Nonnull
    public Method rewrite(@Nonnull Method value) {
        return new RewrittenMethod(value);
    }

    protected class RewrittenMethod
    extends BaseMethodReference
    implements Method {
        @Nonnull
        protected Method method;

        public RewrittenMethod(Method method) {
            this.method = method;
        }

        @Override
        @Nonnull
        public String getDefiningClass() {
            return MethodRewriter.this.rewriters.getMethodReferenceRewriter().rewrite(this.method).getDefiningClass();
        }

        @Override
        @Nonnull
        public String getName() {
            return MethodRewriter.this.rewriters.getMethodReferenceRewriter().rewrite(this.method).getName();
        }

        @Override
        @Nonnull
        public List<? extends CharSequence> getParameterTypes() {
            return MethodRewriter.this.rewriters.getMethodReferenceRewriter().rewrite(this.method).getParameterTypes();
        }

        @Override
        @Nonnull
        public List<? extends MethodParameter> getParameters() {
            return RewriterUtils.rewriteList(MethodRewriter.this.rewriters.getMethodParameterRewriter(), this.method.getParameters());
        }

        @Override
        @Nonnull
        public String getReturnType() {
            return MethodRewriter.this.rewriters.getMethodReferenceRewriter().rewrite(this.method).getReturnType();
        }

        @Override
        public int getAccessFlags() {
            return this.method.getAccessFlags();
        }

        @Override
        @Nonnull
        public Set<? extends Annotation> getAnnotations() {
            return RewriterUtils.rewriteSet(MethodRewriter.this.rewriters.getAnnotationRewriter(), this.method.getAnnotations());
        }

        @Override
        @Nullable
        public MethodImplementation getImplementation() {
            return RewriterUtils.rewriteNullable(MethodRewriter.this.rewriters.getMethodImplementationRewriter(), this.method.getImplementation());
        }
    }
}

