/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.RemoteClusterAware;

public final class SearchShardTarget
implements Writeable,
Comparable<SearchShardTarget> {
    private final Text nodeId;
    private final ShardId shardId;
    private final transient OriginalIndices originalIndices;
    private final String clusterAlias;

    public SearchShardTarget(StreamInput in) throws IOException {
        this.nodeId = in.readBoolean() ? in.readText() : null;
        this.shardId = ShardId.readShardId(in);
        this.originalIndices = null;
        this.clusterAlias = in.getVersion().onOrAfter(Version.V_5_6_0) ? in.readOptionalString() : null;
    }

    public SearchShardTarget(String nodeId, ShardId shardId, String clusterAlias, OriginalIndices originalIndices) {
        this.nodeId = nodeId == null ? null : new Text(nodeId);
        this.shardId = shardId;
        this.originalIndices = originalIndices;
        this.clusterAlias = clusterAlias;
    }

    public SearchShardTarget(String nodeId, Index index, int shardId, String clusterAlias) {
        this(nodeId, new ShardId(index, shardId), clusterAlias, OriginalIndices.NONE);
    }

    @Nullable
    public String getNodeId() {
        return this.nodeId.string();
    }

    public Text getNodeIdText() {
        return this.nodeId;
    }

    public String getIndex() {
        return this.shardId.getIndexName();
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public OriginalIndices getOriginalIndices() {
        return this.originalIndices;
    }

    public String getClusterAlias() {
        return this.clusterAlias;
    }

    public String getFullyQualifiedIndexName() {
        return RemoteClusterAware.buildRemoteIndexName(this.getClusterAlias(), this.getIndex());
    }

    @Override
    public int compareTo(SearchShardTarget o) {
        int i = this.shardId.getIndexName().compareTo(o.getIndex());
        if (i == 0) {
            i = this.shardId.getId() - o.shardId.id();
        }
        return i;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.nodeId == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeText(this.nodeId);
        }
        this.shardId.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_5_6_0)) {
            out.writeOptionalString(this.clusterAlias);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchShardTarget that = (SearchShardTarget)o;
        if (!this.shardId.equals(that.shardId)) {
            return false;
        }
        if (this.nodeId != null ? !this.nodeId.equals(that.nodeId) : that.nodeId != null) {
            return false;
        }
        return !(this.clusterAlias != null ? !this.clusterAlias.equals(that.clusterAlias) : that.clusterAlias != null);
    }

    public int hashCode() {
        int result = this.nodeId != null ? this.nodeId.hashCode() : 0;
        result = 31 * result + (this.shardId.getIndexName() != null ? this.shardId.getIndexName().hashCode() : 0);
        result = 31 * result + this.shardId.hashCode();
        result = 31 * result + (this.clusterAlias != null ? this.clusterAlias.hashCode() : 0);
        return result;
    }

    public String toString() {
        String shardToString = "[" + RemoteClusterAware.buildRemoteIndexName(this.clusterAlias, this.shardId.getIndexName()) + "][" + this.shardId.getId() + "]";
        if (this.nodeId == null) {
            return "[_na_]" + shardToString;
        }
        return "[" + this.nodeId + "]" + shardToString;
    }
}

