/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;

public abstract class OffsetsEnum
implements Comparable<OffsetsEnum>,
Closeable {
    public static final OffsetsEnum EMPTY = new OffsetsEnum(){

        @Override
        public boolean nextPosition() throws IOException {
            return false;
        }

        @Override
        public BytesRef getTerm() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int startOffset() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int endOffset() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int freq() throws IOException {
            return 0;
        }
    };

    @Override
    public int compareTo(OffsetsEnum other) {
        try {
            int cmp = Integer.compare(this.startOffset(), other.startOffset());
            if (cmp != 0) {
                return cmp;
            }
            cmp = Integer.compare(this.endOffset(), other.endOffset());
            if (cmp != 0) {
                return cmp;
            }
            BytesRef thisTerm = this.getTerm();
            BytesRef otherTerm = other.getTerm();
            if (thisTerm == null || otherTerm == null) {
                if (thisTerm == null && otherTerm == null) {
                    return 0;
                }
                if (thisTerm == null) {
                    return 1;
                }
                return -1;
            }
            return thisTerm.compareTo(otherTerm);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract boolean nextPosition() throws IOException;

    public abstract int freq() throws IOException;

    public abstract BytesRef getTerm() throws IOException;

    public abstract int startOffset() throws IOException;

    public abstract int endOffset() throws IOException;

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        String name = this.getClass().getSimpleName();
        String offset = "";
        try {
            offset = ",[" + this.startOffset() + "-" + this.endOffset() + "]";
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return name + "(term:" + this.getTerm().utf8ToString() + offset + ")";
        }
        catch (Exception e) {
            return name;
        }
    }

    public static class MultiOffsetsEnum
    extends OffsetsEnum {
        private final PriorityQueue<OffsetsEnum> queue = new PriorityQueue();
        private boolean started = false;

        public MultiOffsetsEnum(List<OffsetsEnum> inner) throws IOException {
            for (OffsetsEnum oe : inner) {
                if (!oe.nextPosition()) continue;
                this.queue.add(oe);
            }
        }

        @Override
        public boolean nextPosition() throws IOException {
            if (!this.started) {
                this.started = true;
                return this.queue.size() > 0;
            }
            if (this.queue.size() > 0) {
                OffsetsEnum top = this.queue.poll();
                if (top.nextPosition()) {
                    this.queue.add(top);
                    return true;
                }
                top.close();
                return this.queue.size() > 0;
            }
            return false;
        }

        @Override
        public BytesRef getTerm() throws IOException {
            return this.queue.peek().getTerm();
        }

        @Override
        public int startOffset() throws IOException {
            return this.queue.peek().startOffset();
        }

        @Override
        public int endOffset() throws IOException {
            return this.queue.peek().endOffset();
        }

        @Override
        public int freq() throws IOException {
            return this.queue.peek().freq();
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.queue);
        }
    }

    public static class OfMatchesIterator
    extends OffsetsEnum {
        private final MatchesIterator matchesIterator;
        private final Supplier<BytesRef> termSupplier;

        public OfMatchesIterator(MatchesIterator matchesIterator, Supplier<BytesRef> termSupplier) {
            this.matchesIterator = matchesIterator;
            this.termSupplier = termSupplier;
        }

        @Override
        public boolean nextPosition() throws IOException {
            return this.matchesIterator.next();
        }

        @Override
        public int freq() throws IOException {
            return 1;
        }

        @Override
        public BytesRef getTerm() throws IOException {
            return this.termSupplier.get();
        }

        @Override
        public int startOffset() throws IOException {
            return this.matchesIterator.startOffset();
        }

        @Override
        public int endOffset() throws IOException {
            return this.matchesIterator.endOffset();
        }
    }

    public static class OfMatchesIteratorWithSubs
    extends OffsetsEnum {
        private final PriorityQueue<OffsetsEnum> pendingQueue = new PriorityQueue();
        private final HashMap<Query, BytesRef> queryToTermMap = new HashMap();

        public OfMatchesIteratorWithSubs(MatchesIterator matchesIterator) {
            this.pendingQueue.add(new OfMatchesIterator(matchesIterator, () -> this.queryToTerm(matchesIterator.getQuery())));
        }

        @Override
        public boolean nextPosition() throws IOException {
            OffsetsEnum formerHeadOE = this.pendingQueue.poll();
            if (formerHeadOE instanceof CachedOE) {
                OffsetsEnum newHeadOE = this.pendingQueue.peek();
                if (newHeadOE instanceof OfMatchesIterator) {
                    this.nextWhenMatchesIterator((OfMatchesIterator)newHeadOE);
                }
            } else {
                OfMatchesIterator miOE = (OfMatchesIterator)formerHeadOE;
                if (miOE.nextPosition()) {
                    this.nextWhenMatchesIterator(miOE);
                }
            }
            return !this.pendingQueue.isEmpty();
        }

        private void nextWhenMatchesIterator(OfMatchesIterator miOE) throws IOException {
            boolean isHead = miOE == this.pendingQueue.peek();
            MatchesIterator subMatches = miOE.matchesIterator.getSubMatches();
            if (subMatches != null) {
                if (isHead) {
                    this.pendingQueue.poll();
                }
                this.enqueueCachedMatches(subMatches);
                if (miOE.nextPosition()) {
                    this.pendingQueue.add(miOE);
                    assert (this.pendingQueue.peek() != miOE);
                }
            } else if (!isHead) {
                this.pendingQueue.add(miOE);
            }
        }

        private boolean enqueueCachedMatches(MatchesIterator thisMI) throws IOException {
            if (thisMI == null) {
                return false;
            }
            while (thisMI.next()) {
                if (this.enqueueCachedMatches(thisMI.getSubMatches())) continue;
                this.pendingQueue.add(new CachedOE(this.queryToTerm(thisMI.getQuery()), thisMI.startOffset(), thisMI.endOffset()));
            }
            return true;
        }

        private BytesRef queryToTerm(Query query) {
            return this.queryToTermMap.computeIfAbsent(query, q -> {
                try {
                    final BytesRefBuilder bytesRefBuilder = new BytesRefBuilder();
                    UnifiedHighlighter.EMPTY_INDEXSEARCHER.createWeight(UnifiedHighlighter.EMPTY_INDEXSEARCHER.rewrite(q), false, 1.0f).extractTerms((Set)new TreeSet<Term>(){

                        @Override
                        public boolean add(Term term) {
                            if (bytesRefBuilder.length() > 0) {
                                bytesRefBuilder.append((byte)32);
                            }
                            bytesRefBuilder.append(term.bytes());
                            return true;
                        }
                    });
                    if (bytesRefBuilder.length() > 0) {
                        return bytesRefBuilder.get();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return new BytesRef((CharSequence)q.toString());
            });
        }

        @Override
        public int freq() throws IOException {
            return this.pendingQueue.peek().freq();
        }

        @Override
        public BytesRef getTerm() throws IOException {
            return this.pendingQueue.peek().getTerm();
        }

        @Override
        public int startOffset() throws IOException {
            return this.pendingQueue.peek().startOffset();
        }

        @Override
        public int endOffset() throws IOException {
            return this.pendingQueue.peek().endOffset();
        }

        private static class CachedOE
        extends OffsetsEnum {
            final BytesRef term;
            final int startOffset;
            final int endOffset;

            private CachedOE(BytesRef term, int startOffset, int endOffset) {
                this.term = term;
                this.startOffset = startOffset;
                this.endOffset = endOffset;
            }

            @Override
            public boolean nextPosition() throws IOException {
                return false;
            }

            @Override
            public int freq() throws IOException {
                return 1;
            }

            @Override
            public BytesRef getTerm() throws IOException {
                return this.term;
            }

            @Override
            public int startOffset() throws IOException {
                return this.startOffset;
            }

            @Override
            public int endOffset() throws IOException {
                return this.endOffset;
            }
        }
    }

    public static class OfPostings
    extends OffsetsEnum {
        private final BytesRef term;
        private final PostingsEnum postingsEnum;
        private final int freq;
        private int posCounter = -1;

        public OfPostings(BytesRef term, int freq, PostingsEnum postingsEnum) throws IOException {
            this.term = Objects.requireNonNull(term);
            this.postingsEnum = Objects.requireNonNull(postingsEnum);
            this.freq = freq;
            this.posCounter = this.postingsEnum.freq();
        }

        public OfPostings(BytesRef term, PostingsEnum postingsEnum) throws IOException {
            this(term, postingsEnum.freq(), postingsEnum);
        }

        public PostingsEnum getPostingsEnum() {
            return this.postingsEnum;
        }

        @Override
        public boolean nextPosition() throws IOException {
            if (this.posCounter > 0) {
                --this.posCounter;
                this.postingsEnum.nextPosition();
                return true;
            }
            return false;
        }

        @Override
        public BytesRef getTerm() throws IOException {
            return this.term;
        }

        @Override
        public int startOffset() throws IOException {
            return this.postingsEnum.startOffset();
        }

        @Override
        public int endOffset() throws IOException {
            return this.postingsEnum.endOffset();
        }

        @Override
        public int freq() throws IOException {
            return this.freq;
        }
    }
}

