# tewi.tcl
#

set cardSet   tewi
set name(eng) "tewi Card"

if {!$readCards} {
    return
}

# First character:
#   2-9, ordinary numbers, 0 means 10, j (jack) q (queen), k (king), a (ace)
# Second character:
#   d = diamond
#   h = heart
#   s = spade
#   c = club

image create photo ${imgbase}::5d -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP////8AACH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbCAMcDS9euHNe6es/7zxu9fMAi
qCczKjXI5PLpysBARF01uJl6clZtS+j1Zp0sHKt3EUtx1xK7fQSzOW81tY61
mOn4Ux3uEUXyZ9dBCMgh+HFYqMGIyCSUtkVocngiyMX3pvKXN6Tp2Gc5WtIU
urbXOZfHaUi2ooopJzsGOdgYlwZrCHQbKAn6NBwS/EI8rIicbLwM1eyspBxt
NE0NZH29k61tA92tww3+NV79XU6O/iOuTsJutfxOgyp9vlNrPuy6JO9XWtSP
1L58Si7VK8joIEJPCheyamiEIcSIDydSpAfQ3r1ctOs03ovnsd2HgCIjlfR2
kgbJlBZWsnSZEuZJmSVpirTZDqc6neh4lvMZ7QrQZaFk/hqESxNMjP5uuXKJ
TyDHpyFT8XJT0SoXkhKxDtR6geu/O19TYQhoMOlYDEKrgqpEFq47t2/Lvuqq
q2nWuFHrnqVb9+qitftW2uXbKAwRqIK95lIcFvCuo5QgNTLqa3AiyeAKc+6s
aqgzL6KJLv6szTPLTWRKX3NNTcRqFBQk2L6N27aBAgA7
}
image create photo ${imgbase}::4s -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP///////yH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqaay8YsfCXyrdKhjfcgvfAJOzCb
boh08Y5IodLhGfWkM+mDyDzxWlRM1hKMhXPdWtnLqI5RZ8XmqoXGX1sznBSZ
lyTnt4TNlvfzt9fnx/fB95Vx1KdoaEc4yNiomGiJ17W24zaSFhXkuYkVWcdp
BWbK4RaSukjp+nmIo1oYO3orgzt5utukS5Ui+tukU0tMW3aMDMzsnPrs/Bp9
M00tBnldna2N3V3M/U0mPmRNnnnuY54Oyp7svg3fLF9FX28/jq+nb8vf788L
4CWBAQmuCidwHT+F+hjic2gPIj2J8ijCs+gOIzuNn+k4nvNIDqQ0YwgvkjQo
bIcZgnAg+hp0rGVJOjMPQpIZCNWpTEpiURpjLo0oVlg69VJGVCVPSTaZuoK1
VFBRp2DoFEIECmvBS1KzQgB09StMsehyNjArK5LVOGfZplUL1e0yr8uYuExK
Zq7dmmj40pwahqLfN3RZiUT2xMrgb8KKLO625jAxvJJ/qaoMzo/BdptXVejM
iMKj0aRLTwBQAAA7
}
image create photo ${imgbase}::5h -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP////8AACH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbWAMcDS9OuIMf1ft4wD1T5ZsEi
aCgzKjPI5HJ5y/ykuleV5MRdSVHM9JKbhbE5bfY4soKJ1nKYzXmbz57h2vuW
e/J69Lr8x7e1IQjoFwg3V/hRSNfR1dE4qCH59QEZ2Ui2WIIZpwkiiZJmVkrF
Z8LZmZbkiHryOto2Rkmr0ier6DibCLt7GFvbe2vZQ4pLGDS8ijf5BNTl/MwD
uTy943mtlK1dxN0NTQr+9D1eU27Ogp4uJM4etP7OLO/tTn9uf6+er9++lPUL
n5IxtuDxYyEHGbaDKypZa8GQmKh6RhwaiReq0sWIzxIFbePoS5XBfx4/PglG
8WTBjdMMQQFJQ9rIaw/D9aMG8yYHjDqZ5OzpE+g+oRCJ+jOaCymXn0Z5EnUq
FCq9XlLfDaqazmXVmiVq9pEqs2uxZrSguuy47JVThZt2qWWKMqPCVlUwimRU
spmpEDkn4r1bpy+ov3kPyR38ye8lmBb3aCQLZ13jTIq/Mn5MGfGXL5IJrhRG
1+VmNvE8B4Qs5uxYC3avnD7FxtUyrOMsK4XNmenN3Lc/XaANznZvXaR1RzUO
VMTwRxQkOH8O3bmBAgA7
}
image create photo ${imgbase}::black -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP///////yH5BAEAAAAALAAAAABHAGAAAAJl
BIKpy+0PYzBH2otvzbz7D4biSJbmiabqyrbuC8fyTNf2jef6zvf+DwwKh8Si
8YhMKpfMpvMJjUqn1Kr1is1qt9yu9wsOi8fksvmMTqvX7Lb7DY/L5/S6/Y7P
6/f8vnrTROFkUAAAOw==
}
image create photo ${imgbase}::5c -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP///////yH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqZWw8axGzLyfdI0zpf62AuCfgqh
MUMsHo87TFOTuEVZzxeQs5gpVb9L1Zrl2sTe67cWzo3V5TR0jYL7rugz2O5x
x8Wj6HSY4oeHRAcYYQixR1hYd9gh8ffRpAdpV8mIVUhZmcdJMrnVFtiI2Ec6
V4ZWs/gCNgcEO+gU+5CJGXcLeAfzFqnmi9ootyRDFKJK3PMEnCzFyNysFT0t
O12ca81Tnd2CzX39vbQdHkweNG4u6Z2uyI6D7r4B/5s8/2qvXj+sva6lp9yP
yr53AQVCIygukMKCnxg2dATQyKVzDtVBoijREz8mukX6hELIEZYrIfge6mv2
L2I8ZytZtpT2UmBMmTPJ1GRzs11OXTsb9vT5c+SsoEJT9fSDbNVOR/ZSPlyW
SKlBZ5iYOpxC61WrpKsEGb1nyukspJt8bZv4SOOpr6Wi2pIwFhQuuGkvjn3z
y21dvfnoCQr4lyvPbgctWgo1j1deaIoTD+zktIsVgx+fMjaD2V/TymyH+qPa
KRPRxhXNrSlpOjNRz1KPni4djvTqtLOxVKjthMKl3bx7TwBQAAA7
}
image create photo ${imgbase}::6d -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP////8AACH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbYAA/sTLtWDNO6asf7f+rJgESQ
EFdMZo5IpVJ4yXWGQCpvdKNKN75f9xrVWl9NGm5Mgma5Z7Sp7fYwv2E4C75N
Y7P0evuOF7QHgtdHWBi3YfOBmHfYWLIokAh5UqlHRhm4UijoF9fJuRmJZcd2
ZvbnOal66ihqaFTaelr1isl3m5HIObMY6wQkyRusI1lcfIzspLyc1OxMBB39
M01tPHhdZK3Nwt0NBr6dLY5dLk1+7p2uHt5LRNzxrQGsUi/H7oGqs7/6RmsP
oCxLowiaImVQIIlQCEtccogIRb5dDx9FxLXw4j+GzwM3KrTYD2PGgwlDdvR4
j9FHeRM5mISlCx+geCPXzaDp0FfLdid52vSpE2hQoS12EtUw7+iFpEpDGG1q
galSqUepErUqFGu5MVrB0cGKcyHIpU8phtUXk9U+qi8D1jMllaTbMmabMOWI
km6mLXcL5n2bJ2lFkCu5Pm10FjFOwRoh4pX5N+0Uv7ms9JXrWODBuCsJu9nC
t+ynHW1ZhSE705am01FFvyjCCzSVrtQ2u97aj7bX2bfVfdEdLSRwZ3qHlzMu
TgRUIxQkOH8O3bmBAgA7
}
image create photo ${imgbase}::ad -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP////8AACH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbZwMay5WLwjJ+1NfT5D9oJejeg
UbPz+Y5M2uiiLDaNteVQOs1VicQs9ckNe38uKw87ZqW40G5atnZfzW+VsP7F
T+9ovf3Z1udXksQ22AIYRncYlKjIqOMoBkkIOLdI2SEkl9moIdi5cReKYkka
eapmmkoyyurh+soRK4u0Wjt7i2u769kLq/vrJKwZDASqZZzDeUSLM8nkLKOI
HCPNQo05c72SXY3Y5K1trdwtPg7OdN5cjp0d3W5ODZ81T19veI//TZ7G309M
VLxa3AgOlFUQ4cFXCRkuZNUQ4sNUESlOPFUR40VSZRkPoenohxlIPNBCbCT5
aFgveyZ/sRxZpyTMmHRmxuQVEGdODDbDyTHUU91PN0GFvihS9Ii3C0mVplSJ
y4qZpk6vZKBqJMrVkyg/cqXplVgfrEoF7tx6lmeFtBMMSHgLN+5bAwUAADs=
}
image create photo ${imgbase}::5s -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP///////yH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqYhw8ay28i2So/3jusuDwTlFMGi
Zkg0Kn8YJkd3g7akF+fR2qOifFBsNclahLnfTm0q7lnOV3bpoV6DM5EtfGuH
kCRac/8psRf49tc26MdHeLTB5/WVKEhn1VgoBykklfaYEPIyxyg2AhNp+ZnE
5djE2elZKVmq2RaV6oEUq7o6lnti+6k0Wybq+hv3SGzktHu8Q7vMPOxs0xw9
A009dv07nV3MDbTtrRj+bT2OuVyOTaxcBJ7lzpuex84DL+hGjqzXLv9xWd+v
1iGAQSgVDAjoHzByCqUhBEVEmK9q/GiU4neMXj5ttBMJmnv2EWRIhyNJloxh
76QclepYxnPZDeY5meJozrTp7yE3ZSnD8dRJLYWwMjjvpLwVT6NRhBrtIBoF
7tRFTBZbSdK0DYbEprBEtUo2J2ujnA1/Emp4dWCVK2fVGqpD6t4+snNvUq37
9E5cufgE6sXFBN5fvhPZ2OtL+M+PxQGRzvND9AXKnsYgg5pRLycgnF27AA2K
9fNOz5zZruRsWDS6UZJLW3bNqAJsOhQo2b6NewKAAgA7
}
image create photo ${imgbase}::6h -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP////8AACH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbYAA/sTLtWDNO6asf7f+rJgESQ
EFdMZo5IpVJ4yWWaAiqIajWObsNql4vEST9iWRm19Ua/ZfPZ0/aKS1Duqx2H
49/a9dy/56MXKNgH+CVHiKihWPhhQ9a4OCVJl3alSNKIZrKJScgJJscY2Fka
GuYIxleyx7PlSvqnkhcEi8cxu6KLips7NqMamig8BTRpeVfstAM5yvx0eQPt
5EzNbH0drX2dzU3k/f0TLq5DXj5zjt4ivd7c7l4DH8+iTk9if/84/zuWNdjl
n4d8xNwIlOWD1b5WZ2r1S8WrQz5JyA6dMvQpE0BQ6fj4UfLUgWIyTZU2XlzI
kGMklRgzxlp5EmVKXyRfdqRFc2ZEmaZ2ugQ2EueymkCDCt0xlCetY/L0vXNq
ziNUpVOHVbV1lV3WV1uxdjX6daDUsBYIdjWrbxFaeqrWutPldtqPiqsKxU1a
M6Qvtz6JIou11mFPgYDHflT4UxjEIWZZwhQ8yq7hujn1OhY72KblmJj9cj58
mcPEkpsdw50s0qTNWqNBPmTpr0vrxXjjOIx9gWDDvsoS8sJddvIqQIOJU1qT
WzhbPnHRMVcOdUzzt9KhxztN1njy7FS5YxDhfcMEAxLKmz9f3kABADs=
}
image create photo ${imgbase}::6c -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP///////yH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqaYwsayay3yrdIJzp/62AuCfjCh
8QUMMY7M34XG2c2gvqSzY2Nlc9Yudsndory1pKbRAlef6nO7hOYipV96mAo3
k3Z8fDTVp/fhVwcxJDHmJihhp4i4pyemxOjBSOiWIWkpOPd4mFnUOTIaWjg6
eYlZNqkECvSaOldTxvlF6/BXm6c7CPuwITnWmHcbx8RDFMJ63IM3zHzjHAu9
Rk09bR3Nm42Dza21/R3jLV5dLkR+DqmOHs5O/I7sHt87NZ87fu+aLgoOHnwI
YL00Aiu9WUew1C6FCBPq65cmDKtnwABZ1JeOUq8I14kWcjRlqGFATxU1fvIY
MhdJg1X4oApngxTFihKVLQs466bImvkesunJj81MlvS0FTV6NF9SpUsjNpXz
1FzUnVOJVj15dWBWnau2cm111SWdoN8+kn0JdFHIs19blsQFVljOobJs2rkY
NyMMmdNiooX4E+UvkIOLgRK2ct9Hw0gQL377+KveyJDhUt040Vugtrb+nS34
t+sdupVrGSNrzDGhK3FbMhxJkfXn15BmyvYpVBuv215P4z6nhi071l5vCi9b
6jg3hcrjNX8nojgwCpuqW78+AUABADs=
}
image create photo ${imgbase}::ah -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP////8AACH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbawMZyOL7zfbrYwOP+p7vwYL+i
Jijo9YxMWkZJbBaDy2RUiqMOh9ifbgvuZmvW51XMcm2FXHRM3bZW3SokfUq+
G+36MRsW15dTs7YmOGgBZnhYAqd4xujhqBjZSPZYabmzmAmUJ9ep+RQqStry
aVqaioK66umKCKsqK9lKe2R7i8Gnu5vb6wTMwStMLLPI6WdESen1u4KJ6WMM
/Sit/GN9fUOtot2M7fMdNv1cPY7HND7HbX5uvef+Tp4ute3cRR8vFrjP39Xt
VkBaA2UVhHXQVcJVC1M1NPWQVMRQEztVzHTxDqSMYm76ceTH6SOWayKbaLNQ
Uh28YLROspRVqE1KlYCqzLxzk05ONztnIJMp79DPJT19nrEZVOjKl7C2FTXK
xlcvKBmeQmVn1ejGpJH6MW25IavPsFwZlnVYQVhVChLaun3b1kABADs=
}
image create photo ${imgbase}::7d -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP////8AACH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbWAMcDS9OuIMf1ft7w9eMJPzdM
cIjcFIGzpBOzxDWf1OixMxVme6PMdaPTfkvLsVfGy7W6TE/OXHpvQeU5U86S
wzl1rD7/h8IGohdmUrinEcWBmKjR6HhR5leo0ihotFe5sknGpgYWaClK4oIX
CgqY6vnyRhn5scoqJXtmxwmr+IkWm3RLN2hI9TTpOyw5+CRMnOzLW9U8dMpM
1Zm0mEaKhF1z6cStivgdveN9TV6uPQROY72Nnl67Dh+fu3ZMi8+ehh9Cj2WM
xT5U0uxB+ffoWTuFsw65WijPw8A7D0dNK4WQYsRY3eokZqTV0Y24hhxHxoFE
smTIVxeJfAS5UWRLlyfcnZzp0SLDmhVTkoj5cycwVQV/5cwT8F6/fhOX2njp
VEXTqFKhUvV5VcjUrBi5jvN6Duw7sfPIarVqNsNWs1vWihXmFkdSlsiIijF6
ai1QQkJbgdqK82bfvC9tBg2caqphvoHz1RXcmJHJR2ozonRojibknodX6uIZ
mWXfVgdBc9687Exp06kxjyb9mHW21qpjgy7Kt3K7uX50pz3p+zfHz8KHBy8e
qo0/5KKbxM1KmHlV6T0qUKdDQYL27dy1GygAADs=
}
image create photo ${imgbase}::0d -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP////8AACH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbCMFgwzNa1S8+zzaPjG6MBe8QP
LhgbFpeao1LIjIZ+uSRUunQKr5lk0avSWsGYHdEcpiJlZDa6pmuDxGxNnHu6
yz1iXVe/9wEYuOEEhDfIkuhjMogn6MhI4vgGSVnichF4mReJ+ePWsagySpIZ
x1HaCHhyhLqh50EY26r2Cusn+qiZW+vWizsLbLdrBHorKnsnewN62KNalClz
xio1/eXJhA1NSdjinB3dw12yaQ3brLg7/gy+gly2HFzcUa4cz1upPzwXbjmP
2J52HO6lQmdHF61PqwgedJjB4B9Ok7wxNKcNI0QM/xIFBuy00NQ/fB8bljRG
6qTJfShTsgRZr+BIEC9dsuiYbMk3ezOx+MTpM0vPoFGAEiU39Ki0pEqRwmGy
U+a6qDRjSnVpFSBVjkwn9luZlSvMfBVD+hv7tarZlmURtl3LU2NGrW7jyoVL
Em+hrvzIUnuo0u7dtC83ikU7kHBgwSsBF07Lh+9Ex4q3HoancLHlyzrnEjE6
WO9NyaEhq5NiWFBE0qU3C+ScJ2+9nbdAyxNW0x3lJLZ/4c6b2Uxv0bgr57Kd
2qvf2qST39Z8BTTF1sXIGPW2FfvFt4t3m16NOKzyfrmEIK/LvdIy86xF022z
Zc0UeN/VPoqvpHeoaonrsDl/qpMu/vHGWlN/DGiBfgbyguB8C67ToIIP4vff
g/T5UaGFWNXhoIZCebhNBSCSQ4EEJp6IookGFAAAOw==
}
image create photo ${imgbase}::ac -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP///////yH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbayMaym8HyfdJXgvekbuH5hhxg
CkgkGkfIpE9HazpvUMY0GXVch9mabUuFKXZC8ExcHpvPa7O0/fwG3/DSslxv
yRf52J3e19HFAxjoNfdgaIeWqAjiEuH4aEMYUiiJhCf5kXm5afkZFso2yuJZ
eoiqcqo615oj9+rB2kqraouKW6q7GMvl+6v5u9Uwxctp5XQ8m4wFHCccZ3xE
/WxqfR05rCSxTObcvR0sIT7OZBnth50dhOjs5l20fpaOE+94r5hvuB/Y3/cv
T8A6A+EUbHNwTUJ4srzEWthDGER159LM0wfBlSxtVxP1NOqoBx0ojQ3RLSmJ
6CRKPhhAUnxxcWPMVy5RWIQ0E+BNNCVVjpRZjCRQNUJpUvpScxWTPTn5LU21
shNKd1BXbkja4mrTXFt3VZh6lUK3sWTLPjBQAAA7
}
image create photo ${imgbase}::back -format gif -data {
R0lGODlhRwBgAMIAAH//1P///wAA/8DAwP//AP8A/////////yH5BAEAAAAA
LAAAAABHAGAAAAP/CBDc/jDKSWtQy+rNd+5gKI5kaZ6oJaxsKwxuDMftTK/2
Xd1u3vM1nk83cTVktOHxhzQynJJWgDANNFlKKvWKi1W3LEqYICgIwMGukWxG
Y9/r8tm6Egumc/KW3s1Z8Vpzd0F+d3qAdHYMBVWMd4w2kQGOk41/kHAvlY+W
iUWGeYJ8L6RhoIF7hFKniHWfoG2jaqVSbIJMtGNyaHZ1WrK5wYZVXMJfo711
g7iRXstptErPrlFGXKPSuNPZUhN+jpmc0OLhm+XgOGKF4cra2M7uQXbNs6bA
9MbTs/S9PlnE2oz9KmYjGT5dsa5k2XWv3Ks+qxAd2pbrz6GJ73wk27ep/xIV
Spg4grTE6SC1CD8KSRSlyt5Flm80PjQJ6xa0hQmZdasW7J+begIBjqM1L5O0
hvucIY12EkLFofqeshv0ztQbCt+q1kFXkWvWcebSPWwHFupSitagoIyocOqf
tkCpqnU6Rig7n2eDuumFJ+dNL7Z+Mo3jV9HLVDEjHn6b2GUoMIo8dgwZbTLJ
SvgGWP745M6nlYjjWnzMuCxoTzz72pxaiyEQnDaTHStGYzYQvcjGljYKZDdc
tjvXrorHY4kOs168SfG6HNgLzZCGkKsXVlORdaJ7dz5OvEvRpNacKxMvV6ea
fgGHoSk4cJbtoQVnug2cyJfrZaoFH9wIQ+ViB///NbAYRTLxZNRmlnHCmTiS
jUTTRpWNtCCCIylo2YNj9acYaQByKCBpBM71wF+E3ZIIfe3kt5Qfr/gDmFDs
wViXfrh8NxhwtUVlz28zqDNcdsVtl2N3pGDVHFhcYbEIA9JV95WSY0WFXW1C
wgNkcHTtaN5x5N2oZRgPvcfaGnbdgBeWI9rn15hqrkabimBWcxpaG6Li21Nz
eiZng5cEkBmFff4pYSWorTVnRnW2gqhjdjaVZk00iobilgjFFmZ78L0Y6Xx2
bXRnZkrxGCqaDlhZDnJEchNnBE9Sx1wYr26l1XTWRTGlqtShWtZVn4Aanqi/
btlji+mJCdSZAcVn4IPek5LY2prgOVpqS+MNuGi1IF4rrXEHDupgt31OSJkS
GeJpLbVUndvYqll62eamsMFLqnEukrmppGX2xG6avuLIW3YrwuGjVVee6had
FBkJ66xOHnkOw15BeNasZBlc8LZVfvqvv9EeJeK0vuRbby0iF4upnsLBSem7
AZfIy2fqQsSoouiO1ijKdC0prp/gWvitSOESivGJ2dbMCkZG58lXsxtXKq/L
fMh28rGa5oXs0FDQZkyVwmwtC4RJCHFbXGzOy23Yr90mHVQfp+D223DHLffc
E3xAN90Y3I03AAkAADs=
}
image create photo ${imgbase}::jd -format gif -data {
R0lGODlhRwBgAMIAAH//1AAAAP////8AAP8A////AP///////yH5BAEAAAAA
LAAAAABHAGAAAAP/CBDc/jDKSWtQS+jNu/9gKI7CFZBoqqrM6r5vyw30AN+4
vNU27q+6Xe9HJAU1tKJSdBQkl9BO8xmtTodV6HVj6XolI9mTegIFbDUneq12
Ns3h8nhYNrOTeLS7Pvvw/XI8dGFDVG17H2lScUKGbxxngpI0f0g8i0yVUo8a
X5UEggSQjJkFmp0OpmZ8oJKinaQ7m6qrAaa0HkGtoVyxalgMuLm3ticNJQ20
k5clsbuvyMJ8xcTGLckny4LNmRq7NK/BdUHUxaOdyto9p1yB29HW0sTSXLjf
NdDsqN68yMnCJeZNq1fnHrhe3fgd7DSggMNjkAS2K2Nuwz1o3EIEUYTK/xTE
iOXMeKzzDqHGP1hKNGwSTCIqYwJu4eJoclUcgAEFesxli1ifXL78rBwmrpiN
gQN64twUlCdOpT0jUWrA44HGpE2lDN0EQV1SYyOJ6kN2c9qZYw8mQVD1MSDW
hFdpYft6zQK8ljKKjeXUMYIpunUj+DMXlW6BtycJjXzwF0IzmFSLiquhNysk
vWdTZa6Q9OvDnAySHt5Lui5go6HPdlZ9NmCqh5XhwnncWPPXhrgP6x4a1d/D
0ZYnxts8OfXq4/F2aiYd5iWx07VZI/cNGyxim5lCi8Zm27h0a9Gq75Tth+z2
h9Az584NPvmt64DKUh65svt3rHUXx05cSk453P+MbTZdYKgBR14uK81HlW75
qccaWVGxNR5/Jynz32hp1cYeWpOJBh9PikmFWX2+0aAhcRGe4Rpz/SHxX1e2
mOigNXNRYiCFdvxlo1VpxZggjM+hwxdZLZ4H420+hhWMYSLeiF1ckWA22G6p
YegAgEGuGFxfrn12DXJnKRejlTp6yCKU23GoEmtVZmjkOhM+uYp+Yq4JZprJ
MKngmTlCBZl1u2GIZ5VBXrPlXX5CiNxqYQbYoQOHnsFWS0ouKiBmbYaVkZyA
LBbel/c5qF+ag0W6UnWguRXoem1eSRgsB85CqWZ2horkqASaWpuXsDHKGaab
xRlff3sWRddjj/WoX57/fApFX2+YDsajq8vux6lTFEVVlLRgUAtRjM0iKM01
y6oFaWTTCAtii1xN6hUYUjg57FXspEUZVfPJ9JS6TMUaEXqbZqOXR/t+2K9G
iYAEG7bz7Dvkwx5wFGGy4zTMErgdpATxDMz4dko5T3HHMTB7cXARSC8R5NNl
SiH2TDvNKdSPazWB/Ie2EJ1MJMIy85APLumGRBBYYkiyDxOWaCNkzS4draUA
OkPsVRJScth0wBO+7PRsXgnJIdEr+xEnTRtDPQlGj5TDibVOHDyb2a5cJpJV
c4eLSc8DYPRSF9lFmnHHkExNiS8dl90IID0YQoXB5/yiiOGy8KRHHm3goQ9J
TYmvUzIKoVV+xxpo1CuEJVsD4snpdpHudhZKGFI660S4vjPsRcg+JO0r2D4W
7iroznvsNM3+OwyACz+8ErcfH0MGyiOPAerQR0+BAgkAADs=
}
image create photo ${imgbase}::6s -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP///////yH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqaYwsayay3yrdIJzp/62AuCfjCh
8QUMMY7M34XGSd6kuaSzs5tCfdYutsiytbw16nM5FnPPamSj+l6zt+UHCiIn
Scyb/f0eoSfxJ+jnsUcXZcaHyOc2KJiR9Rh4iFgC1aYEM4L2xbk5+UEEVgd0
Kvp5akpop+gIGOPiqqHJlYqJGscU5NQJyxtGhRuMs0VcPAOc3JPILOT83Lws
rVzNG31trW2UzT32DU0dnjvTvJ1m7P0ljFy43jcu6XlbWl5vO+pQhU+vTxsp
V6V/eO69A6gKoSWBkBIWHCKvEcGB+hhSjGcIosVOyqG8Lflljx3DGqwgzioZ
MJ0WebVYUlLmbiE5HvBmVrSpBWdOnbJc8kTyU1hQcEPzFE15VGNSpEtFNq0z
7ymbqE9T/DpTdZ+SdjUxOnPVdZ7PlrDAsiyiaxxalKYm1fzYcRlcf23eXrKU
cSrQgw9fNXzRcqNCsX9l8t2Ft+/Nw/78DlbUL5/jxoYFh42LrO5YxIBCtr0C
5/JLyGWwtlMHDLToJ+cMg16qeiy3Xatnq6lN7rVUt7Jti8J9zR5wnCKkRqHQ
KLny5RMAFAAAOw==
}
image create photo ${imgbase}::7h -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP////8AACH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbWAMcDS9OuIMf1ft7w9eMJPzdM
cIjcFIGzpBOzxDWf1OgxI2NeP9mXDjXCTo05aZdbzo2JYeZGPYOj0+rScuuF
1z16Oem+ltf31TFY9tfm9WZIyMHY6BHl+Bgo9miXODdIcolp0qnZB6ZlpmH4
uTlqFge5eojqpypquqcSK6s32QqLhyj4Slt5suv722s0JFz8S3N2hgSoHMr6
LGTVXHfLI4kNap25Qymtws0inlS+cg4NHs7olK7+jt7uPktPdY+fXwtfLwTM
HxVSA0P8S1bQQryEQxaSOVKND6GIkQ5a0tGvEB2K/xwcuvqhLViWkB0tapmn
0VvFEutSomTDktI0fSs5yZSosoPHjyRF0qxp8xSInDpNPswV8yfQpBmHIlU1
rGlQjkt5jcN5DKa5rEltGHWE0CvDsTvHsihrltzXtC3Wsu3h9q0nuQLp7rPb
MC7eonvz9v32d5gGtHshEbYL7PCLsC4JKSYGq3GXwwGjEptFuOfMRX7QKsVa
eeSXskKnhsR4ZCdRn09BqH4pWfPgry11weZrOlXs1m6g0L65m+QWj7U535aS
gXg2qUdRV0bu2yo1yM2n98JDeiL1iycnzQ4c8zt4NEr0Iq6k+C3EKenZxmqf
9r358Qbpn61gHwUFCfz7+wTnb0ABADs=
}
image create photo ${imgbase}::0h -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP////8AACH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbCMFgwzNa1S8+zzaPjG6MBe8QP
LhgbFpeao1LIjIZ+uSRUunQKr0CozvSV7XziZ1L81XE5amSYpLWe2+43u921
e+JlNF398UdXEvcmiOdxCAhHJXelqKcBOQbiAjK5loF5ZvRDMvkJSVYCeilK
6LlDeaEIdnhyVLUmyEpp+KcSi6i5i9e7O0q7sZin+rsajHvHuYmBPFqc6cxb
ympjWbzSnOWJxrJdhC1jUx3eTVROJI7+GrXOPij13nH7CFzPWXmeCHhv50tM
HymAAVcNiicwVLp84DoNTCcJE6qHp+hJZESxFT+I/xzmDau4sR3GjMoCgXTo
SpjCkiNTAlsZsKXLZzCl7dkHk1wkmSdo9rSJ8luRfLBwYjk6BalSDB6XcnO6
tGmgodeMmiKqwmfCrDszspD6MSZJrEHHAg37cmtNsRZV8gzptq1ItSY11p1b
Fi7eiBw3gPVjd9nJDn+jxeU7uKNVaicZXqQr11hBe/3SKp5Zh7JmWVqbLEZc
a7Pm0GQvSzms7rO2vT0Km2VbNUrfT56ZNEyZwfXVxHc56dbEOPCL3lB+h3b2
uEvkMMazAeZsq6sw4wgJRmc7XXVwfKRJi00zRrdwvd9lXXA9G/l4wtqfIyRv
2fTu9ep5117LEm3gMEIK32FGbBdAFviXnH4ibYHEgO0dFJ930HkhhxLoVdbV
dtEgV0Z/7fnRHUUd1pJhEs1BBeIQGpKoU4gKolgDghJuyCKGJooIY4zPvWjj
ai4mleNTPYZTwY88TGCABEYeiaSRBhQAADs=
}
image create photo ${imgbase}::as -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP///////yH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbZyMZyCGP1jJfuleQ+uLP0fsRN
MBUsFo+jpPK3i96ePumCuoQ9sFDt1MllIYc0cPg0tk7PKjO7un535VRnnI7+
uvHA25XfUtMA2OY1SKhjyICYKOSQcwfH00QDuTeTRIapUKcXibKodBnDyZn1
VFr2GSja46qJM5qXRjvXRfsq23fblNur6wEc7BuiarxpWUtsSrrap9xrzMwq
U/paDC1s49xhPVZW6c2toT2ZDb4MS1Iu7Ut5JV4YiPuLq1oLOn+fi02fllfo
Hzx099Cp6zbOXMFvDKPBA6bNnTSC4n7lA1XPkUCD3y68NcLI0d5DfgeNJOTY
LkJKcOtOkhQJ02JJci7xLcRWUKPFlrP2jQw5aOaLmvUWbYHAchfGou6MBhW6
LaBORSGnary41FPHrbD+8AyI9OrUR1hnkc3pc9pXMaHMZWoLsJNXIuxazrXV
6hDdk4m27GVkCXAsvoKHFrZr+DAQmooR9pvU2OShunL8Un5jmTAfvZcrT+vs
WU/kYIxHlzX9ATQj1XIFDWGNiowp2LETV0Kd1jXusX4005ESdXc40cK/BS9u
xzcedbS5xGmO5bnywtB/VxDOYYIBCdy7e+duoAAAOw==
}
image create photo ${imgbase}::7c -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP///////yH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqZWw8axGzLyfdL6iPcfjQH6hhnh
i0dMXoxG5ZCJ9CRuUxYUtJgprNEa1qaChbvNIjh3RpG7GzE6OzaT4K1tfTya
Vr/51H7OJiXBB6Gm8XckEbikuHi4htjoWKNYIkSXONghaQkJpUdZFrTVhyjI
SOk1ysMqasaaiJbp9krlehpKy2jayfs1m+ZkuxuSKuzziXwrk4yDSbSs9ax8
rEstbN0TLb0dp6Tn1w34rXn91HiexGmuXMne7pcLPSn9Ejt/fO8kXssxre+t
ji9C9PwVbBMM0L8fBx8tFPRwU8NXdt5UNMRlIEON6BLxpOJIDNxEVb0KbTQ5
rmQEiOUYqnFnEKZLlSgRysSlsljEWTovznxpzxifoCBHMePX705GpDyV5nvK
9KksqfmiUk15dd/IrBi5qtvq9VdYfGPTlX13duOjtEDlsIXYE4lVqStJ4ok6
ra7VohID6d1apVXDwADD9UH1Mt5OeaUu+ey2LmbLZ5DR9Z38eGJkmy2FIqaZ
jeKDrr0+bhPpWaxAvD4Rur3Ld1Xr10eWxt4126hu2EhDf65tmxu9K/WOFiT+
VvXv5AZdM8e5+/la4Haly94z96qb7Gy5pxVhHQUFSeTLm58AoAAAOw==
}
image create photo ${imgbase}::jh -format gif -data {
R0lGODlhRwBgAMIAAH//1AAAAP////8AAP8A////AAAA/////yH5BAEAAAAA
LAAAAABHAGAAAAP/CBDc/jDKSWtQS+jNu/9gKI7CFZBoqqrM6r5vyw30AN+4
vNU27q+6Xe9HJAU1tKJSdBQkl9BO8xmtTodV6HVj6XolI9mTegIFkjWn08ZG
l1Fvc3k8lDU457YavXbOaQQbBGkacR9iPHUDZQEFcXk7MzstiYGDPIVhb5hc
i4UFjp2JozSUo2uJJZphniWgb1+mpKeGHk1SDq6hn429u1xIs7Sra5ZPJ2y8
XI7MvYUnf8KYtbiobUnIas+8zaEt0BqX0gOB1HjIs6rgrozdzh0GguOBqkzo
pCW5jbu+/Yfh8zLZEyCOR7lW+2C5+yUl2Cx69UIgSlUC4atl/X61MKBD/xge
YtYUtXu0EJodD/g+DhSC5YxJWAxK2vpAUaVEQ1gq1trnKOOjW6iACbzJylBC
d+9sony2aB1RJq0wvnJH6FkuWzWcyikq5dVRBokaTL2IlRFIM1GXgWqWh1TC
pPnAml0pMa1VB17d8tTYae7Tuj/Z7F0LgbDXoVYjboXK6IGNmGsjSz7ctLE6
xYfM9UXk4DHkyT3vXX2A2ZbmQouorOnsR8K1zggznc6nqYHqUrb36M5quw7p
2UDVhr5d2SWE4rfv+F0scWxP4rZhVYZuuXQ1JszGgsWC25Nx6t5oAx8fcx9y
7nKbcm9K+Nz4MGrZ5x2iHuyMzxdfvqdrfDIkJP+5BTMYWYnRZYZs5bk2CX0T
hHfVX8zpQs1/d6x2CEMVQpgZOAnF9U0e0jXlITQOZhjhhnh449WHcYknloo/
7XfTN+xIaFlbJj2TX4nBbWMPjc68tQ2OtOWzI4cunYUiRjayqJx+RzLFUGa1
ceiNPiCK8qFyKw5A4ImmkTThMZxd+NxhBm5o5QQMMijBmaEpGWaK/lExnRAD
grWijHIAKZl9k3yHJ096htZjkTPS+Rx6Lqk3A3IrfkklE+Kx85+ASX63HmQv
TmkafEVu92h0m126GqeSfkqpOoBiKtdxsI0q1qG0jrjJecnk2pqog5o4qUT1
MILbdoIpeN6odqkKLGn/HqbRqX+UxBpXstcty6pVnoGmbbTMJpnmTL425tWe
+BFWLB7UngOqtxENRixv5DbBLpgN6WRiL4T2Bu9eO6XLBXCoTWhYYOy9Jem8
vx5I5Jzy+jSVUf76uKxxSABrS0kHR4zogUNVhYshSLUnhV051dpBTUpx048O
yqXlsckscaISlz6lKOytVcEcksxPSuXPJ/y0khLMBZ1iHTvuqHUzQaSUAzDT
0tAjcM0Sjrizs08XPQpEO8lU42X30AKw1k3LJp7XHakRtjUb/zMOJzki/fPX
yfxhTA+1vk2IUV5XzayGM+mNTSxKByxnQ/jg8640CgUdB89PVwI11vRJIqDN
XoY7tPfTqEAkDmp96CF6WhV21AOZoMJxzR65ouHvrcFI3GcstFcghLJZLKGa
7LkXsXvbvf/w+6HBrzD8bMWrcHzyRMjMO/MvOA889EUQT30MGVyvxAUK1O79
9xQokAAAOw==
}
image create photo ${imgbase}::0c -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP///////yH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbh+Lrs3MIpQ+eoPbqyDuT4eryg
cTN8WX7HYzLZjD6LQmYNVlsStdUEbcGacjWNME4lVpLPaPaO676Ur4qsut61
7rz2kvev1xUz+OYnQSKBBWLFJ5eoiPRomAHmmPjxCNnBVKl16ZE5idHpeRPD
ifp3qrmJdfM66uNJiWe5NFsYEcm6GtjYVjoX+2tZOxyIyfNAR2wko9psGB3E
iJxMhC2lOX0N0WTd9knNayYOBN6qGGprVv4Dhv1uXHgiTKh8zN3K7NtPKlov
TrBd8xCRA1VwD7pIAbPpo+VwoSOFyxYdAthNF0Jz/wilXUz3MZlHjSBJihwZ
YpVBaAmrNLxFaCXMh7Rm0Lxm82DJLy1PRvnpEqjQmkOLqjEqVCJEpWtursmp
02LUoNJmKuWDj55UU//y9FCJcWNIgiY7rhzbFC3VjN7Elt030sHZigZfApo6
625Ad3jJtguXsGuvvhMBTzss0CI/dbJiDu7TUB7LX4IVl8vXFhdkHevGOZHk
jPBWui+Jfo4oml2spD1xZhujrbLbM0yLsbJnO+2c2qqXIr7dlilWzQOHWWU8
6FlfeGB7q4wH6Z/Ezl4zN4fNljRZ69LxUt+uvdlVtbrlhnX9anl6x5YN8+SG
B0pkp7714JBPkffjp0rwx0NNvR9RsBw133v9wEHFFZwhk4Z+SBU2oIMP3rEF
gRPu1V+CF2IYIYAX3qfhhgqNIaGIDJnoTAUockZBJi6+COMEABQAADs=
}
image create photo ${imgbase}::8d -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP////8AACH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbXAMPsTLtCjNP6acuWvwt6eoNX
UYjcEI3JJsZ2yzmnRNyRcw1meaPfFaiJCcWtbpS5se7UqqU3bd2e4vJPVYqh
g036egfKltHHMohiBtK3h5hoWJJIRvKoyAF10/GoglkCOOlFR6jHZQQpGLpS
uNn1CRd4Gtem+oqFN9Oa6kkb1pm5O2Rmm5bkB8I5PLVTaXx6fFHZROrkjASM
JK0lG304bdpkrYOa5F3L2K29JlnupBlufr2ars7NfvwOP0UtJH6urKN/GQmQ
hT9WY3r9afcBH59cJAbmweZKISWEs+ottGiHIiuI/xc5ZuyIMSG5hhofrot0
0pejlCJZTgTpsaW8jzChrQx5cM7MmzFz6pQo0ybNnwYXCR36syA/JSX/IQpY
hlmUpTMcRixatSkooFnv7QxitSZWWPHA5dMqlquoZyOroSWqlmzZnv3ewh0r
1+tRsHZ5URXYN9OzDGGlosxS+IUwo0AST1XqYVXiuJcYjpJSGOdhy1Mx2zXL
E1+gsKA3KyRl1WXktoIIo5X0F/at0HQrfn2ZdmvMVqRvB2X4LnPt33WANA5M
2bYf41cc7006C02IwD8WVx5N3fBGxNm1P5Tu2Pv3NxbCiyd/pnz388HXs6dl
/rxK+dEq0K9GQYL+/fz1GwIoAAA7
}
image create photo ${imgbase}::jc -format gif -data {
R0lGODlhRwBgAMIAAH//1AAAAP////8AAAD/AP//AAD//////yH5BAEAAAAA
LAAAAABHAGAAAAP/CBDc/jDKSWtQS+jNu/9gKI7CFZBoqqrM6r5vyzlwbcsb
be8rnp+8IMqnIQqPHaMRyVQCmdDi8xetOn+WrBYyknmf01lgMBiTx2Y0uVxm
dYFf6odxrqfZ7HBpqU/CHzltHg1ndA5lhoM6M29YU2lJBARma5WWRBFJjSKU
j5NbepmMnH1ii5JLJQUBq6uKgKMhPg0zBbZgqKWsu66vSpt7tFK3WKu0x627
psHMRcCwqsS1xy0Myb3BFM6kzsfD2EXYj9d/WSWNE9Hg1mDTyVLmpVTp1uLv
2+G85Rbn3PS29pQ1U6Vv34mDOuRJWYgQnjh2IApKE1YuBzABBgIYqDXx/1aB
c8II1nPSR+GeZcXgtDKmaCUXeL+4cQKo8haaGWWMGTvYr8vFOTTL4Tl0JuhJ
RDJlmYS4Jw8lRGsiuIpaEtycpT2bqrGFCM0fggLIFBhwMoc0pW9oqKETtVk1
YgMAkn1A8+eghVrZcIXDsC5XW9lYnY24lOnapzje7gwrN3DdpBHB5h2zt9qJ
nHXFknE8+OqbiU4rIbwsmIYlzlYV+VR2mPLYansAZo67mW5n1aRsGiIUtQ2a
ZLTickVduEtQCMJzrpXtdyxg26n9GLfJDPEu5TuDy+UtOLqY6eKKJO/enflU
2ng83pY+kxgY6yOzU2Mr+jHa9ix5usZsnrkXsf9jFbXed/jp1xRVr+20Slxg
WNKVfYSBB9tle9EkSAlIBcIVUuTZlURd+onWoTc4iQYShJ4VqN9+u1TT1nvj
gdQhZEDpRkhlfHUS24I4OoAibrKAiKGJ8yhmjIn6/chekO6ZsZcYF/52S3Ig
7eidHEzu5CAYCTbAI30cnjgglhFZCOAZZvXnX4wrKklglk8VQoFLvBVi0Yz3
wbmhk7WpuRKPr+GDZ4QFyincWIHpoxxi1Q2aIpw0/PVReRb+xqJUY+IFqXbD
+XjdQXjI6dVIxakYHHrqGIXQeIb45kqpm7Zwmo8LVidiHuGwROMgx8mKanlj
nHTja07lk9WjZdpIYaf/I5V1YCG4igRrsvIJIKk6DfXDYrFlTVtjtYfO1SQ8
Q0J700t5JvsIhX0mNOp43Hbj4TRXrSEtUVBRxW2L85KpyFwImdnVHRQ5CmRk
JKzY4oKPIPKYwUsibEpitvHrh0cqhTSQsxKjJIZuD/HkUq5WhZGKReRq64VN
9/AaUotfZXvyNoCM9gU5WORjT5OZzCyjOQS13JM+aVrWM1Zb6CyQoLqSbHPN
SGuh9DpmmUzdzyr7lKgoQfM7X8n2QePze6NtrM+rRsNcNNkUaz1xVURfhUqa
68yC1dtK4Cw3AY6MfXffJGkxSYkXEiqLH9BI4eDiZcxd4rptc+JLKF0NXHlX
VXNECcvYV1FOsB11ZAhkHBzPwUKoauTRm+ia4EW6UqDEzo+m/lYhxBW2NxGK
Sbm7gHvvt+8O/BG/D3+DxqUbHwPyPitfQ/POx5BB9MRjIPv12FOgQAIAOw==
}
image create photo ${imgbase}::7s -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP///////yH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqZWw8axGzLyfdL6iPcfjQH6hhnh
i0dMXoxG5ZCJ9ERl01y1WcSitL8p95igKljCL6xlU5WrQYfabc12IttHvCRh
a/LbOoTEh6e3lzcIJiG4t1FoWBMIsnZV2PXY1RZ2GTaSNrcQ4ogJiXS2hMkz
JupyGip66MnBSvbV6YpKGGuFC7hK6uSz8znre1faiDJ8lGW8uzzTjKb7+5xr
myT81vs0zQxHdC1I571N+ScuXonznYqofc4u7Z6y+Qrv/nJoPV6HrF4kVa3I
mTN9lwRC65dJH8Js4ADuwsapIb1Efhh2stNHYrd/4OEearR4q5zHdR1hTRpJ
ruSik624qQz50qTGYBNXjpnnUGbDe6C48cypE1o6hMkOEgSl8CiyjEv5KW3a
EqovolJRVjV3VQnVrLS4YvVaD2yPrVljkb1q9ilUeTVKif2oKmk0lybPUJ0L
7mKab6h4LeuLLyEwl5uQNrKBMy2ra4xSiiwmhzBGvTElwQVZ7J2ly0CVPd4s
OSLljaBD4/UMEgrEmiQ7q15NFHPbyKvFnH4t9MZtNlvVfirt9i1F2sL/BS3e
lRBy40WbL4cJ5GzTXtLfVhcr4rkaCoy6e/8+AUABADs=
}
image create photo ${imgbase}::0s -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP///////yH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbh+Lrs3MIpQ+eoPbqyDuT4eryg
cTN8WX7HYzLZjD6LHZjOWlsStVVmDXuacpEK2oIlVmoaaJxqWs483g76OI6J
7Oa7PYQkAebh1aUHEtgHGCgot1jixbjImOeo2CgoKXcp8Yh1RllGhBcDmhAS
Y2qp9XkRx/PDirq0OklGG3sp5LZGqMrHm1qKi1o7+Lrrx9Ykc6MWxukEFkxn
aMQ0nfxnXUwNHdTbhrhtttmMfDoD/oHtSpvbFg6OLQzfPU9MNnzIDXy+r5yo
069/dQISHFhImypF1Yw1XMfvlkJd4vYJ9EYRo7GL/w/7ddTFsQcxbjhE3bN1
cZYsgipHQUynjiHMeBEz1mwUJedGnTxx9vzpDKjOmDbNuOwE8ybFmSnRHc1n
wx1ShqZMxiw5curBiVA/otyK0CPXLiHDlhsLsqy/rgUXgl0rFqDFbPpswk1L
l+jZk2TtEdInV+szvoSfzv2yqSU7vV9bnD11TqnPb5UoR6sIhDFVrxClSe6M
VialZRotbRlzuW1eKvbiQjLMR/O7uEvtptLcbuWtUoqv7WKMFdm04LhiAa+s
shXyVZNBc5ZoFlPNTA5L431bd+9dXqsNa8/OvfvNjq5Yq5UctqT5sjT/FoHS
OmmvNLJBXZH3fn2Ybztv6DEX+gwX8AGYhRIDEhiggf8hOJd/qDGYjRr1QbjS
gRTmMOGFQlSgIYYUSAJiiCJOAEABADs=
}
image create photo ${imgbase}::8h -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP////8AACH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbXAMPsTLtCjNP6acuWvwt6eoNX
UYjcEI3JJsZ2yzmnRNwRI40CQdksafm7hnNWcaesjaFGYabRmlZ7ykV6CRzF
0u3zPfrLFrfl93dG6DUUGJdxiKjRKAcC1Qf5AbmVaFLJ1bim2cl56Dmm9Uj4
6cfDRhb5VliSqjr26tqK6ii5uscBN9Or4hK7YbtCfBfIdyZkJls7RaVY+uw0
eTMNfZ1tUa3dxN2N9M0biTsOVM4hbsqKrsdunB5tCJds/g6voe4OOs//oV/r
FCV/mUhcYsbo0jFYCgeKAnRLmMNdCxk+tESwoEWK/wYFVozYbhjHjyARhgqp
RF5HfCdN/lO5cgdLjcWW1YAJLgjAnCx28gSG8+cMn8NsDg1KSSamUSp+FUOZ
8qnTki2QrqPVEuoTq/vqYZSYqyRWkRfDbgRrD20Hnwe/Zox31mNauTQnqu1K
dy1XQXcD9s3AFo3Xq2oGw40raGXhqXXdurr1mKlQIUQnm7Wscy9mLPk0b5Z2
oTJmp6I5B3E5K1JpUjrwxVrNOOJcOaUNZ0X42jPfpW4Zv9vmuWxvrIuvEN00
3HbUuMrxNge8t63dkY1nUydMl3T0hv3KJguM3Hq9c8a30xvrnK8eNyE0C46N
PfH6NsBPdJm5L3L6+p8ViylZ/RN5oek2mYD89dcHewDy9B2BBXqxIIIR9icC
gj1RIEGGGm6YoQEFAAA7
}
image create photo ${imgbase}::js -format gif -data {
R0lGODlhRwBgAMIAAH//1AAAAP////8AAP//AAAA/wD//////yH5BAEAAAAA
LAAAAABHAGAAAAP/CBDc/jDKSWtQS+jNu/9gKI7CFZBoqqrM6r5vyzlwbcsb
be8rnp+8IMqnIQqPHaMRyVQCmdDi8xetOn+WrBYyknmfYPAgMCiTyeO02dzr
Ar+5IoEgRp/XdvZnOnNLdSUldAN0OWMMh4gNeh4Ne35/UycBg4WGZZiZmXyR
nJxJn32UZJadFY1cfSJLqpSlRUl0sqOoEaohRHxhjSVvs7OgE3Grkj6+r4GT
k7+0praBxFg4y6RTBY3MpVmw0b0P3K6Se9lvWtC4yra7w9ijwN4W5yAtwsfr
Ldfu+s4S8nvpXKgREtcrHzlTyb6FotIrIaxRA2/lyEYHIDhH/lBxMBDA/4Co
SsXAzNE3Z2SwR93+tDIpUZAsimEwttS4Cl6xDodgIsMFiecuB9cEbKo4K1yK
hVK6JLW5aFO4lxWP9pwHjcYWYUpTUk2X8Co9bzW1PnJklZxZrjKTTP2XKBnT
bZN6HeIlttGhMfBKaNqrCS0mjGn/uTnzVRmhMgQQKz4cd1IiM6OQNiSW0yKa
gYkzU/oLtimDkqwY4qpcqHG1zHMws2kMeSSgeZIbFLVZCfHmw6vpyS5ZMbZv
Zsp6k9WtzO3uBztBdQEu+3Nj48aR8ybq203RyuHQEjf91EHUurFcC43s3Ovn
6dSrr+pthijoGCOFD1KPrsWY9BD56r+P/jMj2P+DtXceaObp450da6GSGHmR
9RbVT8H1lxhn4M0wIWb9FTdNLw6W5xxkCSaBGXIMXjXdh21VOFGD/e2nH3nU
DcAhffPcdyBLPfCGYnkhzsDiiQXKR8aMyflo3Y29daVdhOWRFtpSuLino0LQ
Pdcgie+gs5x0ZDk0HEA8Ojebin8ASZxei8miWIlEBkZTfechghdrqpWkWmGC
RIYXmRy6BplftmWmWm70VDQXn00+ZiVuEza6ppWKPDlZfX9wRpaLe1l2F40o
+TgXd1dFR1iP7JxE1lkHWfUVosSAGipaGSkXVqsFbvcQqdyQMKA7hjqVihe4
xjoOdTFiokEBqsbBKV3/ur5EEiKydiKsaFQFM018vBrVkrYhGTmrj7ro+Is2
xixY2kYdectTXlUNh22WpW5GSzkOTboVlb8ehOwbFtqopEKxvdVPnswIkA+9
clgCZrI1bSHHs9VCufBwSjlM8D7MusTvW1BWu83DBXcQlBz+xjRNwAJ/A/I+
eFqoMLjqRnyKhRA35AkYasXcacrthFyqxrkC+C3H1sYzUcnB3uwmmpjuSfK8
4K6z7kl7/JkIYWccDTVC9u48UxFrpJHH2BO9vBQcQ3cRtth4/OX0hmcjDGet
dJ/8ZhVIXIF3EzfvzffdfvOgd+BBDE74DYFJeriuiUu2eA2KPx5DBpIfcYEC
B3VnXrcCCQAAOw==
}
image create photo ${imgbase}::8c -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP///////yH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbXwsayGzLyfdL6iPff/uL5hhqg
hUZM1jAwpXPX5CRwU5ZxKVXMtC3hNdOw2lRXJHNMRqO86nM01yYh30WuuJqG
j6Z4ED/V5yckGCEnsVY3WCOhmHhoCGa3+NjBaFap+GbZGMlYYkYHsyeJyTfJ
mRW0iHXkwhPoUfV6GTv7sAGbhirYettJ+0ka3OvgNAQVsmrsc5m7vJX4TAQs
Pb1bzXxdq00YQ739/SMMqTtOaF7bRRe8zlvuLN4ufhcOzo17HzS6v8YPj98P
gqFCwwZSyuKJ3DmCpQ6mM8gQoUNMAfecgphMHsB+/0d6cUymrKA6KvVSqSsp
MV8kbM9Qsuzy0pjLmIhOqnR0U9Udkjl1susYshvIf3UqZkTnBtBFkfEm/or4
cKFAe1PdSfXVECpFdlWphmHa7Y9KsUGt6pn5VIxNtMSIbjzrFp/GrXDZnmJr
d27Tnqx08fTGl2ZUwdkIj1xpWE/RxGFD2mVJMC/SvTjHPI67TW6xvkJtffSs
6o/PhUfjilqqD1S+TXu7hlptqTVW1K24an3atSxnr3E0z57HkexP4WBtb/mn
qefXd8CW4+191SSr53pTNmcz2ihgeGUCYy7lNTtje2fGK/xiXjr69IunB47p
/D18SY/Z108vgn0LCpv6+wb/PwEABQAAOw==
}
image create photo ${imgbase}::9d -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP////8AACH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbXAMPsTLtCjNP6acuWvwt6eoNX
UYjcEI3JJmb5OzqbRJx0c91lUSNjjhMThltdDTBj1X55ZcwYbd2a4vJhO22m
1z/6vfL+BkfH0sc21+eHhchVghjI55h4YfPT4ahyWUL56KZH6MkYxSka9zkY
epqHZ7qm2ZWqesYqqeECqyom6+qla5ZE+9cJPEWGRnxMeaycrEzM3Oz0TDIM
Qv3UdmgN1gsi7bE6A757ckteaph9jgk63shuXm6XHv+92A6ZOR15j/+uX8iv
nzh39Dh4U1RwD8CAArndcFjQILZ/EFsJctjhoKWK/wO9sNBoaWPCGSBXLExS
Ep6/ICkJ2kPS0mXEjxODnIRZU81MmuHqdXxBMic+nxhHdRMqsqhSo/JUMr1B
9GmweRZlVm1qVeq2ndeo/kzK1ULKSMPIMty6suHXWkhjrQV7NWPbi2/R1u3q
FKNaFTFJaaNbzKRegjwJ/QoKrVnfxOgYT1nsGEsGyJGF4TV5WOCkuQhz+Tm1
+G5UuEf6hkUYFzRnXqLppl4T82ZWjpervZzNNMvYfbjjsvXq2666o3m1ov7Z
KnZa2/HAmR6+ruOo0MEp1uEG2ThzuLXJZRYuhXJkIEDEOyYffnVlOEzEql/f
/uFm+NFhv6f/MJB5/PP57w4Q4V8NFEhAYIEGEmhAAQA7
}
image create photo ${imgbase}::2d -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP////8AACH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbXAMPsTLtCjNP6acuWvwt6bBmg
8JghvozIpvLGbCKVseNAmhwtr8Iq1tLzRU84Lja8pJXHwXB5tvY6tdA3K87W
PXd4+XGv1ufXRvfDJyhFNLjSd0ZnB4fn+LOmE/flcmmZg6mluWk2SbkI93Wh
mGdaU3ijKuqqCgj7xzo7Z2sqi6tXu0vom9gLvDo8JVzccozMo7xcoutMAh39
MU3dYX29ka2d1Z38rcIdHtJMjjEenv693t2u/X4dTz0fXe98v5yPvF/cP/wP
WEBfA3cVxHXQVsJZC2E1dPUwlrluocqd2+BnYcVAbnISklKh6SCkSHYKfrpT
yaKURhyBDGTJEd1EMogseUMi6OOMgDmDYYEJMqXKJkBpQjIplJEZlzOV6iQh
hqmqp0ZlutpI8ubFURoigtrWFBkbr4HSgAlb7BPZlqHW+txarQJcDhMMSLiL
N+9dAwUAADs=
}
image create photo ${imgbase}::kd -format gif -data {
R0lGODlhRwBgAMIAAH//1AAAAP////8AAP//AP8A/wAA/////yH5BAEAAAAA
LAAAAABHAGAAAAP/CBDc/jDKSWtQS+jNu/9gKI7CFZBoqqrM6r5vO8yDQNdw
Dsu03etA1smnmQWPqRbRiGyKlDenFARlTq+bqhU7rRKzlrA4MvJ+S6gAYU1Q
r93seHzooVOHVqZ9g+O4G20Mb3JsdA0aSiE8RlF7Pn1ZNzeBf4VZbYgDjh2L
NY0dkpwSk4BKf5mbfqlZHAWSBaIUkoZvqGWriBuukgOwrKIlZCW1D7egnLq8
vX7BrCfCang2aE92P7mPyn2HQ89o3t10ntSKdLvLudqhAgZ13+/dmPDGAucz
vnjqOJvg88OYxaoV4YWtnjJ8VOZ5Q1SrhCZ69tCZO4goQDt3/Raecoir/5mG
c77IGbwRsmKLbgrJRbMlkM+WPeuYBTOU0tDJhy35IAO1RdWHjO844SxX5gMk
mapQAhXaMVHCmfQKAl3oZ+idouCcNtvzTKm/qk2bbg36zVGiqT+t/gyLVmSd
MWCjXqVaUR4YCA3/hQtI9AnZmYIqBCMmSN6psEWpPZgRmAFjbs/enCQsWe5P
MJqiPdYcYPOYyW7fYu18I1rXNowzE1pNCYLlt7OiBdr8uKbi1g5eC6VReBBp
0x39oM5cUXdV1YVKBb4rgaFm4lpFP9E05wFAgHBWR3Y8PHfOO8khUwokGe/2
NwO6Rwf2JLxN4PBLGyaPWr3xS+ptjm/AayV83P+HfPcTar+ZAhyApTjnQHqd
EXhfXQRostlM5JE2y3UO1NdgZ4hVk16EBZ7WmHkKzkCgawLWkdoamU1gl4IT
fCihWtIpwluLEaoWD1f7LSghixw+CBh/ajw2XwQ9zrQiiB3aWOSTrWGnjWmU
KPljIEJyCCKTCQ5pXmMmpbZSirFYl+F2/Y2IZZjUvbjWLYxtWaFzpSk3InOW
kJlUnG36h+AfB56UYWV6MsfnctkRcuaIgBRCI3tEOUbdmILBGGVyjGUZTpzB
3dVdG9WVpimJtnVFm46z1TkqXqzJ4dhvWAYWW2iQJoTdZ5Jqyd+kHNJUKIST
3UoYYJulWowpWerFUJX/gHpppncm0epTNQFtpJcwl2iVVZZWfeZXTetN6+Rl
S3nkE03bNkkFjW2dhIy27tL15nRm2VaQuXeg9CtHGPkTIFLHuLNvkO+mVCNP
R7l1VLiRdIWuwVCFFtO91+Cb1o7OGOzwHhGVNNE9YJSB00ZobWKAEhGBjE3H
xdG77MPl7pQyOtQo03I53DRU8mXZ2EwNyxb3i3GpHlykTw8f08xwOtO0vHNZ
4uhD8UtijTPMXrlR5W4yvIQEU61r5WwYGdHZMbPX3MZjl4WeNdfKKwDPO66y
gwFSJ7YDVYxGFI00NfLahZSXY38e6L13D33T82+igfdorU4C57GPWAO22jio
Rnkm9oUebOHq+QQcMDI5F1hEETTpSPywNOowmL466yuIfjPsQDDBOe21I450
p7iDwPfuvV/xevAumEB8Exco8PnyzEegQAIAOw==
}
image create photo ${imgbase}::qd -format gif -data {
R0lGODlhRwBgAMIAAH//1AAAAP////8AAP//AP8A/////////yH5BAEAAAAA
LAAAAABHAGAAAAP/CBDc/jDKSWtQS+jNu/9gKI7CFZBoqqrM6r5vqw00Dd94
eQp1n/+snW02ABpHsiGveGx6ksylc7qBbpTUppWYnW6lOot4DEEKo8NTgMBu
twO0nVpH2MXM3LzcXV/DB3OBbHYgURyEH1A9THt8g3FVagx1IjVPeESWGnZr
b36QJZthlB+LHYhPqJqcjgyAOocOpBwFiwWHmB1pVZ51caglgH4dtYsDt6Ii
MlenvG6uci0OwsMbxbZVuUuGrH2+r5Lhv7PGpqHKdtfI5yXPcMvJwdSU5cbs
IDLXNMiNk39z2TbV8JepXjx8Z8w1GvQuFKcqA6sJ0FdjHbBYGijya1en/w+k
ZQ0EjktXzmIudQE7uXp171QPghmxBQwBT1O8BqAabpL2TdisbVhaptLVDCJL
HUf3rIR5JajQUxdn/nMWkmowpswuoUMi8gHHPrIoyYpalCZZh7/ChOvEcK3E
SIjOwkv0L1DVnSClvZ3UB9dWZR/d3oU7Cp4flQ61JQIkNqReCQ6Zsh2EV3Eq
gl7Xqg3XjhPMw5ah+mksLbFdxwyhcpw7FB1YUo4db1bTNi5ouXI9+hP8WMZo
vXB9h471bvTrCTu9afYM0KwZn8Vr021L2ndp3Eigu6JTOyzOYWNFlf5r9rCw
ImFbmb+tUk5i8giVn+dxGIIn9K/BBnqKUdnxhv/o1cfXbvh1JBYs7sGXSGS+
wMFDZ/RN5hF9npRxEF1mjPVKgPTstt47YJmWoHPKmDYhfif45M4/ykGGHToP
+PKghxHUQABjIF4XxnDZ2CUjivUM0AaOKQrolYKX2eegP0KyEeQwRRBpGo+V
+ZijkBFJ0FeURrKmWokTyDePOyg+CN2USBalYwMNRsfmdqChR6QDVLKj5SMR
8gEnPfRJ2RxCXEXm0CCUadfdllfV9xOGYEY2IIF86adhhET2lSYuAD1Kh5sS
Vlgkpy/ShOAm+nU25p1bvqkTiaJytllnmibJEJHC1Omqo7TthpeSA+rmZX+i
vrrTprDR6eKHi7bWKmj/xCFWxnK+/Wers7ZRltmUy3U0GKNmwRYiqZxlJltm
pV5K2FeUgXsdcr2ZGio+gyoXS4jbzgbcVOYeFKu6O+7abGRp5dtSvUaO4qla
SIFjawoCrhajtdOw9O6CHhiiLjjp4pUxvvxFEigHNl18pp21duVXVh6XCLIP
vKyEY79XdQXSytzIRYtMsL4UbF3pkrRPysFOVFLLf0iclzz+WBtTD/zYvDTO
5oFiJ1qRwlbQKk4HmYZHUhOiRhzeWC0008OWqLUl9XUNlYobW1MR0PACVQ7R
v4SLdNgPNVXzxxT9THRxjwlU9SyIWPzrTH0fc4pudIEdad5OwaLy034fIilG
eNHpGVDIZQd9NT70JsNi1XnLDTfFNPsXm1Gd9nx1Gk4T5d+BgTguYYJKwP6x
C7edw6IjSoMBxuG7kmG8BXkMf1YXLuTOyPLMq+B859H/ML3k1VuPxvPZA3E9
8d2jMDf24d9gDvnlHwF++jFkwL4RFyhw/Pz0i6FAAgA7
}
image create photo ${imgbase}::h -format gif -data {
R0lGODdhRwBgAKEAAP///wAAAP///////ywAAAAARwBgAAAC/wSCqcvtD2Mw
h9qLs9682wlK4khKB1ihasqubgu/chrG9ozfulrn/g788U6nkvHoICJgnqbz
aXD1hMGqcMqEarefFpYKtsa+LK5ZK1WG1+Lh8l0+yz3ptwyJT4zV2e4cnVHX
YxNFMVGIWJF4qNh4x7eCwfjnNGnoBdlHSbdnp5m4ySmJ6TmzeHma6ngpqBTn
Fyp60QoXGdvxWPqKesthWeg2+KLKWMxrfEo7PNuLG0gqvNvMrPzZOD06Guy6
jLxKfMwKzX3Ni82sTZNpe95VzW7eDir+lQN+/736Ll0u/9sZDYU8d+Nq9Tt4
7t++buHweTO28OC/hM+2GRQ4EFjBZf+wMircqMNhw3wQQcKb56+iOl0n2+UK
+CwjSoDkbD0ceTOZSX4TsX20aErmy5oxhaqsF5IkzqUagVrrOe3nSphQmw29
WNTjUUj2lIoEF/GjTIk7W1IMm3WgVKRBc3p9e5VjvJTp2Fo7W5bs2LVck7r9
uxRtNqN1+8pNKRgdYWpTiWIE/FVfXrGLCdo165Mm1sFaC5fqChluuMQd1W79
TMgo6bkuT5NhGDl03KdjyTo93Hr1TIqeX2eRzVTybZ61+aLGjXc4xtJ0GV/+
HRx408abFXd2bthLHjyakdfWgJaN+Bu+q363nH28evLrEJ7v3X69fOpStts3
YbGNfvlU9/sWF9/ffAJydV+BJfDzHhTFGMigCAYUAAA7
}
image create photo ${imgbase}::8s -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP///////yH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbXwsayGzLyfdL6iPff/uL5hhqg
hUZM1jAwpXPX7AhvU5VxKUWyErGrlqmYhVvCa6axtVnL6rNjjc5No+AHCiK/
R0iSquebtQfSd1fSB1gnYejnV0P4d7joxhgJ+Tg4NxYUNtLGYdNJB7mpecQV
Yoo4ycN6ytcat+HapfoD65nYuDhb6IjrhAMUCpykxUvcY1yLTMbsvOwcrMvn
M41Ja/2anZV2rActu130q10qKRe7Sz76nW5r11sO/453Lv+GKfiqrv9ZeX1v
nr9LtvjVC6Ro3z1U60ilCGWOm7ojqcSNuRUPjjRx/OG6gRv40U00ZCFHrjEJ
rCRKe+hU5kqDbSOtbxR9lasZUWI+LhC95erk66PQfyD7sdtpdBzBo/SSrnLa
0aC7ovgUBmz4c6rOqz7DCQTYLqclrFFbdh171p9Hjl5dYiHDduDMLtXErFTi
9u5WvXpE8tUI5m+hYaYEcy0MN29Qqqfyps2HsEnIixVvorKZNYhBhqKU8gxa
hc7QpZ6T8hqdMPJBJuOkVmX8mmnT2LA770VLu+1X2bNt1wYkOi7ox09zxnKp
FSkiL8IrNneo0ww6mdHZzKiL27pheYG3F0T81rta8IpNMhefXTP6yN3X53Gf
owJ8PhQO2b+Pf4GBAgA7
}
image create photo ${imgbase}::9h -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP////8AACH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbXAMPsTLtCjNP6acuWvwt6eoNX
UYjcEI3JJmb5OzqbRJzUCMyVtLcYb4T1YqxFMslsLtkywK7VzeWQy2nQGjue
zz/6PWn9ltcXtzEYaAcW1aZoeFXYuNhx1wEZyVaplggCedaIosnnuSn6l+gl
JqhnYvjFCKfRpxLbCneYinriRzsLS5jrW8poe+m4gktbazkmVPx5OzV1dwwt
NNlMvTOJHQ26ze29rU2JCixHPj3UPZ5T54E2nL71Dk/M3h7fyemOGZxPaq4P
kbyAAP/hG0XwUUJJ6gry2scq0yqDDlVJnPgwVMYP/+LW3UP4kWNDiOU0lmTI
YhgXQvQEplw07xi6finrnbp3jWaQSjlbjDTGr9pPWUGDdAS6sMZQd70iLptx
FKJNi3hYRHU4VeVJlES16hKm7OBAnGS/6gRp1ivVsyQzyqTI1d/GYkk5XAW7
MetasW0HmXQqcixghXCVLMW7t2lhDXeT0WkZ5ibkDI2TWUb7eKbhX1k0Kw6D
DNw30dAqkw59uiblw6kBrm79EpdpNsz+ApldlYbmWbhr6S7Hm/WtsH2bBe8a
sngkez5MD1Y+TfKFynX1Tn4tODHhvHZZ87TNnbH3otv91nsyvjritHEaf4fe
Dp37mJ4d22eyOftl2/vBojnnLMVWqYCW1XTCwRYFfiEciGBnBiL4i4K9peag
BROepsuFGLbHIITdeWhUBSBCRYEEJp6IookGFAAAOw==
}
image create photo ${imgbase}::2h -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP////8AACH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbXAMPsTLtCjNP6acuWvwt6bBmg
8JghvozIpvLGbCKVMV3uV52OlgMrrvvtHnu+KCgMDo+30OUKDV9zryc4Wo79
vu164dPLlxX0B8inJRVoNkOWJrZn57SVQ6cCGZmnNnMn5WKpSXkItUkjyMk2
aiWFQdSneolR6ooHK6tKWPuKW3ur68fWa/sLnDtMXDx7jJw8KLysw+vM0xzN
Ak1NYn39ka3dwd298Q2eND0OIm5ugZ6+bt4+/g4e3z2vXX99T50fve/cv/wv
WcBjA4sVHHYQWMJeC3U1xPVwV7l03iZSdHQhYpBYfhoLYWyIkcWohbHqxAlh
cUerSicPojJhqaAnmFWuDAz0SFTGlI8MKduYKNSRRCUX8TRJFCmdf0QVcRh5
lGZSmm7URS1x5+WHMkACqsmUc6cqOqCkkqO4oWTHTyGtoi3S1u3bqm3kzhW1
9Cq1lWtN3T1X4S+HCQYkGD6M2LCBAgA7
}
image create photo ${imgbase}::kh -format gif -data {
R0lGODlhRwBgAMIAAH//1AAAAP////8AAP//AP8A/////////yH5BAEAAAAA
LAAAAABHAGAAAAP/CBDc/jDKSWtQS+jNu/9gKI7CFZBoqqrM6r5vO8yDQNdw
Dsu03etA1smnmQWPqRbRiGyKlDenFARlTq+bqhU7rRKzlrA4MvJ+SyxCgMBe
t9lqOHzooVOHViadVtgUfg1qDIJrgYN2HYh1J1FReDd9f1ElcpVzbUNKHIqJ
jD2OPjc1onqkNJWZbYllnJuhpqIaFKKphFmsZa+wgHcSarKZuD6Rerq7OK0n
ymiUqctPnkagkscDfQ8lDmjKg4SFzCE8pszUsNfZ3Nzb6Jiy7tDGPUPlpud0
dsv5qu+tYAL0M85pADjpGbh1z8gc/KClIIddt+65SijrRjB4RSYtHOfu/54m
hNvI9AP2cIuiWBGfdMw2IEDLlx8ZIsJxy8OPTfli5ithqoGwcCBoYlsIMpNL
i+/CjSSK06USgzslomvpY2nMOjIftHyKUFMLj0evdsrVlCpLqlyD+cS5VRtG
oCR5epzxVJ2bi05bevtJBd02tMDoHuI2h5lLNW0F8ZXJBrBTw4LjdNtXEfGD
X2+pEKDx1GzgrYJQ3dvs1JtVq4LXPs7EeXJhWaS3DsB0ukxbBmjphoyMquPL
2+0yM27Amafno3rlfP3sYAblO2U2zyaeWzduN3OOh6XuvPYT542x4d6aTTTz
5rP1eg83u017t2O2oz+FWWl094bcbqgWwXlysf843YeYcvXZEAY649GnmHB1
ZGdIgYkgBcZ4pM0BoD9PZEcgJz4Vl85hCuoHHTQamgYBgk59SBx2Ky62CHYm
rlWeckaNB+OK61EB2mXKgWEZZspYQltYLkYInJAJ/eiVaPl5NqJSiWV3GzDm
ARMBjTkyFKVlJ16nTQXhWVhkU9idcttX8ohViBzJQbgIKyymd2YWEjIk2XWv
2UdiYxbFh9smccDRZpaLuCddf8d0kl9pz8l0Hy1anVmBlW606aSjGYJ4pmBU
0njWV80JeumbGfZp4z1t4qeMh6lJ5+ZYGR5KXVowIqZbRdUldmFcSg1JF2CU
iMbpqrlpRaii4eVVX63/hBT3V402jjnhIS8tW+tgnNJp1CnHAmosaYBaeOet
q+bzXrc+rgjuNmIOtp1vORn0ZC+FwMSPKqCepy2v6FLqpaKGGUZsZzImNa9M
qUUEFkhTKbQKg0bK5ZNEO63EUsFYQeyKca2tJC8/+tH0sJ5KIYdUxROGZNMW
Ne0HK5R5pbgOUyntp1HLoQSokgRFNVVzPCOjlA1ZJuM1c1IGQVQTR7sKPFRU
G898TB/uEHSNVUjjyzDSaBAEiTsQNY3XXcvZBeoyXvMBNixD7+wNbV1NrE3a
X0czSpq5fNOMxzQ/Uo0RjxCDDNZtFzJBX/Gw3S84gQAJKc+Jj7M4InfBxiYs
cn43QgoamgNOuM7dMGtJ5tb8g5Ldr7QNl53uEuL6WmoPdNMjNvOKeIOoXPLG
G0tFzYQep/kpPAUlfdE0FzkU1DvyMACyPPMrKA+9E9IMPj0Sv1t/vQ6d13D8
9iF0rzr4TnxP/gomnN/EBQoM7/77ESiQAAA7
}
image create photo ${imgbase}::9c -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP///////yH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbXwsayGzLyfdL6iPff/uL5hhqg
hUZM1oJMpXIH6yRwUxbSxolaFdusMNPYalHfYNnMbWFz3zF4zXaTrlVpWowk
x2ujOmgKmPdzZhcxJ6H3Vibht8Eo6KVIxzhIeSjZ9liJeInhBtN35wHKBxl5
FBrq6cLTOMqKSmgX6+BoSib71wpRJKoi12no5AMVwjc8JOiKfKN8y6wGLf0s
3UNdSHV9+usbp92rBqwr/hrefUg+y51eeD6Ilzv+/bYXGK94vKyOziv/kOiv
X6xVlnSVeCREC8KD99AIC1NKmEGGgCI6hJIi1bx5/8eMdaTlp8quhqti6LPo
haQtePjsYepCpCAxlfwkWqMZ8F8ynJtsZmPp0NgYdtvW9Wo1EB9MikeSEjza
9GOnmkJFDeWikea3ha9klqspMCWniTlrdR37jmLYdjqnosu3MaNcnByDmnSX
1tvJs3uLqu0rFjC4dXj51l1ijifBw4jDZVOMqhozxpLdVnZM7/LdM5QlV6zT
eVo/xkTZHjVLWXBXWzo5inQ6LmrIVI3jfi4cNOvLkmDbBg77SSVXtsB9bdVk
2LfUyH/N9nRO9q1LptMZAr0ulrde0nB2M98OGSLUweDhmTofHjdf4tqNNnsm
PrTnhPQ1LzVin02TxvmtfxuXX018kNl3VX87GUhMBQjOQAFCDj4I4QQAFAAA
Ow==
}
image create photo ${imgbase}::qh -format gif -data {
R0lGODlhRwBgAMIAAH//1AAAAP////8AAP//AP8A/////////yH5BAEAAAAA
LAAAAABHAGAAAAP/CBDc/jDKSWtQS+jNu/9gKI7CFZBoqqrM6r5vqw00Dd94
eQp1n/+snW02ABpHsiGveGx6ksylc7qBbpTUppWYnW6lOot4DEEKo8NdqHXa
NQaEeFyNon++aRG7xH8TAnNXNAUbBTVVZkQ9THYcDjpVDHByZzWEhj58emqL
iCCAbRpqkn9/ij6LNo0dMhyHmk+gdGwBNIFLqbmwn6t5dwQDqw6Tlbmdq47I
nqyAwQ1hYbamxrrKomeXvqzAzm20b3AnmNSDu3cnqIeNDNyjjtFq48aE5rG4
qfXN4ct9z4XkA+hZg0QtHzdTot6FoUOOXj1mAuRZMmjLTat+/k514ndO/6M2
UQcR3rmW8d4rjvY0ctT351sVhA9cZVK4hiEWO/rYuXkpsoyikZs6REnoCJgs
kSXmtIow41MiPdtOtJTFbmrPmFCDZo1EIGkDOVNBwXoUCRLRmkiSlSoS9gEw
AVP5ASoF8+kannO6znVACa6EojXcab0bpuXapH2JldzV7NbAiyPngs0bp0gt
St4SZuZrKtRgXl+/hgXLd08VGpJDe0arZzJpi6plJUPdV0dnu6CpivVWumU/
1FgRr+aFxLXShddKyahFO5DbnZ/PKddJS7PsNrQDlwhm9mGy4sZD1Voue3uw
g84gLcV9DpThZzlBis8OXDzRx4+N+66KGpp5lv/pmQYdazWNRgtd3SxHX3/+
NMjeE+F5Y5gzSklyHhwMjsUdfmYYFhc75xlVVUsXdgONhelFByFpJjaT02ht
ARfNIhxuolOGRxlFl4fM7YMdjTWuQUlgEs51nj7hWIjZj8Ah1VFrKG44Yn3c
hPMHMfv1mNqDzKQiXpV7pXalUrcxpxuXjnhJS31VlVaRj5JIdguBvBB5opLj
pUbKmN+QCVlKd42HyI/AXJmgUklmGR6anjTIRg+Gwrbndbr5piIr96l32Zvc
nSjNgYteqtBOvNUQaR8wVVSYTnGJukx1pHBqkaVxohoqnUCpt6GpZvaz3zWr
svonRFnp1saQ/dlW3iP/I04WpFN7RTJMgMq29WVpiwEKLa3IXkSdscnp92xk
VHX7zrdychbbsN9BdWxY6mkCqlE8UCKud2UVWxlSOIlmGWn1HuWgq2f1yG8E
ei0Z7Y49MXofZbNI21WSCAds6VnEbVWdtO5UuqQpF2P8JGE1keVVm7EljJPD
3jHiU2H8vrcPTU21S7JMUbwc7cN4YirIUOyitBFJy13F20ErqwTsVh4BTZYy
Rs7siS7dOfUzPhwP1yDST0SUCyFBnyXR0Mgx9pKqmBYUtiZjL+IQchGDhPY7
aj+mQds9OJSn1qcl2XU6qtiNt9tJscnbjE4SVQ4mS98FkA9Rw/fNZcOO+/fj
i2lUZnKaiSs+VL6OY85IZQHOUl7XuGg7ki5Uu2eivF6RPPTaxQTkdSZyvq5p
0LWnYbciDo3Dk4t7iGfNGYI0bnUKcopIatVAKeG7GWRUPwYX2K/dhQvSu7x9
E90r/30O4UM//g3la38+CekPtD77WKv/vgizuz9/DPbfv4IJ+h9xgQLWC6AA
xaCABAAAOw==
}
image create photo ${imgbase}::2c -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP///////yH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbXwsayGzLyfdL6iPcfnQH6hhih
JUFMFnlLpjIpRPakz1rTB6vueEaU7bl7OVUNLbMcQyu3ilsWPJ6mkNRhdyaB
xuslCd899tbnF4cX1JZDSBSFmEhX8wcoBmnleHR0ZwjpkJYph/nAIqgHyln1
CRpCeYp6xWq35/maOPsqWyuJa6a7y7tW6JsbDDu8CFzccoxMu4xz2/yjDA3y
PM1Rba2Bnb3EnexNJg1+OO5VPnhOsg2+7t3O/Z4dbz0/XQ9935y/vI/cX/xv
WMBgA30V5HVQV0I9sdKJaXjuEZWFziBgOjVqUKhKambEXbPIERaXVLTonPHo
RWKjlIyM+QnH5x8hlA9biswDUxtNdTiJMaQUSdivoBobHVST7M3RL6JOToKT
0dyqkAz31VlI1FI3h1OfpotEEQuwsK3COFRDVs7VnezYuqvAdcMEAzPr2r07
twAAOw==
}
image create photo ${imgbase}::sd -format gif -data {
R0lGODdhRwBgAKEAAAAAAM3Nzf8AAP///ywAAAAARwBgAAAC/4SPqcvtr4Kc
tNqLs97T8A+GoSeWZkme6nql7Lu68CzK9L3Z+G7p/B/wAXfC4a1onCGTryUz
BngCnVITtVqLYnHX7afrzWnDMDAZYz73xjyBwJgGueFsnHs+rd/u7/yPj8cT
pwF49zOYURjIpfeiaEjUyPK4SINoQQl5JHmSycdI4wm4GSqqWcYZYqqolPqx
+og6CRvLEkcrCmWCC3sCxktr5UoBDJwlV2wMspTc3CfG4Zz8NSwhHbxcbX2d
O6I9wV17XBI+KqxSrrsi3fSN0SzrqNxeuko6g926Zwq6nxm54x9AO5QEuUNW
6NDBV6wM/jHn8GGlfm1ODXxIZ8hEikVqVFxS8/FMSDIjw5T0cnJLSiwrq7SU
8vJJTCYzk9TM2FFdTl8Ld0q4OQSoH5/niKLo6VOoQqNHmY5zSg1qNghUq1q9
WgAAOw==
}
image create photo ${imgbase}::kc -format gif -data {
R0lGODlhRwBgAMIAAH//1AAAAP//////AP8AAAD//////////yH5BAEAAAAA
LAAAAABHAGAAAAP/CBDc/jDKSWtQS+jNu/9gKI7CFZBoqqrM6r5v65QNbNty
Pd88e9KaVm+IEuaIyJGxlmx+lj+ndAONTp1LINXC7UaUv2xwFRiYy2fzAK1W
W6ngYNT4FHbKjTVDj2a/4SI5gid/D08EiImKiHl/gCGDNDJ3EHUUiY4lmoGZ
j3KGHl6OO5CdYxxflCCEpHABBKZan6ihrWOZhJKhJbBxn3Zzgrq3OjO5hbyx
wKRhFr+srJq5d8m+0JvQztObt9K7r8rZhuIU3qfd2669nJKV5BPm3N7pt+ul
7ePP0jvTTPPy9cLJ2XeOSbMwswYeGxbQl4YCAQrQqlXIILB/3AjZW2XF/x9A
fN9WYSMobWMdJT4WEtvHCpYMk7VQFkH3b5JGTNXYBUrRr+Y2BgQG4ATnUCSn
ixr7uXwVVCijnPd2WpoAC5NLRUwT6YHKUeYWpn1Y6Vm0CKjTp0mLPkFFNmwj
oGXNOl3TUCckOQQE5N1b4gyhNXwY7cn6FAhRuyIbkMXkdzCfRoro6jocFdJS
vZj5wmoM+PGZoEN1wFQVaOliTGWW6lktt7Cx0aiUmc5MO4/Lzm0I0wX6UmBp
xVgV8+YTGHho0b5L+d3b8QHrNmtAS+adFvGT3K6bMWJNvSnacbC3gGncCyw+
PHjcRH5HuetRd98ZDwZHuDwdWe5LCbb4zLEfRP9C7dacHflxJEFsXXhnnywE
nqTTQQ4UFgRqEQIYjT7WUbRMXxQa19F+/AyUIWmG3WTGUlwgmEplBjbHoVN+
AJZKFWAl595BvAR322Co5ciejYccmBpjacz3WnmqbTUiW+TkeCJ16EXnkohg
5aZWKPZN+eJmuXHXyit67aEki0GCVJ9wRkYH5Zm8XXlHljKcxWWXZtWgWWbC
uclkOxN6N5+XQcF1Wp5LUmHfSwBy6UCRYoJ5Z16EkonlNRzK5xx6jZ52GZCT
anFmYKrhQcMZtDGHUKET9jOXUMZR+FgfbU0k6ZvHRHaVpvONKqVHH5G4in1y
VoWasFU5sxaq1WR1omn/CBH1E6+7IOusVloStFCzPOlp6E1oWVvTSDNJe+iU
OhjmCkMkcEorNirRcy4l0A4YmxLlAXLtV79QdKwn+JUp77XBnGpQQuyS1GCn
yKg0TD/GgMSSO7K5e+8jx3Tx8DgRfzRxQReX82O/CIeUzhwdw9PsJCCvm7C1
g0AIT0bMZLyyOHwGPNlFGKa8Z0UKU8PzwfKK95vGDTuoIq/qqjiVsfDakvS7
WIJ4oIZI11yMV6GAqulooNBizNVSZZ0GcW+Jqm+0G+rMbxDQueH22JJlS2Uz
YIhiN9MlingFFvztLUXffifBTyyBk3HhwYXDIAbiiaeUjdqNp1vMEZHzXTkW
DhlcTsQFCtzt+ecUKJAAADs=
}
image create photo ${imgbase}::3d -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP////8AACH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbWAMcDS9OuIMf1ft7wO+MJQbfL
b4jsFHHBpDNTzD2noZFRymtSl9fscWvVfFnYqa85VuXSyHNZvWYLo7JaXM7j
eu/aod7Op5O01LcSWJgXxoR4wmcW9mZ49wgUCWfpZxW3hzenuSYkCHYlmkV1
Qcd4ukO4Sunq+gfbpjj7JGubmDu6e1vb6wnshCusQlyM8ovMcrxMpOzcAx1d
0mwXOx3aGUyFmdkN+urk6DtFPpxNFliedLjdki55Tms+yT5ujw7urbv/XmNN
nSpupwYSpAYPoY14CjcEbIiKIUQMDydWhHixYUaFhxsRdqT2MVpIZyN39Slp
qxRKDgZNlFkp5h+ITVUK1tlBEyapmzRySmyUT+AXnYvCAdKi85Apij9JuGsp
7YlSfVKDXhpDdB7Ql01dGpXUxQLRSjI74BlbyQsHtC+08aw5MabKrsvSsMWn
4S6SI0PpAqMJN+5OUXqxCa5W4bCHCQYkOH4M2bGBAgA7
}
image create photo ${imgbase}::qc -format gif -data {
R0lGODlhRwBgAMIAAH//1AAAAP//////AP8AAAD//////////yH5BAEAAAAA
LAAAAABHAGAAAAP/CBDc/jDKSWtQS+jNu/9gKI7CFZBoqqrM6r5vqz1wbZcn
Tt98Ksu4nnD0ywWHSE9xA0w6lzOjMwk9Tqk5YNHC7UKIWeNvQC6bCQxCad2S
xsBRZthMRwfUbR2p8XErwzsnAXQMA3Z4cU19DkpwUXwzM2aDBIdskX4cER2Z
mn6QWXWHeFKQiztMjpxZTGeWa6shm5qqeqmShXZ3jzp3nb2fqqhiA5SjbIBo
f4JtWsKMkSVllQ1qsNdppRbRsqx8rNJk1HeItzjKj9u/iRJsxeRp1qVyvukV
1yDNm4XF47v4oNBQA0YB3yKC387pqsRNCbWBNJiBcpTnBz1yM9DpqRZP/2I0
U+usCCgQoAAtetbOiUk3SlumkE1MYYsX5V0pm77g2WskQhHPaqQIGCqGs584
ePWI1Oqjg2EWoZWIGjtaYpxGnzCzZosg1FClqEcdPHxq52Q3MHfKREwrSpA0
X8pyDmx4sOcgomTAcdxac1A9cl/n2SUySSoyQYF7qdWSbeNSh1/RLK4I1a1f
m8U4hXv3mFNkank5I4Z4t18hfeHyDO75edwksQ6kum4w2eJqWVL7zX5dGrOd
d2qxGfwDJrdff3RqGzsNjVFWwn65CqUA3N9Yt5du54ue/F3U2My9PtSgK2Jn
TXhxlkZKm3vgfgLGpnpuN+9pzEYf+JbsPXDz8/9M6GIccKa1V51kd/0j0Era
9TGbfrIBZyB/D6jhD13EsRZfPP7x44t6lFymG2ALDheLhhumBJpUEOonVkbk
QXOWXZExs2F7gdUYWoKI7CJfgw5hFNeGO6pVI2gvtlEjfd2kEWOM7bUIXl4M
xWiNRtspBVeOFOYHIoVA+Wchk/k8wlB5PEp4H4L2gacTkJplpGCCumEW3YcS
GtcYnCdV6B+V00WZS4L30cYZn/MFKORx3xUK1Hqx7QggJlxZ+ZWdhHrFDyHR
TZodMwItFOidEGgagWGIUroFc40amtyjA/p0oizCQeodfm0WxuFlfnkKyKZR
rogTmq+1hmVdtHq4UXT//ImWGDN4kTjXjN0E58adhiFmiGWuSksmU9/oQk9t
VZFmWW7BpQrQZ4jxGsZCE21GqK8BHtIugmyAdYY+m4qrrjZzbVnhNJGFBUF5
9M4qV1xdfUdUVOiccOG3PLHWUcOkPrytxP5SHKcnAdnbHsiHXtiQTLKaBbIm
Vv0npxH+NkSSSXIoxQss4YrskZzkIfwRt3H0tJNESob6Sw7WlUX0Wlp2UW5S
KEMJj30INdM0Fy8zGI1Vv3G7D0xVz1KVM6lwna43qqV8C9aKao00UGdfJAbY
vHyDVcdumd0rN8PQDbLaOaF2Y1qnmWNL0LT+LdOst4wyydov+W0P4DFxHA8h
cD9/IjlCQntzo8Nx74R4massTpxFhxBo7eRh2Fz6HhVJnEZ3VFtRBek12Jj3
7LRnZnvrdnkhvNO/j36FEIwZfzwPyYu0PPNzK/987tE7Pz31NVt/fQxfaL+9
C31/f4Xa4ttgQvlIXKDA8Oy3z4UCCQAAOw==
}
image create photo ${imgbase}::9s -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP///////yH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbXwsayGzLyfdL6iPff/uL5hhqg
hUZM1oJMpXIH8whvUxXS1kngtCwkxvtVzMSt6hF8jlqxuak681g31mF0LV6K
tFESksScBcjx59eXJ1j0h5hmCAIGqLh41/hTxVVHuRF5iGkJM8I2+Dlplxj0
NnnEWOjCQ1bIiFq3VVoZ+wqHK1cbeHvp5AMEKglMN1uc5PWL3MPL3EycFTwW
s1wWrYmda83H7ah9qnso+71LLuVgPJ6+PsfXDcEaz9nOXqlH/02Ivl8uj/9i
W6Ze/+al6WTQVsEQpISosTFMnCh4qlL5CldR4sQu/2jwbKsGLpwnj7E4JhtI
JeS9hNCIbBriDB7AljAVuVQZSExEbyZvtlp1kyPPoRoVXstZiqdRfa6Arsyo
NFc9hqGy6WyYb+VMqyiz1SPJdStBpmIFlvX6taqos2gLutNqz1/aqAjPbZRZ
dK3apV+F5r3bhi5SnDGt0sK5pNo0kM9qemocTBliyGeoOpwMGU9hs2O8aUYs
mN9gMptJO+XX1KJII2RBYUWdYqfkX4VfjgZ7R6rbuGFZVgwzd29d3mNbv4VN
vDjc47eFt90duuE5XJt9VZdu58116X49dyT8F7byJkdTLgq1PWCz5eQplyGf
3n3i+fHds65P+T7mzGzw5xanvp98pgjoUgUENkNBJAouyOAEABQAADs=
}
image create photo ${imgbase}::2s -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP///////yH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbXwsayGzLyfdL6iPcfnQH6hhih
JUFMFnlLpjIpRPqcT6C0d60ypcac4nncimc27avccpjDsPRD2SVHoFScpH6L
s+76tAZPwge4R5WFwkdk9aViM4KGJdbm5cKzOESpJgcWxvbIaAlXmbkJeRZS
Q3pZ2Jf6GcTaehhLCjsbU2vrlxu6y9ubOPirK1xKXGycF4wcqLz80+zcgRv9
B01dfT2cXTK9jerNbQ3evU2ebX6NTq0eze7svgyPLG9MT2wvjP+r38u/658L
oC2BswjGMghsFbhqChdycjTG4ZtvWgxNKkPQ4sU2YPoWiTLXwJSqLxBBhcuC
TxChhlMQ7cE2UgIwOnNmJoRAJ9TET5L87eRpCWDIWxEp6nSHqWjFkUtSiXvG
UqIRhJDwULUD6GoykUbHodGaDOXTcmPPVXAojYKgtWzbTgBQAAA7
}
image create photo ${imgbase}::sh -format gif -data {
R0lGODdhRwBgAKEAAAAAAM3Nzf8AAP///ywAAAAARwBgAAAC/4SPqcvtr4Kc
tNqLs97T8A+GoSeWZkme6nql7Lu68CzK9L3Z+G7p/B/wAXfC4a1onCGTryUz
BngCnVITtVqLYnHX7afrzWnDMDAZYz73xmpVut1hw1Hy+ahu/+JDgn4f5OfH
8hYYyFEo6La3gWiY0ZhotfgI6UhRaZlVgll4yRl5J/LZGTCaqcdnmqgKykHF
CtsY+hFb26rhZKsrAJK7W9s7OfELjHpIDBtMi8yqfMxs6vwMjTk7TQ1pfY19
KpbKjaj5Df4nPs4taUJ+kobOLkzJDLUiP0//2wTPqFumvx+rxN8/VTTeWGhW
UOC2bEcULiTVcEc1Ig6XheNhUMNFjFEVAd2KCKTclI52MrYxqQblGZVkWIZx
6QXmFplYaFaxKQXnE51MeCbxaQToEKEj86Qzag6pMaVLmXpz6orkHKI/qHKE
GhXrU61oIHj9CjYsgAIAOw==
}
image create photo ${imgbase}::ks -format gif -data {
R0lGODlhRwBgAMIAAH//1AAAAP//////AP8AAAD//////////yH5BAEAAAAA
LAAAAABHAGAAAAP/CBDc/jDKSWtQS+jNu/9gKI7CFZBoqqrM6r5v65QNbNty
Pd88e9KaVm+IEuaIyJGxlmx+lj+ndAONTp1LINXC7UaUv2yQNSibz2i0lbP2
iLXtsTs9CNTv9nxcHsr5T3FMHQx4dQQBh4mIe3wgfzQybjsciokEl5iYjFp9
myWDEG6ZhxOdnkJ9bBKgD46BdadrslulVJ+Ajp+DsGCqVmEWtritM216vUGT
wBXCt4CPc6iuya3OXGPDbM270k/PX9/Bt+O22NGxkKHhzOO45eRsvCJ/xOmR
oe26kObc6EDPcnYsi5INoDlj8jpxKBCggDZJxu61yyLt2LxfFSFmzLfH/x3B
hNPmpShIjmBJKiC9KSGhI4wzjsl4WVQo0lRClzihyJwZMpU3Q7Ba6hpmiJCM
QyklrWSlR0/QekajpksKamlMp0ZJFYJQVKYmqqqWMrj0oCsiUg7wNPXaAOyW
lYjKRF17lsCZsou8fu2m9OIAsmmjGroUtAzZwkcD++tj96/RrUjPpjkstS7l
xY4I4537NIJZQGir0ezzV2seM1hNXq2MFDXfqvMMB0ach08YWGwLy0XGWO5p
O3LN5iuBO/Fu4JifaG5L1+i7PJEbAPbD21Hpx8CDOzdJN+ioST0zO2b+tLgE
87X0hVduV3B2rHR8dxYEXuXFRbOZN+X6mLa+5P9uYAMfHu2NNR16vlVRnTdV
JIieJoREpt0xLl1k1TO6peYZZ/vhByBTtODVXnzFoWbedQsGSI1+7p0XHXbS
OZYiU9/BWBt3JZqoh2Yz+pLOdNDVZhttv7VFVo8o1UFcUTQUdxBxeb2nlmxI
BuFakE0695+VHD7V2Ie+3HVIllLZNuBWkoEZogNjZtUhfxymdaSFflnWJlaE
oUGZhEU2NiadnXiJIXN5GnkZega6lQwYgx3pZmdn7BUnlWqutgiZ8EGwZ4eA
NWJfoHUN+iJ5O6am1kOjufIUpjudFydflWZ5JyyRTfSPnDyhup4kOwVFzVDA
WlpTqj8NipOtHn3DUpX3WZaTTUAwefLOrqAoCW1Hw2EkyLTbvqaKtYtCES2s
r1nBkENv1RmgO/8Ml05ATADzEieqGjMUKiTZMwxUq3i7BbjbqJevF9aoEwvA
/AicbRcFE3Owvao9ORAzE79RL4PKSkSQOBvT9/C6LekAzzUCV/TxIApL7Msq
nspyMmwabatvt8zKvLKmmUQkmqd9ETvIKN9VEjPIj/jLMxuVLMInVTYX/K7R
6lX7WyFpBJILJxY/YR2JXEv7nLz0YuzF2OKEC/YVWMTrNdoxZM32EAKt/XYR
BkE990hg2333feGEvfcKxQj1d9qDY5FB4URcoADZjDfOhQIJAAA7
}
image create photo ${imgbase}::3h -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP////8AACH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbWAMcDS9OuIMf1ft7wO+MJQbfL
b4jsFHHBpDNTzD2noZFRypJdj8jlNSvNNYVe4Eo8Q3etzK8KDV9vtW+4WD4f
m+z3YbnGh0XGhhTINfhkqLfj86MDZufkokV3FidpFUmj9jR5uVmJCcQJeCg6
GgpIZRGVusqz9PiKh7E4y0h4O/Wn65fbm8QLjDu8+1sMe4xcI7ys0uyMohz9
PE0tfZ2cTZwo68qddNfn66RGqh2uaMsCfaK+3mJtqUg79F5vbxgsP8+3PxXo
VLdz5KgQLGjwG6JXsjrx4wFv4TZ2DyduaGdRA8aMmRg2cmRV8SNIkdhIkvD4
ESVHlRlZWnS5bBHMYg2rmKwVaiaJiDvH6fxQ092lnx0E1eFEdMPBnkhDCl0K
VAedpDg1PWXShCoqqxIL6cMHUR3YHfeeHtJatgQptGL3NOHCNsy4nhy0YpVq
lO5Fp2q9BQUx127ChoJXmSoMUCZfZ0fgLka29jFNn5InIu4l4qaHCQYkeP4M
2rOBAgA7
}
image create photo ${imgbase}::qs -format gif -data {
R0lGODlhRwBgAMIAAH//1AAAAP////8AAP//AAD//////////yH5BAEAAAAA
LAAAAABHAGAAAAP/CBDc/jDKSWtQS+jNu/9gKI7CFZBoqqrM6r5vqz1wbZcn
Tt98Ksu4nnD0ywWHSE9xA0w6lzOjMwk9Tqk5YNHC7UKIWeNP1CqXBIMAgUFo
r1ngKDM7UzrOrXRbvf9IOX92UTt0HWZjem59hk1McYNadYwnhQF6bG+TjWdk
gQ11an+UUpSJfKJfgI+MoJlynpaJbmISqp2GuKGAAzqjDAOXp5ARjrdzpCWu
JbyfzcCXmVySIVp3UbNMzMVnwMLDtZzUYYShrpbhpM+6vRXhIGW1mNHA6Krq
4xbufr5flObM43Z1w9cuEKsJeP5ZUYKm2zc8NAwCCgPxIUR4YtI01NhL/5I1
iXM4FAhQYCK2cx+z5RloxyBIOcdUfVqmQ1mDNSfuTZxpSxyYk8xw4mRT7o1O
FC8X7jt5U2g5TDyVaqC37V1SX5AUPZgVIY2UgVSvXl2GlaiiPUOjPNMz1RQ9
sUSSER2FtuiWZ3JzgAW46p3cAXscnA2sY21enG1ncPTZKRQwxGZP+cKbl8+b
LAQWWwXjGDAEraMM/20KmWjffZ0Jy4NnuNvQrbBPtzTqGePlWLw2dvYadR1j
caFiBYaKA++94KmYKNvH+fLjm89xN9y6Zq2n5YIaI34s9LnxmTcJXdPMXHto
wGsye6bHe2d1jV3hmi/F/dTbXzDDCyZmDPjlZf/14QfeR0SZMhR2rMyHx1rW
bTJJemhxJduDlFzkBQVnmdafVcEtyOCHIIb4GWIbovZfMxjpoCKKvoDm4ESc
WZYWiyumyOJ+L4bUyXANhOjjjxXOJR81Qrl4IUJBplWiHVrNoiRwIkL05GZk
HGgfcsMMgkZT6iQUVXnA4agfRVuudEobXQo54S7ExILlMby49hyaXlW2ZjYk
EqRkj7qpV+R9U4L5Dna4meIAewP5CR18gWZHJCqf9YioVxAKpp6aSxpi06Gu
SafbmIK91WiCj4oJ26R1rmZppznCVKqlQ13SFkvyvMYGq0O+U1tCw2VyHA51
2XrpqDCSUWdYwdE2EF3/g1Ena66o7XVNTsvWlJ5dOP6X6USuvafBe7SG16yt
pVS4bTHSzsEbdcJytYU+jvq1AVUHURdZkXdY1qpUuCCFG1TX6meUP4SdO80x
TfwCaG9pcdTMTsVSg5odeP0iBiRbJlOwBiOVpKPEHXHykXWL3SgyORXxK1NE
7GRRsU8lnxjPWF6o5VBMQcQc5Mxx1VzcWz1Ri5lqPJPRMkJ/3TxNTmIE/A2Z
IEsDrLcX1xHzxjuoXIw0kaWZoma6kJLwWE9/FNh7+X4CtrZVaX0w0hrPwpIh
dSpnroP7QmqNcpXCx60o2n7pNrxZ811gJSr2SwtPeU+saYbaBDEKQyejbLQf
U0xGiNLOgldCi6vyklBrgXhI/hLUVXB45OpIVwP6FUK4PjjsLsi+L+0r2J4U
7ix8Pjvv/up4O/CipzI88TH6jvwTuy8fQwbOD3GBAqxXb30ECiQAADs=
}
image create photo ${imgbase}::sc -format gif -data {
R0lGODdhRwBgAKEAAAAAAM3Nzf///////ywAAAAARwBgAAAC/4SPqcvtr4Kc
tNqLs97T8A+GoSeWZkme6nql7Lu68CzK9L3Z+G7p/B/wAXfC4a1onCGTryUz
BngCnVITtVqLYnHX7afrzWnDMDAZYz73xrTGL42GENksyIFLV9kRx/xpf9fm
hwIYWDaYVYhIeKgo2Fj42KS4mAUJKFlHmQnlqFT5tfn5icmp4RYUmbpgyfEg
UfoKsmS3KlcbKka5G+G6yAvce/obXAxaZFzsO5zMu5zRDPwcFy06zFyteg2d
7blNvWfL6s2tKyfeWyrmK4ue0HE+jc0KjwrrMAJ6T7+PXy+cS1A7U53ijbo0
8BCpcAStWJs0addBPcEUFpQIUY0mjUgbOVL0+BGkQ5EjSbYyOUsfynsrU7YM
+PJbzDgzZdasAMdjTo47NfZU8/NMUDJDwxT1cnRLUixLqzSV8vRJVCZTk1Q1
0i3rgwIAOw==
}
image create photo ${imgbase}::3c -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP///////yH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqZWw8axGzLyfdIujfce/xr5hh0g
kIgMYhbJZm3JvCWcys0xp6BenzNbUyfksmDfMHnsTfKiMrY6PJzKt214T2LH
HacqPL1l50bil1eXIQhCSGSU1Zc1gihlBpnyZ7UTVCiZ6dCl6bMDgcZXxnlG
ZZgZUvOJipJH6qoHaylbUmubmlu6y9uLhPuLJQzcSux4HGecfLvMnOj8/BMt
zRE8inrtGFvsdLpIjRV5F/46PqvV6KtM2f5WHNHNLgEOjlc/H68MX8mqDf1G
iMB/ANOVG+ZN3btqXRg2dAgIYkSJCCk2s/gK40WNhQU5TvP4gSAxbmI4khS5
Sw6rCyht6WsZUqG5TiUDeqIJ85JAVcPmsDw4TeW5IjJzQrknjpE9ekkDAbXm
BxAtfg/k2VtJEl3CrE2hbJXZFMxXroMm/RzbcotRqGTLQs2WM01NjG7W5lIK
cq5dV6HOejyz16C6wMII/xKR1woFQowbO54AoAAAOw==
}
image create photo ${imgbase}::white -format gif -data {
R0lGODdhRwBgAKEAAP///wAAAP///////ywAAAAARwBgAAAC/wSCqcvtD2Mw
h9qLs9682zlVRiiW5EmhY8qurtki3kzXtdxe5JftOY/xvT44m/Fow6lgr6Uz
92zGhMiqNVUE6nrcYHfrxV7HZCX0LE0z11FRlgxP7qj0r/b+y4/e8X7HrNYm
iMaGxueHGHRYFwbmiDf0c5hIeRAyGEiIWegyWYmYxfioVwJZSprwqbqX2cr5
unlJtdqX2mgqimsnOUsLBwirKewa5ek7FrobuXzKnIvVe3wFHDscTMwqDbqo
3Oz97EykvY1dfn0uO+6XfIvaDf5trG5EbV1tXhw9Lwff//4vZl+ZS/YK4hsm
T+AMdqPCtXPY0JI+hR7qHbyILhvFKsC2Ivp7+M1Owo0bLGbEeG8kyR5zAHp0
iUvlSh0EURo86WbiTEUfX4LsaWknvZo47xXVKHRhy58w3f2UmdSk0akGoQrt
qIupVp9Ik/4hStVmOas7GWblejamTq9Bj4o9SXYmVqdo6aaNu1LqzbDX8JI0
azcwRLVslb7lm3Kt17mDBYfc2rYwB72H9xpSHHVp3cac42G+CtZy5VZ+NzJ+
vBn13c9lQ492y6Q0RcCdgTo+LZkHCNGwq52QADy4cAkGCgAAOw==
}
image create photo ${imgbase}::4d -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP////8AACH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbaMLDy7GJwPOdnbd24DvzwfL+g
UVO7CWDHZsalXBadRygxypnKtKiR9MrtMXNYFe8yzvpmRNZZ3AGz5GavrYwG
h+P6+gsvRmeit8fx5kGYBpJYiGS3yNgYmNiVUcg4SFmZd9l3Qug3uQf66bkp
+Ne2glpipaoGmBkL4rqGqDiHu/mluyFJ8mv4OEsFdBZc3PKYzHzI7OT8XLUs
DU1dPY2dHK2dw90t8w2uPN4kXr6LrnOuTnvdHgpP8y7fSl/vjh9+r9/B3o/h
H0ALAgcWBHiwX0J9C/E1rPdQXkR4E9tVVHcRXcZyphvHdQT3sVtIbSOxlax2
UlrKZyub8QM4pWWQMg2RIQJmK8RLWDqIiRqT8NWqnL6uENxpyehQoUlVFSQl
S2lRLE9NlYA6NSDSn0xvYX3xZGukX2PTQfrq1Wq+UqzOSr2jq2rbD2h5OVpK
NCqxXkHzsu2VZ8NCnzhHeao5M63Tre3GRJFJJgZVxuqEQmaD5/KWuJTR8e2s
EDTDCgNJTDAgIbXq1akNFAAAOw==
}
image create photo ${imgbase}::ss -format gif -data {
R0lGODdhRwBgAKEAAAAAAM3Nzf///////ywAAAAARwBgAAAC/4SPqcvtr4Kc
tNqLs97T8A+GoSeWZkme6nql7Lu68CzK9L3Z+G7p/B/wAXfC4a1onCGTryUz
BngCnVITtVqLYnHX7afrzWnDMPBoPEVz1Tzz92B0cxBxdjkxlGsiaeKif9Tw
o9fz0GZ3AkHYgoiiuFgB+UhHsziJp9T4dknZpCnGickiF8rgmVhqCmWVKqgC
1mqImhXrMAtSq8iKm6ubxdsre7YZLPxGXOzKi5z8NzzXbPsMGu28DF1tfYyd
LbrN3f1ZCBwuHmkuUY5O0WVoazxNHvGu7MjKJ61669gpHeS9qxK8TIH8BSpY
T6BACH4WDjx159GaiJMOjiql8GKojENQNhIkcwdkSJEXSZY0+WodynMr97WM
9/JbTJkzxdS8dtNmTp07M0AC+ZNM0DBDvRTdchRL0ipLpTR98pRJ1CTq1BUA
ADs=
}
image create photo ${imgbase}::3s -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP///////yH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqZWw8axGzLyfdIujfce/xr5hh0g
kIgMYhbJZm3JxAmdz81RlaBWNVeUgqqbdkmwZjjacpintSwrkhy/JUh5Gk60
5yR6L3fGxyYl6IYVmMeG5vU1YjN09mW4E9Tn1+YIKFgn9CCjuEmJqXUTFrI1
SkpYiQpitMr6own7KDvb82pbgpvbWssL+IsYTDvss1vM5Yusq7zc6+zZLDV6
zCwdDRa55lQWdy0pSrzZCYqIJ057bvxNdoh+675uTvc+yHhZbcXePnlZzp3v
GcBC3qABM5gGYUKFexg2dMgMYkSJAinGsvgh4DKNfLMInqLokSOqFI3E7PtF
TqQ+j3vKqFyZyuXJjG44seyF5qWNktoW8dAZr2UGoHxmJJunbtA4CP/WJVW6
tBu4RDNxhvNZ6CWUTw+3aN0asMvXrVCPaqk6VNHYNQTXAkyLUQlcjDtM0sXk
FmmpuBzyshLBlwuFQIQLG15goAAAOw==
}
image create photo ${imgbase}::4h -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP////8AACH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqbaMLDy7GJwPOdnbd24DvzwfL+g
UVO7CWDHZsalXBadRygxevFlsSBtjwuyXotXqfdTLpd428zYfOa83yT21z2m
d/J64QjPtMUXtzFItPZnw2VI+MIYGJaI9jjl+IhoctnFiCI5aUiiWZeoBAbX
95m386fVyKfyuvqFOtsYqiZ7ans6c9jCqioHKWOKWVtsE1TZqYhMlcPm/Ezj
uTRNZXeNXa3tlN1dxQ1u9D0OVG4OLZ6uzu697s6CHq8yT898fw6fb8xP7d8O
oAx7AjkQLIhkH8INBxdeaOgwhMKIDydSlHhxVMZIvRv9dPQA0WHIhSMRlix4
UmBKgCv9teT3Ml/MezPp1Yx3013Oa5V2PgPj04kvCymXrTAq6MxJabeQxio5
9Oiupxab7UpVjCqsYJm4JoVDtKquqFhxCTJTsSuoTWs1lhDlAa7HppziUupX
Ntaeu1+fWKSE9Nggqwnf8t0rd1hauqXMFkrjWHFYtY2vWmViVivlvnQ5C44S
tEkg0GLvYYYU+kjU1EYIsVYm+TUQyRg/GixNsoLtJxQk+P4N3LeBAgA7
}
image create photo ${imgbase}::4c -format gif -data {
R0lGODlhRwBgAKEAAH//1AAAAP///////yH5BAEAAAAALAAAAABHAGAAAAL/
BIKpy+0PYzBH2Iuz3rz7L0wBSJamiZzquqaay8YsfCXyrdKhjfcgvfAJOzCb
boh08Y5IodLh4cWkudGuQVRMtS1rhlljdIPVDdiCrZJPR65ZrHajvOHz1R6V
z9XXPsmYQvVDNxhRCLH31SZhx4gXpijoSBgpUaKzhuaYx3hJmKlpdEf5ojUC
mgcJGIkW6mkF+4jx9MAhyDcTW1t6+ypbGgrV5OQl2ju8xYvctEi6LPP7fBMt
nVz9TH1dpo2cze35Pewd/jFOnnU+ZJ4OzN6z7g4ZP+08D25vjd+ln8u/78+m
HsA3AxMVHHTwj8CEmhiWW8gQ3jyJ8Si6s8gOYzqNpuc4kvMYDuQ3kdxIajOp
bpFDP7MgXgzEEiW9XeZQ+aJkaAc0eL1yZlviSiGsoA1XNZxjTM+bpJL0RJvE
yVIdTC6D5bS1aeqnqqMQZenUEifXrmmi7lLIB1BVtSzR5jp2qJ7ScWWRKg3W
Lg7cr3ePKnrb1+wZJjUDPzxGcyyrnXKFyfRBy2/CQEUUb5Tz+F3Tlbcy4yBs
mZ/nbhVWvqAwKbXq1RMAFAAAOw==
}

image create photo ${imgbase}::back -format gif -data {
R0lGODlhRwBgAPMAMf//////AP8A/8DAwBDxMAAA/wAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAACH5BAEAAAQALAAAAABHAGAAAAT/kBBDq7046827
kRMgjmRpnmiqrsBnsHAsy9Rs33eN7zyqj4WgcFgYEI/G4zCpDDKbpR+gSXxW
qUuqFTqSEoFX5BGcFX9FZ5FXCAi0p2Hh9u02y8fuOrv7IrcLAgV6ZUV4gIJw
hHMBh4Mka395iAWJhU9TkZmUWZeUjJJ6j31olAACb6eUp0ysppinbqmurHKu
qqikoiRBmZ+YnEOYvr6bd529k6Vqo4l/gYN3TobPldLWwYzUe8u7bHnVhYTe
b3bX49C6ZLzFitHB7O60X/DKLcxj5ZVz+eLrafYkLqVyd0ucLYIHzSUskg5N
J4L+DPajFy5ioYZw5FVkQ1HjPnAe/3nx6baxpCdycczx+lauIsZ2X7Ilg4mt
EUiEI9VZeoesjr6NwhAR+2nlZZwBtlzFegXAY1JYT5tCrLfGGM9hk4heFZoV
WLCcpK4tsmlnrLajX7mRsbIIZb+20FQyMRpy3k2x+O5WTPLyocqO76b+QpgF
o8CfbAYqVAyU8eElRgNLFMyP8r+q6/Rq5KiZcrXIJ+OWhKv3L51KkZ3NjDdt
Nd6YZEWqzYXVp9fMtQdLO5ZbNkAwIqDKWhUv6tJbTofjgmO0p26TQUE9V+iJ
ayiwzWSK3lLzbBOzM0GfbqlkPBboLLf9Dpu5LJbpaO1evjcvJbi07yeCMxzM
cf/7AyC1Cv93Cz1WC3ZA6fcee/jYVxiCe3lGBXycuWdNZGzh4dZc6bnUIURz
Qfhad8kwpx1zK8VGE1X0WcVZbiTAOEJvWqW1nmbGRXXLcTkqt5lvmInVI1M7
6qhUVD+ySNJuW0kXo3Ul0HgbkC1GCNtZJsaWpXesqVdVhjFteE4iHLoFopf0
1cXThBRVGF84fUkG3YL3ceTgHfwlhhgvjB14ilRj+KcnZCLaORkXdVq0z3xL
btIZm4lauaaNmJk3kYaikWepkn6cSB6JmQrmKZXdOAfPR1I6aCqnuRzpY3HK
8UickLG6whyEptaIG5SnJrhqaqOumCKXI3qjongfyoVpaeiZCZr/oxbO+ai0
jOoEmKFz3mnaGNgZuNieBSEkKJ/6xIntoodmm64RdHU5KU0fRcuXiGBiY6ay
YW4XB2hJqqavacG6y2o1RvDGq66OpsokpVXSypSsgO41JHKCFbrTiwdPGZ0m
CA8sbHXESmpsyJthmNJK9462bEshzpaRwO29Ga/MpALhl7qESZizNHmSa9C4
4X77c7kWX6tog+sijWaj8KnpJrx5Vcvepvja+6+ozoro77QjuybysOHhqvDF
u0rXq8Fme1yKcEwl9zCSsL79Z820Zexi2RxrXF3awKoIM8he9xsssinXOybL
Ky+tk7XczcGgSdAx+Ox3Wpz311TlYRcpJuSXdo65jTf2IPoOUoxu+gyln676
Ci6s7roKH0jgwey01z67BBEAADs=
}

image create photo ${imgbase}::cardpile -format gif -data {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}
