Accessibility.AccessibilityNode=class{constructor(accessibilityModel,payload){this._accessibilityModel=accessibilityModel;this._agent=accessibilityModel._agent;this._id=payload.nodeId;accessibilityModel._setAXNodeForAXId(this._id,this);if(payload.backendDOMNodeId){accessibilityModel._setAXNodeForBackendDOMNodeId(payload.backendDOMNodeId,this);this._backendDOMNodeId=payload.backendDOMNodeId;this._deferredDOMNode=new SDK.DeferredDOMNode(accessibilityModel.target(),payload.backendDOMNodeId);}else{this._backendDOMNodeId=null;this._deferredDOMNode=null;}
this._ignored=payload.ignored;if(this._ignored&&'ignoredReasons'in payload)
this._ignoredReasons=payload.ignoredReasons;this._role=payload.role||null;this._name=payload.name||null;this._description=payload.description||null;this._value=payload.value||null;this._properties=payload.properties||null;this._childIds=payload.childIds||null;this._parentNode=null;}
accessibilityModel(){return this._accessibilityModel;}
ignored(){return this._ignored;}
ignoredReasons(){return this._ignoredReasons||null;}
role(){return this._role||null;}
coreProperties(){const properties=[];if(this._name)
properties.push(({name:'name',value:this._name}));if(this._description){properties.push(({name:'description',value:this._description}));}
if(this._value)
properties.push(({name:'value',value:this._value}));return properties;}
name(){return this._name||null;}
description(){return this._description||null;}
value(){return this._value||null;}
properties(){return this._properties||null;}
parentNode(){return this._parentNode;}
_setParentNode(parentNode){this._parentNode=parentNode;}
isDOMNode(){return!!this._backendDOMNodeId;}
backendDOMNodeId(){return this._backendDOMNodeId;}
deferredDOMNode(){return this._deferredDOMNode;}
highlightDOMNode(){if(!this.deferredDOMNode())
return;this.deferredDOMNode().highlight();}
children(){const children=[];if(!this._childIds)
return children;for(const childId of this._childIds){const child=this._accessibilityModel.axNodeForId(childId);if(child)
children.push(child);}
return children;}
numChildren(){if(!this._childIds)
return 0;return this._childIds.length;}
hasOnlyUnloadedChildren(){if(!this._childIds||!this._childIds.length)
return false;return!this._childIds.some(id=>this._accessibilityModel.axNodeForId(id)!==undefined);}
printSelfAndChildren(inspectedNode,leadingSpace){let string=leadingSpace||'';if(this._role)
string+=this._role.value;else
string+='<no role>';string+=(this._name?' '+this._name.value:'');string+=' '+this._id;if(this._domNode)
string+=' ('+this._domNode.nodeName()+')';if(this===inspectedNode)
string+=' *';for(const child of this.children())
string+='\n'+child.printSelfAndChildren(inspectedNode,(leadingSpace||'')+'  ');return string;}};Accessibility.AccessibilityModel=class extends SDK.SDKModel{constructor(target){super(target);this._agent=target.accessibilityAgent();this._axIdToAXNode=new Map();this._backendDOMNodeIdToAXNode=new Map();}
clear(){this._axIdToAXNode.clear();}
async requestPartialAXTree(node){const payloads=await this._agent.getPartialAXTree(node.id,undefined,undefined,true);if(!payloads)
return;for(const payload of payloads)
new Accessibility.AccessibilityNode(this,payload);for(const axNode of this._axIdToAXNode.values()){for(const axChild of axNode.children())
axChild._setParentNode(axNode);}}
axNodeForId(axId){return this._axIdToAXNode.get(axId);}
_setAXNodeForAXId(axId,axNode){this._axIdToAXNode.set(axId,axNode);}
axNodeForDOMNode(domNode){if(!domNode)
return null;return this._backendDOMNodeIdToAXNode.get(domNode.backendNodeId());}
_setAXNodeForBackendDOMNodeId(backendDOMNodeId,axNode){this._backendDOMNodeIdToAXNode.set(backendDOMNodeId,axNode);}
logTree(inspectedNode){let rootNode=inspectedNode;while(rootNode.parentNode())
rootNode=rootNode.parentNode();console.log(rootNode.printSelfAndChildren(inspectedNode));}};SDK.SDKModel.register(Accessibility.AccessibilityModel,SDK.Target.Capability.DOM,false);;Accessibility.AccessibilitySidebarView=class extends UI.ThrottledWidget{constructor(){super();this._node=null;this._axNode=null;this._skipNextPullNode=false;this._sidebarPaneStack=UI.viewManager.createStackLocation();this._breadcrumbsSubPane=new Accessibility.AXBreadcrumbsPane(this);this._sidebarPaneStack.showView(this._breadcrumbsSubPane);this._ariaSubPane=new Accessibility.ARIAAttributesPane();this._sidebarPaneStack.showView(this._ariaSubPane);this._axNodeSubPane=new Accessibility.AXNodeSubPane();this._sidebarPaneStack.showView(this._axNodeSubPane);this._sidebarPaneStack.widget().show(this.element);UI.context.addFlavorChangeListener(SDK.DOMNode,this._pullNode,this);this._pullNode();}
node(){return this._node;}
axNode(){return this._axNode;}
setNode(node,fromAXTree){this._skipNextPullNode=!!fromAXTree;this._node=node;this.update();}
accessibilityNodeCallback(axNode){if(!axNode)
return;this._axNode=axNode;if(axNode.isDOMNode())
this._sidebarPaneStack.showView(this._ariaSubPane,this._axNodeSubPane);else
this._sidebarPaneStack.removeView(this._ariaSubPane);if(this._axNodeSubPane)
this._axNodeSubPane.setAXNode(axNode);if(this._breadcrumbsSubPane)
this._breadcrumbsSubPane.setAXNode(axNode);}
doUpdate(){const node=this.node();this._axNodeSubPane.setNode(node);this._ariaSubPane.setNode(node);this._breadcrumbsSubPane.setNode(node);if(!node)
return Promise.resolve();const accessibilityModel=node.domModel().target().model(Accessibility.AccessibilityModel);accessibilityModel.clear();return accessibilityModel.requestPartialAXTree(node).then(()=>{this.accessibilityNodeCallback(accessibilityModel.axNodeForDOMNode(node));});}
wasShown(){super.wasShown();this._breadcrumbsSubPane.setNode(this.node());this._breadcrumbsSubPane.setAXNode(this.axNode());this._axNodeSubPane.setNode(this.node());this._axNodeSubPane.setAXNode(this.axNode());this._ariaSubPane.setNode(this.node());SDK.targetManager.addModelListener(SDK.DOMModel,SDK.DOMModel.Events.AttrModified,this._onAttrChange,this);SDK.targetManager.addModelListener(SDK.DOMModel,SDK.DOMModel.Events.AttrRemoved,this._onAttrChange,this);SDK.targetManager.addModelListener(SDK.DOMModel,SDK.DOMModel.Events.CharacterDataModified,this._onNodeChange,this);SDK.targetManager.addModelListener(SDK.DOMModel,SDK.DOMModel.Events.ChildNodeCountUpdated,this._onNodeChange,this);}
willHide(){SDK.targetManager.removeModelListener(SDK.DOMModel,SDK.DOMModel.Events.AttrModified,this._onAttrChange,this);SDK.targetManager.removeModelListener(SDK.DOMModel,SDK.DOMModel.Events.AttrRemoved,this._onAttrChange,this);SDK.targetManager.removeModelListener(SDK.DOMModel,SDK.DOMModel.Events.CharacterDataModified,this._onNodeChange,this);SDK.targetManager.removeModelListener(SDK.DOMModel,SDK.DOMModel.Events.ChildNodeCountUpdated,this._onNodeChange,this);}
_pullNode(){if(this._skipNextPullNode){this._skipNextPullNode=false;return;}
this.setNode(UI.context.flavor(SDK.DOMNode));}
_onAttrChange(event){if(!this.node())
return;const node=event.data.node;if(this.node()!==node)
return;this.update();}
_onNodeChange(event){if(!this.node())
return;const node=event.data;if(this.node()!==node)
return;this.update();}};Accessibility.AccessibilitySubPane=class extends UI.SimpleView{constructor(name){super(name);this._axNode=null;this.registerRequiredCSS('accessibility/accessibilityProperties.css');}
setAXNode(axNode){}
node(){return this._node;}
setNode(node){this._node=node;}
createInfo(textContent,className){const classNameOrDefault=className||'gray-info-message';const info=this.element.createChild('div',classNameOrDefault);info.textContent=textContent;return info;}
createTreeOutline(){const treeOutline=new UI.TreeOutlineInShadow();treeOutline.registerRequiredCSS('accessibility/accessibilityNode.css');treeOutline.registerRequiredCSS('accessibility/accessibilityProperties.css');treeOutline.registerRequiredCSS('object_ui/objectValue.css');treeOutline.element.classList.add('hidden');treeOutline.hideOverflow();this.element.appendChild(treeOutline.element);return treeOutline;}};;Accessibility.AXNodeSubPane=class extends Accessibility.AccessibilitySubPane{constructor(){super(ls`Computed Properties`);this.contentElement.classList.add('ax-subpane');this._noNodeInfo=this.createInfo(ls`No accessibility node`);this._ignoredInfo=this.createInfo(ls`Accessibility node not exposed`,'ax-ignored-info hidden');this._treeOutline=this.createTreeOutline();this._ignoredReasonsTree=this.createTreeOutline();this.element.classList.add('accessibility-computed');this.registerRequiredCSS('accessibility/accessibilityNode.css');}
setAXNode(axNode){if(this._axNode===axNode)
return;this._axNode=axNode;const treeOutline=this._treeOutline;treeOutline.removeChildren();const ignoredReasons=this._ignoredReasonsTree;ignoredReasons.removeChildren();if(!axNode){treeOutline.element.classList.add('hidden');this._ignoredInfo.classList.add('hidden');ignoredReasons.element.classList.add('hidden');this._noNodeInfo.classList.remove('hidden');this.element.classList.add('ax-ignored-node-pane');return;}
if(axNode.ignored()){this._noNodeInfo.classList.add('hidden');treeOutline.element.classList.add('hidden');this.element.classList.add('ax-ignored-node-pane');this._ignoredInfo.classList.remove('hidden');ignoredReasons.element.classList.remove('hidden');function addIgnoredReason(property){ignoredReasons.appendChild(new Accessibility.AXNodeIgnoredReasonTreeElement(property,(axNode)));}
const ignoredReasonsArray=(axNode.ignoredReasons());for(const reason of ignoredReasonsArray)
addIgnoredReason(reason);if(!ignoredReasons.firstChild())
ignoredReasons.element.classList.add('hidden');return;}
this.element.classList.remove('ax-ignored-node-pane');this._ignoredInfo.classList.add('hidden');ignoredReasons.element.classList.add('hidden');this._noNodeInfo.classList.add('hidden');treeOutline.element.classList.remove('hidden');function addProperty(property){treeOutline.appendChild(new Accessibility.AXNodePropertyTreePropertyElement(property,(axNode)));}
for(const property of axNode.coreProperties())
addProperty(property);const roleProperty=({name:'role',value:axNode.role()});addProperty(roleProperty);for(const property of(axNode.properties()))
addProperty(property);}
setNode(node){super.setNode(node);this._axNode=null;}};Accessibility.AXNodePropertyTreeElement=class extends UI.TreeElement{constructor(axNode){super('');this._axNode=axNode;}
static createSimpleValueElement(type,value){let valueElement;const AXValueType=Protocol.Accessibility.AXValueType;if(!type||type===AXValueType.ValueUndefined||type===AXValueType.ComputedString)
valueElement=createElement('span');else
valueElement=createElementWithClass('span','monospace');let valueText;const isStringProperty=type&&Accessibility.AXNodePropertyTreeElement.StringProperties.has(type);if(isStringProperty){valueText='"'+value.replace(/\n/g,'\u21B5')+'"';valueElement._originalTextContent=value;}else{valueText=String(value);}
if(type&&type in Accessibility.AXNodePropertyTreeElement.TypeStyles)
valueElement.classList.add(Accessibility.AXNodePropertyTreeElement.TypeStyles[type]);valueElement.setTextContentTruncatedIfNeeded(valueText||'');valueElement.title=String(value)||'';return valueElement;}
static createExclamationMark(tooltip){const exclamationElement=createElement('span','dt-icon-label');exclamationElement.type='smallicon-warning';exclamationElement.title=tooltip;return exclamationElement;}
appendNameElement(name){const nameElement=createElement('span');const AXAttributes=Accessibility.AccessibilityStrings.AXAttributes;if(name in AXAttributes){nameElement.textContent=ls(AXAttributes[name].name);nameElement.title=AXAttributes[name].description;nameElement.classList.add('ax-readable-name');}else{nameElement.textContent=name;nameElement.classList.add('ax-name');nameElement.classList.add('monospace');}
this.listItemElement.appendChild(nameElement);}
appendValueElement(value){const AXValueType=Protocol.Accessibility.AXValueType;if(value.type===AXValueType.Idref||value.type===AXValueType.Node||value.type===AXValueType.IdrefList||value.type===AXValueType.NodeList){this.appendRelatedNodeListValueElement(value);return;}else if(value.sources){const sources=value.sources;for(let i=0;i<sources.length;i++){const source=sources[i];const child=new Accessibility.AXValueSourceTreeElement(source,this._axNode);this.appendChild(child);}
this.expand();}
const element=Accessibility.AXNodePropertyTreeElement.createSimpleValueElement(value.type,String(value.value));this.listItemElement.appendChild(element);}
appendRelatedNode(relatedNode,index){const deferredNode=new SDK.DeferredDOMNode(this._axNode.accessibilityModel().target(),relatedNode.backendDOMNodeId);const nodeTreeElement=new Accessibility.AXRelatedNodeSourceTreeElement({deferredNode:deferredNode},relatedNode);this.appendChild(nodeTreeElement);}
appendRelatedNodeInline(relatedNode){const deferredNode=new SDK.DeferredDOMNode(this._axNode.accessibilityModel().target(),relatedNode.backendDOMNodeId);const linkedNode=new Accessibility.AXRelatedNodeElement({deferredNode:deferredNode},relatedNode);this.listItemElement.appendChild(linkedNode.render());}
appendRelatedNodeListValueElement(value){if(value.relatedNodes.length===1&&!value.value){this.appendRelatedNodeInline(value.relatedNodes[0]);return;}
value.relatedNodes.forEach(this.appendRelatedNode,this);if(value.relatedNodes.length<=3)
this.expand();else
this.collapse();}};Accessibility.AXNodePropertyTreeElement.TypeStyles={attribute:'ax-value-string',boolean:'object-value-boolean',booleanOrUndefined:'object-value-boolean',computedString:'ax-readable-string',idref:'ax-value-string',idrefList:'ax-value-string',integer:'object-value-number',internalRole:'ax-internal-role',number:'ax-value-number',role:'ax-role',string:'ax-value-string',tristate:'object-value-boolean',valueUndefined:'ax-value-undefined'};Accessibility.AXNodePropertyTreeElement.StringProperties=new Set([Protocol.Accessibility.AXValueType.String,Protocol.Accessibility.AXValueType.ComputedString,Protocol.Accessibility.AXValueType.IdrefList,Protocol.Accessibility.AXValueType.Idref]);Accessibility.AXNodePropertyTreePropertyElement=class extends Accessibility.AXNodePropertyTreeElement{constructor(property,axNode){super(axNode);this._property=property;this.toggleOnClick=true;this.selectable=false;this.listItemElement.classList.add('property');}
onattach(){this._update();}
_update(){this.listItemElement.removeChildren();this.appendNameElement(this._property.name);this.listItemElement.createChild('span','separator').textContent=':\u00A0';this.appendValueElement(this._property.value);}};Accessibility.AXValueSourceTreeElement=class extends Accessibility.AXNodePropertyTreeElement{constructor(source,axNode){super(axNode);this._source=source;this.selectable=false;}
onattach(){this._update();}
appendRelatedNodeWithIdref(relatedNode,index,idref){const deferredNode=new SDK.DeferredDOMNode(this._axNode.accessibilityModel().target(),relatedNode.backendDOMNodeId);const nodeTreeElement=new Accessibility.AXRelatedNodeSourceTreeElement({deferredNode:deferredNode,idref:idref},relatedNode);this.appendChild(nodeTreeElement);}
appendIDRefValueElement(value){const relatedNodes=value.relatedNodes;const idrefs=value.value.trim().split(/\s+/);if(idrefs.length===1){const idref=idrefs[0];const matchingNode=relatedNodes.find(node=>node.idref===idref);if(matchingNode)
this.appendRelatedNodeWithIdref(matchingNode,0,idref);else
this.listItemElement.appendChild(new Accessibility.AXRelatedNodeElement({idref:idref}).render());}else{for(let i=0;i<idrefs.length;++i){const idref=idrefs[i];const matchingNode=relatedNodes.find(node=>node.idref===idref);if(matchingNode)
this.appendRelatedNodeWithIdref(matchingNode,i,idref);else
this.appendChild(new Accessibility.AXRelatedNodeSourceTreeElement({idref:idref}));}}}
appendRelatedNodeListValueElement(value){const relatedNodes=value.relatedNodes;const numNodes=relatedNodes.length;if(value.type===Protocol.Accessibility.AXValueType.IdrefList||value.type===Protocol.Accessibility.AXValueType.Idref)
this.appendIDRefValueElement(value);else
super.appendRelatedNodeListValueElement(value);if(numNodes<=3)
this.expand();else
this.collapse();}
appendSourceNameElement(source){const nameElement=createElement('span');const AXValueSourceType=Protocol.Accessibility.AXValueSourceType;const type=source.type;switch(type){case AXValueSourceType.Attribute:case AXValueSourceType.Placeholder:case AXValueSourceType.RelatedElement:if(source.nativeSource){const AXNativeSourceTypes=Accessibility.AccessibilityStrings.AXNativeSourceTypes;const nativeSource=source.nativeSource;nameElement.textContent=ls(AXNativeSourceTypes[nativeSource].name);nameElement.title=ls(AXNativeSourceTypes[nativeSource].description);nameElement.classList.add('ax-readable-name');break;}
nameElement.textContent=source.attribute;nameElement.classList.add('ax-name');nameElement.classList.add('monospace');break;default:const AXSourceTypes=Accessibility.AccessibilityStrings.AXSourceTypes;if(type in AXSourceTypes){nameElement.textContent=ls(AXSourceTypes[type].name);nameElement.title=ls(AXSourceTypes[type].description);nameElement.classList.add('ax-readable-name');}else{console.warn(type,'not in AXSourceTypes');nameElement.textContent=ls(type);}}
this.listItemElement.appendChild(nameElement);}
_update(){this.listItemElement.removeChildren();if(this._source.invalid){const exclamationMark=Accessibility.AXNodePropertyTreeElement.createExclamationMark(ls`Invalid source.`);this.listItemElement.appendChild(exclamationMark);this.listItemElement.classList.add('ax-value-source-invalid');}else if(this._source.superseded){this.listItemElement.classList.add('ax-value-source-unused');}
this.appendSourceNameElement(this._source);this.listItemElement.createChild('span','separator').textContent=':\u00a0';if(this._source.attributeValue){this.appendValueElement(this._source.attributeValue);this.listItemElement.createTextChild('\u00a0');}else if(this._source.nativeSourceValue){this.appendValueElement(this._source.nativeSourceValue);this.listItemElement.createTextChild('\u00a0');if(this._source.value)
this.appendValueElement(this._source.value);}else if(this._source.value){this.appendValueElement(this._source.value);}else{const valueElement=Accessibility.AXNodePropertyTreeElement.createSimpleValueElement(Protocol.Accessibility.AXValueType.ValueUndefined,ls`Not specified`);this.listItemElement.appendChild(valueElement);this.listItemElement.classList.add('ax-value-source-unused');}
if(this._source.value&&this._source.superseded)
this.listItemElement.classList.add('ax-value-source-superseded');}};Accessibility.AXRelatedNodeSourceTreeElement=class extends UI.TreeElement{constructor(node,value){super('');this._value=value;this._axRelatedNodeElement=new Accessibility.AXRelatedNodeElement(node,value);this.selectable=false;}
onattach(){this.listItemElement.appendChild(this._axRelatedNodeElement.render());if(!this._value)
return;if(this._value.text){this.listItemElement.appendChild(Accessibility.AXNodePropertyTreeElement.createSimpleValueElement(Protocol.Accessibility.AXValueType.ComputedString,this._value.text));}}};Accessibility.AXRelatedNodeElement=class{constructor(node,value){this._deferredNode=node.deferredNode;this._idref=node.idref;this._value=value;}
render(){const element=createElement('span');let valueElement;if(this._deferredNode){valueElement=createElement('span');element.appendChild(valueElement);this._deferredNode.resolvePromise().then(node=>{Common.Linkifier.linkify(node).then(linkfied=>valueElement.appendChild(linkfied));});}else if(this._idref){element.classList.add('invalid');valueElement=Accessibility.AXNodePropertyTreeElement.createExclamationMark(ls`No node with this ID.`);valueElement.createTextChild(this._idref);element.appendChild(valueElement);}
return element;}};Accessibility.AXNodeIgnoredReasonTreeElement=class extends Accessibility.AXNodePropertyTreeElement{constructor(property,axNode){super(axNode);this._property=property;this._axNode=axNode;this.toggleOnClick=true;this.selectable=false;}
static createReasonElement(reason,axNode){let reasonElement=null;switch(reason){case'activeModalDialog':reasonElement=UI.formatLocalized('Element is hidden by active modal dialog:\u00a0',[]);break;case'ancestorIsLeafNode':reasonElement=UI.formatLocalized('Ancestor\'s children are all presentational:\u00a0',[]);break;case'ariaHiddenElement':{const ariaHiddenSpan=createElement('span','source-code').textContent='aria-hidden';reasonElement=UI.formatLocalized('Element is %s.',[ariaHiddenSpan]);break;}
case'ariaHiddenSubtree':{const ariaHiddenSpan=createElement('span','source-code').textContent='aria-hidden';const trueSpan=createElement('span','source-code').textContent='true';reasonElement=UI.formatLocalized('%s is %s on ancestor:\u00a0',[ariaHiddenSpan,trueSpan]);break;}
case'emptyAlt':reasonElement=UI.formatLocalized('Element has empty alt text.',[]);break;case'emptyText':reasonElement=UI.formatLocalized('No text content.',[]);break;case'inertElement':reasonElement=UI.formatLocalized('Element is inert.',[]);break;case'inertSubtree':reasonElement=UI.formatLocalized('Element is in an inert subtree from\u00a0',[]);break;case'inheritsPresentation':reasonElement=UI.formatLocalized('Element inherits presentational role from\u00a0',[]);break;case'labelContainer':reasonElement=UI.formatLocalized('Part of label element:\u00a0',[]);break;case'labelFor':reasonElement=UI.formatLocalized('Label for\u00a0',[]);break;case'notRendered':reasonElement=UI.formatLocalized('Element is not rendered.',[]);break;case'notVisible':reasonElement=UI.formatLocalized('Element is not visible.',[]);break;case'presentationalRole':{const rolePresentationSpan=createElement('span','source-code').textContent='role='+axNode.role().value;reasonElement=UI.formatLocalized('Element has %s.',[rolePresentationSpan]);break;}
case'probablyPresentational':reasonElement=UI.formatLocalized('Element is presentational.',[]);break;case'staticTextUsedAsNameFor':reasonElement=UI.formatLocalized('Static text node is used as name for\u00a0',[]);break;case'uninteresting':reasonElement=UI.formatLocalized('Element not interesting for accessibility.',[]);break;}
if(reasonElement)
reasonElement.classList.add('ax-reason');return reasonElement;}
onattach(){this.listItemElement.removeChildren();this._reasonElement=Accessibility.AXNodeIgnoredReasonTreeElement.createReasonElement(this._property.name,this._axNode);this.listItemElement.appendChild(this._reasonElement);const value=this._property.value;if(value.type===Protocol.Accessibility.AXValueType.Idref)
this.appendRelatedNodeListValueElement(value);}};;Accessibility.AccessibilityStrings={};Accessibility.AccessibilityStrings.AXAttributes={'disabled':{name:'Disabled',description:'If true, this element currently cannot be interacted with.',group:'AXGlobalStates'},'invalid':{name:'Invalid user entry',description:'If true, this element\'s user-entered value does not conform to validation requirement.',group:'AXGlobalStates'},'editable':{name:'Editable',description:'If and how this element can be edited.'},'focusable':{name:'Focusable',description:'If true, this element can recieve focus.'},'focused':{name:'Focused',description:'If true, this element currently has focus.'},'settable':{name:'Can set value',description:'Whether the value of this element can be set.'},'live':{name:'Live region',description:'Whether and what priority of live updates may be expected for this element.',group:'AXLiveRegionAttributes'},'atomic':{name:'Atomic (live regions)',description:'If this element may receive live updates, whether the entire live region should be presented to the user on changes, or only changed nodes.',group:'AXLiveRegionAttributes'},'relevant':{name:'Relevant (live regions)',description:'If this element may receive live updates, what type of updates should trigger a notification.',group:'AXLiveRegionAttributes'},'busy':{name:'Busy (live regions)',description:'Whether this element or its subtree are currently being updated (and thus may be in an inconsistent state).',group:'AXLiveRegionAttributes'},'root':{name:'Live region root',description:'If this element may receive live updates, the root element of the containing live region.',group:'AXLiveRegionAttributes'},'autocomplete':{name:'Has autocomplete',description:'Whether and what type of autocomplete suggestions are currently provided by this element.',group:'AXWidgetAttributes'},'haspopup':{name:'Has popup',description:'Whether this element has caused some kind of pop-up (such as a menu) to appear.',group:'AXWidgetAttributes'},'level':{name:'Level',description:'The hierarchical level of this element.',group:'AXWidgetAttributes'},'multiselectable':{name:'Multi-selectable',description:'Whether a user may select more than one option from this widget.',group:'AXWidgetAttributes'},'orientation':{name:'Orientation',description:'Whether this linear element\'s orientation is horizontal or vertical.',group:'AXWidgetAttributes'},'multiline':{name:'Multi-line',description:'Whether this textbox may have more than one line.',group:'AXWidgetAttributes'},'readonly':{name:'Read-only',description:'If true, this element may be interacted with, but its value cannot be changed.',group:'AXWidgetAttributes'},'required':{name:'Required',description:'Whether this element is a required field in a form.',group:'AXWidgetAttributes'},'valuemin':{name:'Minimum value',description:'For a range widget, the minimum allowed value.',group:'AXWidgetAttributes'},'valuemax':{name:'Maximum value',description:'For a range widget, the maximum allowed value.',group:'AXWidgetAttributes'},'valuetext':{name:'Value description',description:'A human-readable version of the value of a range widget (where necessary).',group:'AXWidgetAttributes'},'checked':{name:'Checked',description:'Whether this checkbox, radio button or tree item is checked, unchecked, or mixed (e.g. has both checked and un-checked children).',group:'AXWidgetStates'},'expanded':{name:'Expanded',description:'Whether this element, or another grouping element it controls, is expanded.',group:'AXWidgetStates'},'pressed':{name:'Pressed',description:'Whether this toggle button is currently in a pressed state.',group:'AXWidgetStates'},'selected':{name:'Selected',description:'Whether the option represented by this element is currently selected.',group:'AXWidgetStates'},'activedescendant':{name:'Active descendant',description:'The descendant of this element which is active; i.e. the element to which focus should be delegated.',group:'AXRelationshipAttributes'},'flowto':{name:'Flows to',description:'Element to which the user may choose to navigate after this one, instead of the next element in the DOM order.',group:'AXRelationshipAttributes'},'controls':{name:'Controls',description:'Element or elements whose content or presence is/are controlled by this widget.',group:'AXRelationshipAttributes'},'describedby':{name:'Described by',description:'Element or elements which form the description of this element.',group:'AXRelationshipAttributes'},'labelledby':{name:'Labeled by',description:'Element or elements which may form the name of this element.',group:'AXRelationshipAttributes'},'owns':{name:'Owns',description:'Element or elements which should be considered descendants of this element, despite not being descendants in the DOM.',group:'AXRelationshipAttributes'},'name':{name:'Name',description:'The computed name of this element.',group:'Default'},'role':{name:'Role',description:'Indicates the purpose of this element, such as a user interface idiom for a widget, or structural role within a document.',group:'Default'},'value':{name:'Value',description:'The value of this element; this may be user-provided or developer-provided, depending on the element.',group:'Default'},'help':{name:'Help',description:'The computed help text for this element.',group:'Default'},'description':{name:'Description',description:'The accessible description for this element.',group:'Default'}};Accessibility.AccessibilityStrings.AXSourceTypes={'attribute':{name:'From attribute',description:'Value from attribute.'},'implicit':{name:'Implicit',description:'Implicit value.',},'style':{name:'From style',description:'Value from style.'},'contents':{name:'Contents',description:'Value from element contents.'},'placeholder':{name:'From placeholder attribute',description:'Value from placeholder attribute.'},'relatedElement':{name:'Related element',description:'Value from related element.'}};Accessibility.AccessibilityStrings.AXNativeSourceTypes={'figcaption':{name:'From caption',description:'Value from figcaption element.'},'label':{name:'From label',description:'Value from label element.'},'labelfor':{name:'From label (for)',description:'Value from label element with for= attribute.'},'labelwrapped':{name:'From label (wrapped)',description:'Value from label element wrapped.'},'tablecaption':{name:'From caption',description:'Value from table caption.'},'title':{'name':'From title','description':'Value from title attribute.'},'other':{name:'From native HTML',description:'Value from native HTML (unknown source).'},};;Accessibility.ARIAAttributesPane=class extends Accessibility.AccessibilitySubPane{constructor(){super(ls`ARIA Attributes`);this._noPropertiesInfo=this.createInfo(ls`No ARIA attributes`);this._treeOutline=this.createTreeOutline();}
setNode(node){super.setNode(node);this._treeOutline.removeChildren();if(!this.node())
return;const target=this.node().domModel().target();const attributes=node.attributes();for(let i=0;i<attributes.length;++i){const attribute=attributes[i];if(Accessibility.ARIAAttributesPane._attributes.indexOf(attribute.name)<0)
continue;this._treeOutline.appendChild(new Accessibility.ARIAAttributesTreeElement(this,attribute,target));}
const foundAttributes=(this._treeOutline.rootElement().childCount()!==0);this._noPropertiesInfo.classList.toggle('hidden',foundAttributes);this._treeOutline.element.classList.toggle('hidden',!foundAttributes);}};Accessibility.ARIAAttributesTreeElement=class extends UI.TreeElement{constructor(parentPane,attribute,target){super('');this._parentPane=parentPane;this._attribute=attribute;this.selectable=false;}
static createARIAValueElement(value){const valueElement=createElementWithClass('span','monospace');valueElement.setTextContentTruncatedIfNeeded(value||'');return valueElement;}
onattach(){this._populateListItem();this.listItemElement.addEventListener('click',this._mouseClick.bind(this));}
_populateListItem(){this.listItemElement.removeChildren();this.appendNameElement(this._attribute.name);this.listItemElement.createChild('span','separator').textContent=':\u00A0';this.appendAttributeValueElement(this._attribute.value);}
appendNameElement(name){this._nameElement=createElement('span');this._nameElement.textContent=name;this._nameElement.classList.add('ax-name');this._nameElement.classList.add('monospace');this.listItemElement.appendChild(this._nameElement);}
appendAttributeValueElement(value){this._valueElement=Accessibility.ARIAAttributesTreeElement.createARIAValueElement(value);this.listItemElement.appendChild(this._valueElement);}
_mouseClick(event){if(event.target===this.listItemElement)
return;event.consume(true);this._startEditing();}
_startEditing(){const valueElement=this._valueElement;if(UI.isBeingEdited(valueElement))
return;const previousContent=valueElement.textContent;function blurListener(previousContent,event){const text=event.target.textContent;this._editingCommitted(text,previousContent);}
this._prompt=new Accessibility.ARIAAttributesPane.ARIAAttributePrompt(Accessibility.ariaMetadata().valuesForProperty(this._nameElement.textContent),this);this._prompt.setAutocompletionTimeout(0);const proxyElement=this._prompt.attachAndStartEditing(valueElement,blurListener.bind(this,previousContent));proxyElement.addEventListener('keydown',this._editingValueKeyDown.bind(this,previousContent),false);valueElement.getComponentSelection().selectAllChildren(valueElement);}
_removePrompt(){if(!this._prompt)
return;this._prompt.detach();delete this._prompt;}
_editingCommitted(userInput,previousContent){this._removePrompt();if(userInput!==previousContent)
this._parentPane.node().setAttributeValue(this._attribute.name,userInput);}
_editingCancelled(){this._removePrompt();this._populateListItem();}
_editingValueKeyDown(previousContent,event){if(event.handled)
return;if(isEnterKey(event)){this._editingCommitted(event.target.textContent,previousContent);event.consume();return;}
if(isEscKey(event)){this._editingCancelled();event.consume();return;}}};Accessibility.ARIAAttributesPane.ARIAAttributePrompt=class extends UI.TextPrompt{constructor(ariaCompletions,treeElement){super();this.initialize(this._buildPropertyCompletions.bind(this));this._ariaCompletions=ariaCompletions;this._treeElement=treeElement;}
_buildPropertyCompletions(expression,prefix,force){prefix=prefix.toLowerCase();if(!prefix&&!force&&(this._isEditingName||expression))
return Promise.resolve([]);return Promise.resolve(this._ariaCompletions.filter(value=>value.startsWith(prefix)).map(c=>({text:c})));}};Accessibility.ARIAAttributesPane._attributes=['role','aria-busy','aria-checked','aria-disabled','aria-expanded','aria-grabbed','aria-hidden','aria-invalid','aria-pressed','aria-selected','aria-activedescendant','aria-atomic','aria-autocomplete','aria-controls','aria-describedby','aria-dropeffect','aria-flowto','aria-haspopup','aria-label','aria-labelledby','aria-level','aria-live','aria-multiline','aria-multiselectable','aria-orientation','aria-owns','aria-posinset','aria-readonly','aria-relevant','aria-required','aria-setsize','aria-sort','aria-valuemax','aria-valuemin','aria-valuenow','aria-valuetext',];;Accessibility.ARIAMetadata=class{constructor(config){this._attributes=new Map();if(config)
this._initialize(config);}
_initialize(config){const attributes=config['attributes'];const booleanEnum=['true','false'];for(const attributeConfig of attributes){if(attributeConfig.type==='boolean')
attributeConfig.enum=booleanEnum;this._attributes.set(attributeConfig.name,new Accessibility.ARIAMetadata.Attribute(attributeConfig));}
this._roleNames=config['roles'].map(roleConfig=>roleConfig.name);}
valuesForProperty(property){if(this._attributes.has(property))
return this._attributes.get(property).getEnum();if(property==='role')
return this._roleNames;return[];}};Accessibility.ariaMetadata=function(){if(!Accessibility.ARIAMetadata._instance)
Accessibility.ARIAMetadata._instance=new Accessibility.ARIAMetadata(Accessibility.ARIAMetadata._config||null);return Accessibility.ARIAMetadata._instance;};Accessibility.ARIAMetadata.Attribute=class{constructor(config){this._enum=[];if('enum'in config)
this._enum=config.enum;}
getEnum(){return this._enum;}};;Accessibility.ARIAMetadata._config={"attributes":[{"type":"IDREF","name":"aria-activedescendant"},{"default":"false","type":"boolean","name":"aria-atomic"},{"default":"none","enum":["inline","list","both","none"],"type":"token","name":"aria-autocomplete"},{"default":"false","type":"boolean","name":"aria-busy"},{"default":"undefined","enum":["true","false","mixed","undefined"],"type":"token","name":"aria-checked"},{"type":"integer","name":"aria-colcount"},{"type":"integer","name":"aria-colindex"},{"type":"integer","name":"aria-colspan"},{"type":"IDREF_list","name":"aria-controls"},{"default":"false","enum":["page","step","location","date","time","true","false"],"type":"token","name":"aria-current"},{"type":"IDREF_list","name":"aria-describedby"},{"type":"IDREF","name":"aria-details"},{"default":"false","type":"boolean","name":"aria-disabled"},{"default":"none","enum":["copy","move","link","execute","popup","none"],"type":"token_list","name":"aria-dropeffect"},{"type":"IDREF","name":"aria-errormessage"},{"default":"undefined","enum":["true","false","undefined"],"type":"token","name":"aria-expanded"},{"type":"IDREF_list","name":"aria-flowto"},{"default":"undefined","enum":["true","false","undefined"],"type":"token","name":"aria-grabbed"},{"default":"false","enum":["false","true","menu","listbox","tree","grid","dialog"],"type":"token","name":"aria-haspopup"},{"type":"string","name":"aria-help"},{"default":"undefined","enum":["true","false","undefined"],"type":"token","name":"aria-hidden"},{"default":"false","enum":["grammar","false","spelling","true"],"type":"token","name":"aria-invalid"},{"type":"string","name":"aria-keyshortcuts"},{"type":"string","name":"aria-label"},{"type":"IDREF_list","name":"aria-labelledby"},{"type":"IDREF_list","name":"aria-labeledby"},{"type":"integer","name":"aria-level"},{"default":"off","enum":["off","polite","assertive"],"type":"token","name":"aria-live"},{"default":"false","type":"boolean","name":"aria-modal"},{"default":"false","type":"boolean","name":"aria-multiline"},{"default":"false","type":"boolean","name":"aria-multiselectable"},{"default":"undefined","enum":["horizontal","undefined","vertical"],"type":"token","name":"aria-orientation"},{"type":"IDREF_list","name":"aria-owns"},{"type":"string","name":"aria-placeholder"},{"type":"integer","name":"aria-posinset"},{"default":"undefined","enum":["true","false","mixed","undefined"],"type":"token","name":"aria-pressed"},{"default":"false","type":"boolean","name":"aria-readonly"},{"default":"additions text","enum":["additions","removals","text","all"],"type":"token_list","name":"aria-relevant"},{"default":"false","type":"boolean","name":"aria-required"},{"type":"string","name":"aria-roledescription"},{"type":"integer","name":"aria-rowcount"},{"type":"integer","name":"aria-rowindex"},{"type":"integer","name":"aria-rowspan"},{"default":"undefined","enum":["true","false","undefined"],"type":"token","name":"aria-selected"},{"type":"integer","name":"aria-setsize"},{"default":"none","enum":["ascending","descending","none","other"],"type":"token","name":"aria-sort"},{"type":"decimal","name":"aria-valuemax"},{"type":"decimal","name":"aria-valuemin"},{"type":"decimal","name":"aria-valuenow"},{"type":"string","name":"aria-valuetext"}],"roles":[{"implicitValues":{"aria-atomic":"true","aria-live":"assertive"},"superclasses":["section"],"name":"alert","nameFrom":["author"]},{"superclasses":["alert","dialog"],"name":"alertdialog","nameRequired":true,"nameFrom":["author"]},{"superclasses":["structure"],"name":"application","nameRequired":true,"nameFrom":["author"]},{"supportedAttributes":["aria-posinset","aria-setsize"],"superclasses":["document"],"name":"article","nameFrom":["author"]},{"superclasses":["landmark"],"name":"banner","nameFrom":["author"]},{"name":"button","nameRequired":true,"nameFrom":["contents","author"],"supportedAttributes":["aria-expanded","aria-pressed"],"superclasses":["command"],"childrenPresentational":true},{"scope":"row","supportedAttributes":["aria-colindex","aria-colspan","aria-rowindex","aria-rowspan"],"superclasses":["section"],"name":"cell","namefrom":["contents","author"]},{"name":"checkbox","nameRequired":true,"implicitValues":{"aria-checked":false},"requiredAttributes":["aria-checked"],"nameFrom":["contents","author"],"supportedAttributes":["aria-readonly"],"superclasses":["input"]},{"name":"columnheader","nameRequired":true,"nameFrom":["contents","author"],"supportedAttributes":["aria-sort"],"superclasses":["gridcell","sectionhead","widget"],"scope":["row"]},{"name":"combobox","nameRequired":true,"implicitValues":{"aria-haspopup":"listbox","aria-expanded":"false"},"requiredAttributes":["aria-controls","aria-expanded"],"mustContain":["textbox"],"nameFrom":["author"],"supportedAttributes":["aria-autocomplete","aria-readonly","aria-required"],"superclasses":["select"]},{"abstract":true,"superclasses":["widget"],"name":"command","nameFrom":["author"]},{"superclasses":["landmark"],"name":"complementary","nameFrom":["author"]},{"supportedAttributes":["aria-activedescendant"],"abstract":true,"superclasses":["widget"],"name":"composite","nameFrom":["author"]},{"superclasses":["landmark"],"name":"contentinfo","nameFrom":["author"]},{"superclasses":["section"],"name":"definition","nameFrom":["author"]},{"superclasses":["window"],"name":"dialog","nameRequired":true,"nameFrom":["author"]},{"superclasses":["list"],"name":"directory","nameFrom":["author"]},{"supportedAttributes":["aria-expanded"],"superclasses":["structure"],"name":"document","nameRequired":false,"nameFrom":["author"]},{"nameRequired":false,"superclasses":["list"],"name":"feed","mustContain":["article"],"nameFrom":["author"]},{"superclasses":["section"],"name":"figure","nameRequired":false,"namefrom":["author"]},{"superclasses":["landmark"],"name":"form","nameFrom":["author"]},{"name":"grid","nameRequired":true,"nameFrom":["author"],"mustContain":["row"],"supportedAttributes":["aria-level","aria-multiselectable","aria-readonly"],"superclasses":["composite","table"]},{"name":"gridcell","nameRequired":true,"nameFrom":["contents","author"],"supportedAttributes":["aria-readonly","aria-required","aria-selected"],"superclasses":["cell","widget"],"scope":["row"]},{"supportedAttributes":["aria-activedescendant"],"superclasses":["section"],"name":"group","nameFrom":["author"]},{"name":"heading","nameRequired":true,"implicitValues":{"aria-level":"2"},"namefrom":["contents","author"],"supportedAttributes":["aria-level"],"superclasses":["sectionhead"]},{"childrenPresentational":true,"superclasses":["section"],"name":"img","nameRequired":true,"nameFrom":["author"]},{"abstract":true,"superclasses":["widget"],"name":"input","nameFrom":["author"]},{"abstract":true,"superclasses":["section"],"name":"landmark","nameRequired":false,"nameFrom":["author"]},{"supportedAttributes":["aria-expanded"],"superclasses":["command"],"name":"link","nameRequired":true,"nameFrom":["contents","author"]},{"implicitValues":{"aria-orientation":"vertical"},"superclasses":["section"],"name":"list","mustContain":["listitem"],"nameFrom":["author"]},{"name":"listbox","nameRequired":true,"implicitValues":{"aria-orientation":"vertical"},"nameFrom":["author"],"mustContain":["option"],"supportedAttributes":["aria-multiselectable","aria-readonly","aria-required"],"superclasses":["select"]},{"scope":["group","list"],"supportedAttributes":["aria-level","aria-posinset","aria-setsize"],"superclasses":["section"],"name":"listitem","nameFrom":["author"]},{"implicitValues":{"aria-live":"polite"},"superclasses":["section"],"name":"log","nameRequired":true,"nameFrom":["author"]},{"superclasses":["landmark"],"name":"main","nameFrom":["author"]},{"superclasses":["section"],"name":"marquee","nameRequired":true,"nameFrom":["author"]},{"childrenPresentational":true,"superclasses":["section"],"name":"math","nameRequired":true,"nameFrom":["author"]},{"implicitValues":{"aria-orientation":"vertical"},"superclasses":["select"],"name":"menu","mustContain":["group","menuitemradio","menuitem","menuitemcheckbox","menuitemradio"],"nameFrom":["author"]},{"implicitValues":{"aria-orientation":"horizontal"},"superclasses":["menu"],"name":"menubar","mustContain":["menuitem","menuitemradio","menuitemcheckbox"],"nameFrom":["author"]},{"scope":["group","menu","menubar"],"superclasses":["command"],"name":"menuitem","nameRequired":true,"nameFrom":["contents","author"]},{"name":"menuitemcheckbox","nameRequired":true,"implicitValues":{"aria-checked":false},"nameFrom":["contents","author"],"superclasses":["checkbox","menuitem"],"childrenPresentational":true,"scope":["menu","menubar"]},{"name":"menuitemradio","nameRequired":true,"implicitValues":{"aria-checked":false},"nameFrom":["contents","author"],"superclasses":["menuitemcheckbox","radio"],"childrenPresentational":true,"scope":["menu","menubar","group"]},{"superclasses":["landmark"],"name":"navigation","nameFrom":["author"]},{"name":"none","superclasses":["structure"]},{"superclasses":["section"],"name":"note","nameFrom":["author"]},{"name":"option","nameRequired":true,"implicitValues":{"aria-selected":"false"},"requiredAttributes":["aria-selected"],"nameFrom":["contents","author"],"supportedAttributes":["aria-checked","aria-posinset","aria-setsize"],"superclasses":["input"],"childrenPresentational":true,"scope":["listbox"]},{"name":"presentation","superclasses":["structure"]},{"childrenPresentational":true,"superclasses":["range"],"name":"progressbar","nameRequired":true,"nameFrom":["author"]},{"name":"radio","nameRequired":true,"implicitValues":{"aria-checked":"false"},"requiredAttributes":["aria-checked"],"nameFrom":["contents","author"],"supportedAttributes":["aria-posinset","aria-setsize"],"superclasses":["input"],"childrenPresentational":true},{"name":"radiogroup","nameRequired":true,"nameFrom":["author"],"mustContain":["radio"],"supportedAttributes":["aria-readonly","aria-required"],"superclasses":["select"]},{"supportedAttributes":["aria-valuemax","aria-valuemin","aria-valuenow","aria-valuetext"],"abstract":true,"superclasses":["widget"],"name":"range","nameFrom":["author"]},{"superclasses":["landmark"],"name":"region","nameRequired":true,"nameFrom":["author"]},{"supportedAttributes":["aria-atomic","aria-busy","aria-controls","aria-current","aria-describedby","aria-details","aria-disabled","aria-dropeffect","aria-errormessage","aria-flowto","aria-grabbed","aria-haspopup","aria-hidden","aria-invalid","aria-keyshortcuts","aria-label","aria-labelledby","aria-live","aria-owns","aria-relevant","aria-roledescription"],"abstract":true,"name":"roletype"},{"name":"row","nameFrom":["contents","author"],"mustContain":["cell","columnheader","gridcell","rowheader"],"supportedAttributes":["aria-colindex","aria-level","aria-rowindex","aria-selected","aria-setsize","aria-posinset"],"superclasses":["group","widget"],"scope":["grid","rowgroup","table","treegrid"]},{"scope":["grid","table","treegrid"],"superclasses":["structure"],"name":"rowgroup","mustContain":["row"],"nameFrom":["contents","author"]},{"name":"rowheader","nameRequired":true,"nameFrom":["contents","author"],"supportedAttributes":["aria-sort"],"superclasses":["cell","gridcell","sectionhead"],"scope":["row"]},{"name":"scrollbar","nameRequired":false,"implicitValues":{"aria-valuemax":"100","aria-valuemin":"0","aria-orientation":"vertical"},"nameFrom":["author"],"requiredAttributes":["aria-controls","aria-orientation","aria-valuemax","aria-valuemin","aria-valuenow"],"superclasses":["range"],"childrenPresentational":true},{"superclasses":["landmark"],"name":"search","nameFrom":["author"]},{"superclasses":["textbox"],"name":"searchbox","nameRequired":true,"nameFrom":["author"]},{"supportedAttributes":["aria-expanded"],"abstract":true,"name":"section","superclasses":["structure"]},{"supportedAttributes":["aria-expanded"],"abstract":true,"superclasses":["structure"],"name":"sectionhead","nameFrom":["contents","author"]},{"abstract":true,"superclasses":["composite","group"],"name":"select","nameFrom":["author"]},{"supportedAttributes":["aria-orientation","aria-valuemin","aria-valuemax","aria-valuenow","aria-valuetext"],"superclasses":["structure"],"name":"separator","nameFrom":["author"]},{"name":"slider","nameRequired":true,"implicitValues":{"aria-valuemax":"100","aria-valuemin":"0","aria-orientation":"horizontal"},"requiredAttributes":["aria-valuemax","aria-valuemin","aria-valuenow"],"nameFrom":["author"],"supportedAttributes":["aria-orientation"],"superclasses":["input","range"],"childrenPresentational":true},{"name":"spinbutton","nameRequired":true,"implicitValues":{"aria-valuenow":"0"},"requiredAttributes":["aria-valuemax","aria-valuemin","aria-valuenow"],"nameFrom":["author"],"supportedAttributes":["aria-required","aria-readonly"],"superclasses":["composite","input","range"]},{"implicitValues":{"aria-atomic":"true","aria-live":"polite"},"superclasses":["section"],"name":"status","nameFrom":["author"]},{"abstract":true,"name":"structure","superclasses":["roletype"]},{"name":"switch","nameRequired":true,"implicitValues":{"aria-checked":"false"},"nameFrom":["contents","author"],"requiredAttributes":["aria-checked"],"superclasses":["checkbox"],"childrenPresentational":true},{"name":"tab","implicitValues":{"aria-selected":"false"},"nameFrom":["contents","author"],"supportedAttributes":["aria-selected"],"superclasses":["sectionhead","widget"],"childrenPresentational":true,"scope":["tablist"]},{"name":"table","nameRequired":true,"nameFrom":["author"],"mustContain":["row"],"supportedAttributes":["aria-colcount","aria-rowcount"],"superclasses":["section"]},{"name":"tablist","implicitValues":{"aria-orientation":"horizontal"},"nameFrom":["author"],"mustContain":["tab"],"supportedAttributes":["aria-level","aria-multiselectable","aria-orientation"],"superclasses":["composite"]},{"superclasses":["section"],"name":"tabpanel","nameRequired":true,"nameFrom":["author"]},{"superclasses":["section"],"name":"term","nameFrom":["author"]},{"supportedAttributes":["aria-activedescendant","aria-autocomplete","aria-multiline","aria-placeholder","aria-readonly","aria-required"],"superclasses":["input"],"name":"textbox","nameRequired":true,"nameFrom":["author"]},{"superclasses":["status"],"name":"timer","nameFrom":["author"]},{"implicitValues":{"aria-orientation":"horizontal"},"supportedAttributes":["aria-orientation"],"superclasses":["group"],"name":"toolbar","nameFrom":["author"]},{"superclasses":["section"],"name":"tooltip","nameRequired":true,"nameFrom":["contents","author"]},{"name":"tree","nameRequired":true,"implicitValues":{"aria-orientation":"vertical"},"nameFrom":["author"],"mustContain":["group","treeitem"],"supportedAttributes":["aria-multiselectable","aria-required"],"superclasses":["select"]},{"nameRequired":true,"superclasses":["grid","tree"],"name":"treegrid","mustContain":["row"],"nameFrom":["author"]},{"scope":["group","tree"],"superclasses":["listitem","option"],"name":"treeitem","nameRequired":true,"nameFrom":["contents","author"]},{"abstract":true,"name":"widget","superclasses":["roletype"]},{"supportedAttributes":["aria-expanded","aria-modal"],"abstract":true,"superclasses":["roletype"],"name":"window","nameFrom":["author"]}],"metadata":{"namespaceURI":"http://www.w3.org/1999/xhtml","attrsNullNamespace":true,"namespace":"HTML","export":"CORE_EXPORT","namespacePrefix":"xhtml"}};;Accessibility.AXBreadcrumbsPane=class extends Accessibility.AccessibilitySubPane{constructor(axSidebarView){super(ls`Accessibility Tree`);this.element.classList.add('ax-subpane');UI.ARIAUtils.markAsTree(this.element);this.element.tabIndex=-1;this._axSidebarView=axSidebarView;this._preselectedBreadcrumb=null;this._inspectedNodeBreadcrumb=null;this._hoveredBreadcrumb=null;this._rootElement=this.element.createChild('div','ax-breadcrumbs');this._rootElement.addEventListener('keydown',this._onKeyDown.bind(this),true);this._rootElement.addEventListener('mousemove',this._onMouseMove.bind(this),false);this._rootElement.addEventListener('mouseleave',this._onMouseLeave.bind(this),false);this._rootElement.addEventListener('click',this._onClick.bind(this),false);this._rootElement.addEventListener('contextmenu',this._contextMenuEventFired.bind(this),false);this._rootElement.addEventListener('focusout',this._onFocusOut.bind(this),false);this.registerRequiredCSS('accessibility/axBreadcrumbs.css');}
focus(){if(this._inspectedNodeBreadcrumb)
this._inspectedNodeBreadcrumb.nodeElement().focus();else
this.element.focus();}
setAXNode(axNode){const hadFocus=this.element.hasFocus();super.setAXNode(axNode);this._rootElement.removeChildren();if(!axNode)
return;const ancestorChain=[];let ancestor=axNode;while(ancestor){ancestorChain.push(ancestor);ancestor=ancestor.parentNode();}
ancestorChain.reverse();let depth=0;let breadcrumb=null;let parent=null;for(ancestor of ancestorChain){breadcrumb=new Accessibility.AXBreadcrumb(ancestor,depth,(ancestor===axNode));if(parent)
parent.appendChild(breadcrumb);else
this._rootElement.appendChild(breadcrumb.element());parent=breadcrumb;depth++;}
this._inspectedNodeBreadcrumb=breadcrumb;this._inspectedNodeBreadcrumb.setPreselected(true,hadFocus);this._setPreselectedBreadcrumb(this._inspectedNodeBreadcrumb);function append(parentBreadcrumb,axNode,localDepth){const childBreadcrumb=new Accessibility.AXBreadcrumb(axNode,localDepth,false);parentBreadcrumb.appendChild(childBreadcrumb);for(const child of axNode.children())
append(childBreadcrumb,child,localDepth+1);}
for(const child of axNode.children())
append(this._inspectedNodeBreadcrumb,child,depth);}
willHide(){this._setPreselectedBreadcrumb(null);}
_onKeyDown(event){if(!this._preselectedBreadcrumb)
return;if(!event.composedPath().some(element=>element===this._preselectedBreadcrumb.element()))
return;if(event.shiftKey||event.metaKey||event.ctrlKey)
return;let handled=false;if((event.key==='ArrowUp'||event.key==='ArrowLeft')&&!event.altKey)
handled=this._preselectPrevious();else if((event.key==='ArrowDown'||event.key==='ArrowRight')&&!event.altKey)
handled=this._preselectNext();else if(isEnterKey(event))
handled=this._inspectDOMNode(this._preselectedBreadcrumb.axNode());if(handled)
event.consume(true);}
_preselectPrevious(){const previousBreadcrumb=this._preselectedBreadcrumb.previousBreadcrumb();if(!previousBreadcrumb)
return false;this._setPreselectedBreadcrumb(previousBreadcrumb);return true;}
_preselectNext(){const nextBreadcrumb=this._preselectedBreadcrumb.nextBreadcrumb();if(!nextBreadcrumb)
return false;this._setPreselectedBreadcrumb(nextBreadcrumb);return true;}
_setPreselectedBreadcrumb(breadcrumb){if(breadcrumb===this._preselectedBreadcrumb)
return;const hadFocus=this.element.hasFocus();if(this._preselectedBreadcrumb)
this._preselectedBreadcrumb.setPreselected(false,hadFocus);if(breadcrumb)
this._preselectedBreadcrumb=breadcrumb;else
this._preselectedBreadcrumb=this._inspectedNodeBreadcrumb;this._preselectedBreadcrumb.setPreselected(true,hadFocus);if(!breadcrumb&&hadFocus)
SDK.OverlayModel.hideDOMNodeHighlight();}
_onMouseLeave(event){this._setHoveredBreadcrumb(null);}
_onMouseMove(event){const breadcrumbElement=event.target.enclosingNodeOrSelfWithClass('ax-breadcrumb');if(!breadcrumbElement){this._setHoveredBreadcrumb(null);return;}
const breadcrumb=breadcrumbElement.breadcrumb;if(!breadcrumb.isDOMNode())
return;this._setHoveredBreadcrumb(breadcrumb);}
_onFocusOut(event){if(!this._preselectedBreadcrumb||event.target!==this._preselectedBreadcrumb.nodeElement())
return;this._setPreselectedBreadcrumb(null);}
_onClick(event){const breadcrumbElement=event.target.enclosingNodeOrSelfWithClass('ax-breadcrumb');if(!breadcrumbElement){this._setHoveredBreadcrumb(null);return;}
const breadcrumb=breadcrumbElement.breadcrumb;if(breadcrumb.inspected()){breadcrumb.nodeElement().focus();return;}
if(!breadcrumb.isDOMNode())
return;this._inspectDOMNode(breadcrumb.axNode());}
_setHoveredBreadcrumb(breadcrumb){if(breadcrumb===this._hoveredBreadcrumb)
return;if(this._hoveredBreadcrumb)
this._hoveredBreadcrumb.setHovered(false);if(breadcrumb){breadcrumb.setHovered(true);}else if(this.node()){this.node().domModel().overlayModel().nodeHighlightRequested(this.node().id);}
this._hoveredBreadcrumb=breadcrumb;}
_inspectDOMNode(axNode){if(!axNode.isDOMNode())
return false;axNode.deferredDOMNode().resolve(domNode=>{this._axSidebarView.setNode(domNode,true);Common.Revealer.reveal(domNode,true);});return true;}
_contextMenuEventFired(event){const breadcrumbElement=event.target.enclosingNodeOrSelfWithClass('ax-breadcrumb');if(!breadcrumbElement)
return;const axNode=breadcrumbElement.breadcrumb.axNode();if(!axNode.isDOMNode()||!axNode.deferredDOMNode())
return;const contextMenu=new UI.ContextMenu(event);contextMenu.viewSection().appendItem(ls`Scroll into view`,()=>{axNode.deferredDOMNode().resolvePromise().then(domNode=>{if(!domNode)
return;domNode.scrollIntoView();});});contextMenu.appendApplicableItems(axNode.deferredDOMNode());contextMenu.show();}};Accessibility.AXBreadcrumb=class{constructor(axNode,depth,inspected){this._axNode=axNode;this._element=createElementWithClass('div','ax-breadcrumb');this._element.breadcrumb=this;this._nodeElement=createElementWithClass('div','ax-node');UI.ARIAUtils.markAsTreeitem(this._nodeElement);this._nodeElement.tabIndex=-1;this._element.appendChild(this._nodeElement);this._nodeWrapper=createElementWithClass('div','wrapper');this._nodeElement.appendChild(this._nodeWrapper);this._selectionElement=createElementWithClass('div','selection fill');this._nodeElement.appendChild(this._selectionElement);this._childrenGroupElement=createElementWithClass('div','children');UI.ARIAUtils.markAsGroup(this._childrenGroupElement);this._element.appendChild(this._childrenGroupElement);this._children=[];this._hovered=false;this._preselected=false;this._parent=null;this._inspected=inspected;this._nodeElement.classList.toggle('inspected',inspected);this._nodeElement.style.paddingLeft=(16*depth+4)+'px';if(this._axNode.ignored()){this._appendIgnoredNodeElement();}else{this._appendRoleElement(this._axNode.role());if(this._axNode.name()&&this._axNode.name().value){this._nodeWrapper.createChild('span','separator').textContent='\u00A0';this._appendNameElement((this._axNode.name().value));}}
if(this._axNode.hasOnlyUnloadedChildren())
this._nodeElement.classList.add('children-unloaded');if(!this._axNode.isDOMNode())
this._nodeElement.classList.add('no-dom-node');}
element(){return this._element;}
nodeElement(){return this._nodeElement;}
appendChild(breadcrumb){this._children.push(breadcrumb);breadcrumb.setParent(this);this._nodeElement.classList.add('parent');UI.ARIAUtils.setExpanded(this._nodeElement,true);this._childrenGroupElement.appendChild(breadcrumb.element());}
setParent(breadcrumb){this._parent=breadcrumb;}
preselected(){return this._preselected;}
setPreselected(preselected,selectedByUser){if(this._preselected===preselected)
return;this._preselected=preselected;this._nodeElement.classList.toggle('preselected',preselected);if(preselected)
this._nodeElement.setAttribute('tabIndex',0);else
this._nodeElement.setAttribute('tabIndex',-1);if(this._preselected){if(selectedByUser)
this._nodeElement.focus();if(!this._inspected)
this._axNode.highlightDOMNode();else
SDK.OverlayModel.hideDOMNodeHighlight();}}
setHovered(hovered){if(this._hovered===hovered)
return;this._hovered=hovered;this._nodeElement.classList.toggle('hovered',hovered);if(this._hovered){this._nodeElement.classList.toggle('hovered',true);this._axNode.highlightDOMNode();}}
axNode(){return this._axNode;}
inspected(){return this._inspected;}
isDOMNode(){return this._axNode.isDOMNode();}
nextBreadcrumb(){if(this._children.length)
return this._children[0];const nextSibling=this.element().nextSibling;if(nextSibling)
return nextSibling.breadcrumb;return null;}
previousBreadcrumb(){const previousSibling=this.element().previousSibling;if(previousSibling)
return previousSibling.breadcrumb;return this._parent;}
_appendNameElement(name){const nameElement=createElement('span');nameElement.textContent='"'+name+'"';nameElement.classList.add('ax-readable-string');this._nodeWrapper.appendChild(nameElement);}
_appendRoleElement(role){if(!role)
return;const roleElement=createElementWithClass('span','monospace');roleElement.classList.add(Accessibility.AXBreadcrumb.RoleStyles[role.type]);roleElement.setTextContentTruncatedIfNeeded(role.value||'');this._nodeWrapper.appendChild(roleElement);}
_appendIgnoredNodeElement(){const ignoredNodeElement=createElementWithClass('span','monospace');ignoredNodeElement.textContent=ls`Ignored`;ignoredNodeElement.classList.add('ax-breadcrumbs-ignored-node');this._nodeWrapper.appendChild(ignoredNodeElement);}};Accessibility.AXBreadcrumb.RoleStyles={internalRole:'ax-internal-role',role:'ax-role',};;Runtime.cachedResources["accessibility/accessibilityNode.css"]="/*\n * Copyright 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.widget.ax-subpane {\n    overflow-x: hidden;\n    -webkit-user-select: text;\n}\n\n.ax-ignored-info {\n    padding: 6px;\n}\n\n.ax-ignored-node-pane {\n    flex: none;\n}\n\n.invalid {\n    text-decoration: line-through;\n}\n\nspan.ax-value-undefined {\n    font-style: italic;\n}\n\n.ax-value-source-unused {\n    opacity: 0.7;\n}\n\n.ax-value-source-superseded,\n.ax-value-source-invalid {\n    text-decoration: line-through;\n}\n\n.tree-outline span[is=dt-icon-label] {\n    position: relative;\n    left: -11px;\n}\n\n.tree-outline li {\n    display: block;\n    overflow-x: hidden;\n    padding-left: 1px;\n    align-items: baseline;\n}\n\n.tree-outline li::before {\n    content: \"\";\n    width: 14px;\n    display: inline-block;\n}\n\n.tree-outline li.property {\n    color: rgb(33, 33, 33);\n}\n\n.tree-outline li.invalid {\n    position: relative;\n    left: -2px;\n}\n\n.tree-outline span[is=dt-icon-label] + .ax-name {\n    margin-left: -11px;\n}\n\n.tree-outline li span {\n    flex-shrink: 0;\n    text-overflow: ellipsis;\n    white-space: nowrap;\n}\n\n/*# sourceURL=accessibility/accessibilityNode.css */";Runtime.cachedResources["accessibility/accessibilityProperties.css"]="/*\n * Copyright 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.ax-name {\n    color: rgb(153, 69, 0);\n    flex-shrink: 0;\n}\n\n.ax-readable-name {\n    flex-shrink: 0;\n    padding-left: 2px;\n}\n\n.ax-readable-string {\n    font-style: italic;\n}\n\n.ax-value-string {\n    color: rgb(200, 0, 0);\n}\n\nspan.ax-internal-role {\n    font-style: italic;\n}\n\n/*# sourceURL=accessibility/accessibilityProperties.css */";Runtime.cachedResources["accessibility/axBreadcrumbs.css"]="/*\n * Copyright 2017 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.ax-breadcrumbs-ignored-node {\n    font-style: italic;\n    opacity: 0.7;\n}\n\n.ax-breadcrumbs {\n    padding-top: 1px;\n    margin: 0;\n    position: relative;\n}\n\n.ax-breadcrumbs .ax-node {\n    align-items: center;\n    margin-top: 1px;\n    min-height: 16px;\n    overflow-x: hidden;\n    padding-left: 4px;\n    padding-right: 4px;\n    padding-top: 1px;\n    position: relative;\n    text-overflow: ellipsis;\n    white-space: nowrap;\n}\n\n.ax-breadcrumbs .ax-node span {\n    flex-shrink: 0;\n    text-overflow: ellipsis;\n    white-space: nowrap;\n}\n\n.ax-breadcrumbs .ax-node .wrapper {\n    padding-left: 12px;\n    overflow-x: hidden;\n}\n\n.ax-breadcrumbs .ax-node::before {\n    -webkit-mask-image: url(Images/chevrons.png);\n    -webkit-mask-position: 0 0;\n    -webkit-mask-size: 30px 10px;\n    -webkit-mask-repeat: no-repeat;\n    background-color: rgb(48, 57, 66);\n    content: \"\";\n    text-shadow: none;\n    margin-right: -2px;\n    height: 12px;\n    width: 14px;\n    position: absolute;\n    display: inline-block;\n}\n\n@media (-webkit-min-device-pixel-ratio: 1.1) {\n    .ax-breadcrumbs .ax-node::before {\n        -webkit-mask-image: url(Images/chevrons_2x.png);\n    }\n} /* media */\n\n.ax-breadcrumbs .ax-node:not(.parent):not(.children-unloaded)::before {\n    background-color: transparent;\n}\n\n.ax-breadcrumbs .ax-node.parent::before {\n    -webkit-mask-position: -20px 1px;\n}\n\n.ax-breadcrumbs .ax-node.children-unloaded::before {\n    -webkit-mask-position: 0px 1px;\n    width: 13px;\n}\n\n.ax-breadcrumbs .ax-node.no-dom-node {\n    opacity: 0.7;\n}\n\n.ax-breadcrumbs .ax-node.children-unloaded::before {\n    opacity: 0.4;\n}\n\n.ax-breadcrumbs .ax-node.preselected:not(.inspected) .selection,\n.ax-breadcrumbs .ax-node.hovered:not(.inspected) .selection {\n    display: block;\n    left: 2px;\n    right: 2px;\n    background-color: rgba(56, 121, 217, 0.1);\n    border-radius: 5px;\n}\n\n.ax-breadcrumbs .ax-node.preselected:not(.inspected):focus .selection {\n    border: 1px solid rgba(56, 121, 217, 0.4);\n}\n\n.ax-breadcrumbs .ax-node .selection {\n    display: none;\n    z-index: -1;\n}\n\n.ax-breadcrumbs .ax-node.inspected .selection {\n    display: block;\n    background-color: #ddd;\n}\n\n.ax-breadcrumbs .ax-node.inspected:focus .selection {\n    background-color: var(--selection-bg-color);\n}\n\n.ax-breadcrumbs .ax-node.parent.inspected:focus::before {\n    background-color: white;\n}\n\n.ax-breadcrumbs .ax-node.inspected:focus {\n    color: white;\n}\n\n.ax-breadcrumbs .ax-node.inspected:focus * {\n    color: inherit;\n}\n\n/*# sourceURL=accessibility/axBreadcrumbs.css */";